/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.caracteristics;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.caracteristics.CaracteristicMapEditorUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.caracteristics.CaracteristicMapEditorUIModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.decorator.Decorator;

public class CaracteristicMapCellComponent
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CaracteristicMapCellComponent.class);
    protected Decorator<Caracteristic> caracteristicDecorator;
    protected Decorator<CaracteristicQualitativeValue> valueDecorator;
    protected Color computedDataColor;

    public CaracteristicMapCellComponent(TuttiUIContext context) {
        this.caracteristicDecorator = context.getDecoratorService().getDecoratorByType(Caracteristic.class);
        this.valueDecorator = context.getDecoratorService().getDecoratorByType(CaracteristicQualitativeValue.class);
        this.computedDataColor = context.getConfig().getColorComputedWeights();
        this.setHorizontalAlignment(0);
        this.setIcon(SwingUtil.createActionIcon((String)"show-frequency"));
    }

    public void setText(CaracteristicMap map) {
        String s = "-";
        if (map != null && map.size() > 0) {
            s = String.valueOf(map.size());
        }
        this.setText(s);
        Font f = this.getFont();
        f = f.deriveFont(2);
        this.setFont(f);
        this.setForeground(this.computedDataColor);
    }

    public void setToolTipText(CaracteristicMap map) {
        String tooltipText = null;
        if (map != null) {
            tooltipText = "<html><ul>";
            for (Caracteristic caracteristic : map.keySet()) {
                tooltipText = tooltipText + "<li>" + this.caracteristicDecorator.toString((Object)caracteristic) + " : " + this.valueDecorator.toString(map.get((Object)caracteristic)) + "</li>";
            }
            tooltipText = tooltipText + "</ul></html>";
        }
        this.setToolTipText(tooltipText);
    }

    public static TableCellRenderer newRender(TuttiUIContext context) {
        return new CaracteristicMapCellRenderer(context);
    }

    public static TableCellEditor newEditor(IndividualObservationBatchUI ui) {
        return new CaracteristicMapCellEditor(ui);
    }

    public static class CaracteristicMapCellRenderer
    implements TableCellRenderer {
        protected final CaracteristicMapCellComponent component;

        public CaracteristicMapCellRenderer(TuttiUIContext context) {
            this.component = new CaracteristicMapCellComponent(context);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            CaracteristicMapCellComponent result = (CaracteristicMapCellComponent)this.component.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            boolean editable = table.isCellEditable(row, column);
            result.setEnabled(editable);
            CaracteristicMap map = (CaracteristicMap)value;
            result.setText(map);
            result.setToolTipText(map);
            return result;
        }
    }

    public static class CaracteristicMapCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        protected final CaracteristicMapCellComponent component;
        protected final IndividualObservationBatchUI ui;
        protected JTable table;
        protected IndividualObservationBatchTableModel tableModel;
        protected ColumnIdentifier<IndividualObservationBatchRowModel> columnIdentifier;
        protected IndividualObservationBatchRowModel editRow;
        protected Integer rowIndex;
        protected Integer columnIndex;

        public CaracteristicMapCellEditor(IndividualObservationBatchUI ui) {
            this.ui = ui;
            this.component = new CaracteristicMapCellComponent(ui.getHandler().getContext());
            this.component.setBorder(new LineBorder(Color.BLACK));
            this.component.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        e.consume();
                        CaracteristicMapCellEditor.this.startEdit();
                    }
                }
            });
            this.component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.consume();
                    CaracteristicMapCellEditor.this.startEdit();
                }
            });
        }

        protected void startEdit() {
            Preconditions.checkNotNull((Object)this.tableModel, (Object)"No table model assigned.");
            Preconditions.checkNotNull((Object)this.editRow, (Object)"No editRow found.");
            if (log.isInfoEnabled()) {
                log.info((Object)("Will edit frequencies for row: " + this.rowIndex));
            }
            EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
            CaracteristicMapEditorUI caracteristicMapEditor = parent.getCaracteristicMapEditor();
            caracteristicMapEditor.getHandler().editBatch(this.editRow, this);
            parent.getHandler().setIndividualObservationSelectedCard("caracteristicsCard");
        }

        public void validateEdition(CaracteristicMapEditorUIModel caracteristicMapEditorModel) {
            if (caracteristicMapEditorModel.isValid()) {
                CaracteristicMap map = caracteristicMapEditorModel.getCaracteristicMap();
                this.component.setText(map);
                this.component.setToolTipText(map);
                this.editRow.setCaracteristics(map);
            }
            int r = this.rowIndex;
            int c = this.columnIndex;
            this.stopCellEditing();
            AbstractSelectTableAction.doSelectCell(this.table, r, c);
            this.table.requestFocus();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.tableModel = (IndividualObservationBatchTableModel)table.getModel();
            this.table = table;
            this.columnIdentifier = IndividualObservationBatchTableModel.OTHER_CARACTERISTICS;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set columnIdentifier (" + column + ") :: " + this.columnIdentifier.getPropertyName()));
            }
            this.rowIndex = row;
            this.columnIndex = column;
            this.editRow = (IndividualObservationBatchRowModel)this.tableModel.getEntry(row);
            this.component.setText(this.editRow.getCaracteristics());
            this.component.setToolTipText(this.editRow.getCaracteristics());
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            Preconditions.checkNotNull((Object)this.editRow, (Object)"No editRow found in editor.");
            CaracteristicMap result = null;
            if (this.columnIdentifier == IndividualObservationBatchTableModel.OTHER_CARACTERISTICS) {
                result = this.editRow.getCaracteristics();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("editor value (" + this.columnIdentifier + "): " + result));
            }
            return result;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.rowIndex = null;
            this.columnIndex = null;
            this.editRow = null;
        }
    }
}

