/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.PropagatePropertyChangeListener;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create.CreateMarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create.CreateMarineLitterBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellEditor;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.util.decorator.Decorator;

public class MarineLitterBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<MarineLitterBatchRowModel, MarineLitterBatchUIModel, MarineLitterBatchUI> {
    private static final Log log = LogFactory.getLog(MarineLitterBatchUIHandler.class);

    public MarineLitterBatchUIHandler(TuttiUI<?, ?> parentUi, MarineLitterBatchUI ui) {
        super(parentUi, ui, "marineLitterCategory", "marineLitterSizeCategory", "weight", "number", "comment");
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        MarineLitterBatchUIModel model = (MarineLitterBatchUIModel)this.getModel();
        if (empty) {
            rows = null;
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Get marineLitter batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew(bean)) {
                BatchContainer batchContainer = this.persistenceService.getRootMarineLitterBatch(bean.getId());
                model.setRootBatchId(batchContainer.getId());
                List attachments = this.persistenceService.getAllAttachments(Integer.valueOf(model.getObjectId()));
                model.addAllAttachment(attachments);
                if (log.isInfoEnabled()) {
                    log.info((Object)("marineLitter root batch id: " + model.getRootBatchId()));
                }
                for (MarineLitterBatch aBatch : batchContainer.getChildren()) {
                    MarineLitterBatchRowModel entry = this.loadBatch(aBatch);
                    rows.add(entry);
                }
            }
        }
        model.setRows(rows);
        this.recomputeBatchActionEnable();
    }

    protected MarineLitterBatchRowModel loadBatch(MarineLitterBatch aBatch) {
        Integer id = aBatch.getIdAsInt();
        List attachments = this.persistenceService.getAllAttachments(id);
        MarineLitterBatchRowModel newRow = new MarineLitterBatchRowModel(aBatch, attachments);
        return newRow;
    }

    public MarineLitterBatchTableModel getTableModel() {
        return (MarineLitterBatchTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((MarineLitterBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(MarineLitterBatchRowModel row) {
        boolean result = row.getMarineLitterCategory() != null && row.getMarineLitterSizeCategory() != null && row.getNumber() != null;
        return result;
    }

    @Override
    protected void onRowModified(int rowIndex, MarineLitterBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        this.saveSelectedRowIfNeeded();
        this.recomputeBatchActionEnable();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<MarineLitterBatchRowModel> rowMonitor, MarineLitterBatchRowModel row) {
        if (row != null && row.isValid() && rowMonitor.wasModified()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Row " + row + " was modified, will save it"));
            }
            rowMonitor.setBean(null);
            this.saveRow(row);
            rowMonitor.setBean(row);
            rowMonitor.clearModified();
        }
    }

    @Override
    protected void onModelRowsChanged(List<MarineLitterBatchRowModel> rows) {
        super.onModelRowsChanged(rows);
        for (MarineLitterBatchRowModel row : rows) {
            this.addToMarineLitterCategoriesUsed(row);
        }
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, MarineLitterBatchRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        this.recomputeBatchActionEnable();
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, MarineLitterBatchRowModel oldRow, int newRowIndex, MarineLitterBatchRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        this.recomputeBatchActionEnable();
    }

    @Override
    protected void addHighlighters(JXTable table) {
        super.addHighlighters(table);
        Color cellWithValueColor = this.getConfig().getColorCellWithValue();
        Highlighter commentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{MarineLitterBatchTableModel.COMMENT}), new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                String value = (String)adapter.getValue();
                return StringUtils.isNotBlank((CharSequence)value);
            }
        }}), cellWithValueColor);
        table.addHighlighter(commentHighlighter);
        Highlighter attachmentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{MarineLitterBatchTableModel.ATTACHMENT}), new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                Collection attachments = (Collection)adapter.getValue();
                return CollectionUtils.isNotEmpty((Collection)attachments);
            }
        }}), cellWithValueColor);
        table.addHighlighter(attachmentHighlighter);
    }

    @Override
    public SwingValidator<MarineLitterBatchUIModel> getValidator() {
        return ((MarineLitterBatchUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("beforeInit: " + this.ui));
        }
        EditCatchesUIModel catchesUIModel = ((MarineLitterBatchUI)this.ui).getContextValue(EditCatchesUIModel.class);
        MarineLitterBatchUIModel model = new MarineLitterBatchUIModel(catchesUIModel);
        ((MarineLitterBatchUI)this.ui).setContextValue(model);
        PropagatePropertyChangeListener.listenAndPropagate((AbstractBean)catchesUIModel, model, "marineLitterTotalWeight", "marineLitterTotalWeight");
    }

    @Override
    public void afterInitUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("afterInit: " + this.ui));
        }
        this.initUI(this.ui);
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        Decorator<CaracteristicQualitativeValue> decorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        this.addComboDataColumnToModel((TableColumnModel)columnModel, MarineLitterBatchTableModel.MACRO_WASTE_CATEGORY, decorator, this.persistenceService.getMarineLitterCategoryCaracteristic().getQualitativeValue());
        decorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        this.addComboDataColumnToModel((TableColumnModel)columnModel, MarineLitterBatchTableModel.MACRO_WASTE_SIZE_CATEGORY, decorator, this.persistenceService.getMarineLitterSizeCategoryCaracteristic().getQualitativeValue());
        this.addIntegerColumnToModel((TableColumnModel)columnModel, MarineLitterBatchTableModel.NUMBER, "\\d{0,3}");
        this.addFloatColumnToModel((TableColumnModel)columnModel, MarineLitterBatchTableModel.WEIGHT, "\\d{0,6}|\\d{1,6}\\.\\d{0,3}");
        this.addColumnToModel((TableColumnModel)columnModel, CommentCellEditor.newEditor(this.ui), CommentCellRenderer.newRender(), MarineLitterBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor(this.ui), AttachmentCellRenderer.newRender(this.getDecorator(Attachment.class, null)), MarineLitterBatchTableModel.ATTACHMENT);
        MarineLitterBatchTableModel tableModel = new MarineLitterBatchTableModel((TableColumnModelExt)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initBatchTable(table, (TableColumnModel)columnModel, tableModel);
        this.recomputeBatchActionEnable();
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((MarineLitterBatchUI)this.getUI()).getTable();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        ((MarineLitterBatchUI)this.ui).getMarineLitterBatchAttachmentsButton().onCloseUI();
    }

    public void createBatch() {
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        CreateMarineLitterBatchUI createBatchEditor = parent.getMarineLitterTabCreateBatch();
        createBatchEditor.getHandler().openUI((MarineLitterBatchUIModel)this.getModel());
        parent.getHandler().setMarineLitterSelectedCard("createBatch");
    }

    public void addBatch(CreateMarineLitterBatchUIModel model) {
        if (model.isValid()) {
            MarineLitterBatchTableModel tableModel = this.getTableModel();
            MarineLitterBatchRowModel newRow = tableModel.createNewRow();
            newRow.setMarineLitterCategory(model.getMarineLitterCategory());
            newRow.setMarineLitterSizeCategory(model.getMarineLitterSizeCategory());
            newRow.setNumber(model.getNumber());
            this.recomputeRowValidState(newRow);
            this.saveRow(newRow);
            tableModel.addNewRow(newRow);
            AbstractSelectTableAction.doSelectCell((JTable)this.getTable(), tableModel.getRowCount() - 1, 0);
            this.addToMarineLitterCategoriesUsed(newRow);
        }
        this.recomputeBatchActionEnable();
    }

    protected void recomputeBatchActionEnable() {
        int rowIndex = this.getTable().getSelectedRow();
        boolean enableRemove = false;
        if (rowIndex != -1) {
            enableRemove = true;
        }
        MarineLitterBatchUIModel model = (MarineLitterBatchUIModel)this.getModel();
        model.setRemoveBatchEnabled(enableRemove);
    }

    protected void saveRow(MarineLitterBatchRowModel row) {
        MarineLitterBatch catchBean = (MarineLitterBatch)row.toBean();
        FishingOperation fishingOperation = ((MarineLitterBatchUIModel)this.getModel()).getFishingOperation();
        catchBean.setFishingOperation(fishingOperation);
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected fishingOperation: " + fishingOperation.getId()));
        }
        if (TuttiEntities.isNew(catchBean)) {
            catchBean = this.persistenceService.createMarineLitterBatch(catchBean);
            row.setId(catchBean.getId());
        } else {
            this.persistenceService.saveMarineLitterBatch(catchBean);
        }
    }

    public void removeFromMarineLitterCategoriesUsed(MarineLitterBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getMarineLitterCategory());
        Preconditions.checkNotNull((Object)row.getMarineLitterSizeCategory());
        if (log.isInfoEnabled()) {
            log.info((Object)("Remove from speciesUsed: " + this.decorate(row.getMarineLitterSizeCategory()) + " - " + this.decorate(row.getMarineLitterCategory())));
        }
        MarineLitterBatchUIModel model = (MarineLitterBatchUIModel)this.getModel();
        model.getMarineLitterCategoriesUsed().remove((Object)row.getMarineLitterSizeCategory(), (Object)row.getMarineLitterCategory());
    }

    protected void addToMarineLitterCategoriesUsed(MarineLitterBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getMarineLitterCategory());
        Preconditions.checkNotNull((Object)row.getMarineLitterSizeCategory());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add to marineLitterCategoriesUsed: " + this.decorate(row.getMarineLitterSizeCategory()) + " - " + this.decorate(row.getMarineLitterCategory())));
        }
        MarineLitterBatchUIModel model = (MarineLitterBatchUIModel)this.getModel();
        model.getMarineLitterCategoriesUsed().put((Object)row.getMarineLitterSizeCategory(), (Object)row.getMarineLitterCategory());
    }
}

