package fr.ifremer.tutti.ui.swing.util.attachment;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.JAXXUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class AttachmentItem extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ATTACHMENT = "attachment";
    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ATTACHMENT_NAME_LABEL_TEXT = "attachmentNameLabel.text";
    public static final String BINDING_ATTACHMENT_NAME_LABEL_TOOL_TIP_TEXT = "attachmentNameLabel.toolTipText";
    public static final String BINDING_ATTACHMENT_PANEL_TOOL_TIP_TEXT = "attachmentPanel.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VO28TQRCeONjBCe+EiKdkHkJBkLUoEIjwDkQEmYdIkBBuWPvW8UbnvWV3DIcQiJ/AT4CeBomOClFQU9Ag/gJCFLSI2TvbF8dn4iBcnO9255v95ruZ7958h6w1cGCZhyEzTYWyIdj1S/fu3aosiypeEbZqpMbAQPwbykCmDGNeZ90iHCqXHLzYghdng4YOlFAr0DMlGLX4xBe2LgQi7O9GVK0tLnS2Z0LdNO2sHVJpWV/9/JF56b14nQEINbHbSKUU1kIllWwoQUZ6CDvopEe86HO1RDSMVEvEd7Nbm/W5tTd5QzyE5zBSgpzmhpIhHBy85ChHhA81wlaOyKv1BsXe5kr4CKdrhsmaEQ1hGDYRJWtKZh8TC9ZE6bMEwC51budRNLSO0uYQRpMYhJM9+bQwVloUqioYhUiUwjKPI1+RMEk2UufK84VBmP0XZlc9SdXfnb8WZ0nyjifhTtESr7jqdziZw1bW69Gii88ndDAI/AonOhNdoYu0fJmb7uCJQAuVcLlMpANFR3ch41WH2JkALX8kVgPd3p7uuElSI/h7pIG9XS1Izc2S5k66b6gMWdOkZYRd5d55uENb8STsWjUJLmG0+3ty/Mv7b+/m2u0/QmfvTA1dMb3UltqQTMZ1AfVj3PvufRZvcD1ThrwVPo1+NNr7UogttLaJHJ233cHjdrjGbZ1SZEe+fvg4+eDzMGTmYNQPuDfHXfw85LFuSIXA90J94WLEaNPjjXTd5rghjLlXvSj1ogipj888TRqmcOBcQTV9v3ChsCQwUX/qKKNnmr74oXAminoWkmr7UlTrUK/kP/0aX3h7sa3cEFWyu294ol72PuSk8qUSkXW0XCHVKsa0FU0vSKY/zQ+g1xB0a2IOR9epHp0yCBswEujUwAI5Wok6/1VoR/J4pKC7Y5A+5wMUla9RqyCv+DQj2Rr3Lf1vrgTGE+Y2lwqF115PO7TtEmsdNOzMsooyUPNV5wx5ZxjTNelO3SRPnFY3FA24klWEY7Hl8VXOxmI4c0DW6ER3S3pkACxKnVZJqoWtt6ycpO+RwfXW5EzwX2uKsP1qSnPXddfk0Thi73ua/juv2LD7VjU1ELpPXX2+BmtVRlaX8/mTgIJhy1n3IS5UpPLo43S+55Qhdx2ljH8AuqznVqoJAAA=";
    private static final Log log = LogFactory.getLog(AttachmentItem.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Attachment attachment;
    protected JLabel attachmentNameLabel;
    protected AttachmentItem attachmentPanel = this;
    protected AttachmentEditorUIHandler handler;
    protected JButton openAttachmentButton;
    protected JButton removeAttachmentButton;
    protected JButton saveAttachmentButton;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentItem(Attachment attachment, AttachmentEditorUIHandler handler) {
        this.attachment = attachment;
            this.handler = handler;
            $initialize();
    }

    public AttachmentItem(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem(boolean param0) {
        super(param0);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem() {
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__openAttachmentButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openAttachment(attachment);
    }

    public void doActionPerformed__on__removeAttachmentButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeAttachment(this);
    }

    public void doActionPerformed__on__saveAttachmentButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAttachment(attachment);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Attachment getAttachment() {
        return attachment;
    }

    public JLabel getAttachmentNameLabel() {
        return attachmentNameLabel;
    }

    public AttachmentEditorUIHandler getHandler() {
        return handler;
    }

    public JButton getOpenAttachmentButton() {
        return openAttachmentButton;
    }

    public JButton getRemoveAttachmentButton() {
        return removeAttachmentButton;
    }

    public JButton getSaveAttachmentButton() {
        return saveAttachmentButton;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAttachment(Attachment attachment) {
        Attachment oldValue = this.attachment;
        this.attachment = attachment;
        firePropertyChange(PROPERTY_ATTACHMENT, oldValue, attachment);
    }

    public void setHandler(AttachmentEditorUIHandler handler) {
        AttachmentEditorUIHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAttachmentPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(attachmentNameLabel, BorderLayout.CENTER);
        add(toolbar, BorderLayout.EAST);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(openAttachmentButton);
        toolbar.add(saveAttachmentButton);
        toolbar.add(removeAttachmentButton);
    }

    protected void createAttachment() {
        $objectMap.put("attachment", attachment = null);
    }

    protected void createAttachmentNameLabel() {
        $objectMap.put("attachmentNameLabel", attachmentNameLabel = new JLabel());
        
        attachmentNameLabel.setName("attachmentNameLabel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createOpenAttachmentButton() {
        $objectMap.put("openAttachmentButton", openAttachmentButton = new JButton());
        
        openAttachmentButton.setName("openAttachmentButton");
        openAttachmentButton.setToolTipText(_("tutti.attachmentEditor.action.open.tip"));
        openAttachmentButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openAttachmentButton"));
    }

    protected void createRemoveAttachmentButton() {
        $objectMap.put("removeAttachmentButton", removeAttachmentButton = new JButton());
        
        removeAttachmentButton.setName("removeAttachmentButton");
        removeAttachmentButton.setToolTipText(_("tutti.attachmentEditor.action.remove.tip"));
        removeAttachmentButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeAttachmentButton"));
    }

    protected void createSaveAttachmentButton() {
        $objectMap.put("saveAttachmentButton", saveAttachmentButton = new JButton());
        
        saveAttachmentButton.setName("saveAttachmentButton");
        saveAttachmentButton.setToolTipText(_("tutti.attachmentEditor.action.save.tip"));
        saveAttachmentButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAttachmentButton"));
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAttachmentPanel();
        addChildrenToToolbar();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        openAttachmentButton.setIcon(SwingUtil.createActionIcon("open-file"));
        openAttachmentButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.attachmentEditor.action.open.mnemonic"),'Z'));
        saveAttachmentButton.setIcon(SwingUtil.createActionIcon("import"));
        saveAttachmentButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.attachmentEditor.action.save.mnemonic"),'Z'));
        removeAttachmentButton.setIcon(SwingUtil.createActionIcon("delete"));
        removeAttachmentButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.attachmentEditor.action.remove.mnemonic"),'Z'));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("attachmentPanel", attachmentPanel);
        createAttachment();
        createHandler();
        createAttachmentNameLabel();
        createToolbar();
        createOpenAttachmentButton();
        createSaveAttachmentButton();
        createRemoveAttachmentButton();
        // inline creation of attachmentPanel
        setName("attachmentPanel");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ATTACHMENT_PANEL_TOOL_TIP_TEXT, true ,"attachment") {
        
            @Override
            public void processDataBinding() {
                if (getAttachment() != null) {
                    setToolTipText(_(attachment != null ? getAttachment().getComment() : null));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ATTACHMENT_NAME_LABEL_TEXT, true ,"attachment") {
        
            @Override
            public void processDataBinding() {
                if (getAttachment() != null) {
                    attachmentNameLabel.setText(_(attachment != null ? getAttachment().getName() : null));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ATTACHMENT_NAME_LABEL_TOOL_TIP_TEXT, true ,"attachment") {
        
            @Override
            public void processDataBinding() {
                if (getAttachment() != null) {
                    attachmentNameLabel.setToolTipText(_(attachment != null ? getAttachment().getComment() : null));
                }
            }
        });
    }

}