package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditProtocolUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditProtocolUIModel, EditProtocolUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_BENTHOS_PROTOCOL_BUTTON_ENABLED = "addBenthosProtocolButton.enabled";
    public static final String BINDING_ADD_SPECIES_PROTOCOL_BUTTON_ENABLED = "addSpeciesProtocolButton.enabled";
    public static final String BINDING_BENTHOS_COMBO_BOX_ENABLED = "benthosComboBox.enabled";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_REMOVE_BENTHOS_PROTOCOL_BUTTON_ENABLED = "removeBenthosProtocolButton.enabled";
    public static final String BINDING_REMOVE_SPECIES_PROTOCOL_BUTTON_ENABLED = "removeSpeciesProtocolButton.enabled";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SAVE_WARNING_CONTAINER_VISIBLE = "saveWarningContainer.visible";
    public static final String BINDING_SPECIES_COMBO_BOX_ENABLED = "speciesComboBox.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditProtocolUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addBenthosProtocolButton;
    protected JButton addSpeciesProtocolButton;
    protected JPanel benthosActions;
    protected BeanFilterableComboBox<Species> benthosComboBox;
    protected JPanel benthosPanel;
    protected JXTable benthosTable;
    protected JPopupMenu benthosTablePopup;
    protected TuttiHelpBroker broker;
    protected JPanel caracteristicActions;
    protected JTabbedPane caracteristicPane;
    protected JPanel caracteristicPanel;
    protected JButton closeButton;
    protected JTextArea commentField;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentPane")
    protected JScrollPane commentPane;
    protected EditProtocolUI editProtocolTopPanel = this;
    protected JButton exportAllCaracteristicButton;
    protected JButton exportBenthosButton;
    protected JButton exportCaracteristicButton;
    protected JButton exportPupitriButton;
    protected JButton exportSpeciesButton;
    protected BeanDoubleList<Caracteristic> gearUseFeatureList;
    protected EditProtocolUIHandler handler;
    protected JButton importBenthosButton;
    protected JButton importCaracteristicButton;
    protected JButton importSpeciesButton;
    protected BeanDoubleList<Caracteristic> lengthClassesList;
    protected EditProtocolUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    protected Table protocolInfoForm;
    protected JMenuItem removeBenthosProtocolButton;
    protected JMenuItem removeSpeciesProtocolButton;
    protected JButton saveButton;
    protected JLabel saveWarning;
    protected JPanel saveWarningContainer;
    protected JButton selectOtherBenthosButton;
    protected JButton selectOtherSpeciesButton;
    protected JPanel speciesActions;
    protected BeanFilterableComboBox<Species> speciesComboBox;
    protected JPanel speciesPanel;
    protected JXTable speciesTable;
    protected JPopupMenu speciesTablePopup;
    protected JTabbedPane tabPanel;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditProtocolUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected BeanDoubleList<Caracteristic> vesselUseFeatureList;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;
    private TabInfo $TabInfo3;
    private TabInfo $TabInfo4;
    private TabInfo $TabInfo5;
    private TabInfo $TabInfo6;
    private TabInfo $TabInfo7;
    private TabInfo $TabInfo8;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditProtocolUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                  EditProtocolUIHandler handler = new EditProtocolUIHandler(parentUI, this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public EditProtocolUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI() {
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doKeyPressed__on__benthosTable(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, benthosTablePopup);
    }

    public void doKeyPressed__on__speciesTable(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, speciesTablePopup);
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "name");
    }

    public void doMouseClicked__on__benthosTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, benthosTablePopup);
    }

    public void doMouseClicked__on__speciesTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, speciesTablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddBenthosProtocolButton() {
        return addBenthosProtocolButton;
    }

    public JButton getAddSpeciesProtocolButton() {
        return addSpeciesProtocolButton;
    }

    public JPanel getBenthosActions() {
        return benthosActions;
    }

    public BeanFilterableComboBox<Species> getBenthosComboBox() {
        return benthosComboBox;
    }

    public JPanel getBenthosPanel() {
        return benthosPanel;
    }

    public JXTable getBenthosTable() {
        return benthosTable;
    }

    public JPopupMenu getBenthosTablePopup() {
        return benthosTablePopup;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JPanel getCaracteristicActions() {
        return caracteristicActions;
    }

    public JTabbedPane getCaracteristicPane() {
        return caracteristicPane;
    }

    public JPanel getCaracteristicPanel() {
        return caracteristicPanel;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public JButton getExportAllCaracteristicButton() {
        return exportAllCaracteristicButton;
    }

    public JButton getExportBenthosButton() {
        return exportBenthosButton;
    }

    public JButton getExportCaracteristicButton() {
        return exportCaracteristicButton;
    }

    public JButton getExportPupitriButton() {
        return exportPupitriButton;
    }

    public JButton getExportSpeciesButton() {
        return exportSpeciesButton;
    }

    public BeanDoubleList<Caracteristic> getGearUseFeatureList() {
        return gearUseFeatureList;
    }

    public EditProtocolUIHandler getHandler() {
        return handler;
    }

    public JButton getImportBenthosButton() {
        return importBenthosButton;
    }

    public JButton getImportCaracteristicButton() {
        return importCaracteristicButton;
    }

    public JButton getImportSpeciesButton() {
        return importSpeciesButton;
    }

    public BeanDoubleList<Caracteristic> getLengthClassesList() {
        return lengthClassesList;
    }

    public EditProtocolUIModel getModel() {
        return model;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public Table getProtocolInfoForm() {
        return protocolInfoForm;
    }

    public JMenuItem getRemoveBenthosProtocolButton() {
        return removeBenthosProtocolButton;
    }

    public JMenuItem getRemoveSpeciesProtocolButton() {
        return removeSpeciesProtocolButton;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JLabel getSaveWarning() {
        return saveWarning;
    }

    public JPanel getSaveWarningContainer() {
        return saveWarningContainer;
    }

    public JButton getSelectOtherBenthosButton() {
        return selectOtherBenthosButton;
    }

    public JButton getSelectOtherSpeciesButton() {
        return selectOtherSpeciesButton;
    }

    public JPanel getSpeciesActions() {
        return speciesActions;
    }

    public BeanFilterableComboBox<Species> getSpeciesComboBox() {
        return speciesComboBox;
    }

    public JPanel getSpeciesPanel() {
        return speciesPanel;
    }

    public JXTable getSpeciesTable() {
        return speciesTable;
    }

    public JPopupMenu getSpeciesTablePopup() {
        return speciesTablePopup;
    }

    public JTabbedPane getTabPanel() {
        return tabPanel;
    }

    public SwingValidator<EditProtocolUIModel> getValidator() {
        return validator;
    }

    public BeanDoubleList<Caracteristic> getVesselUseFeatureList() {
        return vesselUseFeatureList;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    protected TabInfo get$TabInfo6() {
        return $TabInfo6;
    }

    protected TabInfo get$TabInfo7() {
        return $TabInfo7;
    }

    protected TabInfo get$TabInfo8() {
        return $TabInfo8;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBenthosActions() {
        if (!allComponentsCreated) {
            return;
        }
        benthosActions.add(importBenthosButton);
        benthosActions.add(exportBenthosButton);
    }

    protected void addChildrenToBenthosPanel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosPanel.add(benthosActions, BorderLayout.NORTH);
        benthosPanel.add($Table1, BorderLayout.CENTER);
    }

    protected void addChildrenToBenthosTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTablePopup.add(removeBenthosProtocolButton);
    }

    protected void addChildrenToCaracteristicActions() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicActions.add(importCaracteristicButton);
        caracteristicActions.add(exportCaracteristicButton);
        caracteristicActions.add(exportAllCaracteristicButton);
    }

    protected void addChildrenToCaracteristicPane() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicPane.add(lengthClassesList);
        caracteristicPane.add(gearUseFeatureList);
        caracteristicPane.add(vesselUseFeatureList);
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(caracteristicPane, 0));
        caracteristicPane.setTitleAt(0, _("tutti.editProtocol.tab.caracteristic.lengthClasses"));
        $TabInfo3.addPropertyChangeListener(new TabInfoPropertyChangeListener(caracteristicPane, 1));
        caracteristicPane.setTitleAt(1, _("tutti.editProtocol.tab.caracteristic.gearUseFeature"));
        $TabInfo4.addPropertyChangeListener(new TabInfoPropertyChangeListener(caracteristicPane, 2));
        caracteristicPane.setTitleAt(2, _("tutti.editProtocol.tab.caracteristic.vesselUseFeature"));
    }

    protected void addChildrenToCaracteristicPanel() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicPanel.add(caracteristicActions, BorderLayout.NORTH);
        caracteristicPanel.add(caracteristicPane, BorderLayout.CENTER);
    }

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(commentField);
    }

    protected void addChildrenToEditProtocolTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(tabPanel, BorderLayout.CENTER);
        add(saveWarningContainer, BorderLayout.NORTH);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToProtocolInfoForm() {
        if (!allComponentsCreated) {
            return;
        }
        protocolInfoForm.add(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        protocolInfoForm.add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        protocolInfoForm.add(SwingUtil.boxComponentWithJxLayer(commentPane), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.8, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSaveWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        saveWarningContainer.add(saveWarning, BorderLayout.CENTER);
    }

    protected void addChildrenToSpeciesActions() {
        if (!allComponentsCreated) {
            return;
        }
        speciesActions.add(importSpeciesButton);
        speciesActions.add(exportSpeciesButton);
        speciesActions.add(exportPupitriButton);
    }

    protected void addChildrenToSpeciesPanel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesPanel.add(speciesActions, BorderLayout.NORTH);
        speciesPanel.add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToSpeciesTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTablePopup.add(removeSpeciesProtocolButton);
    }

    protected void addChildrenToTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        tabPanel.add(protocolInfoForm);
        tabPanel.add(caracteristicPanel);
        tabPanel.add(speciesPanel);
        tabPanel.add(benthosPanel);
        tabPanel.add($JLabel0);
        tabPanel.add($JLabel1);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPanel, 0));
        tabPanel.setTitleAt(0, _("tutti.editProtocol.tab.info"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPanel, 1));
        tabPanel.setTitleAt(1, _("tutti.editProtocol.tab.caracteristic"));
        $TabInfo5.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPanel, 2));
        tabPanel.setTitleAt(2, _("tutti.editProtocol.tab.species"));
        $TabInfo6.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPanel, 3));
        tabPanel.setTitleAt(3, _("tutti.editProtocol.tab.benthos"));
        $TabInfo7.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPanel, 4));
        tabPanel.setTitleAt(4, _("tutti.editProtocol.tab.plankton"));
        tabPanel.setEnabledAt(4, false);
        $TabInfo8.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPanel, 5));
        tabPanel.setTitleAt(5, _("tutti.editProtocol.tab.accidental"));
        tabPanel.setEnabledAt(5, false);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddBenthosProtocolButton() {
        $objectMap.put("addBenthosProtocolButton", addBenthosProtocolButton = new JButton());
        
        addBenthosProtocolButton.setName("addBenthosProtocolButton");
        addBenthosProtocolButton.setToolTipText(_("tutti.editProtocol.action.addBenthosProtocol.tip"));
        addBenthosProtocolButton.putClientProperty("help", "tutti.editProtocol.action.addBenthosProtocol.help");
        addBenthosProtocolButton.putClientProperty("tuttiAction", AddBenthosProtocolAction.class);
    }

    protected void createAddSpeciesProtocolButton() {
        $objectMap.put("addSpeciesProtocolButton", addSpeciesProtocolButton = new JButton());
        
        addSpeciesProtocolButton.setName("addSpeciesProtocolButton");
        addSpeciesProtocolButton.setToolTipText(_("tutti.editProtocol.action.addSpeciesProtocol.tip"));
        addSpeciesProtocolButton.putClientProperty("help", "tutti.editProtocol.action.addSpeciesProtocol.help");
        addSpeciesProtocolButton.putClientProperty("tuttiAction", AddSpeciesProtocolAction.class);
    }

    protected void createBenthosActions() {
        $objectMap.put("benthosActions", benthosActions = new JPanel());
        
        benthosActions.setName("benthosActions");
        benthosActions.setLayout(new GridLayout());
    }

    protected void createBenthosComboBox() {
        $objectMap.put("benthosComboBox", benthosComboBox = new BeanFilterableComboBox<Species>(this));
        
        benthosComboBox.setName("benthosComboBox");
        benthosComboBox.setI18nPrefix("tutti.property.");
        benthosComboBox.setShowReset(true);
        benthosComboBox.setToolTipText(_("tutti.editProtocol.field.benthos.tip"));
        benthosComboBox.putClientProperty("help", "tutti.editProtocol.field.benthos.help");
    }

    protected void createBenthosPanel() {
        $objectMap.put("benthosPanel", benthosPanel = new JPanel());
        
        benthosPanel.setName("benthosPanel");
        benthosPanel.setLayout(new BorderLayout());
    }

    protected void createBenthosTable() {
        $objectMap.put("benthosTable", benthosTable = new JXTable());
        
        benthosTable.setName("benthosTable");
        benthosTable.setSortable(false);
        benthosTable.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__benthosTable"));
        benthosTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__benthosTable"));
        benthosTable.putClientProperty("help", "tutti.editProtocol.field.benthos.help");
    }

    protected void createBenthosTablePopup() {
        $objectMap.put("benthosTablePopup", benthosTablePopup = new JPopupMenu());
        
        benthosTablePopup.setName("benthosTablePopup");
        benthosTablePopup.setLabel("tutti.editProtocol.title.batchActions");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editProtocol.help"));
    }

    protected void createCaracteristicActions() {
        $objectMap.put("caracteristicActions", caracteristicActions = new JPanel());
        
        caracteristicActions.setName("caracteristicActions");
        caracteristicActions.setLayout(new GridLayout());
    }

    protected void createCaracteristicPane() {
        $objectMap.put("caracteristicPane", caracteristicPane = new JTabbedPane());
        
        caracteristicPane.setName("caracteristicPane");
        caracteristicPane.putClientProperty("help", "tutti.editProtocol.pane.caracteristic.help");
    }

    protected void createCaracteristicPanel() {
        $objectMap.put("caracteristicPanel", caracteristicPanel = new JPanel());
        
        caracteristicPanel.setName("caracteristicPanel");
        caracteristicPanel.setLayout(new BorderLayout());
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(_("tutti.editProtocol.action.closeEditProtocol"));
        closeButton.setToolTipText(_("tutti.editProtocol.action.closeEditProtocol.tip"));
        closeButton.putClientProperty("help", "tutti.editProtocol.action.closeEditProtocol.help");
        closeButton.putClientProperty("tuttiAction", fr.ifremer.tutti.ui.swing.content.SelectCruiseAction.class);
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
        commentField.putClientProperty("validatorLabel", _("tutti.editProtocol.field.comment"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.setToolTipText(_("tutti.editProtocol.field.comment.tip"));
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
        commentPane.putClientProperty("help", "tutti.editProtocol.field.comment.help");
    }

    protected void createExportAllCaracteristicButton() {
        $objectMap.put("exportAllCaracteristicButton", exportAllCaracteristicButton = new JButton());
        
        exportAllCaracteristicButton.setName("exportAllCaracteristicButton");
        exportAllCaracteristicButton.setText(_("tutti.editProtocol.action.exportProtocolAllCaracteristic"));
        exportAllCaracteristicButton.setToolTipText(_("tutti.editProtocol.action.exportProtocolAllCaracteristic.tip"));
        exportAllCaracteristicButton.putClientProperty("help", "tutti.editProtocol.action.exportProtocolAllCaracteristic.help");
        exportAllCaracteristicButton.putClientProperty("tuttiAction", ExportAllCaracteristicAction.class);
    }

    protected void createExportBenthosButton() {
        $objectMap.put("exportBenthosButton", exportBenthosButton = new JButton());
        
        exportBenthosButton.setName("exportBenthosButton");
        exportBenthosButton.setText(_("tutti.editProtocol.action.exportProtocolBenthos"));
        exportBenthosButton.setToolTipText(_("tutti.editProtocol.action.exportProtocolBenthos.tip"));
        exportBenthosButton.putClientProperty("help", "tutti.editProtocol.action.exportProtocolBenthos.help");
        exportBenthosButton.putClientProperty("tuttiAction", ExportProtocolBenthosAction.class);
    }

    protected void createExportCaracteristicButton() {
        $objectMap.put("exportCaracteristicButton", exportCaracteristicButton = new JButton());
        
        exportCaracteristicButton.setName("exportCaracteristicButton");
        exportCaracteristicButton.setText(_("tutti.editProtocol.action.exportProtocolCaracteristic"));
        exportCaracteristicButton.setToolTipText(_("tutti.editProtocol.action.exportProtocolCaracteristic.tip"));
        exportCaracteristicButton.putClientProperty("help", "tutti.editProtocol.action.exportProtocolCaracteristic.tip");
        exportCaracteristicButton.putClientProperty("tuttiAction", ExportProtocolCaracteristicAction.class);
    }

    protected void createExportPupitriButton() {
        $objectMap.put("exportPupitriButton", exportPupitriButton = new JButton());
        
        exportPupitriButton.setName("exportPupitriButton");
        exportPupitriButton.setText(_("tutti.editProtocol.action.exportPupitri"));
        exportPupitriButton.setToolTipText(_("tutti.editProtocol.action.exportPupitri.tip"));
        exportPupitriButton.putClientProperty("help", "tutti.editProtocol.action.exportPupitri.help");
        exportPupitriButton.putClientProperty("tuttiAction", ExportPupitriAction.class);
    }

    protected void createExportSpeciesButton() {
        $objectMap.put("exportSpeciesButton", exportSpeciesButton = new JButton());
        
        exportSpeciesButton.setName("exportSpeciesButton");
        exportSpeciesButton.setText(_("tutti.editProtocol.action.exportProtocolSpecies"));
        exportSpeciesButton.setToolTipText(_("tutti.editProtocol.action.exportProtocolSpecies.tip"));
        exportSpeciesButton.putClientProperty("help", "tutti.editProtocol.action.exportProtocolSpecies.help");
        exportSpeciesButton.putClientProperty("tuttiAction", ExportProtocolSpeciesAction.class);
    }

    protected void createGearUseFeatureList() {
        $objectMap.put("gearUseFeatureList", gearUseFeatureList = new BeanDoubleList<Caracteristic>());
        
        gearUseFeatureList.setName("gearUseFeatureList");
        gearUseFeatureList.setI18nPrefix("tutti.property.");
        gearUseFeatureList.setProperty("gearUseFeaturePmfm");
        gearUseFeatureList.setShowReset(true);
        gearUseFeatureList.putClientProperty("help", "tutti.editProtocol.field.gearUseFeature.help");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditProtocolUIHandler.class));
    }

    protected void createImportBenthosButton() {
        $objectMap.put("importBenthosButton", importBenthosButton = new JButton());
        
        importBenthosButton.setName("importBenthosButton");
        importBenthosButton.setText(_("tutti.editProtocol.action.importProtocolBenthos"));
        importBenthosButton.setToolTipText(_("tutti.editProtocol.action.importProtocolBenthos.tip"));
        importBenthosButton.putClientProperty("help", "tutti.editProtocol.action.importProtocolBenthos.help");
        importBenthosButton.putClientProperty("tuttiAction", ImportProtocolBenthosAction.class);
    }

    protected void createImportCaracteristicButton() {
        $objectMap.put("importCaracteristicButton", importCaracteristicButton = new JButton());
        
        importCaracteristicButton.setName("importCaracteristicButton");
        importCaracteristicButton.setText(_("tutti.editProtocol.action.importProtocolCaracteristic"));
        importCaracteristicButton.setToolTipText(_("tutti.editProtocol.action.importProtocolCaracteristic.tip"));
        importCaracteristicButton.putClientProperty("help", "tutti.editProtocol.action.importProtocolCaracteristic.help");
        importCaracteristicButton.putClientProperty("tuttiAction", ImportProtocolCaracteristicAction.class);
    }

    protected void createImportSpeciesButton() {
        $objectMap.put("importSpeciesButton", importSpeciesButton = new JButton());
        
        importSpeciesButton.setName("importSpeciesButton");
        importSpeciesButton.setText(_("tutti.editProtocol.action.importProtocolSpecies"));
        importSpeciesButton.setToolTipText(_("tutti.editProtocol.action.importProtocolSpecies.tip"));
        importSpeciesButton.putClientProperty("help", "tutti.editProtocol.action.importProtocolSpecies.help");
        importSpeciesButton.putClientProperty("tuttiAction", ImportProtocolSpeciesAction.class);
    }

    protected void createLengthClassesList() {
        $objectMap.put("lengthClassesList", lengthClassesList = new BeanDoubleList<Caracteristic>());
        
        lengthClassesList.setName("lengthClassesList");
        lengthClassesList.setI18nPrefix("tutti.property.");
        lengthClassesList.setProperty("lengthClassesPmfm");
        lengthClassesList.setShowReset(true);
        lengthClassesList.putClientProperty("help", "tutti.editProtocol.field.lengthClasses.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditProtocolUIModel.class));
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
        nameField.putClientProperty("validatorLabel", _("tutti.editProtocol.field.protocol.name"));
        nameField.putClientProperty("selectOnFocus", true);
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(_("tutti.editProtocol.field.protocol.name"));
        nameLabel.setToolTipText(_("tutti.editProtocol.field.protocol.name.tip"));
        nameLabel.putClientProperty("help", "tutti.editProtocol.field.name.help");
    }

    protected void createProtocolInfoForm() {
        $objectMap.put("protocolInfoForm", protocolInfoForm = new Table());
        
        protocolInfoForm.setName("protocolInfoForm");
    }

    protected void createRemoveBenthosProtocolButton() {
        $objectMap.put("removeBenthosProtocolButton", removeBenthosProtocolButton = new JMenuItem());
        
        removeBenthosProtocolButton.setName("removeBenthosProtocolButton");
        removeBenthosProtocolButton.setText(_("tutti.editProtocol.action.removeBenthosProtocol"));
        removeBenthosProtocolButton.setToolTipText(_("tutti.editProtocol.action.removeBenthosProtocol.tip"));
        removeBenthosProtocolButton.putClientProperty("help", "tutti.editProtocol.action.removeBenthosProtocol.help");
        removeBenthosProtocolButton.putClientProperty("tuttiAction", RemoveBenthosProtocolAction.class);
    }

    protected void createRemoveSpeciesProtocolButton() {
        $objectMap.put("removeSpeciesProtocolButton", removeSpeciesProtocolButton = new JMenuItem());
        
        removeSpeciesProtocolButton.setName("removeSpeciesProtocolButton");
        removeSpeciesProtocolButton.setText(_("tutti.editProtocol.action.removeSpeciesProtocol"));
        removeSpeciesProtocolButton.setToolTipText(_("tutti.editProtocol.action.removeSpeciesProtocol.tip"));
        removeSpeciesProtocolButton.putClientProperty("help", "tutti.editProtocol.action.removeSpeciesProtocol.help");
        removeSpeciesProtocolButton.putClientProperty("tuttiAction", RemoveSpeciesProtocolAction.class);
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.editProtocol.action.saveProtocol"));
        saveButton.setToolTipText(_("tutti.editProtocol.action.saveProtocol.tip"));
        saveButton.putClientProperty("help", "tutti.editProtocol.action.saveProtocol.help");
        saveButton.putClientProperty("tuttiAction", SaveProtocolAction.class);
    }

    protected void createSaveWarning() {
        $objectMap.put("saveWarning", saveWarning = new JLabel());
        
        saveWarning.setName("saveWarning");
    }

    protected void createSaveWarningContainer() {
        $objectMap.put("saveWarningContainer", saveWarningContainer = new JPanel());
        
        saveWarningContainer.setName("saveWarningContainer");
        saveWarningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createSelectOtherBenthosButton() {
        $objectMap.put("selectOtherBenthosButton", selectOtherBenthosButton = new JButton());
        
        selectOtherBenthosButton.setName("selectOtherBenthosButton");
        selectOtherBenthosButton.setText(_("tutti.editProtocol.action.selectOtherBenthos"));
        selectOtherBenthosButton.setToolTipText(_("tutti.editProtocol.action.selectOtherBenthos.tip"));
        selectOtherBenthosButton.putClientProperty("help", "tutti.editProtocol.action.selectOtherBenthos.help");
        selectOtherBenthosButton.putClientProperty("tuttiAction", SelectOtherBenthosAction.class);
    }

    protected void createSelectOtherSpeciesButton() {
        $objectMap.put("selectOtherSpeciesButton", selectOtherSpeciesButton = new JButton());
        
        selectOtherSpeciesButton.setName("selectOtherSpeciesButton");
        selectOtherSpeciesButton.setText(_("tutti.editProtocol.action.selectOtherSpecies"));
        selectOtherSpeciesButton.setToolTipText(_("tutti.editProtocol.action.selectOtherSpecies.tip"));
        selectOtherSpeciesButton.putClientProperty("help", "tutti.editProtocol.action.selectOtherSpecies.help");
        selectOtherSpeciesButton.putClientProperty("tuttiAction", SelectOtherSpeciesAction.class);
    }

    protected void createSpeciesActions() {
        $objectMap.put("speciesActions", speciesActions = new JPanel());
        
        speciesActions.setName("speciesActions");
        speciesActions.setLayout(new GridLayout());
    }

    protected void createSpeciesComboBox() {
        $objectMap.put("speciesComboBox", speciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        speciesComboBox.setName("speciesComboBox");
        speciesComboBox.setI18nPrefix("tutti.property.");
        speciesComboBox.setShowReset(true);
        speciesComboBox.setToolTipText(_("tutti.editProtocol.field.species.tip"));
        speciesComboBox.putClientProperty("help", "tutti.editProtocol.field.species.help");
    }

    protected void createSpeciesPanel() {
        $objectMap.put("speciesPanel", speciesPanel = new JPanel());
        
        speciesPanel.setName("speciesPanel");
        speciesPanel.setLayout(new BorderLayout());
    }

    protected void createSpeciesTable() {
        $objectMap.put("speciesTable", speciesTable = new JXTable());
        
        speciesTable.setName("speciesTable");
        speciesTable.setSortable(false);
        speciesTable.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__speciesTable"));
        speciesTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__speciesTable"));
        speciesTable.putClientProperty("help", "tutti.editProtocol.field.species.help");
    }

    protected void createSpeciesTablePopup() {
        $objectMap.put("speciesTablePopup", speciesTablePopup = new JPopupMenu());
        
        speciesTablePopup.setName("speciesTablePopup");
        speciesTablePopup.setLabel("tutti.editProtocol.title.batchActions");
    }

    protected void createTabPanel() {
        $objectMap.put("tabPanel", tabPanel = new JTabbedPane());
        
        tabPanel.setName("tabPanel");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditProtocolUIModel.class, null));
    }

    protected void createVesselUseFeatureList() {
        $objectMap.put("vesselUseFeatureList", vesselUseFeatureList = new BeanDoubleList<Caracteristic>());
        
        vesselUseFeatureList.setName("vesselUseFeatureList");
        vesselUseFeatureList.setI18nPrefix("tutti.property.");
        vesselUseFeatureList.setProperty("vesselUseFeaturePmfm");
        vesselUseFeatureList.setShowReset(true);
        vesselUseFeatureList.putClientProperty("help", "tutti.editProtocol.field.vesselUseFeature.help");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditProtocolTopPanel();
        addChildrenToValidator();
        addChildrenToSpeciesTablePopup();
        addChildrenToBenthosTablePopup();
        addChildrenToTabPanel();
        addChildrenToProtocolInfoForm();
        addChildrenToCommentPane();
        addChildrenToCaracteristicPanel();
        addChildrenToCaracteristicActions();
        addChildrenToCaracteristicPane();
        addChildrenToSpeciesPanel();
        addChildrenToSpeciesActions();
        // inline complete setup of $Table0
        $Table0.add(speciesComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(selectOtherSpeciesButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addSpeciesProtocolButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 3, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(speciesTable);
        addChildrenToBenthosPanel();
        addChildrenToBenthosActions();
        // inline complete setup of $Table1
        $Table1.add(benthosComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(selectOtherBenthosButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(addBenthosProtocolButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane1, new GridBagConstraints(0, 1, 3, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(benthosTable);
        addChildrenToSaveWarningContainer();
        // inline complete setup of $JPanel0
        $JPanel0.add(closeButton);
        $JPanel0.add(saveButton);
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 61 property setters
        lengthClassesList.setBeanType(Caracteristic.class);
        gearUseFeatureList.setBeanType(Caracteristic.class);
        vesselUseFeatureList.setBeanType(Caracteristic.class);
        speciesComboBox.setBeanType(Species.class);
        benthosComboBox.setBeanType(Species.class);
        $JLabel0.setHorizontalAlignment(JLabel.CENTER);
        $JLabel1.setHorizontalAlignment(JLabel.CENTER);
        removeSpeciesProtocolButton.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeSpeciesProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.removeSpeciesProtocol.mnemonic"),'Z'));
        removeBenthosProtocolButton.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeBenthosProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.removeBenthosProtocol.mnemonic"),'Z'));
        nameLabel.setLabelFor(nameField);
        commentPane.setBorder(BorderFactory.createTitledBorder(_("tutti.editProtocol.field.comment")));
        importCaracteristicButton.setIcon(SwingUtil.createActionIcon("import"));
        importCaracteristicButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.importProtocolCaracteristic.mnemonic"),'Z'));
        exportCaracteristicButton.setIcon(SwingUtil.createActionIcon("export"));
        exportCaracteristicButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.exportProtocolCaracteristic.mnemonic"),'Z'));
        exportAllCaracteristicButton.setIcon(SwingUtil.createActionIcon("export"));
        exportAllCaracteristicButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.exportProtocolAllCaracteristic.mnemonic"),'Z'));
        caracteristicPane.setTabPlacement(JTabbedPane.LEFT);
        lengthClassesList.setBean(model);
        gearUseFeatureList.setBean(model);
        vesselUseFeatureList.setBean(model);
        importSpeciesButton.setIcon(SwingUtil.createActionIcon("import"));
        importSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.importProtocolSpecies.mnemonic"),'Z'));
        exportSpeciesButton.setIcon(SwingUtil.createActionIcon("export"));
        exportSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.exportProtocolSpecies.mnemonic"),'Z'));
        exportPupitriButton.setIcon(SwingUtil.createActionIcon("export"));
        exportPupitriButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.exportPupitri.mnemonic"),'Z'));
        selectOtherSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.selectOtherSpecies.mnemonic"),'Z'));
        addSpeciesProtocolButton.setIcon(SwingUtil.createActionIcon("add"));
        addSpeciesProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.addSpeciesProtocol.mnemonic"),'Z'));
        speciesTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        speciesTable.setSelectionForeground(Color.BLACK);
        speciesTable.setSelectionBackground(null);
        importBenthosButton.setIcon(SwingUtil.createActionIcon("import"));
        importBenthosButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.importProtocolBenthos.mnemonic"),'Z'));
        exportBenthosButton.setIcon(SwingUtil.createActionIcon("export"));
        exportBenthosButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.exportProtocolBenthos.mnemonic"),'Z'));
        selectOtherBenthosButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.selectOtherBenthos.mnemonic"),'Z'));
        addBenthosProtocolButton.setIcon(SwingUtil.createActionIcon("add"));
        addBenthosProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.addBenthosProtocol.mnemonic"),'Z'));
        benthosTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        benthosTable.setSelectionForeground(Color.BLACK);
        benthosTable.setSelectionBackground(null);
        saveWarningContainer.setBackground(new java.awt.Color(245, 218, 88));
        saveWarning.setIcon(SwingUtil.createActionIcon("warning"));
        saveWarning.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.closeEditProtocol.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editProtocol.action.saveProtocol.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editProtocolTopPanel, "tutti.editProtocol.help");
        registerHelpId(_broker, removeSpeciesProtocolButton, "tutti.editProtocol.action.removeSpeciesProtocol.help");
        registerHelpId(_broker, removeBenthosProtocolButton, "tutti.editProtocol.action.removeBenthosProtocol.help");
        registerHelpId(_broker, nameLabel, "tutti.editProtocol.field.name.help");
        registerHelpId(_broker, commentPane, "tutti.editProtocol.field.comment.help");
        registerHelpId(_broker, importCaracteristicButton, "tutti.editProtocol.action.importProtocolCaracteristic.help");
        registerHelpId(_broker, exportCaracteristicButton, "tutti.editProtocol.action.exportProtocolCaracteristic.tip");
        registerHelpId(_broker, exportAllCaracteristicButton, "tutti.editProtocol.action.exportProtocolAllCaracteristic.help");
        registerHelpId(_broker, caracteristicPane, "tutti.editProtocol.pane.caracteristic.help");
        registerHelpId(_broker, lengthClassesList, "tutti.editProtocol.field.lengthClasses.help");
        registerHelpId(_broker, gearUseFeatureList, "tutti.editProtocol.field.gearUseFeature.help");
        registerHelpId(_broker, vesselUseFeatureList, "tutti.editProtocol.field.vesselUseFeature.help");
        registerHelpId(_broker, importSpeciesButton, "tutti.editProtocol.action.importProtocolSpecies.help");
        registerHelpId(_broker, exportSpeciesButton, "tutti.editProtocol.action.exportProtocolSpecies.help");
        registerHelpId(_broker, exportPupitriButton, "tutti.editProtocol.action.exportPupitri.help");
        registerHelpId(_broker, speciesComboBox, "tutti.editProtocol.field.species.help");
        registerHelpId(_broker, selectOtherSpeciesButton, "tutti.editProtocol.action.selectOtherSpecies.help");
        registerHelpId(_broker, addSpeciesProtocolButton, "tutti.editProtocol.action.addSpeciesProtocol.help");
        registerHelpId(_broker, speciesTable, "tutti.editProtocol.field.species.help");
        registerHelpId(_broker, importBenthosButton, "tutti.editProtocol.action.importProtocolBenthos.help");
        registerHelpId(_broker, exportBenthosButton, "tutti.editProtocol.action.exportProtocolBenthos.help");
        registerHelpId(_broker, benthosComboBox, "tutti.editProtocol.field.benthos.help");
        registerHelpId(_broker, selectOtherBenthosButton, "tutti.editProtocol.action.selectOtherBenthos.help");
        registerHelpId(_broker, addBenthosProtocolButton, "tutti.editProtocol.action.addBenthosProtocol.help");
        registerHelpId(_broker, benthosTable, "tutti.editProtocol.field.benthos.help");
        registerHelpId(_broker, closeButton, "tutti.editProtocol.action.closeEditProtocol.help");
        registerHelpId(_broker, saveButton, "tutti.editProtocol.action.saveProtocol.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editProtocolTopPanel", editProtocolTopPanel);
        createHandler();
        createModel();
        createBroker();
        createValidator();
        createSpeciesTablePopup();
        createRemoveSpeciesProtocolButton();
        createBenthosTablePopup();
        createRemoveBenthosProtocolButton();
        createTabPanel();
        createProtocolInfoForm();
        createNameLabel();
        createNameField();
        createCommentPane();
        createCommentField();
        createCaracteristicPanel();
        createCaracteristicActions();
        createImportCaracteristicButton();
        createExportCaracteristicButton();
        createExportAllCaracteristicButton();
        createCaracteristicPane();
        createLengthClassesList();
        createGearUseFeatureList();
        createVesselUseFeatureList();
        createSpeciesPanel();
        createSpeciesActions();
        createImportSpeciesButton();
        createExportSpeciesButton();
        createExportPupitriButton();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createSpeciesComboBox();
        createSelectOtherSpeciesButton();
        createAddSpeciesProtocolButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createSpeciesTable();
        createBenthosPanel();
        createBenthosActions();
        createImportBenthosButton();
        createExportBenthosButton();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createBenthosComboBox();
        createSelectOtherBenthosButton();
        createAddBenthosProtocolButton();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createBenthosTable();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("tutti.to.be.done"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("tutti.to.be.done"));
        createSaveWarningContainer();
        createSaveWarning();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCloseButton();
        createSaveButton();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(_("tutti.editProtocol.tab.info"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(_("tutti.editProtocol.tab.caracteristic"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setTitle(_("tutti.editProtocol.tab.caracteristic.lengthClasses"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new TabInfo());
        
        $TabInfo3.setTitle(_("tutti.editProtocol.tab.caracteristic.gearUseFeature"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new TabInfo());
        
        $TabInfo4.setTitle(_("tutti.editProtocol.tab.caracteristic.vesselUseFeature"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new TabInfo());
        
        $TabInfo5.setTitle(_("tutti.editProtocol.tab.species"));
        // inline creation of $TabInfo6
        $objectMap.put("$TabInfo6", $TabInfo6 = new TabInfo());
        
        $TabInfo6.setTitle(_("tutti.editProtocol.tab.benthos"));
        // inline creation of $TabInfo7
        $objectMap.put("$TabInfo7", $TabInfo7 = new TabInfo());
        
        $TabInfo7.setEnabled(false);
        $TabInfo7.setTitle(_("tutti.editProtocol.tab.plankton"));
        // inline creation of $TabInfo8
        $objectMap.put("$TabInfo8", $TabInfo8 = new TabInfo());
        
        $TabInfo8.setEnabled(false);
        $TabInfo8.setTitle(_("tutti.editProtocol.tab.accidental"));
        // inline creation of editProtocolTopPanel
        setName("editProtocolTopPanel");
        setLayout(new BorderLayout());
        editProtocolTopPanel.putClientProperty("help", "tutti.editProtocol.help");
        
        // registers 10 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 10 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_PROTOCOL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeSpeciesEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesProtocolButton.setEnabled(model.isRemoveSpeciesEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeSpeciesEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_BENTHOS_PROTOCOL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeBenthosEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeBenthosProtocolButton.setEnabled(model.isRemoveBenthosEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeBenthosEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(nameField, model.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, getStringValue(model.getComment()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.setEnabled(!speciesComboBox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_SPECIES_PROTOCOL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesComboBox != null) {
                    addSpeciesProtocolButton.setEnabled(speciesComboBox.getSelectedItem() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (benthosComboBox != null) {
                    benthosComboBox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (benthosComboBox != null) {
                    benthosComboBox.setEnabled(!benthosComboBox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (benthosComboBox != null) {
                    benthosComboBox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_BENTHOS_PROTOCOL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (benthosComboBox != null) {
                    benthosComboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (benthosComboBox != null) {
                    addBenthosProtocolButton.setEnabled(benthosComboBox.getSelectedItem() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (benthosComboBox != null) {
                    benthosComboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_WARNING_CONTAINER_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("imported", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cloned", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveWarningContainer.setVisible(model.isImported() || model.isCloned());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("imported", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cloned", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}