package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUIModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JComponent;
import java.awt.Dimension;
import java.util.List;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.4
 */
public class CreateIndividualObservationBatchUIHandler extends AbstractTuttiUIHandler<CreateIndividualObservationBatchUIModel, CreateIndividualObservationBatchUI>
        implements Cancelable {

    private static final Log log =
            LogFactory.getLog(CreateIndividualObservationBatchUIHandler.class);

    public CreateIndividualObservationBatchUIHandler(TuttiUI parentUi,
                                                     CreateIndividualObservationBatchUI ui) {
        super(parentUi.getHandler().getContext(), ui);
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    @Override
    public void beforeInitUI() {
        CreateIndividualObservationBatchUIModel model = new CreateIndividualObservationBatchUIModel();
        ui.setContextValue(model);
        listModelIsModify(model);
    }

    @Override
    public void afterInitUI() {

        initUI(ui);

        initBeanFilterableComboBox(ui.getIndividualObservationSpeciesComboBox(),
                                   getDataContext().getReferentSpecies(),
                                   null);

        initBeanFilterableComboBox(ui.getIndividualObservationLengthStepCaracteristicComboBox(),
                                   getDataContext().getLengthStepCaracteristics(),
                                   null);

        listenValidatorValid(ui.getValidator(), getModel());
    }

    @Override
    protected JComponent getComponentToFocus() {
        return getUI().getIndividualObservationSpeciesComboBox();
    }

    @Override
    public void onCloseUI() {

        if (log.isDebugEnabled()) {
            log.debug("closing: " + ui);
        }

        // evict model from validator
        ui.getValidator().setBean(null);

        // when canceling always invalid model
        getModel().setValid(false);

        EditCatchesUI parent = SwingUtil.getParentContainer(ui, EditCatchesUI.class);
        parent.getHandler().setIndividualObservationSelectedCard(EditCatchesUIHandler.MAIN_CARD);
    }

    @Override
    public SwingValidator<CreateIndividualObservationBatchUIModel> getValidator() {
        return ui.getValidator();
    }

    //------------------------------------------------------------------------//
    //-- Cancelable methods                                                 --//
    //------------------------------------------------------------------------//

    @Override
    public void cancel() {
        if (log.isInfoEnabled()) {
            log.info("Cancel UI " + ui);
        }
        closeUI(ui);
    }

    //------------------------------------------------------------------------//
    //-- Public methods                                                     --//
    //------------------------------------------------------------------------//

    public void openUI() {

        CreateIndividualObservationBatchUIModel model = getModel();

        // connect model to validator
        ui.getValidator().setBean(model);

        model.reset();

    }

    public void save() {

        if (log.isInfoEnabled()) {
            log.info("Save UI " + ui);
        }

        EditCatchesUI parent = SwingUtil.getParentContainer(ui, EditCatchesUI.class);
        parent.getIndividualObservationTabContent().getHandler().addBatch(getModel());

        // close dialog
        closeUI(ui);
    }

    public Species openAddSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUI dialogContent = new SelectSpeciesUI(ui);
        SelectSpeciesUIModel model = dialogContent.getModel();
        model.setSelectedSpecies(null);
        model.setSpecies(species);

        openDialog(dialogContent, title, new Dimension(400, 130));

        Species result = model.getSelectedSpecies();
        return result;
    }
}
