package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

/*
 * #%L
 * Tutti :: UI
 * $Id: CreateBenthosMelagAction.java 739 2013-04-05 13:36:16Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.4/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/benthos/CreateBenthosMelagAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Maps;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.species.EnterMelagWeightDialog;
import jaxx.runtime.SwingUtil;
import org.apache.commons.lang3.StringUtils;

import javax.swing.JOptionPane;
import java.awt.Frame;
import java.util.Map;

import static org.nuiton.i18n.I18n._;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0.2
 */
public class CreateBenthosMelagAction extends AbstractTuttiAction<BenthosBatchUIModel, BenthosBatchUI, BenthosBatchUIHandler> {

    protected Map<BenthosBatchRowModel, Float> selectedRows = Maps.newHashMap();

    protected Float melagWeight = null;

    protected Float sampleMelagWeight = null;

    protected Float sortedWeight = null;

    public CreateBenthosMelagAction(BenthosBatchUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();

        int[] selectedRowIndexes = handler.getTable().getSelectedRows();

        BenthosBatchTableModel tableModel = handler.getTableModel();

        // sum of the weights already entered by the user
        Float alreadyKnownWeights = 0f;
        sortedWeight = 0f;

        for (int selectedRowIndex : selectedRowIndexes) {
            BenthosBatchRowModel selectedRow =
                    tableModel.getEntry(selectedRowIndex);

            Float sampleWeight = null;
            if (selectedRow.getFinestCategory().getNotNullWeight() != null) {
                alreadyKnownWeights += selectedRow.getFinestCategory().getNotNullWeight();

            } else if (selectedRow.getWeight() != null) {
                sampleWeight = selectedRow.getWeight();

            } else {
                sampleWeight = 0f;
                if (selectedRow.getFrequency() != null) {
                    for (BenthosFrequencyRowModel frequency : selectedRow.getFrequency()) {
                        if (frequency.getWeight() == null) {
                            sampleWeight = 0f;
                            break;
                        }
                        sampleWeight += frequency.getWeight();
                    }
                }
            }

            if (sampleWeight != null) {
                if (sampleWeight == 0f) {
                    JOptionPane.showMessageDialog(
                            getUI(),
                            _("tutti.createBenthosMelag.error.message", selectedRowIndex + 1),
                            _("tutti.createBenthosMelag.error.title"),
                            JOptionPane.ERROR_MESSAGE);

                    handler.getTable().getSelectionModel().setSelectionInterval(selectedRowIndex, selectedRowIndex);
                    result = false;
                    break;

                } else {
                    sortedWeight += sampleWeight;
                }
            }

            selectedRows.put(selectedRow, sampleWeight);
        }

        if (result) {
            melagWeight = openMelagWeightDialog();

            if (melagWeight != null) {
                // substract the weights that the user already entered
                // they must not be used to compute the other weights
                sampleMelagWeight = melagWeight - alreadyKnownWeights;
            }
        }

        return result && melagWeight != null;
    }

    protected Float openMelagWeightDialog() {
        Frame frame = SwingUtil.getParentContainer(getUI(), Frame.class);

        final EnterMelagWeightDialog dialog = new EnterMelagWeightDialog(frame,
                                                                         getConfig().getShortcutClosePopup());
        SwingUtil.center(frame, dialog);
        dialog.pack();
        dialog.setVisible(true);

        Float result = null;
        if (dialog.getEditor().getModel() != null) {
            result = dialog.getEditor().getModel().floatValue();
        }
        return result;
    }

    @Override
    protected void doAction() throws Exception {
        for (BenthosBatchRowModel batch : selectedRows.keySet()) {
            Float sampleWeight = selectedRows.get(batch);
            if (sampleWeight != null) {
                Float weight = sampleMelagWeight * sampleWeight / sortedWeight;
                batch.getFinestCategory().setCategoryWeight(weight);
            }
            String comment = batch.getComment();
            if (StringUtils.isBlank(comment)) {
                comment = "";

            } else {
                comment += "\n";
            }
            comment += "issu d'un MELAG de " + melagWeight + "kg";
            batch.setComment(comment);
        }
        getHandler().saveRows(selectedRows.keySet());
    }

    @Override
    protected void releaseAction() {
        super.releaseAction();
        //FIXME-TC No release action is not design to refresh ui...
//        getHandler().getTable().repaint();
        selectedRows.clear();
        melagWeight = null;
        sortedWeight = null;
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        getHandler().getTable().repaint();

    }
}
