package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id: NewFishingOperationAction.java 715 2013-04-01 20:46:21Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.4/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/NewFishingOperationAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;

import java.util.List;

/**
 * To create a new fishing operation.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class NewFishingOperationAction extends EditFishingOperationAction {

    public NewFishingOperationAction(FishingOperationsUIHandler handler) {
        super(handler);
    }

    @Override
    protected void doAction() throws Exception {

        FishingOperationsUIModel model = getModel();

        // deselect selected fishingOperation
        // Will remove the selection fishing operation from the comboBox

        model.setCatchEnabled(true);

        model.setEditionAdjusting(true);
        try {
            model.setSelectedFishingOperation(null);
        } finally {
            model.setEditionAdjusting(false);
        }

        // creates a empty bean

        FishingOperation newFishingOperation =
                TuttiBeanFactory.newFishingOperation();
        Cruise cruise = getDataContext().getCruise();
        newFishingOperation.setCruise(cruise);
        newFishingOperation.setVessel(cruise.getVessel());

        List<Gear> gears = cruise.getGear();
        if (gears.size() == 1) {
            newFishingOperation.setGear(gears.get(0));
        }

        if (cruise.getMultirigNumber() == 1) {
            newFishingOperation.setMultirigAggregation("1");
        }

        newFishingOperation.setGearShootingStartDate(null);
        newFishingOperation.setGearShootingEndDate(null);
        setFishingOperation(newFishingOperation);

        super.doAction();
    }
}
