/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential;

import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.service.TuttiPersistenceServiceLocator;
import fr.ifremer.tutti.persistence.service.synchro.ReferentialSynchronizeResult;
import fr.ifremer.tutti.persistence.service.synchro.ReferentialSynchronizeService;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import java.io.File;
import java.util.Properties;

public class TuttiReferentialSynchronizeService
extends AbstractTuttiService {
    protected PersistenceService persistenceService;
    protected ReferentialSynchronizeService synchroService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.synchroService = TuttiPersistenceServiceLocator.getReferentialSynchronizeService();
        this.persistenceService = this.getService(PersistenceService.class);
    }

    public void prepare(File dbDirectory, ReferentialSynchronizeResult result) {
        Properties remoteConnectionProperties = this.getRemoteProperties(dbDirectory);
        this.synchroService.prepare(remoteConnectionProperties, result);
    }

    public void synchronize(File dbDirectory, ReferentialSynchronizeResult result) {
        Properties remoteConnectionProperties = this.getRemoteProperties(dbDirectory);
        this.synchroService.synchronize(remoteConnectionProperties, result);
    }

    protected Properties getRemoteProperties(File dbDirectory) {
        Properties remoteConnectionProperties = new Properties();
        TuttiPersistenceConfig persistenceConfig = this.context.getConfig().getPersistenceConfig();
        String jdbcUrl = TuttiEntities.getJdbcUrl((File)dbDirectory, (String)persistenceConfig.getDbName());
        TuttiEntities.fillConnectionProperties((Properties)remoteConnectionProperties, (String)jdbcUrl, (String)persistenceConfig.getJdbcUsername(), (String)persistenceConfig.getJdbcPassword());
        return remoteConnectionProperties;
    }
}

