/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TabHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditCatchesUIHandler
extends AbstractTuttiTabContainerUIHandler<EditCatchesUIModel, EditCatchesUI>
implements TabHandler {
    public static final String MAIN_CARD = "main";
    public static final String CREATE_BATCH_CARD = "createBatch";
    public static final String SPLIT_BATCH_CARD = "splitBatch";
    public static final String EDIT_FREQUENCY_CARD = "editFrequency";
    public static final String CAROUSSEL_TREMIE_VESSEL = "carousselTremieVessel";
    public static final String CLASSIC_VESSEL = "classicVessel";
    private static final Log log = LogFactory.getLog(EditCatchesUIHandler.class);
    private final TuttiBeanMonitor<EditCatchesUIModel> catchBatchMonitor;
    protected final FishingOperationsUI parentUi;

    public EditCatchesUIHandler(FishingOperationsUI parentUi, EditCatchesUI ui) {
        super(parentUi.getHandler().getContext(), ui);
        this.parentUi = parentUi;
        this.catchBatchMonitor = new TuttiBeanMonitor("speciesTotalSortedWeight", "speciesTotalInertWeight", "speciesTotalLivingNotItemizedWeight", "benthosTotalSortedWeight", "benthosTotalInertWeight", "benthosTotalLivingNotItemizedWeight");
    }

    @Override
    public void beforeInitUI() {
        EditCatchesUIModel model = ((EditCatchesUI)this.ui).getContextValue(EditCatchesUIModel.class);
        this.listModelIsModify(model);
        this.catchBatchMonitor.setBean(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        this.listenValidatorValid((SimpleBeanValidator)this.getValidator(), model);
        this.setCustomTab(0, model);
        this.setCustomTab(1, ((EditCatchesUI)this.ui).getSpeciesTabContent().getModel());
        this.setCustomTab(2, ((EditCatchesUI)this.ui).getBenthosTabContent().getModel());
        this.getParentUi().getFishingOperationTabContent().getModel().addPropertyChangeListener("vessel", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Vessel vessel = (Vessel)evt.getNewValue();
                EditCatchesUIHandler.this.selectCatchTotalSortedWeightPanel(vessel);
            }
        });
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        ((EditCatchesUI)this.ui).getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        this.closeUI(((EditCatchesUI)this.ui).getSpeciesTabContent());
        this.closeUI(((EditCatchesUI)this.ui).getBenthosTabContent());
    }

    @Override
    public SwingValidator<EditCatchesUIModel> getValidator() {
        return ((EditCatchesUI)this.ui).getValidator();
    }

    @Override
    protected Set<String> getPropertiesToIgnore() {
        Set<String> result = super.getPropertiesToIgnore();
        result.addAll(Sets.newHashSet((Object[])new String[]{"catchTotalComputedWeight", "catchTotalSortedComputedWeight", "catchTotalUnsortedComputedWeight", "catchTotalRejectedComputedWeight", "speciesTotalComputedWeight", "speciesTotalSortedComputedWeight", "speciesTotalUnsortedComputedWeight", "speciesTotalSampleSortedComputedWeight", "speciesTotalInerComputedtWeight", "speciesTotalLivingNotItemizedComputedWeight", "benthosTotalComputedWeight", "benthosTotalSortedComputedWeight", "benthosTotalUnsortedComputedWeight", "benthosTotalSampleSortedComputedWeight", "benthosTotalInerComputedtWeight", "benthosTotalLivingNotItemizedComputedWeight"}));
        return result;
    }

    @Override
    protected JTabbedPane getTabPanel() {
        return ((EditCatchesUI)this.ui).getTabPane();
    }

    @Override
    protected boolean onTabChanged(int currentIndex, int newIndex) {
        ((EditCatchesUI)this.ui).getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getSpeciesTabContent().getSpeciesBatchAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getBenthosTabContent().getBenthosBatchAttachmentsButton().onCloseUI();
        return super.onTabChanged(currentIndex, newIndex);
    }

    @Override
    public boolean onHideTab(int currentIndex, int newIndex) {
        boolean result;
        ((EditCatchesUI)this.ui).getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getSpeciesTabContent().getSpeciesBatchAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getBenthosTabContent().getBenthosBatchAttachmentsButton().onCloseUI();
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        if (model.isModify()) {
            if (model.isValid()) {
                int answer = this.askSaveBeforeLeaving(I18n._((String)"tutti.editCatchBatch.askSaveBeforeLeaving.saveCatchBatch", (Object[])new Object[0]));
                switch (answer) {
                    case 0: {
                        TuttiActionHelper.runAction(((EditCatchesUI)this.getUI()).getSaveButton());
                        result = true;
                        break;
                    }
                    case 1: {
                        TuttiActionHelper.runAction(((EditCatchesUI)this.getUI()).getCancelButton());
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                        break;
                    }
                }
            } else {
                result = this.askCancelEditBeforeLeaving(I18n._((String)"tutti.editCatchBatch.askCancelEditBeforeLeaving.cancelEditCatchBatch", (Object[])new Object[0]));
                if (result) {
                    TuttiActionHelper.runAction(((EditCatchesUI)this.ui).getCancelButton());
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    @Override
    public void onShowTab(int currentIndex, int newIndex) {
        this.registerValidators();
    }

    public TuttiBeanMonitor<EditCatchesUIModel> getCatchBatchMonitor() {
        return this.catchBatchMonitor;
    }

    public FishingOperationsUI getParentUi() {
        return this.parentUi;
    }

    public FishingOperationsUIHandler getParentHandler() {
        return this.getParentUi().getHandler();
    }

    protected void registerValidators() {
        this.registerValidators(this.getValidator(), ((EditCatchesUI)this.ui).getSpeciesTabContent().getHandler().getValidator(), ((EditCatchesUI)this.ui).getBenthosTabContent().getHandler().getValidator());
    }

    public void setSpeciesSelectedCard(String card) {
        JPanel panel = ((EditCatchesUI)this.ui).getSpeciesTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            JPanel actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                JPanel tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getSpeciesTabCreateBatchReminderLabel();
                    title = I18n.n_((String)"tutti.createSpeciesBatch.title", (Object[])new Object[0]);
                } else if (SPLIT_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabSplitBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getSpeciesTabSplitBatchReminderLabel();
                    title = I18n.n_((String)"tutti.splitSpeciesBatch.title", (Object[])new Object[0]);
                } else if (EDIT_FREQUENCY_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabFrequencyEditor();
                    titlePanel = ((EditCatchesUI)this.ui).getSpeciesTabFrequencyEditorReminderLabel();
                    title = I18n.n_((String)"tutti.editSpeciesFrequencies.title", (Object[])new Object[0]);
                }
                if (tuttiUi != null) {
                    this.registerValidators(((AbstractTuttiUIHandler)tuttiUi.getHandler()).getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getSpeciesTabFishingOperationReminderLabel().getTitle() + " - " + I18n._((String)title, (Object[])new Object[0]));
                }
            }
        }
    }

    public void setBenthosSelectedCard(String card) {
        JPanel panel = ((EditCatchesUI)this.ui).getBenthosTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            JPanel actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                JPanel tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getBenthosTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getBenthosTabCreateBatchReminderLabel();
                    title = I18n.n_((String)"tutti.createBenthosBatch.title", (Object[])new Object[0]);
                } else if (SPLIT_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getBenthosTabSplitBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getBenthosTabSplitBatchReminderLabel();
                    title = I18n.n_((String)"tutti.splitBenthosBatch.title", (Object[])new Object[0]);
                } else if (EDIT_FREQUENCY_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getBenthosTabFrequencyEditor();
                    titlePanel = ((EditCatchesUI)this.ui).getBenthosTabFrequencyEditorReminderLabel();
                    title = I18n.n_((String)"tutti.editBenthosFrequencies.title", (Object[])new Object[0]);
                }
                if (tuttiUi != null) {
                    this.registerValidators(((AbstractTuttiUIHandler)tuttiUi.getHandler()).getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getBenthosTabFishingOperationReminderLabel().getTitle() + " - " + I18n._((String)title, (Object[])new Object[0]));
                }
            }
        }
    }

    public void selectCatchTotalSortedWeightPanel(Vessel vessel) {
        String carousselTremieVesselId = this.getConfig().getTremieCarousselVesselId();
        String card = vessel != null && vessel.getId().equals(carousselTremieVesselId) ? CAROUSSEL_TREMIE_VESSEL : CLASSIC_VESSEL;
        ((EditCatchesUI)this.ui).getCatchTotalSortedWeightPanelLayout().setSelected(card);
    }
}

