/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.persistence.entities.data.SortedUnsortedEnum;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategory;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.i18n.I18n;

public class ComputeWeightsAction
extends AbstractTuttiAction<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {
    public ComputeWeightsAction(EditCatchesUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected void doAction() throws Exception {
        Float benthosTotalSortedWeight;
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        this.computeSpeciesBatches();
        this.computeBenthosBatches();
        Float speciesTotalSortedWeight = model.getSpeciesTotalSortedWeight();
        if (speciesTotalSortedWeight == null) {
            speciesTotalSortedWeight = model.getSpeciesTotalSortedComputedWeight();
        }
        if ((benthosTotalSortedWeight = model.getBenthosTotalSortedWeight()) == null) {
            benthosTotalSortedWeight = model.getBenthosTotalSortedComputedWeight();
        }
        Float carrouselWeight = model.getCatchTotalSortedCarousselWeight();
        Float totalUnsortedWeight = Float.valueOf(model.getSpeciesTotalUnsortedComputedWeight().floatValue() + model.getBenthosTotalUnsortedComputedWeight().floatValue());
        Float totalSortedWeight = carrouselWeight != null ? carrouselWeight : Float.valueOf(speciesTotalSortedWeight.floatValue() + benthosTotalSortedWeight.floatValue());
        model.setCatchTotalSortedComputedWeight(totalSortedWeight);
        model.setCatchTotalUnsortedComputedWeight(totalUnsortedWeight);
        Float totalWeight = model.getCatchTotalWeight();
        Float rejectedWeight = model.getCatchTotalRejectedWeight();
        if (rejectedWeight == null && totalWeight != null) {
            if (!totalWeight.equals(Float.valueOf(totalUnsortedWeight.floatValue() + totalSortedWeight.floatValue()))) {
                throw new TuttiBusinessException(I18n._((String)"tutti.editCatchBatch.action.computeWeights.error.incoherentTotal", (Object[])new Object[0]));
            }
            model.setCatchTotalRejectedComputedWeight(Float.valueOf(totalWeight.floatValue() - totalUnsortedWeight.floatValue() - totalSortedWeight.floatValue()));
        } else if (totalWeight == null) {
            if (rejectedWeight == null) {
                rejectedWeight = Float.valueOf(0.0f);
                model.setCatchTotalRejectedComputedWeight(Float.valueOf(0.0f));
            }
            model.setCatchTotalComputedWeight(Float.valueOf(totalUnsortedWeight.floatValue() + totalSortedWeight.floatValue() + rejectedWeight.floatValue()));
        } else if (!totalWeight.equals(Float.valueOf(totalUnsortedWeight.floatValue() + totalSortedWeight.floatValue() + rejectedWeight.floatValue()))) {
            throw new TuttiBusinessException(I18n._((String)"tutti.editCatchBatch.action.computeWeights.error.incoherentTotal", (Object[])new Object[0]));
        }
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        ((EditCatchesUI)this.getUI()).repaint();
    }

    protected void computeSpeciesBatches() {
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        Float totalSortedWeight = Float.valueOf(0.0f);
        Float totalUnsortedWeight = Float.valueOf(0.0f);
        List roots = ((EditCatchesUI)this.getUI()).getSpeciesTabContent().getModel().getRows();
        for (int i = 0; i < roots.size(); ++i) {
            SpeciesBatchRowModel row = (SpeciesBatchRowModel)roots.get(i);
            if (!row.isBatchRoot()) continue;
            Float weight = this.computeSpeciesBatch(row);
            if (weight == null) {
                AbstractSelectTableAction.doSelectCell((JTable)((EditCatchesUI)this.getUI()).getSpeciesTabContent().getTable(), i, 1);
                throw new TuttiBusinessException(I18n._((String)"tutti.editCatchBatch.action.computeWeights.error.noWeight", (Object[])new Object[0]));
            }
            if (SortedUnsortedEnum.SORTED.matchValue(row.getSortedUnsortedCategory().getCategoryValue())) {
                totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + weight.floatValue());
                continue;
            }
            totalUnsortedWeight = Float.valueOf(totalUnsortedWeight.floatValue() + weight.floatValue());
        }
        Float inertWeight = model.getSpeciesTotalInertWeight();
        if (inertWeight != null) {
            totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + ((Number)inertWeight).floatValue());
        } else {
            model.setSpeciesTotalInertComputedWeight(Float.valueOf(0.0f));
        }
        Float livingNotItemizedWeight = model.getSpeciesTotalLivingNotItemizedWeight();
        if (livingNotItemizedWeight != null) {
            totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + ((Number)livingNotItemizedWeight).floatValue());
        } else {
            model.setSpeciesTotalLivingNotItemizedComputedWeight(Float.valueOf(0.0f));
        }
        model.setSpeciesTotalSampleSortedComputedWeight(totalSortedWeight);
        Float speciesTotalSortedWeight = model.getSpeciesTotalSortedWeight();
        Float rate = this.getConfig().getDifferenceRateBetweenSortedAndTotalWeights();
        if (speciesTotalSortedWeight == null) {
            speciesTotalSortedWeight = totalSortedWeight;
            model.setSpeciesTotalSortedComputedWeight(totalSortedWeight);
        } else {
            if (speciesTotalSortedWeight.floatValue() < totalSortedWeight.floatValue()) {
                throw new TuttiBusinessException(I18n._((String)"tutti.editCatchBatch.action.computeWeights.error.incoherentSpeciesTotalSorted", (Object[])new Object[0]));
            }
            if (speciesTotalSortedWeight.floatValue() < (1.0f + rate.floatValue() / 100.0f) * totalSortedWeight.floatValue()) {
                String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.message", (Object[])new Object[]{rate}), I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.help", (Object[])new Object[0]));
                int answer = JOptionPane.showConfirmDialog(this.getContext().getActionUI(), htmlMessage, I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.title", (Object[])new Object[0]), 0, 3);
                if (answer == 1) {
                    model.setSpeciesTotalSortedWeight(null);
                    speciesTotalSortedWeight = totalSortedWeight;
                    model.setSpeciesTotalSortedComputedWeight(totalSortedWeight);
                }
            }
        }
        model.setSpeciesTotalUnsortedComputedWeight(totalUnsortedWeight);
        Float totalWeight = Float.valueOf(totalUnsortedWeight.floatValue() + speciesTotalSortedWeight.floatValue());
        model.setSpeciesTotalComputedWeight(totalWeight);
    }

    protected Float computeSpeciesBatch(SpeciesBatchRowModel row) {
        SampleCategory finestCategory = row.getFinestCategory();
        Float result = null;
        Float categoryWeight = finestCategory.getCategoryWeight();
        Float rowWeight = row.getWeight();
        List<SpeciesBatchRowModel> children = row.getChildBatch();
        if (!row.isBatchLeaf()) {
            Float sum = Float.valueOf(0.0f);
            for (SpeciesBatchRowModel child : children) {
                Float weight = this.computeSpeciesBatch(child);
                if (weight == null) {
                    sum = null;
                    break;
                }
                sum = Float.valueOf(sum.floatValue() + weight.floatValue());
            }
            if (sum != null) {
                if (categoryWeight == null) {
                    finestCategory.setComputedWeight(sum);
                    for (SpeciesBatchRowModel child : children) {
                        child.getFinestCategory().setSubSample(false);
                    }
                } else {
                    if (categoryWeight.floatValue() < sum.floatValue()) {
                        throw new TuttiBusinessException(I18n._((String)"tutti.editCatchBatch.action.computeWeights.error.incoherentParentCategoryWeight", (Object[])new Object[0]));
                    }
                    boolean subSample = categoryWeight.floatValue() > sum.floatValue();
                    for (SpeciesBatchRowModel child : children) {
                        child.getFinestCategory().setSubSample(subSample);
                    }
                    sum = categoryWeight;
                }
                result = sum;
            }
        } else {
            row.setComputedWeight(null);
            List<SpeciesFrequencyRowModel> frequency = row.getFrequency();
            if (CollectionUtils.isNotEmpty(frequency)) {
                Float frequencyWeight = Float.valueOf(0.0f);
                for (SpeciesFrequencyRowModel frequencyModel : frequency) {
                    Float w = frequencyModel.getWeight();
                    if (w == null) {
                        frequencyWeight = null;
                        break;
                    }
                    if (frequencyWeight == null) continue;
                    frequencyWeight = Float.valueOf(frequencyWeight.floatValue() + w.floatValue());
                }
                if (categoryWeight == null && rowWeight != null) {
                    throw new TuttiBusinessException(I18n._((String)"tutti.editCatchBatch.action.computeWeights.error.incoherentRowWeightCategory", (Object[])new Object[0]));
                }
                if (categoryWeight == null && frequencyWeight != null) {
                    finestCategory.setComputedWeight(frequencyWeight);
                    result = frequencyWeight;
                } else if (frequencyWeight != null && !frequencyWeight.equals(categoryWeight)) {
                    if (frequencyWeight.floatValue() > categoryWeight.floatValue()) {
                        throw new TuttiBusinessException(I18n._((String)"tutti.editCatchBatch.action.computeWeights.error.incoherentCategoryWeight", (Object[])new Object[0]));
                    }
                    if (rowWeight == null) {
                        row.setComputedWeight(frequencyWeight);
                    } else if (!rowWeight.equals(frequencyWeight)) {
                        throw new TuttiBusinessException(I18n._((String)"tutti.editCatchBatch.action.computeWeights.error.incoherentRowWeightFrequency", (Object[])new Object[0]));
                    }
                    result = categoryWeight;
                } else {
                    result = categoryWeight;
                }
            } else {
                result = categoryWeight;
            }
        }
        return result;
    }

    protected void computeBenthosBatches() {
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        Float totalSortedWeight = Float.valueOf(0.0f);
        Float totalUnsortedWeight = Float.valueOf(0.0f);
        List roots = ((EditCatchesUI)this.getUI()).getBenthosTabContent().getModel().getRows();
        for (int i = 0; i < roots.size(); ++i) {
            BenthosBatchRowModel row = (BenthosBatchRowModel)roots.get(i);
            if (!row.isBatchRoot()) continue;
            Float weight = this.computeBenthosBatch(row);
            if (weight == null) {
                AbstractSelectTableAction.doSelectCell((JTable)((EditCatchesUI)this.getUI()).getBenthosTabContent().getTable(), i, 1);
                throw new TuttiBusinessException(I18n._((String)"tutti.editCatchBatch.action.computeWeights.error.noWeight", (Object[])new Object[0]));
            }
            if (SortedUnsortedEnum.SORTED.matchValue(row.getSortedUnsortedCategory().getCategoryValue())) {
                totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + weight.floatValue());
                continue;
            }
            totalUnsortedWeight = Float.valueOf(totalUnsortedWeight.floatValue() + weight.floatValue());
        }
        Float inertWeight = model.getBenthosTotalInertWeight();
        if (inertWeight != null) {
            totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + ((Number)inertWeight).floatValue());
        } else {
            model.setBenthosTotalInertComputedWeight(Float.valueOf(0.0f));
        }
        Float livingNotItemizedWeight = model.getBenthosTotalLivingNotItemizedWeight();
        if (livingNotItemizedWeight != null) {
            totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + ((Number)livingNotItemizedWeight).floatValue());
        } else {
            model.setBenthosTotalLivingNotItemizedComputedWeight(Float.valueOf(0.0f));
        }
        model.setBenthosTotalSampleSortedComputedWeight(totalSortedWeight);
        Float benthosTotalSortedWeight = model.getBenthosTotalSortedWeight();
        Float rate = this.getConfig().getDifferenceRateBetweenSortedAndTotalWeights();
        if (benthosTotalSortedWeight == null) {
            benthosTotalSortedWeight = totalSortedWeight;
            model.setBenthosTotalSortedComputedWeight(totalSortedWeight);
        } else {
            if (benthosTotalSortedWeight.floatValue() < totalSortedWeight.floatValue()) {
                throw new TuttiBusinessException(I18n._((String)"tutti.editCatchBatch.action.computeWeights.error.incoherentSpeciesTotalSorted", (Object[])new Object[0]));
            }
            if (benthosTotalSortedWeight.floatValue() < (1.0f + rate.floatValue() / 100.0f) * totalSortedWeight.floatValue()) {
                String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.message", (Object[])new Object[]{rate}), I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.help", (Object[])new Object[0]));
                int answer = JOptionPane.showConfirmDialog(this.getContext().getActionUI(), htmlMessage, I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.title", (Object[])new Object[0]), 0, 3);
                if (answer == 1) {
                    model.setSpeciesTotalSortedWeight(null);
                    benthosTotalSortedWeight = totalSortedWeight;
                    model.setBenthosTotalSortedComputedWeight(totalSortedWeight);
                }
            }
        }
        model.setBenthosTotalUnsortedComputedWeight(totalUnsortedWeight);
        Float totalWeight = Float.valueOf(totalUnsortedWeight.floatValue() + benthosTotalSortedWeight.floatValue());
        model.setBenthosTotalComputedWeight(totalWeight);
    }

    protected Float computeBenthosBatch(BenthosBatchRowModel row) {
        SampleCategory finestCategory = row.getFinestCategory();
        Float result = null;
        Float categoryWeight = finestCategory.getCategoryWeight();
        Float rowWeight = row.getWeight();
        List<BenthosBatchRowModel> children = row.getChildBatch();
        if (!row.isBatchLeaf()) {
            Float sum = Float.valueOf(0.0f);
            for (BenthosBatchRowModel child : children) {
                Float weight = this.computeBenthosBatch(child);
                if (weight == null) {
                    sum = null;
                    break;
                }
                sum = Float.valueOf(sum.floatValue() + weight.floatValue());
            }
            if (sum != null) {
                if (categoryWeight == null) {
                    finestCategory.setComputedWeight(sum);
                    for (BenthosBatchRowModel child : children) {
                        child.getFinestCategory().setSubSample(false);
                    }
                } else {
                    if (categoryWeight.floatValue() < sum.floatValue()) {
                        throw new TuttiBusinessException(I18n._((String)"tutti.editCatchBatch.action.computeWeights.error.incoherentParentCategoryWeight", (Object[])new Object[0]));
                    }
                    boolean subSample = categoryWeight.floatValue() > sum.floatValue();
                    for (BenthosBatchRowModel child : children) {
                        child.getFinestCategory().setSubSample(subSample);
                    }
                    sum = categoryWeight;
                }
                result = sum;
            }
        } else {
            row.setComputedWeight(null);
            List<BenthosFrequencyRowModel> frequency = row.getFrequency();
            if (CollectionUtils.isNotEmpty(frequency)) {
                Float frequencyWeight = Float.valueOf(0.0f);
                for (BenthosFrequencyRowModel frequencyModel : frequency) {
                    Float w = frequencyModel.getWeight();
                    if (w == null) {
                        frequencyWeight = null;
                        break;
                    }
                    if (frequencyWeight == null) continue;
                    frequencyWeight = Float.valueOf(frequencyWeight.floatValue() + w.floatValue());
                }
                if (categoryWeight == null && rowWeight != null) {
                    throw new TuttiBusinessException(I18n._((String)"tutti.editCatchBatch.action.computeWeights.error.incoherentRowWeightCategory", (Object[])new Object[0]));
                }
                if (categoryWeight == null && frequencyWeight != null) {
                    finestCategory.setComputedWeight(frequencyWeight);
                    result = frequencyWeight;
                } else if (frequencyWeight != null && !frequencyWeight.equals(categoryWeight)) {
                    if (frequencyWeight.floatValue() > categoryWeight.floatValue()) {
                        throw new TuttiBusinessException(I18n._((String)"tutti.editCatchBatch.action.computeWeights.error.incoherentCategoryWeight", (Object[])new Object[0]));
                    }
                    if (rowWeight == null) {
                        row.setComputedWeight(frequencyWeight);
                    } else if (!rowWeight.equals(frequencyWeight)) {
                        throw new TuttiBusinessException(I18n._((String)"tutti.editCatchBatch.action.computeWeights.error.incoherentRowWeightFrequency", (Object[])new Object[0]));
                    }
                    result = categoryWeight;
                } else {
                    result = categoryWeight;
                }
            } else {
                result = categoryWeight;
            }
        }
        return result;
    }
}

