/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.administration.programStrategy;

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program2Department;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program2Person;
import fr.ifremer.adagio.core.dao.administration.programStrategy.ProgramImpl;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Strategy;
import fr.ifremer.adagio.core.dao.referential.gear.GearClassification;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.location.LocationClassification;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupType;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

public abstract class Program
implements Serializable {
    private static final long serialVersionUID = -8923218287399812385L;
    private String code;
    private String name;
    private String description;
    private Date creationDate;
    private Timestamp updateDate;
    private Collection<Strategy> strategies = new HashSet<Strategy>();
    private Collection<Location> locations = new HashSet<Location>();
    private Collection<LocationClassification> locationClassifications = new HashSet<LocationClassification>();
    private Collection<Program2Person> programUsers = new HashSet<Program2Person>();
    private TaxonGroupType taxonGroupType;
    private GearClassification gearClassification;
    private Collection<Program2Department> program2Departments = new HashSet<Program2Department>();

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Timestamp getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Timestamp updateDate) {
        this.updateDate = updateDate;
    }

    public Collection<Strategy> getStrategies() {
        return this.strategies;
    }

    public void setStrategies(Collection<Strategy> strategies) {
        this.strategies = strategies;
    }

    public Collection<Location> getLocations() {
        return this.locations;
    }

    public void setLocations(Collection<Location> locations) {
        this.locations = locations;
    }

    public Collection<LocationClassification> getLocationClassifications() {
        return this.locationClassifications;
    }

    public void setLocationClassifications(Collection<LocationClassification> locationClassifications) {
        this.locationClassifications = locationClassifications;
    }

    public Collection<Program2Person> getProgramUsers() {
        return this.programUsers;
    }

    public void setProgramUsers(Collection<Program2Person> programUsers) {
        this.programUsers = programUsers;
    }

    public TaxonGroupType getTaxonGroupType() {
        return this.taxonGroupType;
    }

    public void setTaxonGroupType(TaxonGroupType taxonGroupType) {
        this.taxonGroupType = taxonGroupType;
    }

    public GearClassification getGearClassification() {
        return this.gearClassification;
    }

    public void setGearClassification(GearClassification gearClassification) {
        this.gearClassification = gearClassification;
    }

    public Collection<Program2Department> getProgram2Departments() {
        return this.program2Departments;
    }

    public void setProgram2Departments(Collection<Program2Department> program2Departments) {
        this.program2Departments = program2Departments;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Program)) {
            return false;
        }
        Program that = (Program)object;
        return this.code != null && that.getCode() != null && this.code.equals(that.getCode());
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.code == null ? 0 : this.code.hashCode());
        return hashCode;
    }

    public static final class Factory {
        public static Program newInstance() {
            ProgramImpl entity = new ProgramImpl();
            return entity;
        }

        public static Program newInstance(String name, String description, Date creationDate, Collection<LocationClassification> locationClassifications, TaxonGroupType taxonGroupType, GearClassification gearClassification) {
            Program entity = Factory.newInstance();
            entity.setName(name);
            entity.setDescription(description);
            entity.setCreationDate(creationDate);
            entity.setLocationClassifications(locationClassifications);
            entity.setTaxonGroupType(taxonGroupType);
            entity.setGearClassification(gearClassification);
            return entity;
        }

        public static Program newInstance(String name, String description, Date creationDate, Timestamp updateDate, Collection<Strategy> strategies, Collection<Location> locations, Collection<LocationClassification> locationClassifications, Collection<Program2Person> programUsers, TaxonGroupType taxonGroupType, GearClassification gearClassification, Collection<Program2Department> program2Departments) {
            Program entity = Factory.newInstance();
            entity.setName(name);
            entity.setDescription(description);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setStrategies(strategies);
            entity.setLocations(locations);
            entity.setLocationClassifications(locationClassifications);
            entity.setProgramUsers(programUsers);
            entity.setTaxonGroupType(taxonGroupType);
            entity.setGearClassification(gearClassification);
            entity.setProgram2Departments(program2Departments);
            return entity;
        }
    }
}

