/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.widget.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentListener;
import javax.swing.text.TextAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.widget.editor.DefaultEditor;
import org.nuiton.widget.editor.EditorInterface;
import org.nuiton.widget.editor.JEditEditor;
import org.nuiton.widget.editor.NullEditor;
import org.nuiton.widget.editor.RSyntaxEditor;
import org.nuiton.widget.editor.SDocEditor;

public class Editor
extends JPanel
implements EditorInterface {
    private static final long serialVersionUID = 5820456710194699050L;
    private static Log log = LogFactory.getLog(Editor.class);
    protected static EditorInterface DEFAULT_EDITOR = new DefaultEditor();
    protected static List<EditorInterface> registered = new ArrayList<EditorInterface>();
    protected static EditorInterface nullEditor;
    protected Map<EditorInterface, EditorInterface> usedEditor = new HashMap<EditorInterface, EditorInterface>();
    protected EditorInterface currentEditor = nullEditor;
    protected File openedFile = null;
    protected Set<DocumentListener> documentListeners = new HashSet<DocumentListener>();
    protected Set<CaretListener> caretListeners = new HashSet<CaretListener>();
    protected boolean askIfNotSaved = true;
    protected boolean forceDefault = false;

    static EditorInterface addEditor(String editorClassName) {
        block18: {
            try {
                Class<?> editorClass = Class.forName(editorClassName);
                EditorInterface result = (EditorInterface)editorClass.newInstance();
                registered.add(result);
                return result;
            }
            catch (NoClassDefFoundError eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can't find your editor class: " + editorClassName), (Throwable)eee);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Can't find your editor class: " + editorClassName));
                }
            }
            catch (ClassNotFoundException eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can't find your editor class: " + editorClassName), (Throwable)eee);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Can't find your editor class: " + editorClassName));
                }
            }
            catch (ClassCastException eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Your editor class is not Editor Child: " + editorClassName), (Throwable)eee);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Your editor class is not Editor Child: " + editorClassName));
                }
            }
            catch (InstantiationException eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can't instanciant your Editor class: " + editorClassName), (Throwable)eee);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Can't instanciant your Editor class: " + editorClassName));
                }
            }
            catch (IllegalAccessException eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can't access your Editor class: " + editorClassName), (Throwable)eee);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Can't access your Editor class: " + editorClassName));
                }
            }
            catch (Exception eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Error during instanciation of your Editor: " + editorClassName), (Throwable)eee);
                }
                if (!log.isInfoEnabled()) break block18;
                log.info((Object)("Error during instanciation of your Editor: " + editorClassName), (Throwable)eee);
            }
        }
        return null;
    }

    public Editor() {
        this.setLayout(new BorderLayout());
        this.addKeyBinding();
        this.close();
    }

    protected void addKeyBinding() {
        SaveAction saveAction = new SaveAction(this);
        KeyStroke key = KeyStroke.getKeyStroke(83, 2);
        this.getInputMap(1).put(key, "save");
        this.getActionMap().put("save", saveAction);
    }

    @Override
    public void setSyntax(EditorSyntaxConstant editorSyntax) {
        this.setAskIfNotSaved(false);
        EditorInterface editor = this.getEditor(editorSyntax);
        this.setCurrentEditor(editor);
        editor.setSyntax(editorSyntax);
    }

    public boolean isAskIfNotSaved() {
        return this.askIfNotSaved;
    }

    public void setAskIfNotSaved(boolean askIfNotSaved) {
        this.askIfNotSaved = askIfNotSaved;
    }

    public boolean isForceDefault() {
        return this.forceDefault;
    }

    public void setForceDefault(boolean forceDefault) {
        this.forceDefault = forceDefault;
    }

    public EditorInterface getEditor(EditorSyntaxConstant editorSyntaxConstant) {
        EditorInterface newEditor;
        block9: {
            EditorInterface editor = DEFAULT_EDITOR;
            if (!this.isForceDefault()) {
                for (EditorInterface e : registered) {
                    if (!e.accept(editorSyntaxConstant)) continue;
                    editor = e;
                }
            }
            newEditor = this.usedEditor.get(editor);
            try {
                if (newEditor == null) {
                    newEditor = (EditorInterface)editor.getClass().newInstance();
                    this.usedEditor.put(editor, newEditor);
                }
            }
            catch (InstantiationException eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can't instanciant your Editor class: " + editor.getClass().getName()), (Throwable)eee);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Can't instanciant your Editor class: " + editor.getClass().getName()));
                }
            }
            catch (IllegalAccessException eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can't access your Editor class: " + editor.getClass().getName()), (Throwable)eee);
                }
                if (!log.isInfoEnabled()) break block9;
                log.info((Object)("Can't access your Editor class: " + editor.getClass().getName()));
            }
        }
        return newEditor;
    }

    public EditorInterface getEditor(File file) {
        EditorInterface newEditor;
        block9: {
            EditorInterface editor = DEFAULT_EDITOR;
            if (!this.isForceDefault()) {
                for (EditorInterface e : registered) {
                    if (!e.accept(file)) continue;
                    editor = e;
                }
            }
            newEditor = this.usedEditor.get(editor);
            try {
                if (newEditor == null) {
                    newEditor = (EditorInterface)editor.getClass().newInstance();
                    this.usedEditor.put(editor, newEditor);
                }
            }
            catch (InstantiationException eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can't instanciant your Editor class: " + editor.getClass().getName()), (Throwable)eee);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Can't instanciant your Editor class: " + editor.getClass().getName()));
                }
            }
            catch (IllegalAccessException eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can't access your Editor class: " + editor.getClass().getName()), (Throwable)eee);
                }
                if (!log.isInfoEnabled()) break block9;
                log.info((Object)("Can't access your Editor class: " + editor.getClass().getName()));
            }
        }
        return newEditor;
    }

    public void setCurrentEditor(EditorInterface editor) {
        if (this.currentEditor == null) {
            return;
        }
        this.remove((Component)((Object)this.currentEditor));
        for (DocumentListener documentListener : this.documentListeners) {
            this.currentEditor.removeDocumentListener(documentListener);
        }
        for (CaretListener caretListener : this.caretListeners) {
            this.currentEditor.removeCaretListener(caretListener);
        }
        this.currentEditor = editor;
        for (DocumentListener documentListener : this.documentListeners) {
            this.currentEditor.addDocumentListener(documentListener);
        }
        for (CaretListener caretListener : this.caretListeners) {
            this.currentEditor.addCaretListener(caretListener);
        }
        this.add((Component)((Object)editor), "Center");
    }

    public EditorInterface getCurrentEditor() {
        return this.currentEditor;
    }

    public File getOpenedFile() {
        return this.openedFile;
    }

    public void setOpenedFile(File openedFile) {
        this.openedFile = openedFile;
    }

    public boolean close() {
        if (this.askAndSaveOrCancel()) {
            this.setOpenedFile(null);
            this.setCurrentEditor(nullEditor);
            return true;
        }
        return false;
    }

    protected boolean askAndSaveOrCancel() {
        boolean result = true;
        if (this.isAskIfNotSaved() && this.getCurrentEditor().isModified()) {
            int val = JOptionPane.showConfirmDialog(this, I18n._((String)"nuitonwidgets.editor.saveorcancel", (Object[])new Object[0]));
            switch (val) {
                case 0: {
                    this.save();
                    result = true;
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    public boolean save() {
        File file = this.getOpenedFile();
        boolean result = this.getCurrentEditor().saveAs(file);
        return result;
    }

    @Override
    public boolean accept(File file) {
        return true;
    }

    @Override
    public boolean accept(EditorSyntaxConstant editorSyntaxConstant) {
        return true;
    }

    @Override
    public boolean isModified() {
        boolean result = this.getCurrentEditor().isModified();
        return result;
    }

    @Override
    public boolean open(File file) {
        boolean result = false;
        if (this.askAndSaveOrCancel()) {
            EditorInterface editor = this.getEditor(file);
            result = editor.open(file);
            if (result) {
                this.setOpenedFile(file);
                this.setCurrentEditor(editor);
            } else {
                this.close();
            }
        }
        return result;
    }

    @Override
    public boolean saveAs(File file) {
        boolean result = this.getCurrentEditor().saveAs(file);
        if (result) {
            result = this.open(file);
        }
        return result;
    }

    @Override
    public String getText() {
        String result = this.getCurrentEditor().getText();
        return result;
    }

    @Override
    public void setText(String text) {
        this.getCurrentEditor().setText(text);
    }

    @Override
    public void copy() {
        this.currentEditor.copy();
    }

    @Override
    public void cut() {
        this.currentEditor.cut();
    }

    @Override
    public void paste() {
        this.currentEditor.paste();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.currentEditor.setEnabled(b);
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
        this.documentListeners.add(listener);
        this.getCurrentEditor().addDocumentListener(listener);
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
        this.documentListeners.remove(listener);
        this.getCurrentEditor().removeDocumentListener(listener);
    }

    @Override
    public void addCaretListener(CaretListener listener) {
        this.caretListeners.add(listener);
        this.getCurrentEditor().addCaretListener(listener);
    }

    @Override
    public void removeCaretListener(CaretListener listener) {
        this.caretListeners.remove(listener);
        this.getCurrentEditor().removeCaretListener(listener);
    }

    static {
        Editor.addEditor(SDocEditor.class.getName());
        Editor.addEditor(JEditEditor.class.getName());
        Editor.addEditor(RSyntaxEditor.class.getName());
        nullEditor = new NullEditor();
    }

    static class SaveAction
    extends TextAction {
        private static final long serialVersionUID = 4694356772539222176L;
        private static Log log = LogFactory.getLog(SaveAction.class);
        protected Editor editor;

        SaveAction(Editor editor) {
            super("save");
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.info((Object)"try to save file");
            if (!this.editor.save()) {
                log.warn((Object)"Unable to save");
            } else {
                log.info((Object)"saved ok");
            }
        }
    }

    public static enum EditorSyntaxConstant {
        XML(I18n._((String)"nuitonwidgets.editor.syntax.xml", (Object[])new Object[0])),
        JAVA(I18n._((String)"nuitonwidgets.editor.syntax.java", (Object[])new Object[0])),
        SQL(I18n._((String)"nuitonwidgets.editor.syntax.sql", (Object[])new Object[0])),
        R(I18n._((String)"nuitonwidgets.editor.syntax.r", (Object[])new Object[0]));

        protected String name;

        private EditorSyntaxConstant(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSupported(EditorSyntaxConstant ... constantsSupported) {
            for (EditorSyntaxConstant supported : constantsSupported) {
                if (!supported.equals((Object)this)) continue;
                return true;
            }
            return false;
        }
    }
}

