/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.CloseableUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FishingOperationsUIHandler
extends AbstractTuttiTabContainerUIHandler<FishingOperationsUIModel, FishingOperationsUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(FishingOperationsUIHandler.class);
    private final PersistenceService persistenceService;
    protected EditFishingOperationAction editFishingOperationAction;

    public FishingOperationsUIHandler(TuttiUI parentUI, FishingOperationsUI ui) {
        super(((AbstractTuttiUIHandler)parentUI.getHandler()).getContext(), ui);
        this.persistenceService = this.context.getPersistenceService();
    }

    @Override
    public void beforeInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("for " + this.ui));
        }
        FishingOperationsUIModel model = new FishingOperationsUIModel();
        EditCatchesUIModel catchesUIModel = new EditCatchesUIModel();
        Cruise cruise = this.getDataContext().getCruise();
        if (this.getContext().isProtocolFilled()) {
            TuttiProtocol protocol = this.persistenceService.getProtocol(this.getContext().getProtocolId());
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading existing protocol: " + protocol));
            }
        }
        ArrayList fishingOperations = Lists.newArrayList((Iterable)this.persistenceService.getAllFishingOperation(cruise.getId()));
        for (FishingOperation fishingOperation : fishingOperations) {
            fishingOperation.setCruise(cruise);
        }
        model.setFishingOperation(fishingOperations);
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded " + fishingOperations.size() + " fishingOperation(s)."));
        }
        ((FishingOperationsUI)this.ui).setContextValue(model);
        ((FishingOperationsUI)this.ui).setContextValue(catchesUIModel);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        this.editFishingOperationAction = this.createLogicAction(EditFishingOperationAction.class);
        FishingOperationsUIModel model = (FishingOperationsUIModel)((Object)this.getModel());
        List<FishingOperation> fishingOperations = model.getFishingOperation();
        this.initBeanComboBox(((FishingOperationsUI)this.ui).getFishingOperationComboBox(), fishingOperations, model.getSelectedFishingOperation());
        model.addPropertyChangeListener("selectedFishingOperation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"propertyChange selectedFishingOperation");
                }
                if (!((FishingOperationsUIModel)((Object)FishingOperationsUIHandler.this.getModel())).isEditionAdjusting()) {
                    FishingOperation operation;
                    FishingOperation newValue = (FishingOperation)evt.getNewValue();
                    if (newValue == null) {
                        operation = null;
                    } else {
                        operation = FishingOperationsUIHandler.this.persistenceService.getFishingOperation(newValue.getId());
                        Cruise cruise = FishingOperationsUIHandler.this.getDataContext().getCruise();
                        operation.setCruise(cruise);
                    }
                    FishingOperationsUIHandler.this.editFishingOperationAction.setFishingOperation(operation);
                    AbstractTuttiAction.runAction(FishingOperationsUIHandler.this.editFishingOperationAction);
                }
            }
        });
        model.addPropertyChangeListener("fishingOperation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"propertyChange fishingOperation");
                }
                ((FishingOperationsUI)FishingOperationsUIHandler.this.ui).getFishingOperationComboBox().setData(null);
                ((FishingOperationsUI)FishingOperationsUIHandler.this.ui).getFishingOperationComboBox().setData((List)evt.getNewValue());
            }
        });
        FishingOperation selectedOperation = null;
        for (FishingOperation fishingOperation : fishingOperations) {
            if (selectedOperation != null && (!fishingOperation.getGearShootingStartDate().after(selectedOperation.getGearShootingStartDate()) || fishingOperation.getFishingOperationNumber() <= selectedOperation.getFishingOperationNumber())) continue;
            selectedOperation = fishingOperation;
        }
        model.setSelectedFishingOperation(selectedOperation);
    }

    @Override
    public void onCloseUI() {
        ((FishingOperationsUI)this.ui).getTabPane().setSelectedIndex(0);
        ((FishingOperationsUI)this.ui).getFishingOperationTabContent().getFishingOperationTabPane().setSelectedIndex(0);
        this.closeUI(((FishingOperationsUI)this.ui).getFishingOperationTabContent());
        this.closeUI(((FishingOperationsUI)this.ui).getCatchesTabContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean quitUI() {
        FishingOperation editFishingOperation = ((FishingOperationsUIModel)((Object)this.getModel())).getEditFishingOperation();
        this.editFishingOperationAction.setFishingOperation(editFishingOperation);
        this.editFishingOperationAction.setCheckPreviousEdit(true);
        try {
            boolean result;
            boolean bl = result = this.editFishingOperationAction.prepareAction();
            return bl;
        }
        finally {
            this.editFishingOperationAction.releaseAction();
        }
    }

    @Override
    public SwingValidator<FishingOperationsUIModel> getValidator() {
        return null;
    }

    @Override
    public JTabbedPane getTabPanel() {
        return ((FishingOperationsUI)this.ui).getTabPane();
    }

    public boolean isFishingOperationModified() {
        return ((FishingOperationsUIModel)((Object)this.getModel())).getEditFishingOperation() != null && ((FishingOperationsUI)this.getUI()).getFishingOperationTabContent().getModel().isModify();
    }

    public boolean isFishingOperationValid() {
        return ((FishingOperationsUIModel)((Object)this.getModel())).getEditFishingOperation() != null && ((FishingOperationsUI)this.getUI()).getFishingOperationTabContent().getModel().isValid();
    }

    public boolean isCatchBatchModified() {
        return ((FishingOperationsUIModel)((Object)this.getModel())).getEditFishingOperation() != null && ((FishingOperationsUI)this.getUI()).getCatchesTabContent().getModel().isModify();
    }

    public boolean isCatchBatchValid() {
        return ((FishingOperationsUIModel)((Object)this.getModel())).getEditFishingOperation() != null && ((FishingOperationsUI)this.getUI()).getCatchesTabContent().getModel().isValid();
    }
}

