/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.config;

import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfigOption;
import fr.ifremer.tutti.service.config.TuttiServiceConfigOption;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfigOption;
import fr.ifremer.tutti.ui.swing.content.GoToPreviousScreenAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.ReloadTuttiAction;
import fr.ifremer.tutti.ui.swing.content.config.SampleOrderIdsTableCell;
import fr.ifremer.tutti.ui.swing.content.config.TuttiConfigUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.action.TuttiUIAction;
import fr.ifremer.tutti.ui.swing.util.editor.VesselTableCell;
import java.awt.Component;
import java.awt.Container;
import javax.swing.Icon;
import javax.swing.table.TableCellEditor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.config.ConfigUI;
import jaxx.runtime.swing.config.ConfigUIHelper;
import jaxx.runtime.swing.config.model.CallBackFinalizer;
import jaxx.runtime.swing.config.model.MainCallBackFinalizer;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.config.ConfigOptionDef;

public class TuttiConfigUIHandler
extends AbstractTuttiUIHandler<TuttiUIContext, TuttiConfigUI> {
    private static final Log log = LogFactory.getLog(TuttiConfigUIHandler.class);
    public static final String CALLBACK_APPLICATION = "application";
    public static final String CALLBACK_UI = "ui";
    public static final String CALLBACK_SHORTCUT = "shortcut";

    public TuttiConfigUIHandler(TuttiUI<?, ?> parentUI, TuttiConfigUI ui) {
        super(((AbstractTuttiUIHandler)parentUI.getHandler()).getContext(), ui);
    }

    @Override
    public SwingValidator<TuttiUIContext> getValidator() {
        return null;
    }

    @Override
    public void beforeInitUI() {
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        TuttiApplicationConfig config = this.getConfig();
        ConfigUIHelper helper = new ConfigUIHelper(config.getApplicationConfig());
        helper.registerCallBack(CALLBACK_UI, I18n.n_((String)"tutti.config.action.reload.ui", (Object[])new Object[0]), (Icon)SwingUtil.createActionIcon((String)"reload-ui"), new Runnable(){

            @Override
            public void run() {
                TuttiConfigUIHandler.this.reloadUI();
            }
        }).registerCallBack(CALLBACK_APPLICATION, I18n.n_((String)"tutti.config.action.reload.application", (Object[])new Object[0]), (Icon)SwingUtil.createActionIcon((String)"reload-application"), new Runnable(){

            @Override
            public void run() {
                TuttiConfigUIHandler.this.reloadApplication();
            }
        }).registerCallBack(CALLBACK_SHORTCUT, I18n.n_((String)"tutti.config.action.reload.actions", (Object[])new Object[0]), (Icon)SwingUtil.createActionIcon((String)"reload-shortcut"), new Runnable(){

            @Override
            public void run() {
                TuttiConfigUIHandler.this.reloadShortcuts();
            }
        });
        helper.addCategory(I18n.n_((String)"tutti.config.category.applications", (Object[])new Object[0]), I18n.n_((String)"tutti.config.category.applications.description", (Object[])new Object[0]), CALLBACK_APPLICATION).addOption((ConfigOptionDef)TuttiServiceConfigOption.CSV_SEPARATOR).addOption((ConfigOptionDef)TuttiApplicationConfigOption.UI_CONFIG_FILE).addOption((ConfigOptionDef)TuttiApplicationConfigOption.TOTAL_SORTED_WEIGHTS_DIFFERENCE_RATE);
        if (this.context.isDbLoaded()) {
            VesselTableCell vesselTableCellComponent = new VesselTableCell(this.context);
            helper.addOption((ConfigOptionDef)TuttiApplicationConfigOption.TREMIE_CAROUSSEL_VESSEL_ID).setOptionEditor(vesselTableCellComponent.getNewTableCellEditor()).setOptionRenderer(vesselTableCellComponent.getNewTableCellRenderer());
            SampleOrderIdsTableCell comp = new SampleOrderIdsTableCell(this.context);
            TableCellEditor sampleOrderEditor = comp.getNewTableCellEditor();
            helper.addOption((ConfigOptionDef)TuttiApplicationConfigOption.SAMPLING_CATEGORY_ORDER_IDS).setOptionEditor(sampleOrderEditor).setOptionRenderer(comp.getNewTableCellRenderer());
        }
        helper.addCategory(I18n.n_((String)"tutti.config.category.ui", (Object[])new Object[0]), I18n.n_((String)"tutti.config.category.ui.description", (Object[])new Object[0]), CALLBACK_UI).addOption((ConfigOptionDef)TuttiApplicationConfigOption.COLOR_ROW_INVALID).addOption((ConfigOptionDef)TuttiApplicationConfigOption.COLOR_ROW_READ_ONLY).addOption((ConfigOptionDef)TuttiApplicationConfigOption.COLOR_CELL_WITH_VALUE).addOption((ConfigOptionDef)TuttiApplicationConfigOption.COLOR_ROW_TO_CONFIRM).addOption((ConfigOptionDef)TuttiApplicationConfigOption.COLOR_COMPUTED_WEIGHTS).addOption((ConfigOptionDef)TuttiApplicationConfigOption.COLOR_BLOCKING_LAYER).addOption((ConfigOptionDef)TuttiApplicationConfigOption.DATE_FORMAT).addOption((ConfigOptionDef)TuttiApplicationConfigOption.COORDINATE_EDITOR_TYPE);
        helper.addCategory(I18n.n_((String)"tutti.config.category.technical", (Object[])new Object[0]), I18n.n_((String)"tutti.config.category.technical.description", (Object[])new Object[0])).addOption((ConfigOptionDef)TuttiServiceConfigOption.BASEDIR).addOption((ConfigOptionDef)TuttiServiceConfigOption.DATA_DIRECTORY).addOption((ConfigOptionDef)TuttiServiceConfigOption.TMP_DIRECTORY).addOption((ConfigOptionDef)TuttiApplicationConfigOption.TUTTI_I18N_DIRECTORY).addOption((ConfigOptionDef)TuttiApplicationConfigOption.TUTTI_HELP_DIRECTORY).addOption((ConfigOptionDef)TuttiPersistenceConfigOption.DB_DIRECTORY).addOption((ConfigOptionDef)TuttiPersistenceConfigOption.DB_ATTACHMENT_DIRECTORY).addOption((ConfigOptionDef)TuttiPersistenceConfigOption.DB_PROTOCOL_DIRECTORY).addOption((ConfigOptionDef)TuttiPersistenceConfigOption.DB_CACHE_DIRECTORY).addOption((ConfigOptionDef)TuttiPersistenceConfigOption.DB_CONFIGURATION_PATH).addOption((ConfigOptionDef)TuttiPersistenceConfigOption.DB_ENUMERATION_PATH).addOption((ConfigOptionDef)TuttiPersistenceConfigOption.JDBC_URL).addOption((ConfigOptionDef)TuttiServiceConfigOption.SITE_URL).addOption((ConfigOptionDef)TuttiApplicationConfigOption.TUTTI_UPDATE_URL);
        helper.setFinalizer((CallBackFinalizer)new MainCallBackFinalizer(CALLBACK_APPLICATION));
        helper.setCloseAction(new Runnable(){

            @Override
            public void run() {
                TuttiUIAction<GoToPreviousScreenAction> action = TuttiConfigUIHandler.this.getContext().getMainUI().getHandler().createUIAction(null, GoToPreviousScreenAction.class);
                action.actionPerformed(null);
            }
        });
        ConfigUI configUI = helper.buildUI(this.getUI(), I18n.n_((String)"tutti.config.category.applications", (Object[])new Object[0]));
        configUI.getHandler().setTopContainer((Container)this.getUI());
        ((TuttiConfigUI)this.getUI()).add((Component)configUI, "Center");
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
    }

    protected void reloadApplication() {
        MainUIHandler handler = this.getContext().getMainUI().getHandler();
        TuttiUIAction<ReloadTuttiAction> action = handler.createUIAction(null, ReloadTuttiAction.class);
        action.actionPerformed(null);
    }

    protected void reloadUI() {
        this.getContext().getMainUI().getHandler().reloadUI();
    }

    protected void reloadShortcuts() {
        this.getContext().getMainUI().getHandler().reloadUI();
    }
}

