/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.table;

import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import java.awt.event.ActionEvent;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoveToNextEditableCellAction<M extends AbstractTuttiTableModel>
extends AbstractSelectTableAction<M> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(MoveToNextEditableCellAction.class);

    public static <M extends AbstractTuttiTableModel> MoveToNextEditableCellAction<M> newAction(M model, JTable table) {
        return new MoveToNextEditableCellAction<M>(model, table);
    }

    protected MoveToNextEditableCellAction(M model, JTable table) {
        super(model, table);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int currentRow = this.getSelectedRow();
        int currentColumn = this.getSelectedColumn();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Move to previous editable cell " + this.getCellCoordinate(currentRow, currentColumn)));
        }
        int columnCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        while (currentRow <= rowCount || currentColumn <= columnCount) {
            if (++currentColumn >= columnCount) {
                currentColumn = 0;
                if (++currentRow == rowCount) {
                    if (!this.isCreateNewRow()) break;
                    this.addNewRow();
                }
            }
            if (this.isCellEditable(currentRow, currentColumn)) {
                this.doSelectCell(currentRow, currentColumn);
                break;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Cell not editable at " + this.getCellCoordinate(currentRow, currentColumn)));
        }
    }
}

