/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategory;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategoryType;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiComputedOrNotData;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import fr.ifremer.tutti.ui.swing.util.comment.CommentModelAware;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class SpeciesBatchRowModel
extends AbstractTuttiBeanUIModel<SpeciesBatch, SpeciesBatchRowModel>
implements AttachmentModelAware,
CommentModelAware {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_SPECIES_TO_CONFIRM = "speciesToConfirm";
    public static final String PROPERTY_SPECIES = "species";
    public static final String PROPERTY_SORTED_UNSORTED_CATEGORY = "sortedUnsortedCategory";
    public static final String PROPERTY_SORTED_UNSORTED_CATEGORY_VALUE = "sortedUnsortedCategoryValue";
    public static final String PROPERTY_SORTED_UNSORTED_CATEGORY_WEIGHT = "sortedUnsortedCategoryWeight";
    public static final String PROPERTY_SORTED_UNSORTED_COMPUTED_WEIGHT = "sortedUnsortedComputedWeight";
    public static final String PROPERTY_SIZE_CATEGORY = "sizeCategory";
    public static final String PROPERTY_SIZE_CATEGORY_VALUE = "sizeCategoryValue";
    public static final String PROPERTY_SIZE_CATEGORY_WEIGHT = "sizeCategoryWeight";
    public static final String PROPERTY_SEX_CATEGORY = "sexCategory";
    public static final String PROPERTY_SEX_CATEGORY_VALUE = "sexCategoryValue";
    public static final String PROPERTY_SEX_CATEGORY_WEIGHT = "sexCategoryWeight";
    public static final String PROPERTY_MATURITY_CATEGORY = "maturityCategory";
    public static final String PROPERTY_MATURITY_CATEGORY_VALUE = "maturityCategoryValue";
    public static final String PROPERTY_MATURITY_CATEGORY_WEIGHT = "maturityCategoryWeight";
    public static final String PROPERTY_AGE_CATEGORY = "ageCategory";
    public static final String PROPERTY_AGE_CATEGORY_VALUE = "ageCategoryValue";
    public static final String PROPERTY_AGE_CATEGORY_WEIGHT = "ageCategoryWeight";
    public static final String PROPERTY_WEIGHT = "weight";
    public static final String PROPERTY_NUMBER = "number";
    public static final String PROPERTY_FREQUENCY = "frequency";
    public static final String PROPERTY_COMPUTED_NUMBER = "computedOrNotNumber";
    public static final String PROPERTY_COMPUTED_WEIGHT = "computedOrNotWeight";
    public static final String PROPERTY_PARENT_BATCH = "parentBatch";
    public static final String PROPERTY_CHILD_BATCH = "childBatch";
    public static final String PROPERTY_BATCH_LEAF = "batchLeaf";
    public static final String PROPERTY_BATCH_ROOT = "batchRoot";
    public static final String PROPERTY_SAMPLE_CATEGORY = "sampleCategory";
    protected Species species;
    protected SampleCategory<CaracteristicQualitativeValue> sortedUnsortedCategory;
    protected SampleCategory<CaracteristicQualitativeValue> sizeCategory;
    protected SampleCategory<CaracteristicQualitativeValue> sexCategory;
    protected SampleCategory<CaracteristicQualitativeValue> maturityCategory;
    protected SampleCategory<Float> ageCategory;
    private SampleCategory<?> sampleCategory;
    protected boolean speciesToConfirm;
    protected TuttiComputedOrNotData<Float> computedOrNotWeight = new TuttiComputedOrNotData();
    protected TuttiComputedOrNotData<Integer> computedOrNotNumber = new TuttiComputedOrNotData();
    protected String comment;
    protected final List<Attachment> attachment = Lists.newArrayList();
    protected List<SpeciesFrequencyRowModel> frequency = Lists.newArrayList();
    protected SpeciesBatchRowModel parentBatch;
    protected List<SpeciesBatchRowModel> childBatch;
    protected static final Binder<SpeciesBatch, SpeciesBatchRowModel> fromBeanBinder = BinderFactory.newBinder(SpeciesBatch.class, SpeciesBatchRowModel.class);
    protected static final Binder<SpeciesBatchRowModel, SpeciesBatch> toBeanBinder = BinderFactory.newBinder(SpeciesBatchRowModel.class, SpeciesBatch.class);

    public SpeciesBatchRowModel() {
        super(SpeciesBatch.class, fromBeanBinder, toBeanBinder);
        this.sortedUnsortedCategory = SampleCategory.newSample(SampleCategoryType.sortedUnsorted);
        this.sizeCategory = SampleCategory.newSample(SampleCategoryType.size);
        this.sexCategory = SampleCategory.newSample(SampleCategoryType.sex);
        this.maturityCategory = SampleCategory.newSample(SampleCategoryType.maturity);
        this.ageCategory = SampleCategory.newSample(SampleCategoryType.age);
        this.computedOrNotWeight.addPropertyChangeListener("data", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SpeciesBatchRowModel.this.firePropertyChange(SpeciesBatchRowModel.PROPERTY_WEIGHT, evt.getOldValue(), evt.getNewValue());
            }
        });
        this.computedOrNotWeight.addPropertyChangeListener("computedData", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SpeciesBatchRowModel.this.firePropertyChange(SpeciesBatchRowModel.PROPERTY_COMPUTED_WEIGHT, evt.getOldValue(), evt.getNewValue());
            }
        });
        this.computedOrNotNumber.addPropertyChangeListener("data", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SpeciesBatchRowModel.this.firePropertyChange(SpeciesBatchRowModel.PROPERTY_NUMBER, evt.getOldValue(), evt.getNewValue());
            }
        });
        this.computedOrNotNumber.addPropertyChangeListener("computedData", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SpeciesBatchRowModel.this.firePropertyChange(SpeciesBatchRowModel.PROPERTY_COMPUTED_NUMBER, evt.getOldValue(), evt.getNewValue());
            }
        });
    }

    public SpeciesBatchRowModel(SpeciesBatch aBatch, List<SpeciesBatchFrequency> frequencies, List<Attachment> attachments) {
        this();
        this.fromBean(aBatch);
        List<SpeciesFrequencyRowModel> frequencyRows = SpeciesFrequencyRowModel.fromBeans(frequencies);
        this.frequency.addAll(frequencyRows);
        this.attachment.addAll(attachments);
        Collections.sort(this.frequency);
    }

    public SampleCategory<?> getSampleCategory() {
        return this.sampleCategory;
    }

    public void setSampleCategory(SampleCategory<?> sampleCategory) {
        SampleCategory<?> oldValue = this.getSampleCategory();
        this.sampleCategory = sampleCategory;
        this.firePropertyChange(PROPERTY_SAMPLE_CATEGORY, oldValue, sampleCategory);
    }

    public SampleCategory<?> getSampleCategory(SampleCategoryEnum sampleCategoryEnum) {
        switch (sampleCategoryEnum) {
            case sortedUnsorted: {
                this.sampleCategory = this.getSortedUnsortedCategory();
                break;
            }
            case size: {
                this.sampleCategory = this.getSizeCategory();
                break;
            }
            case sex: {
                this.sampleCategory = this.getSexCategory();
                break;
            }
            case maturity: {
                this.sampleCategory = this.getMaturityCategory();
                break;
            }
            case age: {
                this.sampleCategory = this.getAgeCategory();
                break;
            }
        }
        return this.sampleCategory;
    }

    public SampleCategory getFinestCategory() {
        SampleCategory<Serializable> finestCategory = this.ageCategory.isValid() ? this.ageCategory : (this.maturityCategory.isValid() ? this.maturityCategory : (this.sexCategory.isValid() ? this.sexCategory : (this.sizeCategory.isValid() ? this.sizeCategory : this.sortedUnsortedCategory)));
        return finestCategory;
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        Species oldCategory = this.getSpecies();
        this.species = species;
        this.firePropertyChange(PROPERTY_SPECIES, oldCategory, species);
    }

    public SampleCategory<CaracteristicQualitativeValue> getSortedUnsortedCategory() {
        return this.sortedUnsortedCategory;
    }

    public void setSortedUnsortedCategory(SampleCategory<CaracteristicQualitativeValue> sortedUnsortedCategory) {
        SampleCategory<CaracteristicQualitativeValue> oldCategory = this.getSortedUnsortedCategory();
        CaracteristicQualitativeValue oldValue = this.getSortedUnsortedCategoryValue();
        Float oldWeight = this.getSortedUnsortedCategoryWeight();
        this.sortedUnsortedCategory = sortedUnsortedCategory;
        this.firePropertyChange(PROPERTY_SORTED_UNSORTED_CATEGORY, oldCategory, sortedUnsortedCategory);
        this.firePropertyChange(PROPERTY_SORTED_UNSORTED_CATEGORY_VALUE, oldValue, this.getSortedUnsortedCategoryValue());
        this.firePropertyChange(PROPERTY_SORTED_UNSORTED_CATEGORY_WEIGHT, oldWeight, this.getSortedUnsortedCategoryWeight());
    }

    public CaracteristicQualitativeValue getSortedUnsortedCategoryValue() {
        return this.sortedUnsortedCategory.getCategoryValue();
    }

    public Float getSortedUnsortedCategoryWeight() {
        return this.sortedUnsortedCategory.getCategoryWeight();
    }

    public void setSortedUnsortedCategoryWeight(Float sortedUnsortedCategoryWeight) {
        Float oldValue = this.getSortedUnsortedCategoryWeight();
        this.sortedUnsortedCategory.setCategoryWeight(sortedUnsortedCategoryWeight);
        this.firePropertyChange(PROPERTY_SORTED_UNSORTED_CATEGORY_WEIGHT, oldValue, sortedUnsortedCategoryWeight);
    }

    public SampleCategory<CaracteristicQualitativeValue> getSizeCategory() {
        return this.sizeCategory;
    }

    public void setSizeCategory(SampleCategory<CaracteristicQualitativeValue> sizeCategory) {
        SampleCategory<CaracteristicQualitativeValue> oldCategory = this.getSizeCategory();
        CaracteristicQualitativeValue oldValue = this.getSizeCategoryValue();
        Float oldWeight = this.getSizeCategoryWeight();
        this.sizeCategory = sizeCategory;
        this.firePropertyChange(PROPERTY_SIZE_CATEGORY, oldCategory, sizeCategory);
        this.firePropertyChange(PROPERTY_SIZE_CATEGORY_VALUE, oldValue, this.getSizeCategoryValue());
        this.firePropertyChange(PROPERTY_SIZE_CATEGORY_WEIGHT, oldWeight, this.getSizeCategoryWeight());
    }

    public CaracteristicQualitativeValue getSizeCategoryValue() {
        return this.sizeCategory.getCategoryValue();
    }

    public Float getSizeCategoryWeight() {
        return this.sizeCategory.getCategoryWeight();
    }

    public void setSizeCategoryWeight(Float sizeCategoryWeight) {
        Float oldValue = this.getSizeCategoryWeight();
        this.sizeCategory.setCategoryWeight(sizeCategoryWeight);
        this.firePropertyChange(PROPERTY_SIZE_CATEGORY_WEIGHT, oldValue, sizeCategoryWeight);
    }

    public SampleCategory<CaracteristicQualitativeValue> getSexCategory() {
        return this.sexCategory;
    }

    public void setSexCategory(SampleCategory<CaracteristicQualitativeValue> sexCategory) {
        SampleCategory<CaracteristicQualitativeValue> oldCategory = this.getSexCategory();
        CaracteristicQualitativeValue oldValue = this.getSexCategoryValue();
        Float oldWeight = this.getSexCategoryWeight();
        this.sexCategory = sexCategory;
        this.firePropertyChange(PROPERTY_SEX_CATEGORY, oldCategory, sexCategory);
        this.firePropertyChange(PROPERTY_SEX_CATEGORY_VALUE, oldValue, this.getSexCategoryValue());
        this.firePropertyChange(PROPERTY_SEX_CATEGORY_WEIGHT, oldWeight, this.getSexCategoryWeight());
    }

    public CaracteristicQualitativeValue getSexCategoryValue() {
        return this.sexCategory.getCategoryValue();
    }

    public Float getSexCategoryWeight() {
        return this.sexCategory.getCategoryWeight();
    }

    public void setSexCategoryWeight(Float sexCategoryWeight) {
        Float oldValue = this.getSexCategoryWeight();
        this.sexCategory.setCategoryWeight(sexCategoryWeight);
        this.firePropertyChange(PROPERTY_SEX_CATEGORY_WEIGHT, oldValue, sexCategoryWeight);
    }

    public SampleCategory<CaracteristicQualitativeValue> getMaturityCategory() {
        return this.maturityCategory;
    }

    public void setMaturityCategory(SampleCategory<CaracteristicQualitativeValue> maturityCategory) {
        SampleCategory<CaracteristicQualitativeValue> oldCategory = this.getMaturityCategory();
        CaracteristicQualitativeValue oldValue = this.getMaturityCategoryValue();
        Float oldWeight = this.getMaturityCategoryWeight();
        this.maturityCategory = maturityCategory;
        this.firePropertyChange(PROPERTY_MATURITY_CATEGORY, oldCategory, maturityCategory);
        this.firePropertyChange(PROPERTY_MATURITY_CATEGORY_VALUE, oldValue, this.getMaturityCategoryValue());
        this.firePropertyChange(PROPERTY_MATURITY_CATEGORY_WEIGHT, oldWeight, this.getMaturityCategoryWeight());
    }

    public CaracteristicQualitativeValue getMaturityCategoryValue() {
        return this.maturityCategory.getCategoryValue();
    }

    public Float getMaturityCategoryWeight() {
        return this.maturityCategory.getCategoryWeight();
    }

    public void setMaturityCategoryWeight(Float maturityCategoryWeight) {
        Float oldValue = this.getMaturityCategoryWeight();
        this.maturityCategory.setCategoryWeight(maturityCategoryWeight);
        this.firePropertyChange(PROPERTY_MATURITY_CATEGORY_WEIGHT, oldValue, maturityCategoryWeight);
    }

    public SampleCategory<Float> getAgeCategory() {
        return this.ageCategory;
    }

    public void setAgeCategory(SampleCategory<Float> ageCategory) {
        SampleCategory<Float> oldCategory = this.getAgeCategory();
        Float oldValue = this.getAgeCategoryValue();
        Float oldWeight = this.getAgeCategoryWeight();
        this.ageCategory = ageCategory;
        this.firePropertyChange(PROPERTY_AGE_CATEGORY, oldCategory, ageCategory);
        this.firePropertyChange(PROPERTY_AGE_CATEGORY_VALUE, oldValue, this.getAgeCategoryValue());
        this.firePropertyChange(PROPERTY_AGE_CATEGORY_WEIGHT, oldWeight, this.getAgeCategoryWeight());
    }

    public Float getAgeCategoryValue() {
        return this.ageCategory.getCategoryValue();
    }

    public Float getAgeCategoryWeight() {
        return this.ageCategory.getCategoryWeight();
    }

    public void setAgeCategoryWeight(Float ageCategoryWeight) {
        Float oldValue = this.getAgeCategoryWeight();
        this.ageCategory.setCategoryWeight(ageCategoryWeight);
        this.firePropertyChange(PROPERTY_AGE_CATEGORY_WEIGHT, oldValue, ageCategoryWeight);
    }

    public SpeciesBatchRowModel getParentBatch() {
        return this.parentBatch;
    }

    public void setParentBatch(SpeciesBatchRowModel parentBatch) {
        SpeciesBatchRowModel oldValue = this.getParentBatch();
        this.parentBatch = parentBatch;
        this.firePropertyChange(PROPERTY_PARENT_BATCH, oldValue, parentBatch);
        this.firePropertyChange(PROPERTY_BATCH_ROOT, null, this.isBatchRoot());
    }

    public List<SpeciesBatchRowModel> getChildBatch() {
        return this.childBatch;
    }

    public void setChildBatch(List<SpeciesBatchRowModel> childBatch) {
        this.childBatch = childBatch;
        this.firePropertyChange(PROPERTY_CHILD_BATCH, null, childBatch);
        this.firePropertyChange(PROPERTY_BATCH_LEAF, null, this.isBatchLeaf());
    }

    public boolean isBatchLeaf() {
        return CollectionUtils.isEmpty(this.childBatch);
    }

    public boolean isBatchRoot() {
        return this.parentBatch == null;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.comment = comment;
        this.firePropertyChange("comment", oldValue, comment);
    }

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.SAMPLE;
    }

    @Override
    public String getObjectId() {
        return this.getId();
    }

    @Override
    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    public Boolean getSpeciesToConfirm() {
        return this.speciesToConfirm;
    }

    public void setSpeciesToConfirm(Boolean speciesToConfirm) {
        Boolean oldValue = this.getSpeciesToConfirm();
        this.speciesToConfirm = speciesToConfirm;
        this.firePropertyChange(PROPERTY_SPECIES_TO_CONFIRM, oldValue, speciesToConfirm);
    }

    public Float getWeight() {
        return this.computedOrNotWeight.getData();
    }

    public void setWeight(Float weight) {
        this.computedOrNotWeight.setData(weight);
    }

    public Integer getNumber() {
        return this.computedOrNotNumber.getData();
    }

    public void setNumber(Integer number) {
        this.computedOrNotNumber.setData(number);
    }

    public List<SpeciesFrequencyRowModel> getFrequency() {
        return this.frequency;
    }

    public void setFrequency(List<SpeciesFrequencyRowModel> frequency) {
        this.frequency = frequency;
        this.firePropertyChange(PROPERTY_FREQUENCY, null, frequency);
    }

    public Integer getComputedNumber() {
        return this.computedOrNotNumber.getComputedData();
    }

    public void setComputedNumber(Integer computedNumber) {
        this.computedOrNotNumber.setComputedData(computedNumber);
    }

    public Float getComputedWeight() {
        return this.computedOrNotWeight.getComputedData();
    }

    public void setComputedWeight(Float computedWeight) {
        this.computedOrNotWeight.setComputedData(computedWeight);
    }

    public TuttiComputedOrNotData<Integer> getComputedOrNotNumber() {
        return this.computedOrNotNumber;
    }

    public void setComputedOrNotNumber(TuttiComputedOrNotData<Integer> computedOrNotNumber) {
        this.computedOrNotNumber = computedOrNotNumber;
    }

    public TuttiComputedOrNotData<Float> getComputedOrNotWeight() {
        return this.computedOrNotWeight;
    }

    public void setComputedOrNotWeight(TuttiComputedOrNotData<Float> computedOrNotWeight) {
        this.computedOrNotWeight = computedOrNotWeight;
    }
}

