package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.ActionListCellRenderer;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class SelectCruiseUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<SelectCruiseUIModel, SelectCruiseUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CRUISE_COMBOBOX_ENABLED = "cruiseCombobox.enabled";
    public static final String BINDING_CRUISE_COMBOBOX_SELECTED_ITEM = "cruiseCombobox.selectedItem";
    public static final String BINDING_EDIT_CATCHES_BUTTON_ENABLED = "editCatchesButton.enabled";
    public static final String BINDING_EDIT_CRUISE_BUTTON_ENABLED = "editCruiseButton.enabled";
    public static final String BINDING_EDIT_PROGRAM_BUTTON_ENABLED = "editProgramButton.enabled";
    public static final String BINDING_EDIT_PROTOCOL_COMBO_BOX_ENABLED = "editProtocolComboBox.enabled";
    public static final String BINDING_NEW_CRUISE_BUTTON_ENABLED = "newCruiseButton.enabled";
    public static final String BINDING_PROGRAM_COMBOBOX_ENABLED = "programCombobox.enabled";
    public static final String BINDING_PROGRAM_COMBOBOX_SELECTED_ITEM = "programCombobox.selectedItem";
    public static final String BINDING_PROTOCOL_COMBOBOX_ENABLED = "protocolCombobox.enabled";
    public static final String BINDING_PROTOCOL_COMBOBOX_SELECTED_ITEM = "protocolCombobox.selectedItem";
    public static final String BINDING_VALIDATE_CATCHES_BUTTON_ENABLED = "validateCatchesButton.enabled";
    public static final String BINDING_WARNING_CONTAINER_VISIBLE = "warningContainer.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SelectCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton cloneProtocolButton;
    @ValidatorField( validatorId = "validator",  propertyName = "cruise",  editorName = "cruiseCombobox")
    protected BeanFilterableComboBox<Cruise> cruiseCombobox;
    protected JLabel cruiseLabel;
    protected JButton deleteProtocolButton;
    protected JButton editCatchesButton;
    protected JButton editCruiseButton;
    protected JButton editProgramButton;
    protected JButton editProtocolButton;
    protected JComboBox editProtocolComboBox;
    protected JButton exportProtocolButton;
    protected SelectCruiseUIHandler handler;
    protected JButton importProtocolButton;
    protected SelectCruiseUIModel model;
    protected JButton newCruiseButton;
    protected JButton newProgramButton;
    protected JButton newProtocolButton;
    protected JComboBox newProtocolComboBox;
    @ValidatorField( validatorId = "validator",  propertyName = "program",  editorName = "programCombobox")
    protected BeanFilterableComboBox<Program> programCombobox;
    protected JLabel programLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "protocol",  editorName = "protocolCombobox")
    protected BeanFilterableComboBox<TuttiProtocol> protocolCombobox;
    protected JLabel protocolLabel;
    protected SelectCruiseUI selectCruiseTopPanel = this;
    protected JButton validateCatchesButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<SelectCruiseUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected JPanel warningContainer;
    protected JLabel warningLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiUIContext uiContext;
    
    
        protected void $afterCompleteSetup() {
            handler.afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectCruiseUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                uiContext = parentUI.getHandler().getContext();
                SelectCruiseUIHandler handler =
                                     new SelectCruiseUIHandler(parentUI, this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public SelectCruiseUI() {
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__editProtocolComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startExistingProtocolAction(event);
    }

    public void doActionPerformed__on__newProtocolComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startNewProtocolAction(event);
    }

    public void doMouseClicked__on__editProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProtocolComboBox.isEnabled()) { handler.startExistingProtocolAction(event); }
    }

    public void doMouseClicked__on__newProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startNewProtocolAction(event);
    }

    public void doMouseEntered__on__editProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProtocolComboBox.isEnabled()) { editProtocolComboBox.showPopup(); }
    }

    public void doMouseEntered__on__newProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        newProtocolComboBox.showPopup();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloneProtocolButton() {
        return cloneProtocolButton;
    }

    public BeanFilterableComboBox<Cruise> getCruiseCombobox() {
        return cruiseCombobox;
    }

    public JLabel getCruiseLabel() {
        return cruiseLabel;
    }

    public JButton getDeleteProtocolButton() {
        return deleteProtocolButton;
    }

    public JButton getEditCatchesButton() {
        return editCatchesButton;
    }

    public JButton getEditCruiseButton() {
        return editCruiseButton;
    }

    public JButton getEditProgramButton() {
        return editProgramButton;
    }

    public JButton getEditProtocolButton() {
        return editProtocolButton;
    }

    public JComboBox getEditProtocolComboBox() {
        return editProtocolComboBox;
    }

    public JButton getExportProtocolButton() {
        return exportProtocolButton;
    }

    public SelectCruiseUIHandler getHandler() {
        return handler;
    }

    public JButton getImportProtocolButton() {
        return importProtocolButton;
    }

    public SelectCruiseUIModel getModel() {
        return model;
    }

    public JButton getNewCruiseButton() {
        return newCruiseButton;
    }

    public JButton getNewProgramButton() {
        return newProgramButton;
    }

    public JButton getNewProtocolButton() {
        return newProtocolButton;
    }

    public JComboBox getNewProtocolComboBox() {
        return newProtocolComboBox;
    }

    public BeanFilterableComboBox<Program> getProgramCombobox() {
        return programCombobox;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public BeanFilterableComboBox<TuttiProtocol> getProtocolCombobox() {
        return protocolCombobox;
    }

    public JLabel getProtocolLabel() {
        return protocolLabel;
    }

    public JButton getValidateCatchesButton() {
        return validateCatchesButton;
    }

    public SwingValidator<SelectCruiseUIModel> getValidator() {
        return validator;
    }

    public JPanel getWarningContainer() {
        return warningContainer;
    }

    public JLabel getWarningLabel() {
        return warningLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSelectCruiseTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(newProtocolButton);
        add(importProtocolButton);
        add(editProtocolButton);
        add(cloneProtocolButton);
        add(exportProtocolButton);
        add(deleteProtocolButton);
        add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void addChildrenToWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        warningContainer.add(warningLabel, BorderLayout.CENTER);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.selectCruise.help"));
    }

    protected void createCloneProtocolButton() {
        $objectMap.put("cloneProtocolButton", cloneProtocolButton = new JButton());
        
        cloneProtocolButton.setName("cloneProtocolButton");
        cloneProtocolButton.setText(_("tutti.selectCruise.action.cloneProtocol"));
        cloneProtocolButton.setToolTipText(_("tutti.selectCruise.action.cloneProtocol.tip"));
        cloneProtocolButton.putClientProperty("help", "tutti.selectCruise.action.cloneProtocol.help");
        cloneProtocolButton.putClientProperty("tuttiAction", CloneProtocolAction.class);
    }

    protected void createCruiseCombobox() {
        $objectMap.put("cruiseCombobox", cruiseCombobox = new BeanFilterableComboBox<Cruise>(this));
        
        cruiseCombobox.setName("cruiseCombobox");
        cruiseCombobox.setI18nPrefix("tutti.property.");
        cruiseCombobox.setProperty("cruise");
        cruiseCombobox.setShowReset(true);
        cruiseCombobox.putClientProperty("validatorLabel", _("tutti.selectCruise.field.cruise"));
    }

    protected void createCruiseLabel() {
        $objectMap.put("cruiseLabel", cruiseLabel = new JLabel());
        
        cruiseLabel.setName("cruiseLabel");
        cruiseLabel.setText(_("tutti.selectCruise.field.cruise"));
        cruiseLabel.setToolTipText(_("tutti.selectCruise.field.cruise.tip"));
        cruiseLabel.putClientProperty("help", "tutti.selectCruise.field.cruise.help");
    }

    protected void createDeleteProtocolButton() {
        $objectMap.put("deleteProtocolButton", deleteProtocolButton = new JButton());
        
        deleteProtocolButton.setName("deleteProtocolButton");
        deleteProtocolButton.setText(_("tutti.selectCruise.action.deleteProtocol"));
        deleteProtocolButton.setToolTipText(_("tutti.selectCruise.action.deleteProtocol.tip"));
        deleteProtocolButton.putClientProperty("help", "tutti.selectCruise.action.deleteProtocol.help");
        deleteProtocolButton.putClientProperty("tuttiAction", DeleteProtocolAction.class);
    }

    protected void createEditCatchesButton() {
        $objectMap.put("editCatchesButton", editCatchesButton = new JButton());
        
        editCatchesButton.setName("editCatchesButton");
        editCatchesButton.setText(_("tutti.selectCruise.action.editCatches"));
        editCatchesButton.setToolTipText(_("tutti.selectCruise.action.editCatches.tip"));
        editCatchesButton.putClientProperty("help", "tutti.selectCruise.action.editCatches.help");
        editCatchesButton.putClientProperty("tuttiAction", EditCatchesAction.class);
    }

    protected void createEditCruiseButton() {
        $objectMap.put("editCruiseButton", editCruiseButton = new JButton());
        
        editCruiseButton.setName("editCruiseButton");
        editCruiseButton.setText(_("tutti.selectCruise.action.editCruise"));
        editCruiseButton.setToolTipText(_("tutti.selectCruise.action.editCruise.tip"));
        editCruiseButton.putClientProperty("help", "tutti.selectCruise.action.editCruise.help");
        editCruiseButton.putClientProperty("tuttiAction", EditCruiseAction.class);
    }

    protected void createEditProgramButton() {
        $objectMap.put("editProgramButton", editProgramButton = new JButton());
        
        editProgramButton.setName("editProgramButton");
        editProgramButton.setText(_("tutti.selectCruise.action.editProgram"));
        editProgramButton.setToolTipText(_("tutti.selectCruise.action.editProgram.tip"));
        editProgramButton.putClientProperty("help", "tutti.selectCruise.action.editProgram.help");
        editProgramButton.putClientProperty("tuttiAction", EditProgramAction.class);
    }

    protected void createEditProtocolButton() {
        $objectMap.put("editProtocolButton", editProtocolButton = new JButton());
        
        editProtocolButton.setName("editProtocolButton");
        editProtocolButton.setText(_("tutti.selectCruise.action.editProtocol"));
        editProtocolButton.setToolTipText(_("tutti.selectCruise.action.editProtocol.tip"));
        editProtocolButton.putClientProperty("help", "tutti.selectCruise.action.editProtocol.help");
        editProtocolButton.putClientProperty("tuttiAction", EditProtocolAction.class);
    }

    protected void createEditProtocolComboBox() {
        $objectMap.put("editProtocolComboBox", editProtocolComboBox = new JComboBox());
        
        editProtocolComboBox.setName("editProtocolComboBox");
        editProtocolComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editProtocolComboBox"));
        editProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__editProtocolComboBox"));
        editProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__editProtocolComboBox"));
    }

    protected void createExportProtocolButton() {
        $objectMap.put("exportProtocolButton", exportProtocolButton = new JButton());
        
        exportProtocolButton.setName("exportProtocolButton");
        exportProtocolButton.setText(_("tutti.selectCruise.action.exportProtocol"));
        exportProtocolButton.setToolTipText(_("tutti.selectCruise.action.exportProtocol.tip"));
        exportProtocolButton.putClientProperty("help", "tutti.selectCruise.action.exportProtocol.help");
        exportProtocolButton.putClientProperty("tuttiAction", ExportProtocolAction.class);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SelectCruiseUIHandler.class));
    }

    protected void createImportProtocolButton() {
        $objectMap.put("importProtocolButton", importProtocolButton = new JButton());
        
        importProtocolButton.setName("importProtocolButton");
        importProtocolButton.setText(_("tutti.selectCruise.action.importProtocol"));
        importProtocolButton.setToolTipText(_("tutti.selectCruise.action.importProtocol.tip"));
        importProtocolButton.putClientProperty("help", "tutti.selectCruise.action.importProtocol.help");
        importProtocolButton.putClientProperty("tuttiAction", ImportProtocolAction.class);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SelectCruiseUIModel.class));
    }

    protected void createNewCruiseButton() {
        $objectMap.put("newCruiseButton", newCruiseButton = new JButton());
        
        newCruiseButton.setName("newCruiseButton");
        newCruiseButton.setText(_("tutti.selectCruise.action.newCruise"));
        newCruiseButton.setToolTipText(_("tutti.selectCruise.action.newCruise.tip"));
        newCruiseButton.putClientProperty("help", "tutti.selectCruise.action.newCruise.help");
        newCruiseButton.putClientProperty("tuttiAction", NewCruiseAction.class);
    }

    protected void createNewProgramButton() {
        $objectMap.put("newProgramButton", newProgramButton = new JButton());
        
        newProgramButton.setName("newProgramButton");
        newProgramButton.setText(_("tutti.selectCruise.action.newProgram"));
        newProgramButton.setToolTipText(_("tutti.selectCruise.action.newProgram.tip"));
        newProgramButton.putClientProperty("help", "tutti.selectCruise.action.newProgram.help");
        newProgramButton.putClientProperty("tuttiAction", NewProgramAction.class);
    }

    protected void createNewProtocolButton() {
        $objectMap.put("newProtocolButton", newProtocolButton = new JButton());
        
        newProtocolButton.setName("newProtocolButton");
        newProtocolButton.setText(_("tutti.selectCruise.action.newProtocol"));
        newProtocolButton.setToolTipText(_("tutti.selectCruise.action.newProtocol.tip"));
        newProtocolButton.putClientProperty("help", "tutti.selectCruise.action.newProtocol.help");
        newProtocolButton.putClientProperty("tuttiAction", NewProtocolAction.class);
    }

    protected void createNewProtocolComboBox() {
        $objectMap.put("newProtocolComboBox", newProtocolComboBox = new JComboBox());
        
        newProtocolComboBox.setName("newProtocolComboBox");
        newProtocolComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newProtocolComboBox"));
        newProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__newProtocolComboBox"));
        newProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__newProtocolComboBox"));
    }

    protected void createProgramCombobox() {
        $objectMap.put("programCombobox", programCombobox = new BeanFilterableComboBox<Program>(this));
        
        programCombobox.setName("programCombobox");
        programCombobox.setI18nPrefix("tutti.property.");
        programCombobox.setProperty("program");
        programCombobox.setShowReset(true);
        programCombobox.putClientProperty("validatorLabel", _("tutti.selectCruise.field.program"));
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(_("tutti.selectCruise.field.program"));
        programLabel.setToolTipText(_("tutti.selectCruise.field.program.tip"));
        programLabel.putClientProperty("help", "tutti.selectCruise.field.program.help");
    }

    protected void createProtocolCombobox() {
        $objectMap.put("protocolCombobox", protocolCombobox = new BeanFilterableComboBox<TuttiProtocol>(this));
        
        protocolCombobox.setName("protocolCombobox");
        protocolCombobox.setI18nPrefix("tutti.property.");
        protocolCombobox.setProperty("protocol");
        protocolCombobox.setShowReset(true);
        protocolCombobox.putClientProperty("validatorLabel", _("tutti.selectCruise.field.protocol"));
    }

    protected void createProtocolLabel() {
        $objectMap.put("protocolLabel", protocolLabel = new JLabel());
        
        protocolLabel.setName("protocolLabel");
        protocolLabel.setText(_("tutti.selectCruise.field.protocol"));
        protocolLabel.setToolTipText(_("tutti.selectCruise.field.protocol.tip"));
        protocolLabel.putClientProperty("help", "tutti.selectCruise.field.protocol.help");
    }

    protected void createValidateCatchesButton() {
        $objectMap.put("validateCatchesButton", validateCatchesButton = new JButton());
        
        validateCatchesButton.setName("validateCatchesButton");
        validateCatchesButton.setText(_("tutti.selectCruise.action.validateCatches"));
        validateCatchesButton.setToolTipText(_("tutti.selectCruise.action.validateCatches.tip"));
        validateCatchesButton.putClientProperty("help", "tutti.selectCruise.action.validateCatches.help");
        validateCatchesButton.putClientProperty("tuttiAction", ValidateCatchesAction.class);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SelectCruiseUIModel.class, null));
    }

    protected void createWarningContainer() {
        $objectMap.put("warningContainer", warningContainer = new JPanel());
        
        warningContainer.setName("warningContainer");
        warningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createWarningLabel() {
        $objectMap.put("warningLabel", warningLabel = new JLabel());
        
        warningLabel.setName("warningLabel");
        warningLabel.setText(_("tutti.selectCruise.warn.invalid.selected.data"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSelectCruiseTopPanel();
        addChildrenToValidator();
        // inline complete setup of $Table0
        $Table0.add(warningContainer, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(programLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(programCombobox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cruiseLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cruiseCombobox), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(protocolLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(protocolCombobox), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel3, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToWarningContainer();
        // inline complete setup of $JPanel0
        $JPanel0.add(editProgramButton);
        $JPanel0.add(newProgramButton);
        // inline complete setup of $JPanel1
        $JPanel1.add(editCruiseButton);
        $JPanel1.add(newCruiseButton);
        // inline complete setup of $JPanel2
        $JPanel2.add(editProtocolComboBox);
        $JPanel2.add(newProtocolComboBox);
        // inline complete setup of $JPanel3
        $JPanel3.add(editCatchesButton);
        $JPanel3.add(validateCatchesButton);
        
        // apply 13 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 48 property setters
        programCombobox.setBeanType(Program.class);
        cruiseCombobox.setBeanType(Cruise.class);
        protocolCombobox.setBeanType(TuttiProtocol.class);
        newProtocolButton.setIcon(SwingUtil.createActionIcon("add"));
        newProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.selectCruise.action.newProtocol.mnemonic"),'Z'));
        importProtocolButton.setIcon(SwingUtil.createActionIcon("import"));
        importProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.selectCruise.action.importProtocol.mnemonic"),'Z'));
        editProtocolButton.setIcon(SwingUtil.createActionIcon("edit"));
        editProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.selectCruise.action.editProtocol.mnemonic"),'Z'));
        cloneProtocolButton.setIcon(SwingUtil.createActionIcon("copy"));
        cloneProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.selectCruise.action.cloneProtocol.mnemonic"),'Z'));
        exportProtocolButton.setIcon(SwingUtil.createActionIcon("export"));
        exportProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.selectCruise.action.exportProtocol.mnemonic"),'Z'));
        deleteProtocolButton.setIcon(SwingUtil.createActionIcon("delete"));
        deleteProtocolButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.selectCruise.action.deleteProtocol.mnemonic"),'Z'));
        warningContainer.setBackground(new java.awt.Color(245, 218, 88));
        warningLabel.setIcon(SwingUtil.createActionIcon("warning"));
        warningLabel.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        programLabel.setIcon(SwingUtil.createActionIcon("program"));
        programCombobox.setBean(model);
        editProgramButton.setIcon(SwingUtil.createActionIcon("edit"));
        editProgramButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.selectCruise.action.editProgram.mnemonic"),'Z'));
        newProgramButton.setIcon(SwingUtil.createActionIcon("add"));
        newProgramButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.selectCruise.action.newProgram.mnemonic"),'Z'));
        cruiseLabel.setLabelFor(cruiseCombobox);
        cruiseLabel.setIcon(SwingUtil.createActionIcon("cruise"));
        cruiseCombobox.setBean(model);
        editCruiseButton.setIcon(SwingUtil.createActionIcon("edit"));
        editCruiseButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.selectCruise.action.editCruise.mnemonic"),'Z'));
        newCruiseButton.setIcon(SwingUtil.createActionIcon("add"));
        newCruiseButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.selectCruise.action.newCruise.mnemonic"),'Z'));
        protocolLabel.setLabelFor(protocolCombobox);
        protocolLabel.setIcon(SwingUtil.createActionIcon("protocol"));
        protocolCombobox.setBean(model);
        editProtocolComboBox.setModel(handler.newComboModel(editProtocolButton, cloneProtocolButton, exportProtocolButton, deleteProtocolButton));
        editProtocolComboBox.setRenderer(new ActionListCellRenderer());
        newProtocolComboBox.setModel(handler.newComboModel(newProtocolButton, importProtocolButton));
        newProtocolComboBox.setRenderer(new ActionListCellRenderer());
        editCatchesButton.setIcon(SwingUtil.createActionIcon("edit"));
        editCatchesButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.selectCruise.action.editCatches.mnemonic"),'Z'));
        validateCatchesButton.setIcon(SwingUtil.createActionIcon("validate"));
        validateCatchesButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.selectCruise.action.validateCatches.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, selectCruiseTopPanel, "tutti.selectCruise.help");
        registerHelpId(_broker, newProtocolButton, "tutti.selectCruise.action.newProtocol.help");
        registerHelpId(_broker, importProtocolButton, "tutti.selectCruise.action.importProtocol.help");
        registerHelpId(_broker, editProtocolButton, "tutti.selectCruise.action.editProtocol.help");
        registerHelpId(_broker, cloneProtocolButton, "tutti.selectCruise.action.cloneProtocol.help");
        registerHelpId(_broker, exportProtocolButton, "tutti.selectCruise.action.exportProtocol.help");
        registerHelpId(_broker, deleteProtocolButton, "tutti.selectCruise.action.deleteProtocol.help");
        registerHelpId(_broker, programLabel, "tutti.selectCruise.field.program.help");
        registerHelpId(_broker, editProgramButton, "tutti.selectCruise.action.editProgram.help");
        registerHelpId(_broker, newProgramButton, "tutti.selectCruise.action.newProgram.help");
        registerHelpId(_broker, cruiseLabel, "tutti.selectCruise.field.cruise.help");
        registerHelpId(_broker, editCruiseButton, "tutti.selectCruise.action.editCruise.help");
        registerHelpId(_broker, newCruiseButton, "tutti.selectCruise.action.newCruise.help");
        registerHelpId(_broker, protocolLabel, "tutti.selectCruise.field.protocol.help");
        registerHelpId(_broker, editCatchesButton, "tutti.selectCruise.action.editCatches.help");
        registerHelpId(_broker, validateCatchesButton, "tutti.selectCruise.action.validateCatches.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("selectCruiseTopPanel", selectCruiseTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createNewProtocolButton();
        createImportProtocolButton();
        createEditProtocolButton();
        createCloneProtocolButton();
        createExportProtocolButton();
        createDeleteProtocolButton();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createWarningContainer();
        createWarningLabel();
        createProgramLabel();
        createProgramCombobox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createEditProgramButton();
        createNewProgramButton();
        createCruiseLabel();
        createCruiseCombobox();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createEditCruiseButton();
        createNewCruiseButton();
        createProtocolLabel();
        createProtocolCombobox();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createEditProtocolComboBox();
        createNewProtocolComboBox();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createEditCatchesButton();
        createValidateCatchesButton();
        // inline creation of selectCruiseTopPanel
        setName("selectCruiseTopPanel");
        setLayout(new BorderLayout());
        selectCruiseTopPanel.putClientProperty("help", "tutti.selectCruise.help");
        
        // registers 13 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 13 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WARNING_CONTAINER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    warningContainer.setVisible(!model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (programCombobox != null) {
                    programCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (programCombobox != null) {
                    programCombobox.setEnabled(!programCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (programCombobox != null) {
                    programCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    programCombobox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_PROGRAM_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editProgramButton.setEnabled(model.isProgramFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.setEnabled(!cruiseCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("cruise", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cruiseCombobox.setSelectedItem(model.getCruise());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("cruise", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_CRUISE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editCruiseButton.setEnabled(model.isProgramFound() && model.isCruiseFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_CRUISE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    newCruiseButton.setEnabled(model.isProgramFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROTOCOL_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.setEnabled(!protocolCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROTOCOL_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("protocol", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    protocolCombobox.setSelectedItem(model.getProtocol());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("protocol", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_PROTOCOL_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("protocolFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editProtocolComboBox.setEnabled(model.isProtocolFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("protocolFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_CATCHES_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                addPropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && uiContext != null) {
                    editCatchesButton.setEnabled(model.isValid() && uiContext.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                removePropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_CATCHES_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                addPropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && uiContext != null) {
                    validateCatchesButton.setEnabled(model.isValid() && uiContext.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                removePropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
    }

}