/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import com.google.common.collect.Maps;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategory;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ComputeWeightsAction
extends AbstractTuttiAction<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ComputeWeightsAction.class);
    protected String errorMessage;
    protected String errorTitle;
    protected Component errorComponent;

    public ComputeWeightsAction(EditCatchesUIHandler handler) {
        super(handler, "computeWeights", "generate", I18n._((String)"tutti.action.computeWeights", (Object[])new Object[0]), I18n._((String)"tutti.action.computeWeights.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected void doAction(ActionEvent event) throws Exception {
        Map<Weights, Float> speciesWeights = this.computeSpeciesBatches();
        EditCatchesUI ui = (EditCatchesUI)this.getUI();
        this.setComputedValue(ui.getCatchTotalUnsortedWeightField(), speciesWeights.get((Object)Weights.UNSORTED));
        this.setComputedValue(ui.getCatchTotalSortedWeightField(), speciesWeights.get((Object)Weights.SORTED));
        EditCatchesUIModel model = (EditCatchesUIModel)((Object)this.getModel());
        Float totalWeight = model.getCatchTotalWeight();
        Float rejectedWeight = model.getCatchTotalRejectedWeight();
        if (rejectedWeight == null && totalWeight != null) {
            if (!totalWeight.equals(Float.valueOf(speciesWeights.get((Object)Weights.UNSORTED).floatValue() + speciesWeights.get((Object)Weights.SORTED).floatValue()))) {
                this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentTotal", (Object[])new Object[0]);
                this.errorTitle = I18n._((String)"tutti.action.computeWeights.error.incoherentTotal.title", (Object[])new Object[0]);
                this.errorComponent = ui.getCatchTotalWeightField();
            } else {
                model.setCatchTotalRejectedComputedWeight(Float.valueOf(totalWeight.floatValue() - speciesWeights.get((Object)Weights.UNSORTED).floatValue() - speciesWeights.get((Object)Weights.SORTED).floatValue()));
            }
        } else if (totalWeight == null) {
            if (rejectedWeight == null) {
                rejectedWeight = Float.valueOf(0.0f);
            }
            model.setCatchTotalComputedWeight(Float.valueOf(speciesWeights.get((Object)Weights.UNSORTED).floatValue() + speciesWeights.get((Object)Weights.SORTED).floatValue() + rejectedWeight.floatValue()));
        } else if (rejectedWeight != null && !totalWeight.equals(Float.valueOf(speciesWeights.get((Object)Weights.UNSORTED).floatValue() + speciesWeights.get((Object)Weights.SORTED).floatValue() + rejectedWeight.floatValue()))) {
            this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentTotal", (Object[])new Object[0]);
            this.errorTitle = I18n._((String)"tutti.action.computeWeights.error.incoherentTotal.title", (Object[])new Object[0]);
            this.errorComponent = ui.getCatchTotalWeightField();
        }
    }

    protected Map<Weights, Float> computeSpeciesBatches() {
        Number livingNotItemizedWeight;
        Number inertWeight;
        EnumMap result = Maps.newEnumMap(Weights.class);
        PersistenceService persistenceService = this.getService(PersistenceService.class);
        EditCatchesUIModel model = (EditCatchesUIModel)((Object)this.getModel());
        Float totalSortedWeight = Float.valueOf(0.0f);
        Float totalUnsortedWeight = Float.valueOf(0.0f);
        SpeciesBatchUI speciesUI = ((EditCatchesUI)this.getUI()).getSpeciesTabContent();
        EditCatchesUI ui = (EditCatchesUI)this.getUI();
        List roots = ((EditCatchesUI)this.getUI()).getSpeciesTabContent().getModel().getRows();
        for (SpeciesBatchRowModel row : roots) {
            if (!row.isBatchRoot()) continue;
            Float weight = this.computeSpeciesBatch(row);
            if (weight == null) {
                JOptionPane.showMessageDialog(speciesUI, I18n._((String)"tutti.dialog.catches.species.computeWeight.error.message", (Object[])new Object[0]), I18n._((String)"tutti.dialog.catches.species.computeWeight.error.title", (Object[])new Object[0]), 0);
                totalSortedWeight = null;
                totalUnsortedWeight = null;
                break;
            }
            if (persistenceService.isSortedQualitativeValue(row.getSortedUnsortedCategory().getCategoryValue())) {
                totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + weight.floatValue());
                continue;
            }
            totalUnsortedWeight = Float.valueOf(totalUnsortedWeight.floatValue() + weight.floatValue());
        }
        if ((inertWeight = speciesUI.getSpeciesTotalInertWeightField().getModel()) != null) {
            totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + inertWeight.floatValue());
        }
        if ((livingNotItemizedWeight = speciesUI.getSpeciesTotalLivingNotItemizedWeightField().getModel()) != null) {
            totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + livingNotItemizedWeight.floatValue());
        }
        this.setComputedValue(speciesUI.getSpeciesTotalSampleSortedWeightField(), totalSortedWeight);
        this.setComputedValue(ui.getSpeciesTotalSampleSortedWeightField(), totalSortedWeight);
        result.put(Weights.SAMPLE_SORTED, totalSortedWeight);
        Float speciesTotalSortedWeight = model.getSpeciesTotalSortedWeight();
        if (speciesTotalSortedWeight == null) {
            speciesTotalSortedWeight = totalSortedWeight;
            model.setSpeciesTotalSortedComputedWeight(totalSortedWeight);
        } else if (speciesTotalSortedWeight.floatValue() < totalSortedWeight.floatValue()) {
            this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentSpeciesTotalSorted", (Object[])new Object[0]);
            this.errorTitle = I18n._((String)"tutti.action.computeWeights.error.incoherentSpeciesTotalSorted.title", (Object[])new Object[0]);
            this.errorComponent = ui.getSpeciesTotalSortedWeightField();
        } else if ((double)speciesTotalSortedWeight.floatValue() < 1.05 * (double)totalSortedWeight.floatValue()) {
            // empty if block
        }
        result.put(Weights.SORTED, speciesTotalSortedWeight);
        this.setComputedValue(speciesUI.getSpeciesTotalUnsortedWeightField(), totalUnsortedWeight);
        this.setComputedValue(ui.getSpeciesTotalUnsortedWeightField(), totalUnsortedWeight);
        result.put(Weights.UNSORTED, totalUnsortedWeight);
        Float totalWeight = Float.valueOf(totalUnsortedWeight.floatValue() + speciesTotalSortedWeight.floatValue());
        this.setComputedValue(speciesUI.getSpeciesTotalWeightField(), totalWeight);
        this.setComputedValue(ui.getSpeciesTotalWeightField(), totalWeight);
        result.put(Weights.TOTAL, speciesTotalSortedWeight);
        speciesUI.getTable().repaint();
        return result;
    }

    protected Float computeSpeciesBatch(SpeciesBatchRowModel row) {
        SampleCategory finestCategory = row.getFinestCategory();
        Float result = null;
        Float categoryWeight = finestCategory.getCategoryWeight();
        Float rowWeight = row.getWeight();
        List<SpeciesBatchRowModel> children = row.getChildBatch();
        if (!row.isBatchLeaf()) {
            Float sum = Float.valueOf(0.0f);
            for (SpeciesBatchRowModel child : children) {
                Float weight = this.computeSpeciesBatch(child);
                if (weight == null) {
                    sum = null;
                    break;
                }
                sum = Float.valueOf(sum.floatValue() + weight.floatValue());
            }
            if (sum != null) {
                if (categoryWeight == null) {
                    finestCategory.setComputedWeight(sum);
                    for (SpeciesBatchRowModel child : children) {
                        child.getFinestCategory().setSubSample(false);
                    }
                } else if (categoryWeight.floatValue() < sum.floatValue()) {
                    this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentParentCategoryWeight", (Object[])new Object[0]);
                    this.errorTitle = I18n._((String)"tutti.action.computeWeights.error.incoherentParentCategoryWeight.title", (Object[])new Object[0]);
                    this.errorComponent = null;
                } else {
                    boolean subSample = categoryWeight.floatValue() > sum.floatValue();
                    for (SpeciesBatchRowModel child : children) {
                        child.getFinestCategory().setSubSample(subSample);
                    }
                }
                result = sum;
            }
        } else {
            row.setComputedWeight(null);
            List<SpeciesFrequencyRowModel> frequency = row.getFrequency();
            if (CollectionUtils.isNotEmpty(frequency)) {
                Float frequencyWeight = Float.valueOf(0.0f);
                for (SpeciesFrequencyRowModel frequencyModel : frequency) {
                    Float w = frequencyModel.getWeight();
                    if (w == null) {
                        frequencyWeight = null;
                        break;
                    }
                    if (frequencyWeight == null) continue;
                    frequencyWeight = Float.valueOf(frequencyWeight.floatValue() + w.floatValue());
                }
                if (categoryWeight == null && rowWeight != null) {
                    this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentRowWeightCategory", (Object[])new Object[0]);
                    this.errorTitle = I18n._((String)"tutti.action.computeWeights.error.incoherentRowWeightCategory.title", (Object[])new Object[0]);
                    this.errorComponent = null;
                } else if (categoryWeight == null && frequencyWeight != null) {
                    finestCategory.setComputedWeight(frequencyWeight);
                    result = frequencyWeight;
                } else if (frequencyWeight != null && !frequencyWeight.equals(categoryWeight)) {
                    if (categoryWeight != null && frequencyWeight.floatValue() > categoryWeight.floatValue()) {
                        this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentCategoryWeight", (Object[])new Object[0]);
                        this.errorTitle = I18n._((String)"tutti.action.computeWeights.error.incoherentCategoryWeight.title", (Object[])new Object[0]);
                        this.errorComponent = null;
                    } else if (rowWeight == null) {
                        row.setComputedWeight(frequencyWeight);
                    } else if (!rowWeight.equals(frequencyWeight)) {
                        this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentRowWeightFrequency", (Object[])new Object[0]);
                        this.errorTitle = I18n._((String)"tutti.action.computeWeights.error.incoherentRowWeightFrequency.title", (Object[])new Object[0]);
                        this.errorComponent = null;
                    }
                    result = categoryWeight;
                } else {
                    result = categoryWeight;
                }
            } else {
                result = categoryWeight;
            }
        }
        return result;
    }

    protected void setComputedValue(JTextField textField, Float value) {
        String textValue = value != null ? String.format("%.3f", value) : JAXXUtil.getStringValue((Object)value);
        textField.setText(textValue);
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        if (this.errorMessage != null) {
            JOptionPane.showMessageDialog((Component)this.getUI(), this.errorMessage, this.errorTitle, 0);
        }
        if (this.errorComponent != null) {
            this.errorComponent.requestFocus();
        }
        this.errorMessage = null;
        this.errorComponent = null;
    }

    protected static enum Weights {
        UNSORTED,
        SAMPLE_SORTED,
        SORTED,
        TOTAL;

    }
}

