/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.TuttiService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.MainUI;
import fr.ifremer.tutti.ui.swing.TuttiExceptionHandler;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUI;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUIModel;
import java.awt.event.ActionEvent;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import jaxx.runtime.SwingUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.util.decorator.Decorator;

public abstract class AbstractTuttiAction<M extends AbstractBean, UI extends TuttiUI<M, ?>, H extends AbstractTuttiUIHandler<M, UI>>
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractTuttiAction.class);
    private static final Timer t = new Timer();
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final H handler;
    private boolean failed;
    private final boolean hideBody;
    private static final Object lock = new Object();
    private static final Set<Object> actions = Sets.newHashSet();
    private static AbstractTuttiAction mainAction;

    protected abstract void doAction(ActionEvent var1) throws Exception;

    protected AbstractTuttiAction(H handler, String name, String icon, String text, String tip, boolean hideBody) {
        this.handler = handler;
        this.hideBody = hideBody;
        this.putValue("SmallIcon", SwingUtil.createActionIcon((String)icon));
        this.putValue("SwingLargeIconKey", SwingUtil.createActionIcon((String)icon));
        this.putValue("ActionCommandKey", name);
        this.putValue("Name", text);
        this.putValue("ShortDescription", tip);
    }

    public final UI getUI() {
        return ((AbstractTuttiUIHandler)this.handler).getUI();
    }

    protected String getActionName() {
        return (String)this.getValue("actionName");
    }

    public String getActionDescription() {
        return (String)this.getValue("actionDescription");
    }

    protected boolean prepareAction(ActionEvent event) {
        this.putValue("actionName", this.getValue("Name"));
        this.putValue("actionDescription", this.getValue("ShortDescription"));
        return true;
    }

    protected void releaseAction(ActionEvent event) {
        this.putValue("actionName", null);
        this.putValue("actionDescription", null);
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void actionPerformed(final ActionEvent event) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Task [" + this + "] starting"));
        }
        this.setFailed(false);
        boolean doAction = this.prepareAction(event);
        if (doAction) {
            boolean useTimer;
            Object object = lock;
            synchronized (object) {
                useTimer = actions.isEmpty();
                mainAction = this;
                actions.add(this);
            }
            if (useTimer) {
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        AbstractTuttiAction.this.runAction(true, event);
                    }
                });
            } else {
                this.runAction(false, event);
            }
        } else {
            this.releaseAction(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAction(boolean useTimer, ActionEvent event) {
        ActionTimerTask<AbstractTuttiAction> timer = null;
        if (useTimer) {
            timer = new ActionTimerTask<AbstractTuttiAction>(this);
            t.schedule(timer, 1000L);
        }
        try {
            this.doAction(event);
        }
        catch (Throwable e) {
            this.setFailed(true);
            if (log.isErrorEnabled()) {
                log.error((Object)("Task [" + this + "] error: " + e.getMessage()), e);
            }
            throw new TuttiExceptionHandler.TuttiActionException(this, e);
        }
        finally {
            if (log.isInfoEnabled()) {
                log.info((Object)("Task [" + this + "] done"));
            }
            if (timer != null) {
                ((TimerTask)timer).cancel();
            }
            try {
                this.releaseAction(event);
            }
            finally {
                Object object = lock;
                synchronized (object) {
                    TuttiActionUI actionUI = this.getContext().getActionUI();
                    TuttiActionUIModel actionUIModel = actionUI.getModel();
                    if (ObjectUtils.equals((Object)this, (Object)actionUIModel.getAction())) {
                        actionUIModel.clear();
                    }
                    actions.remove(this);
                    if (this.equals(AbstractTuttiAction.getMainAction())) {
                        mainAction = null;
                    }
                }
            }
        }
    }

    public TuttiUIContext getContext() {
        return ((AbstractTuttiUIHandler)this.handler).getContext();
    }

    public H getHandler() {
        return this.handler;
    }

    public M getModel() {
        return (M)((AbstractBean)((AbstractTuttiUIHandler)this.handler).getModel());
    }

    protected <S extends TuttiService> S getService(Class<S> serviceType) {
        return this.getContext().getService(serviceType);
    }

    protected TuttiApplicationConfig getConfig() {
        return this.getContext().getConfig();
    }

    protected void setMnemonic(int key) {
        this.putValue("MnemonicKey", key);
    }

    public boolean isHideBody() {
        return this.hideBody;
    }

    public static AbstractTuttiAction getMainAction() {
        return mainAction;
    }

    protected void sendMessage(String message) {
        this.getContext().showInformationMessage(message);
    }

    protected <O> Decorator<O> getDecorator(Class<O> type, String name) {
        DecoratorService decoratorService = this.getContext().getService(DecoratorService.class);
        Preconditions.checkNotNull(type);
        Decorator<DecoratorService.LabelAware> decorator = decoratorService.getDecoratorByType(type, name);
        if (decorator == null && DecoratorService.LabelAware.class.isAssignableFrom(type)) {
            decorator = this.getDecorator(DecoratorService.LabelAware.class, null);
        }
        Preconditions.checkNotNull((Object)decorator);
        return decorator;
    }

    protected String decorate(Object object) {
        return ((AbstractTuttiUIHandler)this.handler).getDecorator(object.getClass(), null).toString(object);
    }

    protected static class ActionTimerTask<A extends AbstractTuttiAction>
    extends TimerTask {
        private final Object lock = new Object();
        protected boolean canceled;
        private final A action;
        protected TuttiActionUI actionUI;

        public ActionTimerTask(A action) {
            this.action = action;
            this.actionUI = ((AbstractTuttiAction)action).getContext().getActionUI();
        }

        @Override
        public void run() {
            if (this.canceled) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Task [" + this.action + "] was already canceled, do nothing"));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Task [" + this.action + "] is started, show waiting dialog"));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Try to open dialog (was canceled ? " + this.canceled + ")"));
                }
                if (!this.canceled || !((AbstractTuttiAction)this.action).isFailed()) {
                    this.updateBusyState(true);
                    this.actionUI.getModel().setAction((AbstractTuttiAction)this.action);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.canceled = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Task [" + this.action + "] canceled."));
                }
                boolean cancel = super.cancel();
                this.updateBusyState(false);
                if (ObjectUtils.equals(this.action, (Object)this.actionUI.getModel().getAction())) {
                    this.actionUI.getModel().clear();
                }
                return cancel;
            }
        }

        protected void updateBusyState(boolean busy) {
            MainUI ui = ((AbstractTuttiAction)this.action).getContext().getMainUI();
            if (busy) {
                if (((AbstractTuttiAction)this.action).isHideBody()) {
                    ui.getBody().setVisible(false);
                }
            } else if (((AbstractTuttiAction)this.action).isHideBody()) {
                ui.getBody().setVisible(true);
            }
        }
    }
}

