/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.measure;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentImpl;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.measure.GearPhysicalMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.Measurement;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.scientificCruise.ScientificCruise;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeatures;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagDao;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.gear.Gear;
import fr.ifremer.adagio.core.dao.referential.gear.GearImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueImpl;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="measurementPersistenceHelper")
public class MeasurementPersistenceHelper
extends AbstractPersistenceService {
    @Resource(name="referentialPersistenceService")
    protected ReferentialPersistenceService referentialService;
    @Resource(name="qualityFlagDao")
    protected QualityFlagDao qualityFlagDao;

    public QuantificationMeasurement setQuantificationMeasurement(Batch batch, Integer pmfmId, Integer recorderDepartmentId, Float weightValue, boolean isReferenceQuantitification) {
        QuantificationMeasurement quantificationMeasurement = this.getQuantificationMeasurement(batch, pmfmId, recorderDepartmentId, true);
        quantificationMeasurement.setNumericalValue(weightValue);
        quantificationMeasurement.setIsReferenceQuantification(Boolean.valueOf(isReferenceQuantitification));
        return quantificationMeasurement;
    }

    public QuantificationMeasurement getQuantificationMeasurement(Batch batch, Integer pmfmId, Integer recorderDepartmentId, boolean createIfNotExists) {
        QuantificationMeasurement quantificationMeasurement = null;
        if (batch.getQuantificationMeasurements() != null) {
            for (QuantificationMeasurement qm : batch.getQuantificationMeasurements()) {
                if (!pmfmId.equals(qm.getPmfm().getId())) continue;
                quantificationMeasurement = qm;
                break;
            }
        }
        if (quantificationMeasurement == null) {
            if (!createIfNotExists) {
                return null;
            }
            quantificationMeasurement = QuantificationMeasurement.Factory.newInstance();
            quantificationMeasurement.setBatch(batch);
            if (batch.getQuantificationMeasurements() == null) {
                batch.setQuantificationMeasurements((Collection)Sets.newHashSet((Object[])new QuantificationMeasurement[]{quantificationMeasurement}));
            } else {
                batch.getQuantificationMeasurements().add(quantificationMeasurement);
            }
            quantificationMeasurement.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
            quantificationMeasurement.setDepartment((Department)this.load(DepartmentImpl.class, recorderDepartmentId));
            quantificationMeasurement.setPmfm((Pmfm)this.load(PmfmImpl.class, pmfmId));
        }
        return quantificationMeasurement;
    }

    public void setMeasurement(Measurement measurement, Caracteristic caracteristic, Serializable value) {
        if (caracteristic.getCaracteristicType() == CaracteristicType.TEXT) {
            measurement.setAlphanumericalValue((String)((Object)value));
        } else if (caracteristic.getCaracteristicType() == CaracteristicType.NUMBER) {
            measurement.setNumericalValue((Float)value);
        } else if (caracteristic.getCaracteristicType() == CaracteristicType.QUALITATIVE) {
            Integer qvId = null;
            qvId = value instanceof CaracteristicQualitativeValue ? Integer.valueOf(((CaracteristicQualitativeValue)value).getId()) : (value instanceof Integer ? (Integer)value : Integer.valueOf(value.toString()));
            QualitativeValue qv = (QualitativeValue)this.load(QualitativeValueImpl.class, qvId);
            measurement.setQualitativeValue(qv);
        }
    }

    public SortingMeasurement setSortingMeasurement(SortingBatch sortingBatch, Integer recorderDepartmentId, SampleCategoryEnum sampleCategory, Serializable value) {
        Preconditions.checkNotNull((Object)((Object)sampleCategory));
        Preconditions.checkNotNull((Object)value);
        Integer pmfmId = this.sampleCategory2PmfmId(sampleCategory);
        Caracteristic caracteristic = this.referentialService.getCaracteristic(pmfmId);
        SortingMeasurement sortingMeasurement = this.getSortingMeasurement(sortingBatch, pmfmId, recorderDepartmentId, true);
        this.setMeasurement((Measurement)sortingMeasurement, caracteristic, value);
        return sortingMeasurement;
    }

    public SortingMeasurement setSortingMeasurement(SortingBatch sortingBatch, Integer recorderDepartmentId, Integer pmfmId, Serializable value) {
        Preconditions.checkNotNull((Object)pmfmId);
        Preconditions.checkNotNull((Object)value);
        Caracteristic caracteristic = this.referentialService.getCaracteristic(pmfmId);
        SortingMeasurement sortingMeasurement = this.getSortingMeasurement(sortingBatch, pmfmId, recorderDepartmentId, true);
        this.setMeasurement((Measurement)sortingMeasurement, caracteristic, value);
        return sortingMeasurement;
    }

    public SortingMeasurement getSortingMeasurement(SortingBatch sortingBatch, Integer pmfmId, Integer recorderDepartmentId, boolean createIfNotExists) {
        SortingMeasurement sortingMeasurement = null;
        if (sortingBatch.getSortingMeasurements() != null) {
            for (SortingMeasurement qm : sortingBatch.getSortingMeasurements()) {
                if (!pmfmId.equals(qm.getPmfm().getId())) continue;
                sortingMeasurement = qm;
                break;
            }
        }
        if (sortingMeasurement == null) {
            if (!createIfNotExists) {
                return null;
            }
            sortingMeasurement = SortingMeasurement.Factory.newInstance();
            sortingMeasurement.setSortingBatch(sortingBatch);
            if (sortingBatch.getSortingMeasurements() == null) {
                sortingBatch.setSortingMeasurements((Collection)Sets.newHashSet((Object[])new SortingMeasurement[]{sortingMeasurement}));
                sortingMeasurement.setRankOrder(Integer.valueOf(1));
            } else {
                sortingBatch.getSortingMeasurements().add(sortingMeasurement);
                sortingMeasurement.setRankOrder(Integer.valueOf(sortingBatch.getSortingMeasurements().size()));
            }
            sortingMeasurement.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
            sortingMeasurement.setDepartment((Department)this.load(DepartmentImpl.class, recorderDepartmentId));
            sortingMeasurement.setPmfm((Pmfm)this.load(PmfmImpl.class, pmfmId));
        }
        return sortingMeasurement;
    }

    public SortingMeasurement getInheritedSortingMeasurement(SortingBatch sortingBatch, Integer pmfmId) {
        if (sortingBatch.getInheritedSortingMeasurements() != null) {
            for (SortingMeasurement qm : sortingBatch.getInheritedSortingMeasurements()) {
                if (!pmfmId.equals(qm.getPmfm().getId())) continue;
                return qm;
            }
        }
        return null;
    }

    public Integer sampleCategory2PmfmId(SampleCategoryEnum sampleCategory) {
        Integer pmfmId = null;
        if (sampleCategory == SampleCategoryEnum.sortedUnsorted) {
            pmfmId = this.enumeration.PMFM_ID_SORTED_UNSORTED;
        } else if (sampleCategory == SampleCategoryEnum.size) {
            pmfmId = this.enumeration.PMFM_ID_SIZE_CATEGORY;
        } else if (sampleCategory == SampleCategoryEnum.maturity) {
            pmfmId = this.enumeration.PMFM_ID_MATURITY;
        } else if (sampleCategory == SampleCategoryEnum.sex) {
            pmfmId = this.enumeration.PMFM_ID_SEX;
        } else if (sampleCategory == SampleCategoryEnum.age) {
            pmfmId = this.enumeration.PMFM_ID_AGE;
        }
        if (pmfmId == null) {
            throw new IllegalArgumentException("Unable to find corresponding PMFM.ID for sampleCategory : " + sampleCategory.name());
        }
        return pmfmId;
    }

    public GearPhysicalFeatures getGearPhysicalfeatures(FishingTrip fishingTrip, Integer gearId) {
        return this.getGearPhysicalfeatures(fishingTrip, gearId, false);
    }

    public GearPhysicalFeatures getGearPhysicalfeatures(FishingTrip fishingTrip, Integer gearId, boolean createIfNotExists) {
        if (fishingTrip.getGearPhysicalFeatures() != null && fishingTrip.getGearPhysicalFeatures().size() >= 0) {
            for (GearPhysicalFeatures guf : fishingTrip.getGearPhysicalFeatures()) {
                if (!gearId.equals(guf.getGear().getId())) continue;
                return guf;
            }
        }
        if (!createIfNotExists) {
            return null;
        }
        GearPhysicalFeatures gearPhysicalFeature = GearPhysicalFeatures.Factory.newInstance();
        gearPhysicalFeature.setFishingTrip(fishingTrip);
        Gear gear = (Gear)this.getCurrentSession().load(GearImpl.class, (Serializable)gearId);
        gearPhysicalFeature.setGear(gear);
        if (fishingTrip.getGearPhysicalFeatures() == null) {
            fishingTrip.setGearPhysicalFeatures((Collection)Lists.newArrayList((Object[])new GearPhysicalFeatures[]{gearPhysicalFeature}));
        } else {
            fishingTrip.getGearPhysicalFeatures().add(gearPhysicalFeature);
        }
        return gearPhysicalFeature;
    }

    public GearPhysicalMeasurement getGearPhysicalMeasurement(GearPhysicalFeatures gearPhysicalFeatures, Integer pmfmId) {
        return this.getGearPhysicalMeasurement(null, gearPhysicalFeatures, pmfmId, false);
    }

    protected GearPhysicalMeasurement getGearPhysicalMeasurement(ScientificCruise scientificCruise, GearPhysicalFeatures gearPhysicalFeatures, Integer pmfmId, boolean createIfNotExists) {
        GearPhysicalMeasurement gearPhysicalMeasurement = null;
        if (gearPhysicalFeatures.getGearPhysicalMeasurements() != null) {
            for (GearPhysicalMeasurement vum : gearPhysicalFeatures.getGearPhysicalMeasurements()) {
                if (!pmfmId.equals(vum.getPmfm().getId())) continue;
                gearPhysicalMeasurement = vum;
                break;
            }
        }
        if (gearPhysicalMeasurement == null) {
            if (!createIfNotExists) {
                return null;
            }
            gearPhysicalMeasurement = GearPhysicalMeasurement.Factory.newInstance();
            gearPhysicalMeasurement.setGearPhysicalFeatures(gearPhysicalFeatures);
            if (gearPhysicalFeatures.getGearPhysicalMeasurements() == null) {
                gearPhysicalFeatures.setGearPhysicalMeasurements((Collection)Lists.newArrayList((Object[])new GearPhysicalMeasurement[]{gearPhysicalMeasurement}));
            } else {
                gearPhysicalFeatures.getGearPhysicalMeasurements().add(gearPhysicalMeasurement);
            }
            gearPhysicalMeasurement.setQualityFlag(this.qualityFlagDao.load(this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED));
            gearPhysicalMeasurement.setDepartment(scientificCruise.getRecorderDepartment());
            Pmfm pmfm = (Pmfm)this.getCurrentSession().load(PmfmImpl.class, (Serializable)pmfmId);
            gearPhysicalMeasurement.setPmfm(pmfm);
        }
        return gearPhysicalMeasurement;
    }

    public void removeGearPhysicalMeasurement(GearPhysicalFeatures gearPhysicalFeatures, Integer pmfmId) {
        GearPhysicalMeasurement gearPhysicalMeasurement = this.getGearPhysicalMeasurement(null, gearPhysicalFeatures, pmfmId, false);
        if (gearPhysicalMeasurement == null) {
            return;
        }
        gearPhysicalFeatures.getGearPhysicalMeasurements().remove(gearPhysicalMeasurement);
    }

    public GearPhysicalMeasurement setGearPhysicalMeasurement(ScientificCruise scientificCruise, GearPhysicalFeatures gearPhysicalFeatures, Integer pmfmId, Float numericalValue, String alphanumericalValue, Integer qualitativevalueId) {
        GearPhysicalMeasurement gearPhysicalMeasurement = this.getGearPhysicalMeasurement(scientificCruise, gearPhysicalFeatures, pmfmId, true);
        if (alphanumericalValue != null) {
            gearPhysicalMeasurement.setAlphanumericalValue(alphanumericalValue);
        } else if (numericalValue != null) {
            gearPhysicalMeasurement.setNumericalValue(numericalValue);
        } else if (qualitativevalueId != null) {
            QualitativeValue qv = (QualitativeValue)this.getCurrentSession().load(QualitativeValueImpl.class, (Serializable)qualitativevalueId);
            gearPhysicalMeasurement.setQualitativeValue(qv);
        }
        return gearPhysicalMeasurement;
    }
}

