/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.FishingOperationAware;
import fr.ifremer.tutti.persistence.entities.data.MacroWasteBatch;
import fr.ifremer.tutti.persistence.entities.data.PlanktonBatch;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.referential.Country;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Zone;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class TuttiPersistenceDevImpl
implements TuttiPersistence {
    private static final Log log = LogFactory.getLog(TuttiPersistenceDevImpl.class);
    public static final List<String> FILE_KEYS = Lists.newArrayList((Object[])new String[]{"fr.ifremer.tutti.persistence.entities.data.Attachment", "fr.ifremer.tutti.persistence.entities.data.AccidentalBatch", "fr.ifremer.tutti.persistence.entities.data.BenthosBatch", "fr.ifremer.tutti.persistence.entities.data.FishingOperation", "fr.ifremer.tutti.persistence.entities.data.MacroWasteBatch", "fr.ifremer.tutti.persistence.entities.data.PlanktonBatch", "fr.ifremer.tutti.persistence.entities.data.Program", "fr.ifremer.tutti.persistence.entities.data.Cruise", "fr.ifremer.tutti.persistence.entities.data.CatchBatch", "fr.ifremer.tutti.persistence.entities.data.SpeciesBatch", "fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency", "fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol", "fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue", "fr.ifremer.tutti.persistence.entities.referential.Country", "fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation#Strata", "fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation#SubStrata", "fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation#Localite", "fr.ifremer.tutti.persistence.entities.referential.Gear#Scientific", "fr.ifremer.tutti.persistence.entities.referential.Gear#Fishing", "fr.ifremer.tutti.persistence.entities.referential.Person", "fr.ifremer.tutti.persistence.entities.referential.Species", "fr.ifremer.tutti.persistence.entities.referential.Vessel#Scientific", "fr.ifremer.tutti.persistence.entities.referential.Vessel#Fishing", "fr.ifremer.tutti.persistence.entities.referential.Zone"});
    public static final String SKIP_FIXTURES_OPTION = "LoadFixtures";
    public static final Function<TuttiProtocol, String> GET_PROTOCOL_NAME;
    protected final ApplicationConfig config;
    protected final ArrayListMultimap<String, IdAware> cache = ArrayListMultimap.create();
    protected final Map<String, Binder<? extends IdAware, ? extends IdAware>> binderCache = Maps.newHashMap();
    protected final File storageDirectory;

    public static File getStorageDirectory(ApplicationConfig config) {
        return new File(config.getOptionAsFile("tutti.data.directory"), "devStorage");
    }

    public TuttiPersistenceDevImpl(ApplicationConfig config) {
        Preconditions.checkNotNull((Object)config, (Object)" No config property setted");
        this.config = config;
        this.storageDirectory = TuttiPersistenceDevImpl.getStorageDirectory(this.config);
    }

    @Override
    public String getImplementationName() {
        return "Persistence Dev implementation";
    }

    @Override
    public void init() {
        try {
            FileUtils.forceMkdir((File)this.storageDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create directory", e);
        }
        this.cache.clear();
        boolean loadFixtures = this.config.getOptionAsBoolean(SKIP_FIXTURES_OPTION);
        if (!loadFixtures) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Load default fixtures...");
            }
            TuttiPersistenceDevFixtures fixtures = new TuttiPersistenceDevFixtures();
            for (String entityType : FILE_KEYS) {
                try {
                    this.loadEntities(entityType, fixtures);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not load entities " + entityType, e);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Close persistence driver " + this.getImplementationName()));
        }
        this.binderCache.clear();
        for (String entityType : this.cache.keySet()) {
            this.persistToFile(entityType);
        }
    }

    @Override
    public List<Species> getAllSpecies() {
        List<Species> result = this.getDataInNewList(Species.class.getName());
        return result;
    }

    @Override
    public List<Species> getAllReferentSpecies() {
        throw new IllegalStateException("method 'getAllReferentSpecies' not implemented");
    }

    @Override
    public List<Species> getAllSpecies(TuttiProtocol protocol) {
        List<Species> result = this.getAllSpecies();
        if (protocol != null && !protocol.isSpeciesEmpty()) {
            Map<String, Species> map = TuttiEntities.splitById(result);
            for (SpeciesProtocol speciesProtocol : protocol.getSpecies()) {
                map.get(speciesProtocol.getSpeciesReferenceTaxonId()).setSurveyCode(speciesProtocol.getSpeciesSurveyCode());
            }
        }
        return result;
    }

    @Override
    public List<Caracteristic> getAllCaracteristic() {
        List<Caracteristic> result = this.getAllCaracteristic(CaracteristicEnum.All);
        return result;
    }

    @Override
    public List<Zone> getAllProgramZone() {
        List<Zone> result = this.getDataInNewList(Zone.class.getName());
        return result;
    }

    @Override
    public List<Country> getAllCountry() {
        List<Country> result = this.getDataInNewList(Country.class.getName());
        return result;
    }

    @Override
    public List<FishingOperationLocation> getAllFishingOperationStrata(String zoneId) {
        List<FishingOperationLocation> result = this.getDataInNewList(TuttiPersistenceDevImpl.getKey(FishingOperationLocation.class, "Strata"));
        return result;
    }

    @Override
    public List<FishingOperationLocation> getAllFishingOperationSubStrata(String zoneId, String strataId) {
        List<FishingOperationLocation> result = this.getDataInNewList(TuttiPersistenceDevImpl.getKey(FishingOperationLocation.class, "SubStrata"));
        return result;
    }

    @Override
    public List<FishingOperationLocation> getAllFishingOperationLocation(String zoneId, String strataId, String subStrataId) {
        List<FishingOperationLocation> result = this.getDataInNewList(TuttiPersistenceDevImpl.getKey(FishingOperationLocation.class, "Localite"));
        return result;
    }

    @Override
    public List<Vessel> getAllScientificVessel() {
        List<Vessel> result = this.getDataInNewList(TuttiPersistenceDevImpl.getKey(Vessel.class, "Scientific"));
        return result;
    }

    @Override
    public List<Vessel> getAllFishingVessel() {
        List<Vessel> result = this.getDataInNewList(TuttiPersistenceDevImpl.getKey(Vessel.class, "Fishing"));
        return result;
    }

    @Override
    public List<Gear> getAllScientificGear() {
        List<Gear> result = this.getDataInNewList(TuttiPersistenceDevImpl.getKey(Gear.class, "Scientific"));
        return result;
    }

    @Override
    public List<Gear> getAllFishingGear() {
        List<Gear> result = this.getDataInNewList(TuttiPersistenceDevImpl.getKey(Gear.class, "Fishing"));
        return result;
    }

    @Override
    public List<Person> getAllPerson() {
        List<Person> result = this.getDataInNewList(Person.class.getName());
        return result;
    }

    @Override
    public Caracteristic getSizeCategoryCaracteristic() {
        return this.getCaracteristic(CaracteristicEnum.SizeCategory);
    }

    @Override
    public Caracteristic getSexCaracteristic() {
        return this.getCaracteristic(CaracteristicEnum.SexCategory);
    }

    @Override
    public Caracteristic getSortedUnsortedCaracteristic() {
        return this.getCaracteristic(CaracteristicEnum.SortedUnsortedCategory);
    }

    @Override
    public Caracteristic getMaturityCaracteristic() {
        return this.getCaracteristic(CaracteristicEnum.MaturityCategory);
    }

    @Override
    public Caracteristic getMacroWasteCategoryCaracteristic() {
        return this.getCaracteristic(CaracteristicEnum.MacroWasteCategory);
    }

    @Override
    public Caracteristic getMacroWasteSizeCategoryCaracteristic() {
        return this.getCaracteristic(CaracteristicEnum.MacroWasteSizeCategory);
    }

    @Override
    public Vessel getVessel(String vesselCode) {
        return (Vessel)this.getBean(Vessel.class.getName(), vesselCode);
    }

    @Override
    public Person getPerson(Integer personId) {
        return (Person)this.getBean(Person.class.getName(), personId.toString());
    }

    @Override
    public Gear getGear(Integer gearCode) {
        return (Gear)this.getBean(Gear.class.getName(), gearCode.toString());
    }

    @Override
    public boolean isSortedQualitativeValue(CaracteristicQualitativeValue value) {
        return value != null && value.getId().equals("311");
    }

    @Override
    public List<Species> importTemporarySpecies(List<Species> species) {
        throw new IllegalStateException("method 'importTemporarySpecies' not implemented");
    }

    @Override
    public List<Vessel> importTemporaryVessel(List<Vessel> vessels) {
        throw new IllegalStateException("method 'importTemporaryVessel' not implemented");
    }

    @Override
    public List<Person> importTemporaryPerson(List<Person> persons) {
        throw new IllegalStateException("method 'importTemporaryPerson' not implemented");
    }

    @Override
    public List<Gear> importTemporaryGear(List<Gear> gears) {
        throw new IllegalStateException("method 'importTemporaryGear' not implemented");
    }

    @Override
    public List<Program> getAllProgram() {
        List<Program> result = this.getDataInNewList(Program.class.getName());
        return result;
    }

    @Override
    public Program getProgram(String id) {
        Program result = (Program)this.getBean(Program.class.getName(), id);
        return result;
    }

    @Override
    public Program createProgram(Program bean) {
        Program result = this.create(Program.class.getName(), bean);
        return result;
    }

    @Override
    public Program saveProgram(Program bean) {
        Program result = this.save(Program.class.getName(), bean);
        return result;
    }

    @Override
    public List<Cruise> getAllCruise(final String programId) {
        List<Cruise> result = this.getFilteredDataList(Cruise.class.getName(), new Predicate<Cruise>(){

            public boolean apply(Cruise input) {
                return programId.equals(input.getProgram().getId());
            }
        });
        return result;
    }

    @Override
    public Cruise getCruise(String id) {
        Cruise result = (Cruise)this.getBean(Cruise.class.getName(), id);
        return result;
    }

    @Override
    public Cruise createCruise(Cruise bean) {
        Cruise result = this.create(Cruise.class.getName(), bean);
        return result;
    }

    @Override
    public Cruise saveCruise(Cruise bean) {
        Cruise result = this.save(Cruise.class.getName(), bean);
        return result;
    }

    @Override
    public List<String> getAllProtocolNames() {
        throw new IllegalStateException("method 'getAllProtocolNames' not implemented");
    }

    @Override
    public List<TuttiProtocol> getAllProtocol() {
        throw new IllegalStateException("method 'getAllProtocol' not implemented");
    }

    @Override
    public boolean isProtocolExist(String id) {
        throw new IllegalStateException("method 'isProtocolExist' not implemented");
    }

    @Override
    public TuttiProtocol getProtocol(String id) {
        throw new IllegalStateException("method 'getProtocol' not implemented");
    }

    @Override
    public TuttiProtocol createProtocol(TuttiProtocol bean) {
        throw new IllegalStateException("method 'createProtocol' not implemented");
    }

    @Override
    public TuttiProtocol saveProtocol(TuttiProtocol bean) {
        throw new IllegalStateException("method 'saveProtocol' not implemented");
    }

    @Override
    public void deleteProtocol(String id) {
        throw new IllegalStateException("method 'deleteProtocol' not implemented");
    }

    @Override
    public List<FishingOperation> getAllFishingOperation(final String cruiseId) {
        List<FishingOperation> result = this.getFilteredDataList(FishingOperation.class.getName(), new Predicate<FishingOperation>(){

            public boolean apply(FishingOperation input) {
                return cruiseId.equals(input.getCruise().getId());
            }
        });
        return result;
    }

    @Override
    public FishingOperation getFishingOperation(String id) {
        List data = this.getData(FishingOperation.class.getName());
        FishingOperation result = (FishingOperation)TuttiEntities.findById(data, id);
        return result;
    }

    @Override
    public FishingOperation createFishingOperation(FishingOperation bean) {
        FishingOperation result = this.create(FishingOperation.class.getName(), bean);
        return result;
    }

    @Override
    public FishingOperation saveFishingOperation(FishingOperation bean) {
        FishingOperation result = this.save(FishingOperation.class.getName(), bean);
        return result;
    }

    @Override
    public CatchBatch getCatchBatchFromFishingOperation(String id) {
        List data = this.getData(CatchBatch.class.getName());
        CatchBatch result = null;
        for (CatchBatch catchBatch : data) {
            if (!id.equals(catchBatch.getFishingOperation().getId())) continue;
            result = catchBatch;
            break;
        }
        return result;
    }

    @Override
    public CatchBatch createCatchBatch(CatchBatch bean) {
        CatchBatch result = this.create(CatchBatch.class.getName(), bean);
        return result;
    }

    @Override
    public CatchBatch saveCatchBatch(CatchBatch bean) {
        CatchBatch result = this.save(CatchBatch.class.getName(), bean);
        return result;
    }

    @Override
    public List<SpeciesBatch> getAllRootSpeciesBatch(String fishingOperationId) {
        List<SpeciesBatch> result = this.getAllTraitFilterBatches(SpeciesBatch.class.getName(), fishingOperationId, new Predicate<SpeciesBatch>(){

            public boolean apply(SpeciesBatch input) {
                return input.getParentBatch() == null;
            }
        });
        return result;
    }

    private SpeciesBatch getSpeciesBatch(String id) {
        SpeciesBatch result = (SpeciesBatch)this.getBean(SpeciesBatch.class.getName(), id);
        return result;
    }

    @Override
    public SpeciesBatch createSpeciesBatch(SpeciesBatch bean, String parentBatchId) {
        boolean withParent = parentBatchId != null;
        SpeciesBatch result = this.create(SpeciesBatch.class.getName(), bean, !withParent);
        if (withParent) {
            SpeciesBatch parentBatch = this.getSpeciesBatch(parentBatchId);
            result.setParentBatch(parentBatch);
            ArrayList childBatchs = parentBatch.getChildBatchs();
            if (childBatchs == null) {
                childBatchs = Lists.newArrayList();
                parentBatch.setChildBatchs(childBatchs);
            }
            childBatchs.add(result);
            this.persistToFile(SpeciesBatch.class.getName());
        }
        return result;
    }

    @Override
    public SpeciesBatch saveSpeciesBatch(SpeciesBatch bean) {
        SpeciesBatch result = this.save(SpeciesBatch.class.getName(), bean);
        return result;
    }

    @Override
    public void deleteSpeciesBatch(String id) {
        this.remove(SpeciesBatch.class.getName(), id);
    }

    @Override
    public void deleteSpeciesSubBatch(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"Can't save a bean with null id");
        SpeciesBatch bean = (SpeciesBatch)this.getBean(SpeciesBatch.class.getName(), id);
        Preconditions.checkNotNull((Object)bean, (Object)("SpeciesBatch with id: " + id + " does not exist"));
        HashSet collected = Sets.newHashSet();
        this.collectChilds(bean, collected);
        for (SpeciesBatch toDelete : collected) {
            this.cache.remove(SpeciesBatch.class, (Object)toDelete);
        }
        bean.setChildBatchs(null);
        this.persistToFile(SpeciesBatch.class.getName());
    }

    @Override
    public void changeSpeciesBatchSpecies(String batchId, Species species) {
        throw new IllegalStateException("method 'changeSpeciesBatchSpecies' not implemented");
    }

    protected void collectChilds(SpeciesBatch bean, Set<SpeciesBatch> collected) {
        if (!bean.isChildBatchsEmpty()) {
            for (SpeciesBatch batch : bean.getChildBatchs()) {
                collected.add(batch);
                this.collectChilds(batch, collected);
            }
        }
    }

    @Override
    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(final String speciesBatchId) {
        List<SpeciesBatchFrequency> result = this.getFilteredDataList(SpeciesBatchFrequency.class.getName(), new Predicate<SpeciesBatchFrequency>(){

            public boolean apply(SpeciesBatchFrequency input) {
                return speciesBatchId.equals(input.getBatch().getId());
            }
        });
        return result;
    }

    @Override
    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(String speciesBatchId, List<SpeciesBatchFrequency> frequencies) {
        List<SpeciesBatchFrequency> existingData = this.getAllSpeciesBatchFrequency(speciesBatchId);
        List<SpeciesBatchFrequency> result = this.persistList(SpeciesBatchFrequency.class.getName(), existingData, frequencies);
        return result;
    }

    @Override
    public List<BenthosBatch> getAllBenthosBatch(String fishingOperationId) {
        List<BenthosBatch> result = this.getAllTraitFilterBatches(BenthosBatch.class.getName(), fishingOperationId, null);
        return result;
    }

    @Override
    public BenthosBatch getBenthosBatch(String id) {
        BenthosBatch result = (BenthosBatch)this.getBean(BenthosBatch.class.getName(), id);
        return result;
    }

    @Override
    public BenthosBatch createBenthosBatch(BenthosBatch bean) {
        BenthosBatch result = this.create(BenthosBatch.class.getName(), bean);
        return result;
    }

    @Override
    public BenthosBatch saveBenthosBatch(BenthosBatch bean) {
        BenthosBatch result = this.save(BenthosBatch.class.getName(), bean);
        return result;
    }

    @Override
    public void deleteBenthosBatch(String id) {
        this.remove(BenthosBatch.class.getName(), id);
    }

    @Override
    public List<PlanktonBatch> getAllPlanktonBatch(String fishingOperationId) {
        List<PlanktonBatch> result = this.getAllTraitFilterBatches(PlanktonBatch.class.getName(), fishingOperationId, null);
        return result;
    }

    @Override
    public PlanktonBatch getPlanktonBatch(String id) {
        PlanktonBatch result = (PlanktonBatch)this.getBean(PlanktonBatch.class.getName(), id);
        return result;
    }

    @Override
    public PlanktonBatch createPlanktonBatch(PlanktonBatch bean) {
        PlanktonBatch result = this.create(PlanktonBatch.class.getName(), bean);
        return result;
    }

    @Override
    public PlanktonBatch savePlanktonBatch(PlanktonBatch bean) {
        PlanktonBatch result = this.save(PlanktonBatch.class.getName(), bean);
        return result;
    }

    @Override
    public void deletePlanktonBatch(String id) {
        this.remove(PlanktonBatch.class.getName(), id);
    }

    @Override
    public List<MacroWasteBatch> getAllMacroWasteBatch(String fishingOperationId) {
        List<MacroWasteBatch> result = this.getAllTraitFilterBatches(MacroWasteBatch.class.getName(), fishingOperationId, null);
        return result;
    }

    @Override
    public MacroWasteBatch getMacroWasteBatch(String id) {
        MacroWasteBatch result = (MacroWasteBatch)this.getBean(MacroWasteBatch.class.getName(), id);
        return result;
    }

    @Override
    public MacroWasteBatch createMacroWasteBatch(MacroWasteBatch bean) {
        MacroWasteBatch result = this.create(MacroWasteBatch.class.getName(), bean);
        return result;
    }

    @Override
    public MacroWasteBatch saveMacroWasteBatch(MacroWasteBatch bean) {
        MacroWasteBatch result = this.save(MacroWasteBatch.class.getName(), bean);
        return result;
    }

    @Override
    public void deleteMacroWasteBatch(String id) {
        this.remove(MacroWasteBatch.class.getName(), id);
    }

    @Override
    public List<AccidentalBatch> getAllAccidentalBatch(String fishingOperationId) {
        List<AccidentalBatch> result = this.getAllTraitFilterBatches(AccidentalBatch.class.getName(), fishingOperationId, null);
        return result;
    }

    @Override
    public AccidentalBatch getAccidentalBatch(String id) {
        AccidentalBatch result = (AccidentalBatch)this.getBean(AccidentalBatch.class.getName(), id);
        return result;
    }

    @Override
    public AccidentalBatch createAccidentalBatch(AccidentalBatch bean) {
        AccidentalBatch result = this.create(AccidentalBatch.class.getName(), bean);
        return result;
    }

    @Override
    public AccidentalBatch saveAccidentalBatch(AccidentalBatch bean) {
        AccidentalBatch result = this.save(AccidentalBatch.class.getName(), bean);
        return result;
    }

    @Override
    public void deleteAccidentalBatch(String id) {
        this.remove(AccidentalBatch.class.getName(), id);
    }

    protected <B> Class<B> getType(String type) {
        String typeName = type;
        int i = type.indexOf(35);
        if (i > -1) {
            typeName = type.substring(0, i);
        }
        try {
            Class<?> result = Class.forName(typeName);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("No class named " + typeName, e);
        }
    }

    protected <B extends IdAware> Binder<B, B> getBinder(String type) {
        Binder result = this.binderCache.get(type);
        if (result == null) {
            Class<B> binderType = this.getType(type);
            result = BinderFactory.newBinder(binderType);
            this.binderCache.put(type, (Binder<? extends IdAware, ? extends IdAware>)result);
        }
        return result;
    }

    protected <B extends IdAware> void persist(String beanType, B source, B target, boolean synchFile) {
        this.getBinder(beanType).copyExcluding(source, target, new String[]{"id"});
        if (source.getId() == null) {
            target.setId(UUID.randomUUID().toString());
        }
        if (!this.cache.containsEntry((Object)beanType, target)) {
            this.cache.put((Object)beanType, target);
        }
        if (synchFile) {
            this.persistToFile(beanType);
        }
    }

    protected <B extends IdAware> List<B> persistList(String beanType, List<B> existingData, List<B> newData) {
        HashMap toPersist = Maps.newHashMap();
        TuttiEntities.fillEntries(toPersist, existingData, TuttiEntities.newConstantFunction(null));
        Map<String, B> existingById = TuttiEntities.splitById(existingData);
        for (IdAware source : newData) {
            IdAware target;
            if (TuttiEntities.isNew(source)) {
                Class<B> type = this.getType(beanType);
                target = TuttiEntities.newEntity(type);
            } else {
                target = (IdAware)existingById.get(source.getId());
            }
            toPersist.put(target, source);
        }
        ArrayList result = Lists.newArrayList();
        for (Map.Entry entry : toPersist.entrySet()) {
            IdAware source = (IdAware)entry.getValue();
            IdAware target = (IdAware)entry.getKey();
            if (source == null) {
                this.cache.remove((Object)beanType, (Object)target);
                continue;
            }
            this.persist(beanType, source, target, false);
            result.add(target);
        }
        this.persistToFile(beanType);
        return result;
    }

    protected <B extends IdAware> List<B> loadEntities(String entityType, TuttiPersistenceDevFixtures fix) throws IOException {
        List result;
        File storageFile = this.getStorageFile(entityType);
        if (storageFile.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Load data from file: " + storageFile));
            }
            ObjectInputStream oos = new ObjectInputStream(new FileInputStream(storageFile));
            try {
                result = (List)oos.readObject();
                oos.close();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not find a class ", e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)oos);
            }
            this.cache.putAll((Object)entityType, (Iterable)result);
        } else {
            result = fix.getData(entityType);
            this.cache.putAll((Object)entityType, result);
            this.persistToFile(entityType);
        }
        return result;
    }

    public static String getKey(Class<?> type, String context) {
        String key = type.getName();
        if (context != null) {
            key = key + '#' + context;
        }
        return key;
    }

    protected <B extends IdAware> List<B> loadEntities(String entityType, List<B> defaultList) throws IOException {
        List result;
        File storageFile = this.getStorageFile(entityType);
        if (storageFile.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Load data from file: " + storageFile));
            }
            ObjectInputStream oos = new ObjectInputStream(new FileInputStream(storageFile));
            try {
                result = (List)oos.readObject();
                oos.close();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not find a class ", e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)oos);
            }
        } else {
            result = defaultList;
            this.persistToFile(entityType);
        }
        this.cache.putAll((Object)entityType, result);
        return result;
    }

    protected <B> File getStorageFile(String entityType) {
        File result = new File(this.storageDirectory, entityType + ".ser");
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <B extends IdAware> void persistToFile(String entityType) {
        List<B> entities = this.getDataInNewList(entityType);
        File storageFile = this.getStorageFile(entityType);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Persist storage to file: " + storageFile));
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(storageFile));
            oos.writeObject(entities);
            oos.close();
            if (oos == null) return;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Could not persist to file: " + storageFile, e);
            }
            catch (Throwable throwable) {
                if (oos == null) throw throwable;
                IOUtils.closeQuietly(oos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)oos);
        return;
    }

    protected <B extends IdAware> List<B> getData(String entityType) {
        List result = this.cache.get((Object)entityType);
        return result;
    }

    protected <B extends IdAware> List<B> getDataInNewList(String entityType) {
        List<B> result = this.getData(entityType);
        return Lists.newArrayList(result);
    }

    protected <B extends IdAware, E> List<E> getTransformedDataList(String entityType, Function<B, E> function) {
        List<B> result = this.getData(entityType);
        return Lists.newArrayList((Iterable)Iterables.transform(result, function));
    }

    protected <B extends IdAware> List<B> getFilteredDataList(String entityType, Predicate<B> predicate) {
        List<B> result = this.getData(entityType);
        return Lists.newArrayList((Iterable)Iterables.filter(result, predicate));
    }

    protected <B extends FishingOperationAware> List<B> getAllTraitFilterBatches(String beanType, String traitId, Predicate<B> extraPredicate) {
        Predicate predicate = TuttiEntities.newTraitIdPredicate(traitId);
        if (extraPredicate != null) {
            predicate = Predicates.and(predicate, extraPredicate);
        }
        List<B> result = this.getFilteredDataList(beanType, predicate);
        return result;
    }

    protected <B extends IdAware> B create(String type, B bean) {
        return this.create(type, bean, true);
    }

    public <B extends IdAware> B create(String type, B bean, boolean sychronize) {
        Preconditions.checkNotNull(bean, (Object)"Can't persist a null bean");
        B result = TuttiEntities.newEntity(bean);
        this.persist(type, bean, result, sychronize);
        return result;
    }

    protected <B extends IdAware> B save(String type, B bean) {
        Preconditions.checkNotNull(bean, (Object)"Can't persist a null bean");
        String id = bean.getId();
        Preconditions.checkNotNull((Object)id, (Object)"Can't save a bean with null id");
        B result = this.getBean(type, id);
        Preconditions.checkNotNull(result, (Object)("Can't save a not persisted bean with id: " + id));
        this.persist(type, bean, result, true);
        return result;
    }

    protected <B extends IdAware> void remove(String type, String id) {
        Preconditions.checkNotNull((Object)id, (Object)"Can't delete a null id");
        B bean = this.getBean(type, id);
        if (bean == null && log.isWarnEnabled()) {
            log.warn((Object)("No bean with id: " + id));
        }
        this.cache.remove((Object)type, bean);
        this.persistToFile(type);
    }

    protected <B extends IdAware> B getBean(String type, String id) {
        List<B> data = this.getData(type);
        B result = TuttiEntities.findById(data, id);
        return result;
    }

    protected List<Caracteristic> getAllCaracteristic(CaracteristicEnum categoryId) {
        List<Caracteristic> result = this.getDataInNewList(TuttiPersistenceDevImpl.getKey(Caracteristic.class, categoryId.name()));
        return result;
    }

    protected Caracteristic getCaracteristic(CaracteristicEnum categoryId) {
        List data = this.getData(TuttiPersistenceDevImpl.getKey(Caracteristic.class, categoryId.name()));
        Caracteristic result = (Caracteristic)data.get(0);
        return result;
    }

    static {
        for (CaracteristicEnum caracteristicEnum : CaracteristicEnum.values()) {
            FILE_KEYS.add(TuttiPersistenceDevImpl.getKey(Caracteristic.class, caracteristicEnum.name()));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Found " + FILE_KEYS.size() + " files."));
        }
        GET_PROTOCOL_NAME = new Function<TuttiProtocol, String>(){

            public String apply(TuttiProtocol input) {
                return input.getName();
            }
        };
    }

    public static class TuttiPersistenceDevFixtures {
        protected final ArrayListMultimap<String, IdAware> cache = ArrayListMultimap.create();

        protected void putInCache(Class<?> type, IdAware b) {
            this.putInCache(type, null, b);
        }

        protected void putInCache(Class<?> type, String context, IdAware b) {
            String key = TuttiPersistenceDevImpl.getKey(type, context);
            this.cache.put((Object)key, (Object)b);
        }

        public TuttiPersistenceDevFixtures() {
            Zone z = new Zone();
            z.setId(UUID.randomUUID().toString());
            z.setName("zone1");
            this.putInCache(Zone.class, z);
            FishingOperationLocation l = new FishingOperationLocation();
            l.setId(UUID.randomUUID().toString());
            l.setName("zone1 - strata1");
            l.setZone(z);
            this.putInCache(FishingOperationLocation.class, "Strata", l);
            FishingOperationLocation sl = new FishingOperationLocation();
            sl.setId(UUID.randomUUID().toString());
            sl.setName("strat1 - substrata1");
            sl.setParent(l);
            this.putInCache(FishingOperationLocation.class, "SubStrata", sl);
            FishingOperationLocation ssl = new FishingOperationLocation();
            ssl.setId(UUID.randomUUID().toString());
            ssl.setName("substrata1 - localite1");
            ssl.setLocalite(true);
            ssl.setParent(sl);
            this.putInCache(FishingOperationLocation.class, "Localite", ssl);
            ssl = new FishingOperationLocation();
            ssl.setId(UUID.randomUUID().toString());
            ssl.setName("substrata1 - localite2");
            ssl.setLocalite(true);
            ssl.setParent(sl);
            this.putInCache(FishingOperationLocation.class, "Localite", ssl);
            sl = new FishingOperationLocation();
            sl.setId(UUID.randomUUID().toString());
            sl.setName("strat1 - substrata2");
            sl.setParent(l);
            this.putInCache(FishingOperationLocation.class, "SubStrata", sl);
            ssl = new FishingOperationLocation();
            ssl.setId(UUID.randomUUID().toString());
            ssl.setName("substrata2 - localite1");
            ssl.setLocalite(true);
            ssl.setParent(sl);
            this.putInCache(FishingOperationLocation.class, "Localite", ssl);
            ssl = new FishingOperationLocation();
            ssl.setId(UUID.randomUUID().toString());
            ssl.setName("substrata2 - localite2");
            ssl.setLocalite(true);
            ssl.setParent(sl);
            this.putInCache(FishingOperationLocation.class, "Localite", ssl);
            l = new FishingOperationLocation();
            l.setId(UUID.randomUUID().toString());
            l.setName("zone1 - strata2");
            l.setZone(z);
            this.putInCache(FishingOperationLocation.class, "Strata", l);
            ssl = new FishingOperationLocation();
            ssl.setId(UUID.randomUUID().toString());
            ssl.setName("strata2 - localite1");
            ssl.setParent(l);
            ssl.setLocalite(true);
            this.putInCache(FishingOperationLocation.class, "Localite", ssl);
            ssl = new FishingOperationLocation();
            ssl.setId(UUID.randomUUID().toString());
            ssl.setName("strata2 - localite2");
            ssl.setParent(l);
            ssl.setLocalite(true);
            this.putInCache(FishingOperationLocation.class, "Localite", ssl);
            z = new Zone();
            z.setId(UUID.randomUUID().toString());
            z.setName("zone2");
            this.putInCache(Zone.class, z);
            l = new FishingOperationLocation();
            l.setId(UUID.randomUUID().toString());
            l.setName("zone2 - strata1");
            l.setZone(z);
            this.putInCache(FishingOperationLocation.class, "Strata", l);
            l = new FishingOperationLocation();
            l.setId(UUID.randomUUID().toString());
            l.setName("zone2 - strata2");
            l.setZone(z);
            this.putInCache(FishingOperationLocation.class, "Strata", l);
            Country c = new Country();
            c.setId(UUID.randomUUID().toString());
            c.setName("France");
            this.putInCache(Country.class, c);
            c = new Country();
            c.setId(UUID.randomUUID().toString());
            c.setName("Espagne");
            this.putInCache(Country.class, c);
            Vessel v = new Vessel();
            v.setId(UUID.randomUUID().toString());
            v.setName("THALASSA");
            v.setScientificVessel(true);
            v.setRegistrationCode("RegistrationCode1");
            this.putInCache(Vessel.class, "Scientific", v);
            v = new Vessel();
            v.setId(UUID.randomUUID().toString());
            v.setName("THALASSA-II");
            v.setScientificVessel(true);
            v.setRegistrationCode("RegistrationCode2");
            this.putInCache(Vessel.class, "Scientific", v);
            v = new Vessel();
            v.setId(UUID.randomUUID().toString());
            v.setName("Fishing1");
            v.setScientificVessel(false);
            v.setRegistrationCode("RegistrationCode1");
            this.putInCache(Vessel.class, "Fishing", v);
            v = new Vessel();
            v.setId(UUID.randomUUID().toString());
            v.setName("Fishing2");
            v.setScientificVessel(false);
            v.setRegistrationCode("RegistrationCode1");
            this.putInCache(Vessel.class, "Fishing", v);
            Gear g = new Gear();
            g.setId(UUID.randomUUID().toString());
            g.setName("Gear-Scientific-1");
            this.putInCache(Gear.class, "Scientific", g);
            g = new Gear();
            g.setId(UUID.randomUUID().toString());
            g.setName("Gear-Scientific-2");
            this.putInCache(Gear.class, "Scientific", g);
            g = new Gear();
            g.setId(UUID.randomUUID().toString());
            g.setName("Gear-Fishing-1");
            this.putInCache(Gear.class, "Fishing", g);
            g = new Gear();
            g.setId(UUID.randomUUID().toString());
            g.setName("Gear-Fishing-2");
            this.putInCache(Gear.class, "Fishing", g);
            Person u = new Person();
            u.setId(UUID.randomUUID().toString());
            u.setName("Vincent Badts");
            u.setFirstName("Vincent");
            u.setLastName("Badts");
            this.putInCache(Person.class, u);
            u = new Person();
            u.setId(UUID.randomUUID().toString());
            u.setName("Jean claude Mahet");
            u.setFirstName("Jean claude");
            u.setLastName("Mahet");
            this.putInCache(Person.class, u);
            u = new Person();
            u.setId(UUID.randomUUID().toString());
            u.setName("Luisa Metral");
            u.setFirstName("Luisa");
            u.setLastName("Metral");
            this.putInCache(Person.class, u);
            u = new Person();
            u.setId(UUID.randomUUID().toString());
            u.setName("Jean Herv\u00e9 Bourdeix");
            u.setFirstName("Jean Herv\u00e9");
            u.setLastName("Bourdeix");
            this.putInCache(Person.class, u);
            u = new Person();
            u.setId(UUID.randomUUID().toString());
            u.setName("Ysabelle Cheret");
            u.setFirstName("Ysabelle");
            u.setLastName("Cheret");
            this.putInCache(Person.class, u);
            u = new Person();
            u.setId(UUID.randomUUID().toString());
            u.setName("Blandine Brisset");
            u.setFirstName("Blandine");
            u.setLastName("Brisset");
            this.putInCache(Person.class, u);
            Species sp = new Species();
            sp.setId(UUID.randomUUID().toString());
            sp.setRefTaxCode("BAR");
            sp.setName("Bar");
            this.putInCache(Species.class, sp);
            sp = new Species();
            sp.setId(UUID.randomUUID().toString());
            sp.setRefTaxCode("CHIN");
            sp.setName("Chinchard");
            this.putInCache(Species.class, sp);
            sp = new Species();
            sp.setId(UUID.randomUUID().toString());
            sp.setRefTaxCode("FLE");
            sp.setName("Flet");
            this.putInCache(Species.class, sp);
            sp = new Species();
            sp.setId(UUID.randomUUID().toString());
            sp.setRefTaxCode("LIM");
            sp.setName("Limande");
            this.putInCache(Species.class, sp);
            Caracteristic ca = this.createQualitativeCaracteristic("MacroWaste", CaracteristicEnum.MacroWasteCategory.name());
            this.createCaracteristicQualitativeValue(ca, "Bottle");
            this.createCaracteristicQualitativeValue(ca, "Sheet");
            this.createCaracteristicQualitativeValue(ca, "Bag");
            this.createCaracteristicQualitativeValue(ca, "Caps/ lids");
            this.createCaracteristicQualitativeValue(ca, "Fishing line (monofilament)");
            this.createCaracteristicQualitativeValue(ca, "Fishing line (entangled)");
            this.createCaracteristicQualitativeValue(ca, "Synthetic rope");
            this.createCaracteristicQualitativeValue(ca, "Cable ties");
            this.createCaracteristicQualitativeValue(ca, "Strapping band");
            this.createCaracteristicQualitativeValue(ca, "Crates abd containers");
            this.createCaracteristicQualitativeValue(ca, "Boots");
            this.createCaracteristicQualitativeValue(ca, "Balloons");
            this.createCaracteristicQualitativeValue(ca, "bobbins (fishing)");
            this.createCaracteristicQualitativeValue(ca, "tyre");
            this.createCaracteristicQualitativeValue(ca, "glove");
            this.createCaracteristicQualitativeValue(ca, "diapers");
            this.createCaracteristicQualitativeValue(ca, "cotton buds");
            this.createCaracteristicQualitativeValue(ca, "cigarette butts");
            this.createCaracteristicQualitativeValue(ca, "condoms");
            this.createCaracteristicQualitativeValue(ca, "syringes");
            this.createCaracteristicQualitativeValue(ca, "sanitary towels / tampon");
            this.createCaracteristicQualitativeValue(ca, "jar");
            this.createCaracteristicQualitativeValue(ca, "piece");
            ca = this.createQualitativeCaracteristic("MacroWaste Size category", CaracteristicEnum.MacroWasteSizeCategory.name());
            this.createCaracteristicQualitativeValue(ca, "<5*5cm = 25cm\u00b2");
            this.createCaracteristicQualitativeValue(ca, "<10*10cm = 100cm\u00b2");
            this.createCaracteristicQualitativeValue(ca, "<20*20cm = 400cm\u00b2");
            this.createCaracteristicQualitativeValue(ca, "<50*50cm = 2500cm\u00b2");
            this.createCaracteristicQualitativeValue(ca, "<100*100cm = 1m\u00b2");
            this.createCaracteristicQualitativeValue(ca, ">100*100cm = 1m\u00b2");
            ca = this.createQualitativeCaracteristic("Sorted / Unsorted Category", CaracteristicEnum.SortedUnsortedCategory.name());
            this.createCaracteristicQualitativeValue(ca, "Vrac");
            this.createCaracteristicQualitativeValue(ca, "Hors Vrac");
            ca = this.createQualitativeCaracteristic("Species Sex Category", CaracteristicEnum.SexCategory.name());
            this.createCaracteristicQualitativeValue(ca, "Male");
            this.createCaracteristicQualitativeValue(ca, "Femelle");
            this.createCaracteristicQualitativeValue(ca, "Ind\u00e9termin\u00e9");
            ca = this.createQualitativeCaracteristic("Species Maturity Category", CaracteristicEnum.MaturityCategory.name());
            this.createCaracteristicQualitativeValue(ca, "0");
            this.createCaracteristicQualitativeValue(ca, "1");
            this.createCaracteristicQualitativeValue(ca, "2");
            ca = this.createQualitativeCaracteristic("Species Size Category", CaracteristicEnum.SizeCategory.name());
            this.createCaracteristicQualitativeValue(ca, "Petit");
            this.createCaracteristicQualitativeValue(ca, "Gros");
        }

        protected void createCaracteristicQualitativeValue(Caracteristic ca, String name) {
            CaracteristicQualitativeValue cqv = new CaracteristicQualitativeValue();
            cqv.setId(UUID.randomUUID().toString());
            cqv.setName(name);
            ca.addQualitativeValue(cqv);
            this.putInCache(CaracteristicQualitativeValue.class, name, cqv);
        }

        protected Caracteristic createQualitativeCaracteristic(String name, String category) {
            Caracteristic ca = new Caracteristic();
            ca.setId(UUID.randomUUID().toString());
            ca.setName(name);
            ca.setCategory(category);
            ca.setCaracteristicType(CaracteristicType.QUALITATIVE);
            ca.setQualitativeValue(Lists.newArrayList());
            this.putInCache(Caracteristic.class, category, ca);
            return ca;
        }

        protected Caracteristic createNumberCaracteristic(String name, String category) {
            Caracteristic ca = new Caracteristic();
            ca.setId(UUID.randomUUID().toString());
            ca.setName(name);
            ca.setCategory(category);
            ca.setCaracteristicType(CaracteristicType.NUMBER);
            this.putInCache(Caracteristic.class, category, ca);
            return ca;
        }

        public <B extends IdAware> List<B> getData(String entityType) {
            List result = this.cache.get((Object)entityType);
            return result;
        }
    }

    public static enum CaracteristicEnum {
        All,
        SizeCategory,
        SexCategory,
        SortedUnsortedCategory,
        MaturityCategory,
        MacroWasteCategory,
        MacroWasteSizeCategory;

    }
}

