/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.TuttiTechnicalException;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiColorHighlighter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;

public final class TuttiUIUtil {
    private static final Log log = LogFactory.getLog(TuttiUIUtil.class);
    private static final JAXXContextEntryDef<Program> PROGRAM_ENTRY = JAXXUtil.newContextEntryDef((String)"loadedProgram", Program.class);
    private static final JAXXContextEntryDef<Cruise> CRUISE_ENTRY = JAXXUtil.newContextEntryDef((String)"loadedCruise", Cruise.class);
    private static final JAXXContextEntryDef<TuttiProtocol> PROTOCOL_ENTRY = JAXXUtil.newContextEntryDef((String)"loadedProtocol", TuttiProtocol.class);

    private TuttiUIUtil() {
    }

    public static Program getProgram(TuttiUIContext context) {
        return (Program)PROGRAM_ENTRY.getContextValue((JAXXContext)context.getMainUI());
    }

    public static Cruise getCruise(TuttiUIContext context) {
        return (Cruise)CRUISE_ENTRY.getContextValue((JAXXContext)context.getMainUI());
    }

    public static TuttiProtocol getProtocol(TuttiUIContext context) {
        return (TuttiProtocol)PROTOCOL_ENTRY.getContextValue((JAXXContext)context.getMainUI());
    }

    public static void setProgram(TuttiUIContext context, Program value) {
        if (value == null) {
            PROGRAM_ENTRY.removeContextValue((JAXXContext)context.getMainUI());
        } else {
            PROGRAM_ENTRY.setContextValue((JAXXContext)context.getMainUI(), (Object)value);
        }
    }

    public static void setCruise(TuttiUIContext context, Cruise value) {
        if (value == null) {
            CRUISE_ENTRY.removeContextValue((JAXXContext)context.getMainUI());
        } else {
            CRUISE_ENTRY.setContextValue((JAXXContext)context.getMainUI(), (Object)value);
        }
    }

    public static void setProtocol(TuttiUIContext context, TuttiProtocol value) {
        if (value == null) {
            PROTOCOL_ENTRY.removeContextValue((JAXXContext)context.getMainUI());
        } else {
            PROTOCOL_ENTRY.setContextValue((JAXXContext)context.getMainUI(), (Object)value);
        }
    }

    public static File chooseFile(Component parent, String title, String buttonLabel, File incoming, String ... filters) {
        File basedir;
        File oldBasedir = FileUtil.getCurrentDirectory();
        if (incoming != null && (basedir = incoming.isFile() ? incoming.getParentFile() : incoming).exists()) {
            FileUtil.setCurrentDirectory((File)basedir);
        }
        File file = FileUtil.getFile((String)title, (String)buttonLabel, (Component)parent, (String[])filters);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        FileUtil.setCurrentDirectory((File)oldBasedir);
        File result = file == null ? incoming : file;
        return result;
    }

    public static File chooseDirectory(Component parent, String title, String buttonLabel, File incoming) {
        File basedir;
        File oldBasedir = FileUtil.getCurrentDirectory();
        if (incoming != null && (basedir = incoming.isFile() ? incoming.getParentFile() : incoming).exists()) {
            FileUtil.setCurrentDirectory((File)basedir);
        }
        String file = FileUtil.getDirectory((Component)parent, (String)title, (String)buttonLabel);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        FileUtil.setCurrentDirectory((File)oldBasedir);
        return file == null ? incoming : new File(file);
    }

    public static void updateBusyState(Component ui, boolean busy) {
        if (busy) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"block ui in busy mode");
            }
            ui.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"unblock ui in none busy mode");
            }
            ui.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static void showSuccessMessage(Component ui, String message) {
        JOptionPane.showMessageDialog(ui, message, "Success", 1, UIManager.getIcon("info"));
    }

    public static void showErrorMessage(Component ui, String message) {
        JOptionPane.showMessageDialog(ui, message, "Error", 0, UIManager.getIcon("error"));
    }

    public static boolean askQuestion(Component ui, String message) {
        int i = JOptionPane.showConfirmDialog(ui, message, "Question?", 0);
        return i == 0;
    }

    public static void setProperty(Object bean, String property, Object value) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)property);
        try {
            PropertyUtils.setSimpleProperty((Object)bean, (String)property, (Object)value);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not set property '" + property + "' on object of type '" + bean.getClass().getName() + "'", (Throwable)e);
        }
    }

    public static Object getProperty(Object bean, String property) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)property);
        try {
            return PropertyUtils.getSimpleProperty((Object)bean, (String)property);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not get property '" + property + "' on object of type '" + bean.getClass().getName() + "'", (Throwable)e);
        }
    }

    public static Highlighter newBackgroundColorHighlighter(HighlightPredicate predicate, Color color) {
        return new TuttiColorHighlighter(predicate, color, false);
    }

    public static Highlighter newForegroundColorHighlighter(HighlightPredicate predicate, Color color) {
        return new TuttiColorHighlighter(predicate, color, true);
    }

    public static String getDuration(Date startDate, Date endDate) {
        String duration = "";
        if (startDate != null && endDate != null) {
            duration = DurationFormatUtils.formatPeriod((long)startDate.getTime(), (long)endDate.getTime(), (String)I18n._((String)"tutti.duration.format", (Object[])new Object[0]));
        }
        return duration;
    }

    public static int computeDistanceInMeters(Float startLatitude, Float startLongitude, Float endLatitude, Float endLongitude) {
        double sLat = (double)startLatitude.floatValue() * Math.PI / 180.0;
        double sLong = (double)startLongitude.floatValue() * Math.PI / 180.0;
        double eLat = (double)endLatitude.floatValue() * Math.PI / 180.0;
        double eLong = (double)endLongitude.floatValue() * Math.PI / 180.0;
        Double d = 6378288.0 * (1.5707963267948966 - Math.asin(Math.sin(eLat) * Math.sin(sLat) + Math.cos(eLong - sLong) * Math.cos(eLat) * Math.cos(sLat)));
        return d.intValue();
    }
}

