/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportProtocolSpeciesAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ExportProtocolSpeciesAction.class);
    private File file;

    public ExportProtocolSpeciesAction(EditProtocolUIHandler handler) {
        super(handler, "exportProtocolSpecies", "export", I18n._((String)"tutti.action.exportProtocolSpecies", (Object[])new Object[0]), I18n._((String)"tutti.action.exportProtocolSpecies.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {
        boolean doAction;
        this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.title.choose.protocolSpeciesExportFile", (Object[])new Object[0]), I18n._((String)"tutti.action.chooseProtocolSpeciesFile", (Object[])new Object[0]), null, "^.*\\.csv", I18n._((String)"tutti.file.csv", (Object[])new Object[0]));
        boolean bl = doAction = this.file != null;
        if (doAction) {
            super.prepareAction(event);
        }
        return doAction;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        super.releaseAction(event);
        this.file = null;
    }

    @Override
    protected void doAction(ActionEvent e) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export protocol species to file: " + this.file));
        }
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        ArrayList protocols = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : model.getRows()) {
            if (!row.isValid()) continue;
            protocols.add(row.toBean());
        }
        TuttiProtocolImportExportService service = this.getService(TuttiProtocolImportExportService.class);
        service.exportProtocolSpecies(this.file, (List)protocols, model.getAllCaracteristic(), model.getAllReferentSpeciesByTaxonId());
        this.sendMessage(I18n._((String)"tutti.flash.information.species.exported.from.protocol", (Object[])new Object[]{this.file}));
    }
}

