/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.program;

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUIHandler;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUIModel;
import java.awt.event.ActionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SaveProgramAction
extends AbstractTuttiAction<EditProgramUIModel, EditProgramUI, EditProgramUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SaveProgramAction.class);

    public SaveProgramAction(EditProgramUIHandler handler) {
        super(handler, "saveProgram", "save", I18n._((String)"tutti.action.saveProgram", (Object[])new Object[0]), I18n._((String)"tutti.action.saveProgram.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected void doAction(ActionEvent event) {
        TuttiUIContext context = this.getContext();
        PersistenceService persistenceService = this.getService(PersistenceService.class);
        EditProgramUIModel model = (EditProgramUIModel)this.getModel();
        Program bean = (Program)model.toBean();
        Program saved = TuttiEntities.isNew(bean) ? persistenceService.createProgram(bean) : persistenceService.saveProgram(bean);
        context.setProgramId(saved.getId());
        TuttiScreen nextScreen = event.getSource().getClass().isAssignableFrom(TuttiScreen.class) ? (TuttiScreen)((Object)event.getSource()) : TuttiScreen.SELECT_CRUISE;
        context.setScreen(nextScreen);
    }
}

