/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SelectSpeciesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class CreateSpeciesBatchUIHandler
extends AbstractTuttiUIHandler<CreateSpeciesBatchUIModel, CreateSpeciesBatchUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(CreateSpeciesBatchUIHandler.class);
    private final TuttiPersistence persistenceService;
    private final CaracteristicQualitativeValue sortedValue;

    public CreateSpeciesBatchUIHandler(TuttiUI parentUi, CreateSpeciesBatchUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui);
        this.persistenceService = (TuttiPersistence)this.context.getService(PersistenceService.class);
        Caracteristic caracteristic = this.persistenceService.getSortedUnsortedCaracteristic();
        CaracteristicQualitativeValue v = null;
        for (CaracteristicQualitativeValue value : caracteristic.getQualitativeValue()) {
            if (!this.persistenceService.isSortedQualitativeValue(value)) continue;
            v = value;
            break;
        }
        this.sortedValue = v;
    }

    @Override
    public void beforeInitUI() {
        CreateSpeciesBatchUIModel model = new CreateSpeciesBatchUIModel();
        ((CreateSpeciesBatchUI)this.ui).setContextValue(model);
        this.listModelIsModify(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        boolean protocolFilled = this.context.isProtocolFilled();
        this.initBeanComboBox(((CreateSpeciesBatchUI)this.ui).getSpeciesComboBox(), Lists.newArrayList(), null, DecoratorService.getSpeciesContext((boolean)protocolFilled));
        Caracteristic caracteristic = this.persistenceService.getSortedUnsortedCaracteristic();
        this.initBeanComboBox(((CreateSpeciesBatchUI)this.ui).getSortedUnsortedCategoryComboBox(), caracteristic.getQualitativeValue(), null);
        ((CreateSpeciesBatchUIModel)this.getModel()).addPropertyChangeListener("species", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CreateSpeciesBatchUIModel source = (CreateSpeciesBatchUIModel)evt.getSource();
                Species newValue = (Species)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("New Selected species " + (newValue == null ? null : newValue.getRefTaxCode())));
                }
                if (newValue == null || source.getSpeciesUsed() == null) {
                    source.setSortedUnsortedCategory(null);
                } else {
                    CaracteristicQualitativeValue qualitativeValue;
                    List qualitativeValues = ((CreateSpeciesBatchUI)CreateSpeciesBatchUIHandler.this.ui).getSortedUnsortedCategoryComboBox().getData();
                    CaracteristicQualitativeValue newCategory = null;
                    Iterator i$ = qualitativeValues.iterator();
                    while (!(!i$.hasNext() || source.isSpeciesAndCategoryAvailable(newValue, qualitativeValue = (CaracteristicQualitativeValue)i$.next()) && (newCategory = qualitativeValue).equals(CreateSpeciesBatchUIHandler.this.sortedValue))) {
                    }
                    source.setSortedUnsortedCategory(newCategory);
                }
            }
        });
        this.listenValidatorValid((SimpleBeanValidator)((CreateSpeciesBatchUI)this.ui).getValidator(), (AbstractTuttiBeanUIModel)this.getModel());
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
        ((CreateSpeciesBatchUI)this.ui).getValidator().setBean(null);
        ((CreateSpeciesBatchUIModel)this.getModel()).setValid(false);
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getHandler().setSpeciesSelectedCard("main");
    }

    @Override
    public SwingValidator<CreateSpeciesBatchUIModel> getValidator() {
        return ((CreateSpeciesBatchUI)this.ui).getValidator();
    }

    @Override
    public void cancel() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Cancel UI " + this.ui));
        }
        this.closeUI(this.ui);
    }

    public void openUI(SpeciesBatchUIModel batchModel) {
        CreateSpeciesBatchUIModel model = (CreateSpeciesBatchUIModel)this.getModel();
        ((CreateSpeciesBatchUI)this.ui).getValidator().setBean((Object)model);
        model.setSpecies(null);
        model.setSortedUnsortedCategory(null);
        model.setBatchWeight(null);
        ArrayList speciesToUse = Lists.newArrayList();
        Multimap<CaracteristicQualitativeValue, Species> speciesUsed = model.getSpeciesUsed();
        speciesUsed.clear();
        if (batchModel != null) {
            speciesUsed.putAll(batchModel.getSpeciesUsed());
            List<Species> allSpecies = batchModel.getAllSpecies();
            speciesToUse.addAll(allSpecies);
        }
        model.setAvailableSpecies(speciesToUse);
    }

    public void save() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Save UI " + this.ui));
        }
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getSpeciesTabContent().getHandler().addSpeciesBatch((CreateSpeciesBatchUIModel)this.getModel());
        this.closeUI(this.ui);
    }

    public Species openAddSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUI dialog = new SelectSpeciesUI(this.ui);
        SelectSpeciesUIModel model = dialog.getModel();
        model.setSelectedSpecies(null);
        model.setSpecies(species);
        this.openDialog(this.ui, dialog, title, new Dimension(400, 130));
        return model.getSelectedSpecies();
    }
}

