/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise;

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Country;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.content.cruise.VesselTypeEnum;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class EditCruiseUIModel
extends AbstractTuttiBeanUIModel<Cruise, EditCruiseUIModel> {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_PROGRAM = "program";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_COMMENT = "comment";
    public static final String PROPERTY_COUNTRY = "country";
    public static final String PROPERTY_SURVEY_PART = "surveyPart";
    public static final String PROPERTY_VESSEL = "vessel";
    public static final String PROPERTY_GEAR = "gear";
    public static final String PROPERTY_HEAD_OF_MISSION = "headOfMission";
    public static final String PROPERTY_HEAD_OF_SORT_ROOM = "headOfSortRoom";
    public static final String PROPERTY_YEAR = "year";
    public static final String PROPERTY_MULTIRIG_NUMBER = "multirigNumber";
    public static final String PROPERTY_BEGIN_DATE = "beginDate";
    public static final String PROPERTY_END_DATE = "endDate";
    public static final String PROPERTY_CAN_GENERATE_NAME = "canGenerateName";
    public static final String PROPERTY_VESSEL_TYPE = "vesselType";
    public static final String PROPERTY_VESSEL_TYPE_ALL = "vesselTypeAll";
    public static final String PROPERTY_VESSEL_TYPE_SCIENTIFIC = "vesselTypeScientific";
    public static final String PROPERTY_VESSEL_TYPE_FISHING = "vesselTypeFishing";
    protected Program program;
    protected Country country;
    protected String name;
    protected String surveyPart;
    protected List<Vessel> vessel;
    protected List<Gear> gear;
    protected List<Person> headOfMission;
    protected List<Person> headOfSortRoom;
    protected String comment;
    protected Integer year;
    protected Integer multirigNumber;
    protected Date beginDate;
    protected Date endDate;
    protected VesselTypeEnum vesselType;
    protected static Binder<EditCruiseUIModel, Cruise> toBeanBinder = BinderFactory.newBinder(EditCruiseUIModel.class, Cruise.class);
    protected static Binder<Cruise, EditCruiseUIModel> fromBeanBinder = BinderFactory.newBinder(Cruise.class, EditCruiseUIModel.class);
    public static final String cruiseNameFormat = "%1$s_%2$s";

    public EditCruiseUIModel() {
        super(Cruise.class, fromBeanBinder, toBeanBinder);
    }

    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        Program oldValue = this.getProgram();
        this.program = program;
        this.firePropertyChange(PROPERTY_PROGRAM, oldValue, program);
        this.firePropertyChange(PROPERTY_CAN_GENERATE_NAME, null, this.isCanGenerateName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.getName();
        this.name = name;
        this.firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.comment = comment;
        this.firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        Country oldValue = this.getCountry();
        this.country = country;
        this.firePropertyChange(PROPERTY_COUNTRY, oldValue, country);
    }

    public String getSurveyPart() {
        return this.surveyPart;
    }

    public void setSurveyPart(String surveyPart) {
        String oldValue = this.getSurveyPart();
        this.surveyPart = surveyPart;
        this.firePropertyChange(PROPERTY_SURVEY_PART, oldValue, surveyPart);
    }

    public Integer getYear() {
        return this.year;
    }

    public void setYear(Integer year) {
        Integer oldValue = this.getYear();
        this.year = year;
        this.firePropertyChange(PROPERTY_YEAR, oldValue, year);
        this.firePropertyChange(PROPERTY_CAN_GENERATE_NAME, null, this.isCanGenerateName());
    }

    public Integer getMultirigNumber() {
        return this.multirigNumber;
    }

    public void setMultirigNumber(Integer multirigNumber) {
        Integer oldValue = this.getMultirigNumber();
        this.multirigNumber = multirigNumber;
        this.firePropertyChange(PROPERTY_MULTIRIG_NUMBER, oldValue, multirigNumber);
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        Date oldValue = this.getBeginDate();
        this.beginDate = beginDate;
        this.firePropertyChange(PROPERTY_BEGIN_DATE, oldValue, beginDate);
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        Date oldValue = this.getEndDate();
        this.endDate = endDate;
        this.firePropertyChange(PROPERTY_END_DATE, oldValue, endDate);
    }

    public List<Vessel> getVessel() {
        return this.vessel;
    }

    public void setVessel(List<Vessel> vessel) {
        this.vessel = vessel;
        this.firePropertyChange(PROPERTY_VESSEL, null, vessel);
    }

    public List<Gear> getGear() {
        return this.gear;
    }

    public void setGear(List<Gear> gear) {
        this.gear = gear;
        this.firePropertyChange(PROPERTY_GEAR, null, gear);
    }

    public List<Person> getHeadOfMission() {
        return this.headOfMission;
    }

    public void setHeadOfMission(List<Person> headOfMission) {
        this.headOfMission = headOfMission;
        this.firePropertyChange(PROPERTY_HEAD_OF_MISSION, null, headOfMission);
    }

    public List<Person> getHeadOfSortRoom() {
        return this.headOfSortRoom;
    }

    public void setHeadOfSortRoom(List<Person> headOfSortRoom) {
        this.headOfSortRoom = headOfSortRoom;
        this.firePropertyChange(PROPERTY_HEAD_OF_SORT_ROOM, null, headOfSortRoom);
    }

    public VesselTypeEnum getVesselType() {
        return this.vesselType;
    }

    public void setVesselType(VesselTypeEnum vesselType) {
        boolean oldAll = this.isVesselTypeAll();
        boolean oldScientific = this.isVesselTypeScientific();
        boolean oldFishing = this.isVesselTypeFishing();
        VesselTypeEnum oldValue = this.getVesselType();
        this.vesselType = vesselType;
        this.firePropertyChange(PROPERTY_VESSEL_TYPE, (Object)oldValue, (Object)vesselType);
        this.firePropertyChange(PROPERTY_VESSEL_TYPE_ALL, oldAll, this.isVesselTypeAll());
        this.firePropertyChange(PROPERTY_VESSEL_TYPE_SCIENTIFIC, oldScientific, this.isVesselTypeScientific());
        this.firePropertyChange(PROPERTY_VESSEL_TYPE_FISHING, oldFishing, this.isVesselTypeFishing());
    }

    public boolean isVesselTypeAll() {
        return VesselTypeEnum.ALL.equals((Object)this.vesselType);
    }

    public boolean isVesselTypeScientific() {
        return VesselTypeEnum.SCIENTIFIC.equals((Object)this.vesselType);
    }

    public boolean isVesselTypeFishing() {
        return VesselTypeEnum.FISHING.equals((Object)this.vesselType);
    }

    public boolean isCanGenerateName() {
        return this.program != null && this.year != null;
    }

    public String getGeneratedCampaignName() {
        String name = String.format(cruiseNameFormat, this.program.getName(), this.year);
        if (StringUtils.isNotEmpty((CharSequence)this.surveyPart)) {
            name = name + "_" + this.surveyPart;
        }
        return name;
    }
}

