package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: RemoveSpeciesProtocolAction.java 383 2013-02-10 15:00:32Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/RemoveSpeciesProtocolAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;

import java.awt.event.ActionEvent;
import java.util.Collection;

import static org.nuiton.i18n.I18n._;

/**
 * To add a new species protocol.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class RemoveSpeciesProtocolAction extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {

    private static final long serialVersionUID = 1L;

    public RemoveSpeciesProtocolAction(EditProtocolUIHandler handler) {
        super(handler,
              "removeSpeciesProtocol",
              "batch-delete",
              _("tutti.action.removeSpeciesProtocol"),
              _("tutti.action.removeSpeciesProtocol.tip"),
              false
        );
    }

    @Override
    protected void doAction(ActionEvent event) {

        EditProtocolUIHandler handler = getHandler();
        int rowIndex = handler.getTable().getSelectedRow();

        Preconditions.checkState(rowIndex != -1,
                                 "Cant remove species if no species selected");

        EditProtocolSpeciesTableModel tableModel = getHandler().getTableModel();

        EditProtocolSpeciesRowModel selectedRow = tableModel.getEntry(rowIndex);

        // re-add all synonym of this taxon to the species comobox
        Integer taxonId = selectedRow.getSpecies().getReferenceTaxonId();
        Collection<Species> allSynonyms = getModel().getAllSynonyms(String.valueOf(taxonId));
        getUI().getSpeciesComboBox().getData().addAll(allSynonyms);
        getUI().getSpeciesComboBox().getHandler().sortData();


        // remove the row from the model(do it after treating the comboBox which can be long)
        tableModel.removeRow(rowIndex);

        String speciesStr = getDecorator(Species.class, DecoratorService.SPECIES_BY_CRUISE_CODE).toString(selectedRow.getSpecies());
        sendMessage(_("tutti.flash.information.species.remove.from.protocol",
                      speciesStr));
    }

}