/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Zone;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.MainUI;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.environment.EnvironmentTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.environment.EnvironmentTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting.GearShootingTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting.GearShootingTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyTabUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import fr.ifremer.tutti.ui.swing.util.CustomTab;
import fr.ifremer.tutti.ui.swing.util.TabHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditFishingOperationUIHandler
extends AbstractTuttiTabContainerUIHandler<EditFishingOperationUIModel>
implements TabHandler {
    private static final Log log = LogFactory.getLog(EditFishingOperationUIHandler.class);
    private final EditFishingOperationUI ui;
    private final FishingOperationsUI parentUi;
    private final PersistenceService persistenceService;
    private final TuttiBeanMonitor<EditFishingOperationUIModel> fishingOperationMonitor;

    public EditFishingOperationUIHandler(FishingOperationsUI parentUi, EditFishingOperationUI ui) {
        super(parentUi.getHandler().getContext());
        this.ui = ui;
        this.parentUi = parentUi;
        this.persistenceService = this.context.getService(PersistenceService.class);
        this.fishingOperationMonitor = new TuttiBeanMonitor("stationNumber", "fishingOperationNumber", "strata", "subStrata", "gearShootingStartLatitude", "gearShootingStartLongitude", "gearShootingStartDate", "gearShootingEndLatitude", "gearShootingEndLongitude", "gearShootingEndDate", "fishingOperationRectiligne", "distanceChalutee", "fishingOperationValid", "location", "saisisseur", "comment");
    }

    @Override
    public void beforeInitUI() {
        EditFishingOperationUIModel model = new EditFishingOperationUIModel();
        model.setValidationContext(this.getContext().getValidationContext());
        model.addPropertyChangeListener("empty", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JPanel form = EditFishingOperationUIHandler.this.ui.getFishingOperationPane();
                JLabel noContentPane = EditFishingOperationUIHandler.this.ui.getNoTraitPane();
                Boolean empty = (Boolean)evt.getNewValue();
                EditFishingOperationUIHandler.this.ui.remove(form);
                EditFishingOperationUIHandler.this.ui.remove(noContentPane);
                if (empty.booleanValue()) {
                    EditFishingOperationUIHandler.this.ui.add((Component)noContentPane, "Center");
                } else {
                    EditFishingOperationUIHandler.this.ui.add((Component)form, "Center");
                }
                EditFishingOperationUIHandler.this.ui.repaint();
            }
        });
        model.addPropertyChangeListener("strata", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditFishingOperationUIModel source = (EditFishingOperationUIModel)((Object)evt.getSource());
                FishingOperationLocation newStrata = (FishingOperationLocation)evt.getNewValue();
                EditFishingOperationUIHandler.this.onSelectedStrata(source, newStrata);
            }
        });
        model.addPropertyChangeListener("subStrata", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditFishingOperationUIModel source = (EditFishingOperationUIModel)((Object)evt.getSource());
                FishingOperationLocation newStrata = (FishingOperationLocation)evt.getNewValue();
                EditFishingOperationUIHandler.this.onSelectedSubStrata(source, newStrata);
            }
        });
        model.addPropertyChangeListener("useSexagecimalFormat", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean useSexagecimalFormat = (Boolean)evt.getNewValue();
                log.info((Object)("property PROPERTY_USE_SEXAGECIMAL_FORMAT changed " + useSexagecimalFormat));
                if (useSexagecimalFormat) {
                    EditFishingOperationUIHandler.this.getModel().convertGearShootingCoordinatesDDToDMS();
                } else {
                    EditFishingOperationUIHandler.this.getModel().convertGearShootingCoordinatesDMSToDD();
                }
            }
        });
        this.ui.setContextValue(model);
        this.fishingOperationMonitor.setBean(model);
    }

    @Override
    public void afterInitUI() {
        this.ui.getFishingOperationValidPanel().remove(this.ui.getFishingOperationResetRadio());
        EditFishingOperationUIModel model = this.getModel();
        this.initUI(this.ui);
        this.initBeanList(this.ui.getSaisisseurList(), this.persistenceService.getAllPerson(), model.getSaisisseur());
        String programId = this.context.getProgramId();
        Program program = this.persistenceService.getProgram(programId);
        Zone zone = program.getZone();
        FishingOperationLocation strata = model.getStrata();
        String strataId = strata == null ? null : strata.getId();
        FishingOperationLocation subStrata = model.getSubStrata();
        String substrataId = subStrata == null ? null : subStrata.getId();
        FishingOperationLocation location = model.getLocation();
        List stratas = this.persistenceService.getAllFishingOperationStrata(zone.getId());
        List subStratas = strataId == null ? Lists.newArrayList() : this.persistenceService.getAllFishingOperationSubStrata(strataId);
        List locations = substrataId == null ? Lists.newArrayList() : this.persistenceService.getAllFishingOperationLocation(substrataId);
        this.initBeanComboBox(this.ui.getStrataComboBox(), stratas, strata);
        this.initBeanComboBox(this.ui.getSubStrataComboBox(), subStratas, subStrata);
        this.initBeanComboBox(this.ui.getLocationComboBox(), locations, location);
        model.setEmpty(true);
        this.changeValidatorContext(model.getValidationContext(), this.ui.getValidator());
        this.listenValidatorValid((SimpleBeanValidator)this.ui.getValidator(), model);
        this.setCustomTab(0, model);
        this.listModelIsModify(model);
        GearShootingTabUIModel gearShootingModel = this.ui.getGearShootingTabContent().getModel();
        gearShootingModel.setAvailableCaracteristics(this.persistenceService.getAllFishingOperationGearCaracteristic());
        this.setCustomTab(1, gearShootingModel);
        EnvironmentTabUIModel environmentModel = this.ui.getEnvironmentTabContent().getModel();
        environmentModel.setAvailableCaracteristics(this.persistenceService.getAllFishingOperationEnvironmentCaracteristic());
        this.setCustomTab(2, environmentModel);
        HydrologyTabUIModel hydrologyModel = this.ui.getHydrologyTabContent().getModel();
        hydrologyModel.setAvailableCaracteristics(this.persistenceService.getAllFishingOperationHydrologicCaracteristic());
        this.setCustomTab(3, hydrologyModel);
        MainUI main = this.ui.getContextValue(MainUI.class, MainUI.class.getName());
        main.clearValidators();
        main.registerValidator(this.ui.getValidator());
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
        MainUI main = this.ui.getContextValue(MainUI.class, MainUI.class.getName());
        main.clearValidators();
        this.closeUI(this.ui.getGearShootingTabContent());
        this.closeUI(this.ui.getEnvironmentTabContent());
        this.closeUI(this.ui.getHydrologyTabContent());
    }

    @Override
    protected JTabbedPane getTabPanel() {
        return this.ui.getFishingOperationTabPane();
    }

    @Override
    protected boolean onTabChanged(int currentIndex, int newIndex) {
        CustomTab currentTab;
        AbstractTuttiBeanUIModel model;
        boolean result = super.onTabChanged(currentIndex, newIndex);
        if (result && currentIndex != newIndex && currentIndex >= 0 && (result = (model = (currentTab = (CustomTab)this.getTabPanel().getTabComponentAt(currentIndex)).getModel()).isValid()) && !model.isCreate() && model.isModify()) {
            this.save();
        }
        return result;
    }

    @Override
    public boolean onHideTab() {
        EditFishingOperationUIModel model = this.getModel();
        boolean result = model.isValid();
        if (result && !model.isCreate() && model.isModify()) {
            this.save();
        }
        return result;
    }

    @Override
    public void onShowTab() {
        log.info((Object)"show tab");
    }

    @Override
    protected EditFishingOperationUIModel getModel() {
        return this.ui.getModel();
    }

    public void clearFishingOperation() {
        if (this.fishingOperationMonitor.wasModified()) {
            this.save();
        }
        EditFishingOperationUIModel model = this.getModel();
        model.fromBean(new FishingOperation());
        model.setModify(false);
        this.fishingOperationMonitor.clearModified();
        model.setEmpty(true);
    }

    public void selectFishingOperation(FishingOperation bean) {
        if (this.fishingOperationMonitor.wasModified()) {
            this.save();
        }
        boolean empty = bean == null;
        EditFishingOperationUIModel model = this.getModel();
        if (empty) {
            bean = new FishingOperation();
        }
        FishingOperationLocation strata = bean.getStrata();
        FishingOperationLocation subStrata = bean.getSubStrata();
        FishingOperationLocation location = bean.getLocation();
        model.fromBean(bean);
        model.setStrata(null);
        model.setSubStrata(null);
        model.setLocation(null);
        model.convertGearShootingCoordinatesDDToDMS();
        if (strata != null) {
            this.ui.getStrataComboBox().setSelectedItem((Object)strata);
        }
        if (subStrata != null) {
            this.ui.getSubStrataComboBox().setSelectedItem((Object)subStrata);
        }
        if (location != null) {
            this.ui.getLocationComboBox().setSelectedItem((Object)location);
        }
        model.setFishingOperation(bean);
        List<Person> saisisseur = model.getSaisisseur();
        this.ui.getSaisisseurList().getModel().setSelected(saisisseur);
        model.setEmpty(empty);
        GearShootingTabUI gearShootingTab = this.ui.getGearShootingTabContent();
        gearShootingTab.getHandler().reset(bean);
        EnvironmentTabUI environmentTab = this.ui.getEnvironmentTabContent();
        environmentTab.getHandler().reset(bean);
        HydrologyTabUI hydrologyTab = this.ui.getHydrologyTabContent();
        hydrologyTab.getHandler().reset(bean);
        model.setModify(false);
        this.fishingOperationMonitor.clearModified();
    }

    public void cancel() {
        boolean newBean;
        String id = this.getModel().getId();
        if (log.isInfoEnabled()) {
            log.info((Object)("Cancel edition for fishingOperation: " + id));
        }
        if (newBean = StringUtils.isBlank((CharSequence)id)) {
            this.parentUi.getHandler().closeCurrentFishingOperation();
        }
    }

    public void save() {
        EditFishingOperationUIModel beanToSave = this.fishingOperationMonitor.getBean();
        if (beanToSave.isEmpty()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Won't save new fishing operation, use explicit save button instead...");
            }
        } else if (beanToSave.isValid()) {
            if (beanToSave.isUseSexagecimalFormat()) {
                beanToSave.convertGearShootingCoordinatesDMSToDD();
            }
            FishingOperation toSave = (FishingOperation)beanToSave.toBean();
            this.showInformationMessage("[ Trait - Caract\u00e9ristiques g\u00e9n\u00e9rales ] Sauvegarde des modifications de " + this.decorate(toSave) + ".");
            if (log.isInfoEnabled()) {
                log.info((Object)("FishingOperation " + toSave.getId() + " was modified, will save it."));
            }
            this.fishingOperationMonitor.clearModified();
            this.getModel().setModify(false);
            this.parentUi.getHandler().saveFishingOperation(toSave);
        }
    }

    public void importCasino() {
    }

    public void setUseSexagecimalFormat(boolean useSexagecimalFormat) {
        this.getModel().setUseSexagecimalFormat(useSexagecimalFormat);
    }

    public void setGearShootingStartLatitude(String text) {
        this.getModel().setGearShootingStartLatitude(Float.valueOf(text));
    }

    public void setGearShootingStartLatitudeDegree(String text) {
        this.getModel().setGearShootingStartLatitude(Float.valueOf(text));
    }

    public void setGearShootingStartLatitudeMinute(String text) {
        this.getModel().setGearShootingStartLatitude(Float.valueOf(text));
    }

    public void setGearShootingStartLatitudeSecond(String text) {
        this.getModel().setGearShootingStartLatitude(Float.valueOf(text));
    }

    public void setGearShootingStartLongitude(String text) {
        this.getModel().setGearShootingStartLongitude(Float.valueOf(text));
    }

    public void setGearShootingEndLatitude(String text) {
        this.getModel().setGearShootingEndLatitude(Float.valueOf(text));
    }

    public void setGearShootingEndLongitude(String text) {
        this.getModel().setGearShootingEndLongitude(Float.valueOf(text));
    }

    protected void onSelectedStrata(EditFishingOperationUIModel model, FishingOperationLocation newStrata) {
        model.setSubStrata(null);
        this.ui.getSubStrataComboBox().setData(null);
        if (newStrata == null) {
            this.ui.getStrataComboBox().grabFocus();
        } else {
            List subStrata = this.persistenceService.getAllFishingOperationSubStrata(newStrata.getId());
            this.ui.getSubStrataComboBox().setData(subStrata);
            if (CollectionUtils.isEmpty((Collection)subStrata)) {
                List location = this.persistenceService.getAllFishingOperationLocation(newStrata.getId());
                this.ui.getLocationComboBox().setData(location);
                this.ui.getLocationComboBox().grabFocus();
            }
        }
    }

    protected void onSelectedSubStrata(EditFishingOperationUIModel model, FishingOperationLocation newSubStrata) {
        model.setLocation(null);
        this.ui.getLocationComboBox().setData(null);
        if (newSubStrata == null) {
            this.ui.getSubStrataComboBox().grabFocus();
        } else {
            List location = this.persistenceService.getAllFishingOperationLocation(newSubStrata.getId());
            this.ui.getLocationComboBox().setData(location);
        }
    }
}

