/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SelectCruiseUIHandler
extends AbstractTuttiUIHandler<SelectCruiseUIModel> {
    private static final Log log = LogFactory.getLog(SelectCruiseUIHandler.class);
    protected static final String PROTOCOL_ACTION_NEW = "tutti.action.new";
    protected static final String PROTOCOL_ACTION_CLONE = "tutti.action.clone";
    protected static final String PROTOCOL_ACTION_IMPORT = "tutti.action.import";
    protected final PersistenceService persistenceService;
    protected final SelectCruiseUI ui;

    public SelectCruiseUIHandler(TuttiUIContext context, SelectCruiseUI ui) {
        super(context);
        this.ui = ui;
        this.persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    protected SelectCruiseUIModel getModel() {
        return this.ui.getModel();
    }

    @Override
    public void beforeInitUI() {
        SelectCruiseUIModel model = new SelectCruiseUIModel();
        List programs = this.persistenceService.getAllProgram();
        model.setPrograms(programs);
        if (programs.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No program found.");
            }
        } else {
            String programId = this.context.getProgramId();
            Program selectedProgram = null;
            List cruises = null;
            if (programId != null) {
                selectedProgram = (Program)TuttiEntities.findById((Iterable)programs, (String)programId);
                cruises = this.persistenceService.getAllCruise(programId);
            }
            model.setProgram(selectedProgram);
            model.setCruises(cruises);
            if (!CollectionUtils.isEmpty(cruises)) {
                String cruiseId = this.context.getCruiseId();
                Cruise selectedCruise = null;
                if (cruiseId != null) {
                    selectedCruise = (Cruise)TuttiEntities.findById((Iterable)cruises, (String)cruiseId);
                }
                model.setCruise(selectedCruise);
            }
        }
        List protocols = this.persistenceService.getAllProtocol();
        model.setProtocols(protocols);
        if (protocols.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No protocol found.");
            }
        } else {
            String protocolId = this.context.getProtocolId();
            TuttiProtocol selectedProtocol = null;
            if (protocolId != null) {
                selectedProtocol = (TuttiProtocol)TuttiEntities.findById((Iterable)protocols, (String)protocolId);
            }
            model.setProtocol(selectedProtocol);
        }
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        SelectCruiseUIModel model = this.getModel();
        this.initBeanComboBox(this.ui.getProgramCombobox(), model.getPrograms(), model.getProgram());
        this.initBeanComboBox(this.ui.getCruiseCombobox(), model.getCruises(), model.getCruise());
        this.initBeanComboBox(this.ui.getProtocolCombobox(), model.getProtocols(), model.getProtocol());
        DefaultComboBoxModel<String> protocolActions = new DefaultComboBoxModel<String>(new String[]{I18n._((String)PROTOCOL_ACTION_NEW, (Object[])new Object[0]), I18n._((String)PROTOCOL_ACTION_CLONE, (Object[])new Object[0]), I18n._((String)PROTOCOL_ACTION_IMPORT, (Object[])new Object[0])});
        JComboBox newProtocolCombo = this.ui.getNewProtocolCombo();
        newProtocolCombo.setModel(protocolActions);
        model.addPropertyChangeListener("program", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Program newValue = (Program)evt.getNewValue();
                boolean noProgram = newValue == null;
                SelectCruiseUIHandler.this.context.setProgramId(noProgram ? null : newValue.getId());
                List campaigns = noProgram ? Lists.newArrayList() : SelectCruiseUIHandler.this.persistenceService.getAllCruise(newValue.getId());
                SelectCruiseUIModel model = (SelectCruiseUIModel)((Object)evt.getSource());
                model.setCruises(campaigns);
                model.setCruise(null);
            }
        });
        model.addPropertyChangeListener("cruises", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BeanComboBox<Cruise> combobox = SelectCruiseUIHandler.this.ui.getCruiseCombobox();
                List campaigns = (List)evt.getNewValue();
                combobox.setData(null);
                combobox.setData(campaigns);
            }
        });
        model.addPropertyChangeListener("cruise", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Cruise newValue = (Cruise)evt.getNewValue();
                SelectCruiseUIHandler.this.context.setCruiseId(newValue == null ? null : newValue.getId());
            }
        });
        model.addPropertyChangeListener("protocol", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TuttiProtocol newValue = (TuttiProtocol)evt.getNewValue();
                SelectCruiseUIHandler.this.context.setProtocolId(newValue == null ? null : newValue.getId());
            }
        });
    }

    @Override
    public void onCloseUI() {
        PropertyChangeListener[] listeners;
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
        for (PropertyChangeListener listener : listeners = this.getModel().getPropertyChangeListeners()) {
            this.getModel().removePropertyChangeListener(listener);
        }
    }

    public void showFillCatches() {
        this.context.setValidationContext("edit");
        this.context.setScreen(TuttiScreen.EDIT_FISHING_OPERATION);
    }

    public void showValidateCatches() {
        this.context.setValidationContext("validate");
        this.context.setScreen(TuttiScreen.EDIT_FISHING_OPERATION);
    }

    public void showSelectedProgram() {
        Program program = this.getModel().getProgram();
        this.context.setProgramId(program.getId());
        this.context.setScreen(TuttiScreen.EDIT_PROGRAM);
    }

    public void showNewProgram() {
        this.context.setProgramId(null);
        this.context.setCruiseId(null);
        this.context.setScreen(TuttiScreen.EDIT_PROGRAM);
    }

    public void showSelectedCruise() {
        Cruise cruise = this.getModel().getCruise();
        this.context.setCruiseId(cruise.getId());
        this.context.setScreen(TuttiScreen.EDIT_CRUISE);
    }

    public void showNewCruise() {
        this.context.setCruiseId(null);
        this.context.setScreen(TuttiScreen.EDIT_CRUISE);
    }

    public void showSelectedProtocol() {
        TuttiProtocol protocol = this.getModel().getProtocol();
        this.context.setProtocolId(protocol.getId());
        this.context.setScreen(TuttiScreen.EDIT_PROTOCOL);
    }

    public void showNewProtocol(ActionEvent event) {
        log.info(event.getSource());
        this.context.setProtocolId(null);
        this.context.setScreen(TuttiScreen.EDIT_PROTOCOL);
    }
}

