/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.MainUI;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIModel;
import fr.ifremer.tutti.ui.swing.content.cruise.VesselTypeEnum;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditCruiseUIHandler
extends AbstractTuttiUIHandler<EditCruiseUIModel> {
    private static final Log log = LogFactory.getLog(EditCruiseUIHandler.class);
    private final EditCruiseUI ui;
    private final PersistenceService persistenceService;
    JAXXContextEntryDef<List<Vessel>> SCIENTIFIC_VESSELS_CONTEXT_ENTRY = JAXXUtil.newListContextEntryDef((String)"scientificVessel");
    JAXXContextEntryDef<List<Vessel>> FISHING_VESSELS_CONTEXT_ENTRY = JAXXUtil.newListContextEntryDef((String)"fishingVessel");
    JAXXContextEntryDef<List<Gear>> SCIENTIFIC_GEARS_CONTEXT_ENTRY = JAXXUtil.newListContextEntryDef((String)"scientificGear");
    JAXXContextEntryDef<List<Gear>> FISHING_GEARS_CONTEXT_ENTRY = JAXXUtil.newListContextEntryDef((String)"fishingGear");
    public static final String cruiseNameFormat = "%1$s_%2$s";

    public EditCruiseUIHandler(TuttiUI parentUi, EditCruiseUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext());
        this.ui = ui;
        this.persistenceService = this.context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {
        EditCruiseUIModel model = new EditCruiseUIModel();
        List fishingVessels = this.persistenceService.getAllFishingVessel();
        this.FISHING_VESSELS_CONTEXT_ENTRY.setContextValue((JAXXContext)this.ui, (Object)fishingVessels);
        List scientificVessels = this.persistenceService.getAllScientificVessel();
        this.SCIENTIFIC_VESSELS_CONTEXT_ENTRY.setContextValue((JAXXContext)this.ui, (Object)scientificVessels);
        List scientificGears = this.persistenceService.getAllScientificGear();
        this.SCIENTIFIC_GEARS_CONTEXT_ENTRY.setContextValue((JAXXContext)this.ui, (Object)scientificGears);
        List fishingGears = this.persistenceService.getAllFishingGear();
        this.FISHING_GEARS_CONTEXT_ENTRY.setContextValue((JAXXContext)this.ui, (Object)fishingGears);
        String cruiseId = this.context.getCruiseId();
        if (cruiseId == null) {
            Program program = this.persistenceService.getProgram(this.context.getProgramId());
            model.setProgram(program);
            model.setPoche(1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will create a new cruise from program: " + program));
            }
        } else {
            Cruise cruise = this.persistenceService.getCruise(cruiseId);
            model.fromBean(cruise);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will edit cruise: " + cruiseId));
            }
        }
        this.listModelIsModify(model);
        this.ui.setContextValue(model);
    }

    protected List<Vessel> getVesselList(VesselTypeEnum vesselType) {
        ArrayList result = Lists.newArrayList();
        switch (vesselType) {
            case ALL: {
                result.addAll((Collection)this.FISHING_VESSELS_CONTEXT_ENTRY.getContextValue((JAXXContext)this.ui));
                result.addAll((Collection)this.SCIENTIFIC_VESSELS_CONTEXT_ENTRY.getContextValue((JAXXContext)this.ui));
                break;
            }
            case SCIENTIFIC: {
                result.addAll((Collection)this.SCIENTIFIC_VESSELS_CONTEXT_ENTRY.getContextValue((JAXXContext)this.ui));
                break;
            }
            case FISHING: {
                result.addAll((Collection)this.FISHING_VESSELS_CONTEXT_ENTRY.getContextValue((JAXXContext)this.ui));
            }
        }
        return result;
    }

    protected List<Gear> getGearList(VesselTypeEnum vesselType) {
        ArrayList result = Lists.newArrayList();
        switch (vesselType) {
            case ALL: {
                result.addAll((Collection)this.SCIENTIFIC_GEARS_CONTEXT_ENTRY.getContextValue((JAXXContext)this.ui));
                result.addAll((Collection)this.FISHING_GEARS_CONTEXT_ENTRY.getContextValue((JAXXContext)this.ui));
                break;
            }
            case SCIENTIFIC: {
                result.addAll((Collection)this.SCIENTIFIC_GEARS_CONTEXT_ENTRY.getContextValue((JAXXContext)this.ui));
                break;
            }
            case FISHING: {
                result.addAll((Collection)this.FISHING_GEARS_CONTEXT_ENTRY.getContextValue((JAXXContext)this.ui));
            }
        }
        return result;
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        List users = this.persistenceService.getAllPerson();
        EditCruiseUIModel model = this.getModel();
        model.setVesselType(VesselTypeEnum.ALL);
        model.addPropertyChangeListener("vesselType", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditCruiseUIModel source = (EditCruiseUIModel)((Object)evt.getSource());
                List<Vessel> selectedVessel = source.getVessel();
                List<Gear> selectedGear = source.getGear();
                VesselTypeEnum vesselType = (VesselTypeEnum)((Object)evt.getNewValue());
                List<Vessel> newVesselList = EditCruiseUIHandler.this.getVesselList(vesselType);
                List<Gear> newGearList = EditCruiseUIHandler.this.getGearList(vesselType);
                ArrayList newSelectedVessel = Lists.newArrayList();
                if (selectedVessel != null) {
                    newSelectedVessel.addAll(selectedVessel);
                }
                newSelectedVessel.retainAll(newVesselList);
                ArrayList newSelectedGear = Lists.newArrayList();
                if (selectedGear != null) {
                    newSelectedGear.addAll(selectedGear);
                }
                newSelectedGear.retainAll(newGearList);
                EditCruiseUIHandler.this.ui.getVesselList().getModel().setUniverse(newVesselList);
                EditCruiseUIHandler.this.ui.getVesselList().getModel().setSelected((List)newSelectedVessel);
                EditCruiseUIHandler.this.ui.getGearList().getModel().setUniverse(newGearList);
                EditCruiseUIHandler.this.ui.getGearList().getModel().setSelected((List)newSelectedGear);
            }
        });
        this.initBeanComboBox(this.ui.getSurveyComboBox(), this.persistenceService.getAllProgram(), model.getProgram());
        this.initBeanComboBox(this.ui.getCountryComboBox(), this.persistenceService.getAllCountry(), model.getCountry());
        this.initBeanList(this.ui.getVesselList(), this.getVesselList(VesselTypeEnum.ALL), model.getVessel());
        this.initBeanList(this.ui.getGearList(), this.getGearList(VesselTypeEnum.ALL), model.getGear());
        this.initBeanList(this.ui.getHeadOfMissionList(), users, model.getHeadOfMission());
        this.initBeanList(this.ui.getHeadOfSortRoomList(), users, model.getHeadOfSortRoom());
        SwingValidator<EditCruiseUIModel> validator = this.ui.getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        model.setModify(model.isCreate());
        MainUI main = this.ui.getContextValue(MainUI.class, MainUI.class.getName());
        main.clearValidators();
        main.registerValidator(validator);
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
        MainUI main = this.ui.getContextValue(MainUI.class, MainUI.class.getName());
        main.clearValidators();
    }

    @Override
    protected EditCruiseUIModel getModel() {
        return this.ui.getModel();
    }

    public void cancel() {
        this.context.setScreen(TuttiScreen.SELECT_CRUISE);
    }

    public void save() {
        EditCruiseUIModel model = this.getModel();
        Cruise bean = (Cruise)model.toBean();
        Cruise saved = TuttiEntities.isNew((IdAware)bean) ? this.persistenceService.createCruise(bean) : this.persistenceService.saveCruise(bean);
        this.context.setProgramId(saved.getProgram().getId());
        this.context.setCruiseId(saved.getId());
        this.context.setScreen(TuttiScreen.SELECT_CRUISE);
    }

    public void generateCampaignName() {
        EditCruiseUIModel model = this.getModel();
        Program program = model.getProgram();
        Integer year = model.getYear();
        String name = String.format(cruiseNameFormat, program.getName(), year);
        String surveyPart = model.getSurveyPart();
        if (StringUtils.isNotEmpty((CharSequence)surveyPart)) {
            name = name + "_" + surveyPart;
        }
        model.setName(name);
    }
}

