package fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting;

/*
 * #%L
 * Tutti :: UI
 * $Id: GearShootingRowModel.java 146 2013-01-02 18:51:13Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/fishing/gearshooting/GearShootingRowModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.table.CaracteristicRow;
import java.io.Serializable;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

/**
 * @author kmorin
 * @since 0.3
 */
public class GearShootingRowModel extends AbstractTuttiBeanUIModel<CaracteristicRow, GearShootingRowModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_KEY = "key";

    public static final String PROPERTY_VALUE = "value";

    protected static final Binder<CaracteristicRow, GearShootingRowModel> fromBeanBinder =
            BinderFactory.newBinder(CaracteristicRow.class,
                                    GearShootingRowModel.class);

    protected static final Binder<GearShootingRowModel, CaracteristicRow> toBeanBinder =
            BinderFactory.newBinder(GearShootingRowModel.class,
                                    CaracteristicRow.class);

    protected Caracteristic key;

    protected Serializable value;

    public GearShootingRowModel() {
        super(CaracteristicRow.class, fromBeanBinder, toBeanBinder);
    }

    public Caracteristic getKey() {
        return key;
    }

    public void setKey(Caracteristic key) {
        Object oldValue = getKey();
        this.key = key;
        firePropertyChange(PROPERTY_KEY, oldValue, key);
    }

    public Serializable getValue() {
        return value;
    }

    public void setValue(Serializable value) {
        Object oldValue = getValue();
        this.value = value;
        firePropertyChange(PROPERTY_VALUE, oldValue, value);
    }

}
