package fr.ifremer.tutti.ui.swing.content.operation.fishing.environment;

/*
 * #%L
 * Tutti :: UI
 * $Id: EnvironmentTableModel.java 135 2013-01-01 16:10:44Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/fishing/environment/EnvironmentTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;

import javax.swing.table.TableColumnModel;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author kmorin
 * @since 0.3
 */
public class EnvironmentTableModel extends AbstractTuttiTableModel<EnvironmentRowModel> {

    private static final long serialVersionUID = 1L;

    public static final ColumnIdentifier<EnvironmentRowModel> KEY = ColumnIdentifier.newId(
            EnvironmentRowModel.PROPERTY_KEY,
            n_("tutti.table.fishing.environment.header.key"),
            n_("tutti.table.fishing.environment.header.key"));

    public static final ColumnIdentifier<EnvironmentRowModel> VALUE = ColumnIdentifier.newId(
            EnvironmentRowModel.PROPERTY_VALUE,
            n_("tutti.table.fishing.environment.header.value"),
            n_("tutti.table.fishing.environment.header.value"));

    public EnvironmentTableModel(TableColumnModel columnModel) {
        super(columnModel, false, false);
        setNoneEditableCols(KEY);
    }

    @Override
    public EnvironmentRowModel createNewRow() {
        EnvironmentRowModel result = new EnvironmentRowModel();
        return result;
    }
}
