package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.environment.EnvironmentTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting.GearShootingTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyTabUI;
import fr.ifremer.tutti.ui.swing.util.editor.SimpleTimeEditor;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.TimeEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditFishingOperationUI extends JPanel implements TuttiUI<EditFishingOperationUIModel, EditFishingOperationUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_CREATE_FISHING_OPERATION_ACTIONS_VISIBLE = "createFishingOperationActions.visible";
    public static final String BINDING_DISTANCE_CHALUTEE_FIELD_ENABLED = "distanceChaluteeField.enabled";
    public static final String BINDING_DISTANCE_CHALUTEE_FIELD_MODEL = "distanceChaluteeField.model";
    public static final String BINDING_DISTANCE_CHALUTEE_FIELD_NUMBER_PATTERN = "distanceChaluteeField.numberPattern";
    public static final String BINDING_DUREE_FIELD_TEXT = "dureeField.text";
    public static final String BINDING_FISHING_OPERATION_INVALID_RADIO_SELECTED = "fishingOperationInvalidRadio.selected";
    public static final String BINDING_FISHING_OPERATION_NUMBER_FIELD_MODEL = "fishingOperationNumberField.model";
    public static final String BINDING_FISHING_OPERATION_NUMBER_FIELD_NUMBER_PATTERN = "fishingOperationNumberField.numberPattern";
    public static final String BINDING_FISHING_OPERATION_RECTILIGNE_CHECK_BOX_SELECTED = "fishingOperationRectiligneCheckBox.selected";
    public static final String BINDING_FISHING_OPERATION_RESET_RADIO_SELECTED = "fishingOperationResetRadio.selected";
    public static final String BINDING_FISHING_OPERATION_VALID_RADIO_SELECTED = "fishingOperationValidRadio.selected";
    public static final String BINDING_GEAR_SHOOTING_COORDINATES_DDRADIO_SELECTED = "gearShootingCoordinatesDDRadio.selected";
    public static final String BINDING_GEAR_SHOOTING_COORDINATES_DMSRADIO_SELECTED = "gearShootingCoordinatesDMSRadio.selected";
    public static final String BINDING_GEAR_SHOOTING_END_DATE_FIELD_DATE = "gearShootingEndDateField.date";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DDFIELD_MODEL = "gearShootingEndLatitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSDEGREE_FIELD_MODEL = "gearShootingEndLatitudeDMSDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMSDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSMINUTE_FIELD_MODEL = "gearShootingEndLatitudeDMSMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMSMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSSECOND_FIELD_MODEL = "gearShootingEndLatitudeDMSSecondField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSSECOND_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMSSecondField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_LAYOUT_SELECTED = "gearShootingEndLatitudeLayout.selected";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DDFIELD_MODEL = "gearShootingEndLongitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSDEGREE_FIELD_MODEL = "gearShootingEndLongitudeDMSDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMSDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSMINUTE_FIELD_MODEL = "gearShootingEndLongitudeDMSMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMSMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSSECOND_FIELD_MODEL = "gearShootingEndLongitudeDMSSecondField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSSECOND_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMSSecondField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_LAYOUT_SELECTED = "gearShootingEndLongitudeLayout.selected";
    public static final String BINDING_GEAR_SHOOTING_END_TIME_FIELD_DATE = "gearShootingEndTimeField.date";
    public static final String BINDING_GEAR_SHOOTING_START_DATE_FIELD_DATE = "gearShootingStartDateField.date";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DDFIELD_MODEL = "gearShootingStartLatitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSDEGREE_FIELD_MODEL = "gearShootingStartLatitudeDMSDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMSDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSMINUTE_FIELD_MODEL = "gearShootingStartLatitudeDMSMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMSMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSSECOND_FIELD_MODEL = "gearShootingStartLatitudeDMSSecondField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSSECOND_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMSSecondField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_LAYOUT_SELECTED = "gearShootingStartLatitudeLayout.selected";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DDFIELD_MODEL = "gearShootingStartLongitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSDEGREE_FIELD_MODEL = "gearShootingStartLongitudeDMSDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMSDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSMINUTE_FIELD_MODEL = "gearShootingStartLongitudeDMSMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMSMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSSECOND_FIELD_MODEL = "gearShootingStartLongitudeDMSSecondField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSSECOND_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMSSecondField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_LAYOUT_SELECTED = "gearShootingStartLongitudeLayout.selected";
    public static final String BINDING_GEAR_SHOOTING_START_TIME_FIELD_DATE = "gearShootingStartTimeField.date";
    public static final String BINDING_LOCATION_COMBO_BOX_SELECTED_ITEM = "locationComboBox.selectedItem";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_STATION_NUMBER_FIELD_TEXT = "stationNumberField.text";
    public static final String BINDING_STRATA_COMBO_BOX_SELECTED_ITEM = "strataComboBox.selectedItem";
    public static final String BINDING_SUB_STRATA_COMBO_BOX_SELECTED_ITEM = "subStrataComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditFishingOperationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentField")
    protected JTextArea commentField;
    protected JScrollPane commentPane;
    protected JPanel createFishingOperationActions;
    protected NumberEditor distanceChaluteeField;
    protected JLabel distanceChaluteeLabel;
    protected JTextField dureeField;
    protected JLabel dureeLabel;
    protected TabInfo environmentTab;
    protected EnvironmentTabUI environmentTabContent;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected JRadioButton fishingOperationInvalidRadio;
    @ValidatorField( validatorId = "validator",  propertyName = "fishingOperationNumber",  editorName = "fishingOperationNumberField")
    protected NumberEditor fishingOperationNumberField;
    protected JLabel fishingOperationNumberLabel;
    protected JPanel fishingOperationPane;
    protected JCheckBox fishingOperationRectiligneCheckBox;
    protected JRadioButton fishingOperationResetRadio;
    protected JTabbedPane fishingOperationTabPane;
    protected JAXXButtonGroup fishingOperationValid;
    protected JToolBar fishingOperationValidPanel;
    protected JRadioButton fishingOperationValidRadio;
    protected Table gearCaracteristicsTable;
    protected JLabel gearDateLabel;
    protected JLabel gearLatitudeLabel;
    protected JLabel gearLongitudeLabel;
    protected JAXXButtonGroup gearShootingCoordinates;
    protected JRadioButton gearShootingCoordinatesDDRadio;
    protected JRadioButton gearShootingCoordinatesDMSRadio;
    protected JXDatePicker gearShootingEndDateField;
    protected JLabel gearShootingEndLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitude",  editorName = "gearShootingEndLatitudeDDField")
    protected NumberEditor gearShootingEndLatitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeDegree",  editorName = "gearShootingEndLatitudeDMSDegreeField")
    protected NumberEditor gearShootingEndLatitudeDMSDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeMinute",  editorName = "gearShootingEndLatitudeDMSMinuteField")
    protected NumberEditor gearShootingEndLatitudeDMSMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeSecond",  editorName = "gearShootingEndLatitudeDMSSecondField")
    protected NumberEditor gearShootingEndLatitudeDMSSecondField;
    protected CardLayout2Ext gearShootingEndLatitudeLayout;
    protected JPanel gearShootingEndLatitudePanel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitude",  editorName = "gearShootingEndLongitudeDDField")
    protected NumberEditor gearShootingEndLongitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeDegree",  editorName = "gearShootingEndLongitudeDMSDegreeField")
    protected NumberEditor gearShootingEndLongitudeDMSDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeMinute",  editorName = "gearShootingEndLongitudeDMSMinuteField")
    protected NumberEditor gearShootingEndLongitudeDMSMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeSecond",  editorName = "gearShootingEndLongitudeDMSSecondField")
    protected NumberEditor gearShootingEndLongitudeDMSSecondField;
    protected CardLayout2Ext gearShootingEndLongitudeLayout;
    protected JPanel gearShootingEndLongitudePanel;
    protected SimpleTimeEditor gearShootingEndTimeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartDate",  editorName = "gearShootingStartDateField")
    protected JXDatePicker gearShootingStartDateField;
    protected JLabel gearShootingStartLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitude",  editorName = "gearShootingStartLatitudeDDField")
    protected NumberEditor gearShootingStartLatitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeDegree",  editorName = "gearShootingStartLatitudeDMSDegreeField")
    protected NumberEditor gearShootingStartLatitudeDMSDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeMinute",  editorName = "gearShootingStartLatitudeDMSMinuteField")
    protected NumberEditor gearShootingStartLatitudeDMSMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeSecond",  editorName = "gearShootingStartLatitudeDMSSecondField")
    protected NumberEditor gearShootingStartLatitudeDMSSecondField;
    protected CardLayout2Ext gearShootingStartLatitudeLayout;
    protected JPanel gearShootingStartLatitudePanel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitude",  editorName = "gearShootingStartLongitudeDDField")
    protected NumberEditor gearShootingStartLongitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeDegree",  editorName = "gearShootingStartLongitudeDMSDegreeField")
    protected NumberEditor gearShootingStartLongitudeDMSDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeMinute",  editorName = "gearShootingStartLongitudeDMSMinuteField")
    protected NumberEditor gearShootingStartLongitudeDMSMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeSecond",  editorName = "gearShootingStartLongitudeDMSSecondField")
    protected NumberEditor gearShootingStartLongitudeDMSSecondField;
    protected CardLayout2Ext gearShootingStartLongitudeLayout;
    protected JPanel gearShootingStartLongitudePanel;
    protected SimpleTimeEditor gearShootingStartTimeField;
    protected GearShootingTabUI gearShootingTabContent;
    protected JLabel gearTimeLabel;
    protected Table generalForm;
    protected EditFishingOperationUIHandler handler;
    protected EditFishingOperationUI homePanel = this;
    protected HydrologyTabUI hydrologyTabContent;
    protected JButton importCasinoButton;
    protected BeanComboBox<FishingOperationLocation> locationComboBox;
    protected JLabel locationLabel;
    protected EditFishingOperationUIModel model;
    protected JLabel noTraitPane;
    protected JButton resetValidStateButton;
    @ValidatorField( validatorId = "validator",  propertyName = "saisisseur",  editorName = "saisisseurList")
    protected BeanDoubleList<Person> saisisseurList;
    protected JButton saveButton;
    @ValidatorField( validatorId = "validator",  propertyName = "stationNumber",  editorName = "stationNumberField")
    protected JTextField stationNumberField;
    protected JLabel stationNumberLabel;
    protected BeanComboBox<FishingOperationLocation> strataComboBox;
    protected JLabel strataLabel;
    protected BeanComboBox<FishingOperationLocation> subStrataComboBox;
    protected JLabel subStrataLabel;
    protected TabInfo traitGearShootingTab;
    protected TabInfo traitGeneralTab;
    protected TabInfo traitHydrologyTabContent;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditFishingOperationUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private HBox $HBox0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel10;
    private JPanel $JPanel11;
    private JPanel $JPanel12;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JPanel $JPanel4;
    private JPanel $JPanel5;
    private JPanel $JPanel6;
    private JPanel $JPanel7;
    private JPanel $JPanel8;
    private JPanel $JPanel9;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditFishingOperationUI(FishingOperationsUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            EditFishingOperationUIHandler handler = new EditFishingOperationUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public EditFishingOperationUI() {
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__fishingOperationInvalidRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(Boolean.FALSE);
    }

    public void doActionPerformed__on__fishingOperationValidRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(Boolean.TRUE);
    }

    public void doActionPerformed__on__gearShootingCoordinatesDDRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setUseSexagecimalFormat(false);
    }

    public void doActionPerformed__on__gearShootingCoordinatesDMSRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setUseSexagecimalFormat(true);
    }

    public void doActionPerformed__on__gearShootingEndDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "gearShootingEndDate");
    }

    public void doActionPerformed__on__gearShootingStartDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "gearShootingStartDate");
    }

    public void doActionPerformed__on__importCasinoButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importCasino();
    }

    public void doActionPerformed__on__resetValidStateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(null);
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doItemStateChanged__on__fishingOperationRectiligneCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "fishingOperationRectiligne");
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__stationNumberField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "stationNumber");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public JPanel getCreateFishingOperationActions() {
        return createFishingOperationActions;
    }

    public NumberEditor getDistanceChaluteeField() {
        return distanceChaluteeField;
    }

    public JLabel getDistanceChaluteeLabel() {
        return distanceChaluteeLabel;
    }

    public JTextField getDureeField() {
        return dureeField;
    }

    public JLabel getDureeLabel() {
        return dureeLabel;
    }

    public TabInfo getEnvironmentTab() {
        return environmentTab;
    }

    public EnvironmentTabUI getEnvironmentTabContent() {
        return environmentTabContent;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public JRadioButton getFishingOperationInvalidRadio() {
        return fishingOperationInvalidRadio;
    }

    public NumberEditor getFishingOperationNumberField() {
        return fishingOperationNumberField;
    }

    public JLabel getFishingOperationNumberLabel() {
        return fishingOperationNumberLabel;
    }

    public JPanel getFishingOperationPane() {
        return fishingOperationPane;
    }

    public JCheckBox getFishingOperationRectiligneCheckBox() {
        return fishingOperationRectiligneCheckBox;
    }

    public JRadioButton getFishingOperationResetRadio() {
        return fishingOperationResetRadio;
    }

    public JTabbedPane getFishingOperationTabPane() {
        return fishingOperationTabPane;
    }

    public JAXXButtonGroup getFishingOperationValid() {
        return fishingOperationValid;
    }

    public JToolBar getFishingOperationValidPanel() {
        return fishingOperationValidPanel;
    }

    public JRadioButton getFishingOperationValidRadio() {
        return fishingOperationValidRadio;
    }

    public Table getGearCaracteristicsTable() {
        return gearCaracteristicsTable;
    }

    public JLabel getGearDateLabel() {
        return gearDateLabel;
    }

    public JLabel getGearLatitudeLabel() {
        return gearLatitudeLabel;
    }

    public JLabel getGearLongitudeLabel() {
        return gearLongitudeLabel;
    }

    public JAXXButtonGroup getGearShootingCoordinates() {
        return gearShootingCoordinates;
    }

    public JRadioButton getGearShootingCoordinatesDDRadio() {
        return gearShootingCoordinatesDDRadio;
    }

    public JRadioButton getGearShootingCoordinatesDMSRadio() {
        return gearShootingCoordinatesDMSRadio;
    }

    public JXDatePicker getGearShootingEndDateField() {
        return gearShootingEndDateField;
    }

    public JLabel getGearShootingEndLabel() {
        return gearShootingEndLabel;
    }

    public NumberEditor getGearShootingEndLatitudeDDField() {
        return gearShootingEndLatitudeDDField;
    }

    public NumberEditor getGearShootingEndLatitudeDMSDegreeField() {
        return gearShootingEndLatitudeDMSDegreeField;
    }

    public NumberEditor getGearShootingEndLatitudeDMSMinuteField() {
        return gearShootingEndLatitudeDMSMinuteField;
    }

    public NumberEditor getGearShootingEndLatitudeDMSSecondField() {
        return gearShootingEndLatitudeDMSSecondField;
    }

    public CardLayout2Ext getGearShootingEndLatitudeLayout() {
        return gearShootingEndLatitudeLayout;
    }

    public JPanel getGearShootingEndLatitudePanel() {
        return gearShootingEndLatitudePanel;
    }

    public NumberEditor getGearShootingEndLongitudeDDField() {
        return gearShootingEndLongitudeDDField;
    }

    public NumberEditor getGearShootingEndLongitudeDMSDegreeField() {
        return gearShootingEndLongitudeDMSDegreeField;
    }

    public NumberEditor getGearShootingEndLongitudeDMSMinuteField() {
        return gearShootingEndLongitudeDMSMinuteField;
    }

    public NumberEditor getGearShootingEndLongitudeDMSSecondField() {
        return gearShootingEndLongitudeDMSSecondField;
    }

    public CardLayout2Ext getGearShootingEndLongitudeLayout() {
        return gearShootingEndLongitudeLayout;
    }

    public JPanel getGearShootingEndLongitudePanel() {
        return gearShootingEndLongitudePanel;
    }

    public SimpleTimeEditor getGearShootingEndTimeField() {
        return gearShootingEndTimeField;
    }

    public JXDatePicker getGearShootingStartDateField() {
        return gearShootingStartDateField;
    }

    public JLabel getGearShootingStartLabel() {
        return gearShootingStartLabel;
    }

    public NumberEditor getGearShootingStartLatitudeDDField() {
        return gearShootingStartLatitudeDDField;
    }

    public NumberEditor getGearShootingStartLatitudeDMSDegreeField() {
        return gearShootingStartLatitudeDMSDegreeField;
    }

    public NumberEditor getGearShootingStartLatitudeDMSMinuteField() {
        return gearShootingStartLatitudeDMSMinuteField;
    }

    public NumberEditor getGearShootingStartLatitudeDMSSecondField() {
        return gearShootingStartLatitudeDMSSecondField;
    }

    public CardLayout2Ext getGearShootingStartLatitudeLayout() {
        return gearShootingStartLatitudeLayout;
    }

    public JPanel getGearShootingStartLatitudePanel() {
        return gearShootingStartLatitudePanel;
    }

    public NumberEditor getGearShootingStartLongitudeDDField() {
        return gearShootingStartLongitudeDDField;
    }

    public NumberEditor getGearShootingStartLongitudeDMSDegreeField() {
        return gearShootingStartLongitudeDMSDegreeField;
    }

    public NumberEditor getGearShootingStartLongitudeDMSMinuteField() {
        return gearShootingStartLongitudeDMSMinuteField;
    }

    public NumberEditor getGearShootingStartLongitudeDMSSecondField() {
        return gearShootingStartLongitudeDMSSecondField;
    }

    public CardLayout2Ext getGearShootingStartLongitudeLayout() {
        return gearShootingStartLongitudeLayout;
    }

    public JPanel getGearShootingStartLongitudePanel() {
        return gearShootingStartLongitudePanel;
    }

    public SimpleTimeEditor getGearShootingStartTimeField() {
        return gearShootingStartTimeField;
    }

    public GearShootingTabUI getGearShootingTabContent() {
        return gearShootingTabContent;
    }

    public JLabel getGearTimeLabel() {
        return gearTimeLabel;
    }

    public Table getGeneralForm() {
        return generalForm;
    }

    public EditFishingOperationUIHandler getHandler() {
        return handler;
    }

    public HydrologyTabUI getHydrologyTabContent() {
        return hydrologyTabContent;
    }

    public JButton getImportCasinoButton() {
        return importCasinoButton;
    }

    public BeanComboBox<FishingOperationLocation> getLocationComboBox() {
        return locationComboBox;
    }

    public JLabel getLocationLabel() {
        return locationLabel;
    }

    public EditFishingOperationUIModel getModel() {
        return model;
    }

    public JLabel getNoTraitPane() {
        return noTraitPane;
    }

    public JButton getResetValidStateButton() {
        return resetValidStateButton;
    }

    public BeanDoubleList<Person> getSaisisseurList() {
        return saisisseurList;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JTextField getStationNumberField() {
        return stationNumberField;
    }

    public JLabel getStationNumberLabel() {
        return stationNumberLabel;
    }

    public BeanComboBox<FishingOperationLocation> getStrataComboBox() {
        return strataComboBox;
    }

    public JLabel getStrataLabel() {
        return strataLabel;
    }

    public BeanComboBox<FishingOperationLocation> getSubStrataComboBox() {
        return subStrataComboBox;
    }

    public JLabel getSubStrataLabel() {
        return subStrataLabel;
    }

    public TabInfo getTraitGearShootingTab() {
        return traitGearShootingTab;
    }

    public TabInfo getTraitGeneralTab() {
        return traitGeneralTab;
    }

    public TabInfo getTraitHydrologyTabContent() {
        return traitHydrologyTabContent;
    }

    public SwingValidator<EditFishingOperationUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel10() {
        return $JPanel10;
    }

    protected JPanel get$JPanel11() {
        return $JPanel11;
    }

    protected JPanel get$JPanel12() {
        return $JPanel12;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected JPanel get$JPanel6() {
        return $JPanel6;
    }

    protected JPanel get$JPanel7() {
        return $JPanel7;
    }

    protected JPanel get$JPanel8() {
        return $JPanel8;
    }

    protected JPanel get$JPanel9() {
        return $JPanel9;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(SwingUtil.boxComponentWithJxLayer(commentField));
    }

    protected void addChildrenToCreateFishingOperationActions() {
        if (!allComponentsCreated) {
            return;
        }
        createFishingOperationActions.add(cancelButton);
        createFishingOperationActions.add(saveButton);
    }

    protected void addChildrenToFishingOperationInvalidRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationInvalidRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationInvalidRadio); }
    }

    protected void addChildrenToFishingOperationPane() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationPane.add(fishingOperationTabPane, BorderLayout.CENTER);
        fishingOperationPane.add($JPanel12, BorderLayout.SOUTH);
    }

    protected void addChildrenToFishingOperationResetRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationResetRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationResetRadio); }
    }

    protected void addChildrenToFishingOperationTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationTabPane.add(generalForm);
        fishingOperationTabPane.add(gearShootingTabContent);
        fishingOperationTabPane.add(environmentTabContent);
        fishingOperationTabPane.add(hydrologyTabContent);
        traitGeneralTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 0));
        traitGearShootingTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 1));
        environmentTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 2));
        traitHydrologyTabContent.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 3));
    }

    protected void addChildrenToFishingOperationValidPanel() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationValidPanel.add(resetValidStateButton, BorderLayout.WEST);
        fishingOperationValidPanel.add(fishingOperationResetRadio, BorderLayout.EAST);
    }

    protected void addChildrenToFishingOperationValidRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationValidRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationValidRadio); }
    }

    protected void addChildrenToGearCaracteristicsTable() {
        if (!allComponentsCreated) {
            return;
        }
        gearCaracteristicsTable.add($JPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearLatitudeLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearLongitudeLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearDateLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearTimeLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLatitudePanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLongitudePanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartDateField), new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartTimeField, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLatitudePanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLongitudePanel, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndDateField, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndTimeField, new GridBagConstraints(4, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JLabel0, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(fishingOperationRectiligneCheckBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JPanel8, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JLabel1, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JPanel9, new GridBagConstraints(4, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(fishingOperationValidPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($HBox0, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JPanel10, new GridBagConstraints(2, 4, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToGearShootingCoordinatesDDRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = gearShootingCoordinates; gearShootingCoordinatesDDRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(gearShootingCoordinatesDDRadio); }
    }

    protected void addChildrenToGearShootingCoordinatesDMSRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = gearShootingCoordinates; gearShootingCoordinatesDMSRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(gearShootingCoordinatesDMSRadio); }
    }

    protected void addChildrenToGearShootingEndLatitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingEndLatitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDDField), "DD");
        gearShootingEndLatitudePanel.add($JPanel6, "DMS");
    }

    protected void addChildrenToGearShootingEndLongitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingEndLongitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDDField), "DD");
        gearShootingEndLongitudePanel.add($JPanel7, "DMS");
    }

    protected void addChildrenToGearShootingStartLatitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingStartLatitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDDField), "DD");
        gearShootingStartLatitudePanel.add($JPanel4, "DMS");
    }

    protected void addChildrenToGearShootingStartLongitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingStartLongitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDDField), "DD");
        gearShootingStartLongitudePanel.add($JPanel5, "DMS");
    }

    protected void addChildrenToGeneralForm() {
        if (!allComponentsCreated) {
            return;
        }
        generalForm.add($Table0, new GridBagConstraints(0, 0, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(strataLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(strataComboBox, new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(subStrataLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(subStrataComboBox, new GridBagConstraints(3, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(locationLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(locationComboBox, new GridBagConstraints(5, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel2, new GridBagConstraints(0, 2, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel11, new GridBagConstraints(0, 3, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(saisisseurList), new GridBagConstraints(0, 4, 6, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(commentPane, new GridBagConstraints(0, 5, 6, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(fishingOperationPane, BorderLayout.CENTER);
        add(noTraitPane);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.action.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
    }

    protected void createCreateFishingOperationActions() {
        $objectMap.put("createFishingOperationActions", createFishingOperationActions = new JPanel());
        
        createFishingOperationActions.setName("createFishingOperationActions");
        createFishingOperationActions.setLayout(new GridLayout(1,0));
    }

    protected void createDistanceChaluteeField() {
        $objectMap.put("distanceChaluteeField", distanceChaluteeField = new NumberEditor(this));
        
        distanceChaluteeField.setName("distanceChaluteeField");
        distanceChaluteeField.setProperty("distanceChalutee");
        distanceChaluteeField.setUseFloat(false);
        distanceChaluteeField.setShowReset(true);
    }

    protected void createDistanceChaluteeLabel() {
        $objectMap.put("distanceChaluteeLabel", distanceChaluteeLabel = new JLabel());
        
        distanceChaluteeLabel.setName("distanceChaluteeLabel");
        distanceChaluteeLabel.setText(_("tutti.label.fishingOperation.distanceChalutee"));
    }

    protected void createDureeField() {
        $objectMap.put("dureeField", dureeField = new JTextField());
        
        dureeField.setName("dureeField");
        dureeField.setColumns(15);
        dureeField.setEnabled(false);
    }

    protected void createDureeLabel() {
        $objectMap.put("dureeLabel", dureeLabel = new JLabel());
        
        dureeLabel.setName("dureeLabel");
        dureeLabel.setText(_("tutti.label.fishingOperation.duree"));
    }

    protected void createEnvironmentTab() {
        $objectMap.put("environmentTab", environmentTab = new TabInfo());
    }

    protected void createEnvironmentTabContent() {
        $objectMap.put("environmentTabContent", environmentTabContent = new EnvironmentTabUI(this));
        
        environmentTabContent.setName("environmentTabContent");
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createFishingOperationInvalidRadio() {
        $objectMap.put("fishingOperationInvalidRadio", fishingOperationInvalidRadio = new JRadioButton());
        
        fishingOperationInvalidRadio.setName("fishingOperationInvalidRadio");
        fishingOperationInvalidRadio.setText(_("tutti.label.fishingOperation.fishingOperationInvalid"));
        fishingOperationInvalidRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fishingOperationInvalidRadio"));
    }

    protected void createFishingOperationNumberField() {
        $objectMap.put("fishingOperationNumberField", fishingOperationNumberField = new NumberEditor(this));
        
        fishingOperationNumberField.setName("fishingOperationNumberField");
        fishingOperationNumberField.setProperty("fishingOperationNumber");
        fishingOperationNumberField.setUseFloat(false);
        fishingOperationNumberField.setShowReset(true);
    }

    protected void createFishingOperationNumberLabel() {
        $objectMap.put("fishingOperationNumberLabel", fishingOperationNumberLabel = new JLabel());
        
        fishingOperationNumberLabel.setName("fishingOperationNumberLabel");
        fishingOperationNumberLabel.setText(_("tutti.label.fishingOperation.fishingOperationNumber"));
    }

    protected void createFishingOperationPane() {
        $objectMap.put("fishingOperationPane", fishingOperationPane = new JPanel());
        
        fishingOperationPane.setName("fishingOperationPane");
        fishingOperationPane.setLayout(new BorderLayout());
    }

    protected void createFishingOperationRectiligneCheckBox() {
        $objectMap.put("fishingOperationRectiligneCheckBox", fishingOperationRectiligneCheckBox = new JCheckBox());
        
        fishingOperationRectiligneCheckBox.setName("fishingOperationRectiligneCheckBox");
        fishingOperationRectiligneCheckBox.setText(_("tutti.label.fishingOperation.fishingOperationRectiligne"));
        fishingOperationRectiligneCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fishingOperationRectiligneCheckBox"));
    }

    protected void createFishingOperationResetRadio() {
        $objectMap.put("fishingOperationResetRadio", fishingOperationResetRadio = new JRadioButton());
        
        fishingOperationResetRadio.setName("fishingOperationResetRadio");
    }

    protected void createFishingOperationTabPane() {
        $objectMap.put("fishingOperationTabPane", fishingOperationTabPane = new JTabbedPane());
        
        fishingOperationTabPane.setName("fishingOperationTabPane");
    }

    protected void createFishingOperationValid() {
        $objectMap.put("fishingOperationValid", fishingOperationValid = new JAXXButtonGroup());
    }

    protected void createFishingOperationValidPanel() {
        $objectMap.put("fishingOperationValidPanel", fishingOperationValidPanel = new JToolBar());
        
        fishingOperationValidPanel.setName("fishingOperationValidPanel");
        fishingOperationValidPanel.setLayout(new BorderLayout());
        fishingOperationValidPanel.setFloatable(false);
        fishingOperationValidPanel.setOpaque(false);
        fishingOperationValidPanel.setBorderPainted(false);
    }

    protected void createFishingOperationValidRadio() {
        $objectMap.put("fishingOperationValidRadio", fishingOperationValidRadio = new JRadioButton());
        
        fishingOperationValidRadio.setName("fishingOperationValidRadio");
        fishingOperationValidRadio.setText(_("tutti.label.fishingOperation.fishingOperationValid"));
        fishingOperationValidRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fishingOperationValidRadio"));
    }

    protected void createGearCaracteristicsTable() {
        $objectMap.put("gearCaracteristicsTable", gearCaracteristicsTable = new Table());
        
        gearCaracteristicsTable.setName("gearCaracteristicsTable");
    }

    protected void createGearDateLabel() {
        $objectMap.put("gearDateLabel", gearDateLabel = new JLabel());
        
        gearDateLabel.setName("gearDateLabel");
        gearDateLabel.setText(_("tutti.label.fishingOperation.gearDate"));
    }

    protected void createGearLatitudeLabel() {
        $objectMap.put("gearLatitudeLabel", gearLatitudeLabel = new JLabel());
        
        gearLatitudeLabel.setName("gearLatitudeLabel");
        gearLatitudeLabel.setText(_("tutti.label.fishingOperation.gearLatitude"));
    }

    protected void createGearLongitudeLabel() {
        $objectMap.put("gearLongitudeLabel", gearLongitudeLabel = new JLabel());
        
        gearLongitudeLabel.setName("gearLongitudeLabel");
        gearLongitudeLabel.setText(_("tutti.label.fishingOperation.gearLongitude"));
    }

    protected void createGearShootingCoordinates() {
        $objectMap.put("gearShootingCoordinates", gearShootingCoordinates = new JAXXButtonGroup());
    }

    protected void createGearShootingCoordinatesDDRadio() {
        $objectMap.put("gearShootingCoordinatesDDRadio", gearShootingCoordinatesDDRadio = new JRadioButton());
        
        gearShootingCoordinatesDDRadio.setName("gearShootingCoordinatesDDRadio");
        gearShootingCoordinatesDDRadio.setText(_("tutti.label.fishingOperation.gearShootingCoordinatesDD"));
        gearShootingCoordinatesDDRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearShootingCoordinatesDDRadio"));
    }

    protected void createGearShootingCoordinatesDMSRadio() {
        $objectMap.put("gearShootingCoordinatesDMSRadio", gearShootingCoordinatesDMSRadio = new JRadioButton());
        
        gearShootingCoordinatesDMSRadio.setName("gearShootingCoordinatesDMSRadio");
        gearShootingCoordinatesDMSRadio.setText(_("tutti.label.fishingOperation.gearShootingCoordinatesDMS"));
        gearShootingCoordinatesDMSRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearShootingCoordinatesDMSRadio"));
    }

    protected void createGearShootingEndDateField() {
        $objectMap.put("gearShootingEndDateField", gearShootingEndDateField = new JXDatePicker());
        
        gearShootingEndDateField.setName("gearShootingEndDateField");
        gearShootingEndDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearShootingEndDateField"));
    }

    protected void createGearShootingEndLabel() {
        $objectMap.put("gearShootingEndLabel", gearShootingEndLabel = new JLabel());
        
        gearShootingEndLabel.setName("gearShootingEndLabel");
        gearShootingEndLabel.setText(_("tutti.label.fishingOperation.gearShootingEnd"));
    }

    protected void createGearShootingEndLatitudeDDField() {
        $objectMap.put("gearShootingEndLatitudeDDField", gearShootingEndLatitudeDDField = new NumberEditor(this));
        
        gearShootingEndLatitudeDDField.setName("gearShootingEndLatitudeDDField");
        gearShootingEndLatitudeDDField.setUseSign(true);
        gearShootingEndLatitudeDDField.setProperty("gearShootingEndLatitude");
        gearShootingEndLatitudeDDField.setUseFloat(true);
        gearShootingEndLatitudeDDField.setShowReset(false);
    }

    protected void createGearShootingEndLatitudeDMSDegreeField() {
        $objectMap.put("gearShootingEndLatitudeDMSDegreeField", gearShootingEndLatitudeDMSDegreeField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMSDegreeField.setName("gearShootingEndLatitudeDMSDegreeField");
        gearShootingEndLatitudeDMSDegreeField.setUseSign(true);
        gearShootingEndLatitudeDMSDegreeField.setProperty("gearShootingEndLatitudeDegree");
        gearShootingEndLatitudeDMSDegreeField.setUseFloat(false);
        gearShootingEndLatitudeDMSDegreeField.setShowReset(false);
    }

    protected void createGearShootingEndLatitudeDMSMinuteField() {
        $objectMap.put("gearShootingEndLatitudeDMSMinuteField", gearShootingEndLatitudeDMSMinuteField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMSMinuteField.setName("gearShootingEndLatitudeDMSMinuteField");
        gearShootingEndLatitudeDMSMinuteField.setUseSign(false);
        gearShootingEndLatitudeDMSMinuteField.setProperty("gearShootingEndLatitudeMinute");
        gearShootingEndLatitudeDMSMinuteField.setUseFloat(false);
        gearShootingEndLatitudeDMSMinuteField.setShowReset(false);
    }

    protected void createGearShootingEndLatitudeDMSSecondField() {
        $objectMap.put("gearShootingEndLatitudeDMSSecondField", gearShootingEndLatitudeDMSSecondField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMSSecondField.setName("gearShootingEndLatitudeDMSSecondField");
        gearShootingEndLatitudeDMSSecondField.setUseSign(false);
        gearShootingEndLatitudeDMSSecondField.setProperty("gearShootingEndLatitudeSecond");
        gearShootingEndLatitudeDMSSecondField.setUseFloat(false);
        gearShootingEndLatitudeDMSSecondField.setShowReset(false);
    }

    protected void createGearShootingEndLatitudeLayout() {
        $objectMap.put("gearShootingEndLatitudeLayout", gearShootingEndLatitudeLayout = new CardLayout2Ext(this, "gearShootingEndLatitudePanel"));
    }

    protected void createGearShootingEndLatitudePanel() {
        $objectMap.put("gearShootingEndLatitudePanel", gearShootingEndLatitudePanel = new JPanel());
        
        gearShootingEndLatitudePanel.setName("gearShootingEndLatitudePanel");
        gearShootingEndLatitudePanel.setLayout(gearShootingEndLatitudeLayout);
    }

    protected void createGearShootingEndLongitudeDDField() {
        $objectMap.put("gearShootingEndLongitudeDDField", gearShootingEndLongitudeDDField = new NumberEditor(this));
        
        gearShootingEndLongitudeDDField.setName("gearShootingEndLongitudeDDField");
        gearShootingEndLongitudeDDField.setUseSign(true);
        gearShootingEndLongitudeDDField.setProperty("gearShootingEndLongitude");
        gearShootingEndLongitudeDDField.setUseFloat(true);
        gearShootingEndLongitudeDDField.setShowReset(false);
    }

    protected void createGearShootingEndLongitudeDMSDegreeField() {
        $objectMap.put("gearShootingEndLongitudeDMSDegreeField", gearShootingEndLongitudeDMSDegreeField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMSDegreeField.setName("gearShootingEndLongitudeDMSDegreeField");
        gearShootingEndLongitudeDMSDegreeField.setUseSign(true);
        gearShootingEndLongitudeDMSDegreeField.setProperty("gearShootingEndLongitudeDegree");
        gearShootingEndLongitudeDMSDegreeField.setUseFloat(false);
        gearShootingEndLongitudeDMSDegreeField.setShowReset(false);
    }

    protected void createGearShootingEndLongitudeDMSMinuteField() {
        $objectMap.put("gearShootingEndLongitudeDMSMinuteField", gearShootingEndLongitudeDMSMinuteField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMSMinuteField.setName("gearShootingEndLongitudeDMSMinuteField");
        gearShootingEndLongitudeDMSMinuteField.setUseSign(false);
        gearShootingEndLongitudeDMSMinuteField.setProperty("gearShootingEndLongitudeMinute");
        gearShootingEndLongitudeDMSMinuteField.setUseFloat(false);
        gearShootingEndLongitudeDMSMinuteField.setShowReset(false);
    }

    protected void createGearShootingEndLongitudeDMSSecondField() {
        $objectMap.put("gearShootingEndLongitudeDMSSecondField", gearShootingEndLongitudeDMSSecondField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMSSecondField.setName("gearShootingEndLongitudeDMSSecondField");
        gearShootingEndLongitudeDMSSecondField.setUseSign(false);
        gearShootingEndLongitudeDMSSecondField.setProperty("gearShootingEndLongitudeSecond");
        gearShootingEndLongitudeDMSSecondField.setUseFloat(false);
        gearShootingEndLongitudeDMSSecondField.setShowReset(false);
    }

    protected void createGearShootingEndLongitudeLayout() {
        $objectMap.put("gearShootingEndLongitudeLayout", gearShootingEndLongitudeLayout = new CardLayout2Ext(this, "gearShootingEndLongitudePanel"));
    }

    protected void createGearShootingEndLongitudePanel() {
        $objectMap.put("gearShootingEndLongitudePanel", gearShootingEndLongitudePanel = new JPanel());
        
        gearShootingEndLongitudePanel.setName("gearShootingEndLongitudePanel");
        gearShootingEndLongitudePanel.setLayout(gearShootingEndLongitudeLayout);
    }

    protected void createGearShootingEndTimeField() {
        $objectMap.put("gearShootingEndTimeField", gearShootingEndTimeField = new SimpleTimeEditor(this));
        
        gearShootingEndTimeField.setName("gearShootingEndTimeField");
        gearShootingEndTimeField.setProperty("gearShootingEndDate");
    }

    protected void createGearShootingStartDateField() {
        $objectMap.put("gearShootingStartDateField", gearShootingStartDateField = new JXDatePicker());
        
        gearShootingStartDateField.setName("gearShootingStartDateField");
        gearShootingStartDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearShootingStartDateField"));
    }

    protected void createGearShootingStartLabel() {
        $objectMap.put("gearShootingStartLabel", gearShootingStartLabel = new JLabel());
        
        gearShootingStartLabel.setName("gearShootingStartLabel");
        gearShootingStartLabel.setText(_("tutti.label.fishingOperation.gearShootingStart"));
    }

    protected void createGearShootingStartLatitudeDDField() {
        $objectMap.put("gearShootingStartLatitudeDDField", gearShootingStartLatitudeDDField = new NumberEditor(this));
        
        gearShootingStartLatitudeDDField.setName("gearShootingStartLatitudeDDField");
        gearShootingStartLatitudeDDField.setUseSign(true);
        gearShootingStartLatitudeDDField.setProperty("gearShootingStartLatitude");
        gearShootingStartLatitudeDDField.setUseFloat(true);
        gearShootingStartLatitudeDDField.setShowReset(false);
    }

    protected void createGearShootingStartLatitudeDMSDegreeField() {
        $objectMap.put("gearShootingStartLatitudeDMSDegreeField", gearShootingStartLatitudeDMSDegreeField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMSDegreeField.setName("gearShootingStartLatitudeDMSDegreeField");
        gearShootingStartLatitudeDMSDegreeField.setUseSign(true);
        gearShootingStartLatitudeDMSDegreeField.setProperty("gearShootingStartLatitudeDegree");
        gearShootingStartLatitudeDMSDegreeField.setUseFloat(false);
        gearShootingStartLatitudeDMSDegreeField.setShowReset(false);
    }

    protected void createGearShootingStartLatitudeDMSMinuteField() {
        $objectMap.put("gearShootingStartLatitudeDMSMinuteField", gearShootingStartLatitudeDMSMinuteField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMSMinuteField.setName("gearShootingStartLatitudeDMSMinuteField");
        gearShootingStartLatitudeDMSMinuteField.setUseSign(false);
        gearShootingStartLatitudeDMSMinuteField.setProperty("gearShootingStartLatitudeMinute");
        gearShootingStartLatitudeDMSMinuteField.setUseFloat(false);
        gearShootingStartLatitudeDMSMinuteField.setShowReset(false);
    }

    protected void createGearShootingStartLatitudeDMSSecondField() {
        $objectMap.put("gearShootingStartLatitudeDMSSecondField", gearShootingStartLatitudeDMSSecondField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMSSecondField.setName("gearShootingStartLatitudeDMSSecondField");
        gearShootingStartLatitudeDMSSecondField.setUseSign(false);
        gearShootingStartLatitudeDMSSecondField.setProperty("gearShootingStartLatitudeSecond");
        gearShootingStartLatitudeDMSSecondField.setUseFloat(false);
        gearShootingStartLatitudeDMSSecondField.setShowReset(false);
    }

    protected void createGearShootingStartLatitudeLayout() {
        $objectMap.put("gearShootingStartLatitudeLayout", gearShootingStartLatitudeLayout = new CardLayout2Ext(this, "gearShootingStartLatitudePanel"));
    }

    protected void createGearShootingStartLatitudePanel() {
        $objectMap.put("gearShootingStartLatitudePanel", gearShootingStartLatitudePanel = new JPanel());
        
        gearShootingStartLatitudePanel.setName("gearShootingStartLatitudePanel");
        gearShootingStartLatitudePanel.setLayout(gearShootingStartLatitudeLayout);
    }

    protected void createGearShootingStartLongitudeDDField() {
        $objectMap.put("gearShootingStartLongitudeDDField", gearShootingStartLongitudeDDField = new NumberEditor(this));
        
        gearShootingStartLongitudeDDField.setName("gearShootingStartLongitudeDDField");
        gearShootingStartLongitudeDDField.setUseSign(true);
        gearShootingStartLongitudeDDField.setProperty("gearShootingStartLongitude");
        gearShootingStartLongitudeDDField.setUseFloat(true);
        gearShootingStartLongitudeDDField.setShowReset(false);
    }

    protected void createGearShootingStartLongitudeDMSDegreeField() {
        $objectMap.put("gearShootingStartLongitudeDMSDegreeField", gearShootingStartLongitudeDMSDegreeField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMSDegreeField.setName("gearShootingStartLongitudeDMSDegreeField");
        gearShootingStartLongitudeDMSDegreeField.setUseSign(true);
        gearShootingStartLongitudeDMSDegreeField.setProperty("gearShootingStartLongitudeDegree");
        gearShootingStartLongitudeDMSDegreeField.setUseFloat(false);
        gearShootingStartLongitudeDMSDegreeField.setShowReset(false);
    }

    protected void createGearShootingStartLongitudeDMSMinuteField() {
        $objectMap.put("gearShootingStartLongitudeDMSMinuteField", gearShootingStartLongitudeDMSMinuteField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMSMinuteField.setName("gearShootingStartLongitudeDMSMinuteField");
        gearShootingStartLongitudeDMSMinuteField.setUseSign(false);
        gearShootingStartLongitudeDMSMinuteField.setProperty("gearShootingStartLongitudeMinute");
        gearShootingStartLongitudeDMSMinuteField.setUseFloat(false);
        gearShootingStartLongitudeDMSMinuteField.setShowReset(false);
    }

    protected void createGearShootingStartLongitudeDMSSecondField() {
        $objectMap.put("gearShootingStartLongitudeDMSSecondField", gearShootingStartLongitudeDMSSecondField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMSSecondField.setName("gearShootingStartLongitudeDMSSecondField");
        gearShootingStartLongitudeDMSSecondField.setUseSign(false);
        gearShootingStartLongitudeDMSSecondField.setProperty("gearShootingStartLongitudeSecond");
        gearShootingStartLongitudeDMSSecondField.setUseFloat(false);
        gearShootingStartLongitudeDMSSecondField.setShowReset(false);
    }

    protected void createGearShootingStartLongitudeLayout() {
        $objectMap.put("gearShootingStartLongitudeLayout", gearShootingStartLongitudeLayout = new CardLayout2Ext(this, "gearShootingStartLongitudePanel"));
    }

    protected void createGearShootingStartLongitudePanel() {
        $objectMap.put("gearShootingStartLongitudePanel", gearShootingStartLongitudePanel = new JPanel());
        
        gearShootingStartLongitudePanel.setName("gearShootingStartLongitudePanel");
        gearShootingStartLongitudePanel.setLayout(gearShootingStartLongitudeLayout);
    }

    protected void createGearShootingStartTimeField() {
        $objectMap.put("gearShootingStartTimeField", gearShootingStartTimeField = new SimpleTimeEditor(this));
        
        gearShootingStartTimeField.setName("gearShootingStartTimeField");
        gearShootingStartTimeField.setProperty("gearShootingStartDate");
    }

    protected void createGearShootingTabContent() {
        $objectMap.put("gearShootingTabContent", gearShootingTabContent = new GearShootingTabUI(this));
        
        gearShootingTabContent.setName("gearShootingTabContent");
    }

    protected void createGearTimeLabel() {
        $objectMap.put("gearTimeLabel", gearTimeLabel = new JLabel());
        
        gearTimeLabel.setName("gearTimeLabel");
        gearTimeLabel.setText(_("tutti.label.fishingOperation.gearTime"));
    }

    protected void createGeneralForm() {
        $objectMap.put("generalForm", generalForm = new Table());
        
        generalForm.setName("generalForm");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditFishingOperationUIHandler.class));
    }

    protected void createHydrologyTabContent() {
        $objectMap.put("hydrologyTabContent", hydrologyTabContent = new HydrologyTabUI(this));
        
        hydrologyTabContent.setName("hydrologyTabContent");
    }

    protected void createImportCasinoButton() {
        $objectMap.put("importCasinoButton", importCasinoButton = new JButton());
        
        importCasinoButton.setName("importCasinoButton");
        importCasinoButton.setText(_("tutti.action.casino-import"));
        importCasinoButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importCasinoButton"));
    }

    protected void createLocationComboBox() {
        $objectMap.put("locationComboBox", locationComboBox = new BeanComboBox<FishingOperationLocation>(this));
        
        locationComboBox.setName("locationComboBox");
        locationComboBox.setI18nPrefix("tutti.property.");
        locationComboBox.setProperty("location");
        locationComboBox.setShowReset(true);
    }

    protected void createLocationLabel() {
        $objectMap.put("locationLabel", locationLabel = new JLabel());
        
        locationLabel.setName("locationLabel");
        locationLabel.setText(_("tutti.label.fishingOperation.location"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditFishingOperationUIModel.class));
    }

    protected void createNoTraitPane() {
        $objectMap.put("noTraitPane", noTraitPane = new JLabel());
        
        noTraitPane.setName("noTraitPane");
        noTraitPane.setText(_("tutti.label.no.fishingOperation.selected"));
    }

    protected void createResetValidStateButton() {
        $objectMap.put("resetValidStateButton", resetValidStateButton = new JButton());
        
        resetValidStateButton.setName("resetValidStateButton");
        resetValidStateButton.setText(_("tutti.action.reset.fishingOperationValidState"));
        resetValidStateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetValidStateButton"));
    }

    protected void createSaisisseurList() {
        $objectMap.put("saisisseurList", saisisseurList = new BeanDoubleList<Person>());
        
        saisisseurList.setName("saisisseurList");
        saisisseurList.setProperty("saisisseur");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.action.save"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createStationNumberField() {
        $objectMap.put("stationNumberField", stationNumberField = new JTextField());
        
        stationNumberField.setName("stationNumberField");
        stationNumberField.setColumns(15);
        stationNumberField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__stationNumberField"));
    }

    protected void createStationNumberLabel() {
        $objectMap.put("stationNumberLabel", stationNumberLabel = new JLabel());
        
        stationNumberLabel.setName("stationNumberLabel");
        stationNumberLabel.setText(_("tutti.label.fishingOperation.stationNumber"));
    }

    protected void createStrataComboBox() {
        $objectMap.put("strataComboBox", strataComboBox = new BeanComboBox<FishingOperationLocation>(this));
        
        strataComboBox.setName("strataComboBox");
        strataComboBox.setI18nPrefix("tutti.property.");
        strataComboBox.setProperty("strata");
        strataComboBox.setShowReset(true);
    }

    protected void createStrataLabel() {
        $objectMap.put("strataLabel", strataLabel = new JLabel());
        
        strataLabel.setName("strataLabel");
        strataLabel.setText(_("tutti.label.fishingOperation.strata"));
    }

    protected void createSubStrataComboBox() {
        $objectMap.put("subStrataComboBox", subStrataComboBox = new BeanComboBox<FishingOperationLocation>(this));
        
        subStrataComboBox.setName("subStrataComboBox");
        subStrataComboBox.setI18nPrefix("tutti.property.");
        subStrataComboBox.setProperty("subStrata");
        subStrataComboBox.setShowReset(true);
    }

    protected void createSubStrataLabel() {
        $objectMap.put("subStrataLabel", subStrataLabel = new JLabel());
        
        subStrataLabel.setName("subStrataLabel");
        subStrataLabel.setText(_("tutti.label.fishingOperation.subStrata"));
    }

    protected void createTraitGearShootingTab() {
        $objectMap.put("traitGearShootingTab", traitGearShootingTab = new TabInfo());
    }

    protected void createTraitGeneralTab() {
        $objectMap.put("traitGeneralTab", traitGeneralTab = new TabInfo());
    }

    protected void createTraitHydrologyTabContent() {
        $objectMap.put("traitHydrologyTabContent", traitHydrologyTabContent = new TabInfo());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditFishingOperationUIModel.class, "validate"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToFishingOperationPane();
        addChildrenToFishingOperationTabPane();
        addChildrenToGeneralForm();
        // inline complete setup of $Table0
        $Table0.add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(stationNumberLabel, BorderLayout.WEST);
        $JPanel0.add(SwingUtil.boxComponentWithJxLayer(stationNumberField), BorderLayout.CENTER);
        // inline complete setup of $JPanel1
        $JPanel1.add(fishingOperationNumberLabel, BorderLayout.WEST);
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(fishingOperationNumberField), BorderLayout.CENTER);
        // inline complete setup of $JPanel2
        $JPanel2.add(gearCaracteristicsTable, BorderLayout.CENTER);
        addChildrenToGearCaracteristicsTable();
        // inline complete setup of $JPanel3
        $JPanel3.add(gearShootingCoordinatesDDRadio);
        $JPanel3.add(gearShootingCoordinatesDMSRadio);
        addChildrenToGearShootingCoordinatesDDRadio();
        addChildrenToGearShootingCoordinatesDMSRadio();
        addChildrenToGearShootingStartLatitudePanel();
        // inline complete setup of $JPanel4
        $JPanel4.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMSDegreeField));
        $JPanel4.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMSMinuteField));
        $JPanel4.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMSSecondField));
        addChildrenToGearShootingStartLongitudePanel();
        // inline complete setup of $JPanel5
        $JPanel5.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMSDegreeField));
        $JPanel5.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMSMinuteField));
        $JPanel5.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMSSecondField));
        addChildrenToGearShootingEndLatitudePanel();
        // inline complete setup of $JPanel6
        $JPanel6.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMSDegreeField));
        $JPanel6.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMSMinuteField));
        $JPanel6.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMSSecondField));
        addChildrenToGearShootingEndLongitudePanel();
        // inline complete setup of $JPanel7
        $JPanel7.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMSDegreeField));
        $JPanel7.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMSMinuteField));
        $JPanel7.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMSSecondField));
        // inline complete setup of $JPanel8
        $JPanel8.add(distanceChaluteeLabel, BorderLayout.WEST);
        $JPanel8.add(distanceChaluteeField, BorderLayout.CENTER);
        // inline complete setup of $JPanel9
        $JPanel9.add(dureeLabel, BorderLayout.WEST);
        $JPanel9.add(dureeField, BorderLayout.CENTER);
        addChildrenToFishingOperationValidPanel();
        addChildrenToFishingOperationResetRadio();
        // inline complete setup of $HBox0
        $HBox0.add(fishingOperationValidRadio);
        $HBox0.add(fishingOperationInvalidRadio);
        addChildrenToFishingOperationValidRadio();
        addChildrenToFishingOperationInvalidRadio();
        // inline complete setup of $JPanel11
        $JPanel11.add(importCasinoButton);
        addChildrenToCommentPane();
        // inline complete setup of $JPanel12
        $JPanel12.add(createFishingOperationActions, BorderLayout.CENTER);
        addChildrenToCreateFishingOperationActions();
        
        // apply 55 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 101 property setters
        strataComboBox.setBeanType(FishingOperationLocation.class);
        subStrataComboBox.setBeanType(FishingOperationLocation.class);
        locationComboBox.setBeanType(FishingOperationLocation.class);
        saisisseurList.setBeanType(Person.class);
        stationNumberLabel.setLabelFor(stationNumberField);
        fishingOperationNumberLabel.setLabelFor(fishingOperationNumberField);
        fishingOperationNumberField.setBean(model);
        fishingOperationNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        fishingOperationNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        strataLabel.setLabelFor(strataComboBox);
        strataComboBox.setBean(model);
        subStrataLabel.setLabelFor(subStrataComboBox);
        subStrataComboBox.setBean(model);
        locationLabel.setLabelFor(locationComboBox);
        locationComboBox.setBean(model);
        gearShootingStartLatitudeDDField.setBean(model);
        gearShootingStartLatitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMSDegreeField.setBean(model);
        gearShootingStartLatitudeDMSDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMSDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMSMinuteField.setBean(model);
        gearShootingStartLatitudeDMSMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMSMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMSSecondField.setBean(model);
        gearShootingStartLatitudeDMSSecondField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMSSecondField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDDField.setBean(model);
        gearShootingStartLongitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMSDegreeField.setBean(model);
        gearShootingStartLongitudeDMSDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMSDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMSMinuteField.setBean(model);
        gearShootingStartLongitudeDMSMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMSMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMSSecondField.setBean(model);
        gearShootingStartLongitudeDMSSecondField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMSSecondField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartDateField.setFormats("dd/MM/yyyy");
        gearShootingStartTimeField.setBean(model);
        gearShootingEndLatitudeDDField.setBean(model);
        gearShootingEndLatitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMSDegreeField.setBean(model);
        gearShootingEndLatitudeDMSDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMSDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMSMinuteField.setBean(model);
        gearShootingEndLatitudeDMSMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMSMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMSSecondField.setBean(model);
        gearShootingEndLatitudeDMSSecondField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMSSecondField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDDField.setBean(model);
        gearShootingEndLongitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMSDegreeField.setBean(model);
        gearShootingEndLongitudeDMSDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMSDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMSMinuteField.setBean(model);
        gearShootingEndLongitudeDMSMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMSMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMSSecondField.setBean(model);
        gearShootingEndLongitudeDMSSecondField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMSSecondField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndDateField.setFormats("dd/MM/yyyy");
        gearShootingEndTimeField.setBean(model);
        distanceChaluteeLabel.setLabelFor(distanceChaluteeField);
        distanceChaluteeField.setBean(model);
        distanceChaluteeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        distanceChaluteeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        dureeLabel.setLabelFor(dureeField);
        resetValidStateButton.setIcon(SwingUtil.createActionIcon("reset"));
        importCasinoButton.setIcon(SwingUtil.createActionIcon("casino-import"));
        saisisseurList.setBean(model);
        saisisseurList.setBorder(BorderFactory.createTitledBorder(_("tutti.label.list.saisisseur")));
        commentPane.setColumnHeaderView(new JLabel(_("tutti.label.comment")));
        commentPane.setMinimumSize(new Dimension(10,50));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        noTraitPane.setHorizontalAlignment(JLabel.CENTER);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createGearShootingStartLongitudeLayout();
        createGearShootingStartLatitudeLayout();
        createGearShootingEndLongitudeLayout();
        createGearShootingEndLatitudeLayout();
        createFishingOperationPane();
        createFishingOperationTabPane();
        createGeneralForm();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createStationNumberLabel();
        createStationNumberField();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createFishingOperationNumberLabel();
        createFishingOperationNumberField();
        createStrataLabel();
        createStrataComboBox();
        createSubStrataLabel();
        createSubStrataComboBox();
        createLocationLabel();
        createLocationComboBox();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new BorderLayout());
        createGearCaracteristicsTable();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createGearShootingCoordinatesDDRadio();
        createGearShootingCoordinatesDMSRadio();
        createGearLatitudeLabel();
        createGearLongitudeLabel();
        createGearDateLabel();
        createGearTimeLabel();
        createGearShootingStartLabel();
        createGearShootingStartLatitudePanel();
        createGearShootingStartLatitudeDDField();
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new JPanel());
        
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout(new GridLayout(1,0));
        createGearShootingStartLatitudeDMSDegreeField();
        createGearShootingStartLatitudeDMSMinuteField();
        createGearShootingStartLatitudeDMSSecondField();
        createGearShootingStartLongitudePanel();
        createGearShootingStartLongitudeDDField();
        // inline creation of $JPanel5
        $objectMap.put("$JPanel5", $JPanel5 = new JPanel());
        
        $JPanel5.setName("$JPanel5");
        $JPanel5.setLayout(new GridLayout(1,0));
        createGearShootingStartLongitudeDMSDegreeField();
        createGearShootingStartLongitudeDMSMinuteField();
        createGearShootingStartLongitudeDMSSecondField();
        createGearShootingStartDateField();
        createGearShootingStartTimeField();
        createGearShootingEndLabel();
        createGearShootingEndLatitudePanel();
        createGearShootingEndLatitudeDDField();
        // inline creation of $JPanel6
        $objectMap.put("$JPanel6", $JPanel6 = new JPanel());
        
        $JPanel6.setName("$JPanel6");
        $JPanel6.setLayout(new GridLayout(1,0));
        createGearShootingEndLatitudeDMSDegreeField();
        createGearShootingEndLatitudeDMSMinuteField();
        createGearShootingEndLatitudeDMSSecondField();
        createGearShootingEndLongitudePanel();
        createGearShootingEndLongitudeDDField();
        // inline creation of $JPanel7
        $objectMap.put("$JPanel7", $JPanel7 = new JPanel());
        
        $JPanel7.setName("$JPanel7");
        $JPanel7.setLayout(new GridLayout(1,0));
        createGearShootingEndLongitudeDMSDegreeField();
        createGearShootingEndLongitudeDMSMinuteField();
        createGearShootingEndLongitudeDMSSecondField();
        createGearShootingEndDateField();
        createGearShootingEndTimeField();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createFishingOperationRectiligneCheckBox();
        // inline creation of $JPanel8
        $objectMap.put("$JPanel8", $JPanel8 = new JPanel());
        
        $JPanel8.setName("$JPanel8");
        $JPanel8.setLayout(new BorderLayout());
        createDistanceChaluteeLabel();
        createDistanceChaluteeField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        // inline creation of $JPanel9
        $objectMap.put("$JPanel9", $JPanel9 = new JPanel());
        
        $JPanel9.setName("$JPanel9");
        $JPanel9.setLayout(new BorderLayout());
        createDureeLabel();
        createDureeField();
        createFishingOperationValidPanel();
        createResetValidStateButton();
        createFishingOperationResetRadio();
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        createFishingOperationValidRadio();
        createFishingOperationInvalidRadio();
        // inline creation of $JPanel10
        $objectMap.put("$JPanel10", $JPanel10 = new JPanel());
        
        $JPanel10.setName("$JPanel10");
        // inline creation of $JPanel11
        $objectMap.put("$JPanel11", $JPanel11 = new JPanel());
        
        $JPanel11.setName("$JPanel11");
        $JPanel11.setLayout(new GridLayout(1,0));
        createImportCasinoButton();
        createSaisisseurList();
        createCommentPane();
        createCommentField();
        createGearShootingTabContent();
        createEnvironmentTabContent();
        createHydrologyTabContent();
        // inline creation of $JPanel12
        $objectMap.put("$JPanel12", $JPanel12 = new JPanel());
        
        $JPanel12.setName("$JPanel12");
        $JPanel12.setLayout(new BorderLayout());
        createCreateFishingOperationActions();
        createCancelButton();
        createSaveButton();
        createNoTraitPane();
        createTraitGeneralTab();
        createTraitGearShootingTab();
        createEnvironmentTab();
        createTraitHydrologyTabContent();
        createGearShootingCoordinates();
        createFishingOperationValid();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 55 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 55 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("useSexagecimalFormat", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeLayout.setSelected(model.isUseSexagecimalFormat() ? "DMS" : "DD");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("useSexagecimalFormat", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("useSexagecimalFormat", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeLayout.setSelected(model.isUseSexagecimalFormat() ? "DMS" : "DD");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("useSexagecimalFormat", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("useSexagecimalFormat", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeLayout.setSelected(model.isUseSexagecimalFormat() ? "DMS" : "DD");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("useSexagecimalFormat", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("useSexagecimalFormat", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeLayout.setSelected(model.isUseSexagecimalFormat() ? "DMS" : "DD");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("useSexagecimalFormat", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATION_NUMBER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("stationNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(stationNumberField, model.getStationNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("stationNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_NUMBER_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationNumberField.setModel(model.getFishingOperationNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationNumber", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FISHING_OPERATION_NUMBER_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                fishingOperationNumberField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STRATA_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("strata", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    strataComboBox.setSelectedItem(model.getStrata());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("strata", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SUB_STRATA_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("subStrata", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    subStrataComboBox.setSelectedItem(model.getSubStrata());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("subStrata", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LOCATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("location", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    locationComboBox.setSelectedItem(model.getLocation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("location", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_COORDINATES_DDRADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("useSexagecimalFormat", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingCoordinatesDDRadio.setSelected(!model.isUseSexagecimalFormat());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("useSexagecimalFormat", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_COORDINATES_DMSRADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("useSexagecimalFormat", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingCoordinatesDMSRadio.setSelected(model.isUseSexagecimalFormat());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("useSexagecimalFormat", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDDField.setModel(model.getGearShootingStartLatitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMSDegreeField.setModel(model.getGearShootingStartLatitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMSDegreeField.setNumberPattern("-?" + INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMSMinuteField.setModel(model.getGearShootingStartLatitudeMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMSMinuteField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSSECOND_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeSecond", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMSSecondField.setModel(model.getGearShootingStartLatitudeSecond());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeSecond", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSSECOND_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMSSecondField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDDField.setModel(model.getGearShootingStartLongitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMSDegreeField.setModel(model.getGearShootingStartLongitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN, true ,"INT_3_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMSDegreeField.setNumberPattern("-?" + INT_3_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMSMinuteField.setModel(model.getGearShootingStartLongitudeMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMSMinuteField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSSECOND_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeSecond", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMSSecondField.setModel(model.getGearShootingStartLongitudeSecond());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeSecond", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSSECOND_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMSSecondField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartDateField.setDate(model.getGearShootingStartDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_TIME_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartTimeField.setDate(model.getGearShootingStartDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDDField.setModel(model.getGearShootingEndLatitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMSDegreeField.setModel(model.getGearShootingEndLatitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMSDegreeField.setNumberPattern("-?" + INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMSMinuteField.setModel(model.getGearShootingEndLatitudeMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMSMinuteField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSSECOND_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeSecond", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMSSecondField.setModel(model.getGearShootingEndLatitudeSecond());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeSecond", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSSECOND_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMSSecondField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDDField.setModel(model.getGearShootingEndLongitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMSDegreeField.setModel(model.getGearShootingEndLongitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN, true ,"INT_3_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMSDegreeField.setNumberPattern("-?" + INT_3_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMSMinuteField.setModel(model.getGearShootingEndLongitudeMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMSMinuteField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSSECOND_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeSecond", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMSSecondField.setModel(model.getGearShootingEndLongitudeSecond());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeSecond", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSSECOND_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMSSecondField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndDateField.setDate(model.getGearShootingEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_TIME_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndTimeField.setDate(model.getGearShootingEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_RECTILIGNE_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationRectiligneCheckBox.setSelected(model.isFishingOperationRectiligne());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISTANCE_CHALUTEE_FIELD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    distanceChaluteeField.setEnabled(!model.isFishingOperationRectiligne());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISTANCE_CHALUTEE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("distanceChalutee", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    distanceChaluteeField.setModel(model.getDistanceChalutee());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("distanceChalutee", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DISTANCE_CHALUTEE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                distanceChaluteeField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DUREE_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(dureeField, fr.ifremer.tutti.ui.swing.util.TuttiUIUtil.getDuration(
                          model.getGearShootingStartDate(), model.getGearShootingEndDate(), "tutti.duration.format"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_RESET_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationResetRadio.setSelected(model.getFishingOperationValid() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_VALID_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationValidRadio.setSelected(model.getFishingOperationValid() == Boolean.TRUE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_INVALID_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationInvalidRadio.setSelected(model.getFishingOperationValid() == Boolean.FALSE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, model.getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_FISHING_OPERATION_ACTIONS_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("persisted", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    createFishingOperationActions.setVisible(!model.isPersisted());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("persisted", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}