/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.editor;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.ComponentMover;
import fr.ifremer.tutti.ui.swing.util.ComponentResizer;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.editor.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class AttachmentCellComponent
extends JButton {
    private static final Log log = LogFactory.getLog(AttachmentCellComponent.class);
    private static final long serialVersionUID = 1L;

    public AttachmentCellComponent() {
        this.setContentAreaFilled(false);
        this.setOpaque(false);
        this.setIcon(SwingUtil.createActionIcon((String)"edit-attachment"));
    }

    public static TableCellRenderer newRender(Decorator<Attachment> decorator, String noneText) {
        return new AttachmentCellRenderer(decorator, noneText);
    }

    public static TableCellEditor newEditor(AttachmentEditorUI ui) {
        return new AttachmentCellEditor(ui);
    }

    public static class AttachmentCellRenderer
    implements TableCellRenderer {
        protected final AttachmentCellComponent component = new AttachmentCellComponent();
        public static final String TEXT_PATTERN = "<html><body>%s</body></html>";
        private final String noneText;
        private final Decorator<Attachment> decorator;
        protected String propertyName;

        public AttachmentCellRenderer(Decorator<Attachment> decorator, String noneText) {
            this.noneText = noneText;
            this.decorator = decorator;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String textValue;
            if (value == null) {
                if (this.propertyName == null) {
                    AbstractTuttiTableModel tableModel = (AbstractTuttiTableModel)table.getModel();
                    ColumnIdentifier columnIdentifier = tableModel.getPropertyName(column);
                    this.propertyName = columnIdentifier.getPropertyName();
                }
                textValue = "<i>" + I18n._((String)this.noneText, (Object[])new Object[0]) + "</i>";
            } else {
                Collection attachments = (Collection)value;
                StringBuilder sb = new StringBuilder();
                for (Attachment attachment : attachments) {
                    sb.append("<br/>").append(this.decorator.toString((Object)attachment));
                }
                textValue = sb.substring(5);
            }
            String text = String.format(TEXT_PATTERN, textValue);
            boolean editable = table.isCellEditable(row, column);
            this.component.setEnabled(editable);
            this.component.setToolTipText(text);
            return this.component;
        }
    }

    public static class AttachmentCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        protected final AttachmentCellComponent component;
        protected final AttachmentEditorUI ui;
        protected Frame frame;
        protected JTable table;
        protected AbstractTuttiTableModel<AbstractTuttiBeanUIModel> tableModel;
        protected ColumnIdentifier<AbstractTuttiBeanUIModel> columnIdentifier;
        protected AbstractTuttiBeanUIModel editRow;
        protected Integer rowIndex;
        protected Integer columnIndex;

        public AttachmentCellEditor(AttachmentEditorUI ui) {
            this.ui = ui;
            this.component = new AttachmentCellComponent();
            this.component.setBorder(new LineBorder(Color.BLACK));
            this.component.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        e.consume();
                        AttachmentCellEditor.this.startEdit();
                    }
                }
            });
            this.component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.consume();
                    AttachmentCellEditor.this.startEdit();
                }
            });
        }

        protected void startEdit() {
            if (this.frame == null) {
                this.frame = (Frame)SwingUtil.getParentContainer((Object)((Object)this.ui), Frame.class);
            }
            this.ui.setBorder(BorderFactory.createTitledBorder(I18n._((String)this.columnIdentifier.getHeaderI18nKey(), (Object[])new Object[0])));
            this.ui.setBean(this.editRow);
            this.ui.setProperty(this.columnIdentifier.getPropertyName());
            JDialog editor = new JDialog(this.frame, true);
            editor.setUndecorated(true);
            editor.add((Component)((Object)this.ui));
            editor.setResizable(true);
            JRootPane rootPane = editor.getRootPane();
            rootPane.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "close");
            rootPane.getActionMap().put("close", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttachmentCellEditor.this.ui.getHandler().close();
                }
            });
            editor.pack();
            ComponentResizer cr = new ComponentResizer();
            cr.registerComponent(editor);
            ComponentMover cm = new ComponentMover();
            cm.setDragInsets(cr.getDragInsets());
            cm.registerComponent(editor);
            editor.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    Component ui = (Component)e.getSource();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Destroy ui " + ui));
                    }
                    JAXXUtil.destroy((Component)ui);
                }
            });
            int x = 0;
            int y = this.component.getHeight();
            for (Container comp = this.component; comp != null; comp = comp.getParent()) {
                x += ((Component)comp).getX();
                y += ((Component)comp).getY();
            }
            if (x + editor.getWidth() > this.frame.getX() + this.frame.getWidth()) {
                x = x - editor.getWidth() + this.component.getWidth();
            }
            editor.setLocation(x, y);
            editor.setVisible(true);
            int r = this.rowIndex;
            int c = this.columnIndex;
            this.stopCellEditing();
            AbstractSelectTableAction.doSelectCell(this.table, r, c);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.tableModel == null) {
                this.tableModel = (AbstractTuttiTableModel)table.getModel();
                this.table = table;
                this.columnIdentifier = this.tableModel.getPropertyName(column);
            }
            this.rowIndex = row;
            this.columnIndex = column;
            this.editRow = this.tableModel.getEntry(row);
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            Preconditions.checkNotNull((Object)((Object)this.editRow), (Object)"No editRow found in editor.");
            String propertyName = this.columnIdentifier.getPropertyName();
            Object result = TuttiUIUtil.getProperty((Object)this.editRow, propertyName);
            if (log.isInfoEnabled()) {
                log.info((Object)("editor value (" + propertyName + "): " + result));
            }
            return result;
        }

        @Override
        public boolean stopCellEditing() {
            boolean b = super.stopCellEditing();
            if (b) {
                this.rowIndex = null;
                this.editRow = null;
                this.columnIndex = null;
            }
            return b;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.rowIndex = null;
            this.columnIndex = null;
            this.editRow = null;
        }
    }
}

