/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.species;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.referential.SortedUnsortedCategory;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesBatchTreeNode;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class SpeciesBatchTreeModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final SpeciesBatchTreeNode root;
    protected String[] samplingOrder;
    protected final Map<SpeciesBatchRowModel, SpeciesBatchTreeNode> rowToNode;
    protected final Multimap<SpeciesBatchTreeNode, SpeciesBatchRowModel> nodeToRow;

    public SpeciesBatchTreeModel(String ... samplingOrder) {
        this.samplingOrder = samplingOrder;
        this.root = new SpeciesBatchTreeNode();
        this.rowToNode = Maps.newHashMap();
        this.nodeToRow = HashMultimap.create();
    }

    public void populate(List<SpeciesBatchRowModel> rows) {
        this.clear();
        for (SpeciesBatchRowModel row : rows) {
            SpeciesBatchTreeNode node = this.getSamplingNode(row);
            boolean rowIsValid = this.isValid(row, node);
            row.setValid(rowIsValid);
        }
    }

    public String[] getSamplingOrder() {
        return this.samplingOrder;
    }

    public void setSamplingOrder(String ... samplingOrder) {
        this.samplingOrder = samplingOrder;
        this.clear();
    }

    protected void clear() {
        this.root.removeAllChildren();
        this.rowToNode.clear();
        this.nodeToRow.clear();
    }

    public SpeciesBatchTreeNode removeNodeFromCache(SpeciesBatchRowModel row) {
        SpeciesBatchTreeNode result = this.rowToNode.remove((Object)row);
        if (result != null) {
            this.nodeToRow.remove((Object)result, (Object)row);
        }
        return result;
    }

    public SpeciesBatchTreeNode getSamplingNode(SpeciesBatchRowModel row) {
        SpeciesBatchTreeNode result = this.rowToNode.get((Object)row);
        if (result == null) {
            result = this.getSamplingNode(this.root, 0, row);
            if (result == this.root) {
                result = null;
            } else {
                this.rowToNode.put(row, result);
                this.nodeToRow.put((Object)result, (Object)row);
            }
        }
        return result;
    }

    protected SpeciesBatchTreeNode getSamplingNode(SpeciesBatchTreeNode node, int samplingIndex, SpeciesBatchRowModel row) {
        SpeciesBatchTreeNode result;
        String samplingKey = this.samplingOrder[samplingIndex];
        Serializable samplingValue = (Serializable)TuttiUIUtil.getProperty((Object)row, samplingKey);
        if (samplingValue == null) {
            result = node;
        } else {
            result = node.getChild(samplingValue);
            if (result == null) {
                result = new SpeciesBatchTreeNode(samplingKey, samplingValue);
                node.add(result);
            }
            if (samplingIndex < this.samplingOrder.length) {
                result = this.getSamplingNode(result, samplingIndex + 1, row);
            }
        }
        return result;
    }

    public SamplingContext createSamplingContext(SpeciesBatchTreeNode rootNode) {
        HashSet childRows = Sets.newHashSet();
        SpeciesBatchRowModel superSamplingRow = this.getNodeToRow(rootNode);
        float totalWeight = 0.0f;
        int nbChildren = rootNode.getChildCount();
        for (int i = 0; i < nbChildren; ++i) {
            SortedUnsortedCategory sortedUnsortedCategory;
            SpeciesBatchTreeNode node = rootNode.getChildAt(i);
            SpeciesBatchRowModel row = this.getNodeToRow(node);
            if (row == null || (sortedUnsortedCategory = row.getSortedUnsortedCategory()) != null && "unsorted".equals(sortedUnsortedCategory.getName())) continue;
            childRows.add(row);
            Float weight = row.getWeight();
            if (weight == null) continue;
            totalWeight += weight.floatValue();
        }
        SamplingContext result = new SamplingContext(rootNode, superSamplingRow, childRows, totalWeight);
        return result;
    }

    public SpeciesBatchRowModel getNodeToRow(SpeciesBatchTreeNode node) {
        Collection rows = this.nodeToRow.get((Object)node);
        SpeciesBatchRowModel result = null;
        if (CollectionUtils.isNotEmpty((Collection)rows)) {
            for (SpeciesBatchRowModel next : rows) {
                if (!next.isValid()) continue;
                result = next;
                break;
            }
        }
        return result;
    }

    public boolean isValid(SpeciesBatchRowModel row, SpeciesBatchTreeNode newNode) {
        boolean result;
        boolean bl = result = row.getWeight() != null && newNode != null;
        if (result && CollectionUtils.size((Object)this.nodeToRow.get((Object)newNode)) > 1) {
            result = false;
        }
        return result;
    }

    public static class SamplingContext {
        private final SpeciesBatchTreeNode rootNode;
        private final SpeciesBatchRowModel superSamplingRow;
        private final Set<SpeciesBatchRowModel> samplingRows;
        private final float totalWeight;

        public SamplingContext(SpeciesBatchTreeNode rootNode, SpeciesBatchRowModel superSamplingRow, Set<SpeciesBatchRowModel> samplingRows, float totalWeight) {
            this.rootNode = rootNode;
            this.superSamplingRow = superSamplingRow;
            this.samplingRows = samplingRows;
            this.totalWeight = totalWeight;
        }

        public SpeciesBatchTreeNode getRootNode() {
            return this.rootNode;
        }

        public SpeciesBatchRowModel getSuperSamplingRow() {
            return this.superSamplingRow;
        }

        public Set<SpeciesBatchRowModel> getSamplingRows() {
            return this.samplingRows;
        }

        public float getTotalWeight() {
            return this.totalWeight;
        }

        public void applyNewSampleValues(float samplingWeight, Float samplingRatio) {
            for (SpeciesBatchRowModel row : this.samplingRows) {
                row.setSampleWeight(Float.valueOf(samplingWeight));
                row.setSamplingRatio(samplingRatio);
            }
        }
    }
}

