/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class FishingOperationTabUIHandler
extends AbstractTuttiUIHandler<FishingOperationTabUIModel> {
    private static final Log log = LogFactory.getLog(FishingOperationTabUIHandler.class);
    private final FishingOperationTabUI ui;
    private final FishingOperationsUI parentUi;
    private final PersistenceService persistenceService;

    public FishingOperationTabUIHandler(FishingOperationsUI parentUi, FishingOperationTabUI ui) {
        super(parentUi.getHandler().getContext());
        this.ui = ui;
        this.parentUi = parentUi;
        this.persistenceService = this.context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {
        FishingOperationTabUIModel model = new FishingOperationTabUIModel();
        model.addPropertyChangeListener("empty", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JPanel form = FishingOperationTabUIHandler.this.ui.getFishingOperationPane();
                JLabel noContentPane = FishingOperationTabUIHandler.this.ui.getNoTraitPane();
                Boolean empty = (Boolean)evt.getNewValue();
                FishingOperationTabUIHandler.this.ui.remove(form);
                FishingOperationTabUIHandler.this.ui.remove(noContentPane);
                if (empty.booleanValue()) {
                    FishingOperationTabUIHandler.this.ui.add((Component)noContentPane, "Center");
                } else {
                    FishingOperationTabUIHandler.this.ui.add((Component)form, "Center");
                }
                FishingOperationTabUIHandler.this.ui.repaint();
            }
        });
        this.listModelIsModify(model);
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.ui.getFishingOperationValidPanel().remove(this.ui.getFishingOperationResetRadio());
        FishingOperationTabUIModel model = this.ui.getModel();
        this.initUI(this.ui);
        this.initBeanList(this.ui.getSaisisseurList(), this.persistenceService.getAllPerson(), model.getSaisisseur());
        this.initBeanComboBox(this.ui.getBeaufortScaleComboBox(), this.persistenceService.getAllBeaufortScale(), model.getBeaufortScale());
        this.initBeanComboBox(this.ui.getStrataComboBox(), this.persistenceService.getAllStrata(), model.getStrata());
        this.initBeanComboBox(this.ui.getSeaStateComboBox(), this.persistenceService.getAllSeaState(), model.getSeaState());
        model.setEmpty(true);
        this.listenValidatorValid((SimpleBeanValidator)this.ui.getValidator(), this.getModel());
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    protected FishingOperationTabUIModel getModel() {
        return this.ui.getModel();
    }

    public void selectFishingOperation(FishingOperation bean) {
        boolean empty = bean == null;
        FishingOperationTabUIModel model = this.getModel();
        if (empty) {
            model.fromBean(new FishingOperation());
        } else {
            model.fromBean(bean);
        }
        List<Person> saisisseur = model.getSaisisseur();
        this.ui.getSaisisseurList().getModel().setSelected(saisisseur);
        model.setEmpty(empty);
        model.setModify(!empty && model.isCreate());
    }

    public void cancel() {
        boolean newBean;
        String id = this.getModel().getId();
        if (log.isInfoEnabled()) {
            log.info((Object)("Cancel edition for fishingOperation: " + id));
        }
        if (newBean = StringUtils.isBlank((CharSequence)id)) {
            this.parentUi.getHandler().selectFishingOperation(null);
        } else {
            FishingOperation selectedFishingOperation = this.parentUi.getModel().getSelectedFishingOperation();
            this.parentUi.getHandler().selectFishingOperation(selectedFishingOperation);
        }
    }

    public void save() {
        FishingOperation toSave = (FishingOperation)this.getModel().toBean();
        if (log.isInfoEnabled()) {
            log.info((Object)("Save edition for fishingOperation: " + toSave.getId()));
        }
        int selectedIndex = this.ui.getFishingOperationTabPane().getSelectedIndex();
        this.parentUi.getHandler().saveFishingOperation(toSave);
        this.ui.getFishingOperationTabPane().setSelectedIndex(selectedIndex);
        this.getModel().setModify(false);
    }

    public void importPupitri() {
    }

    public void importCasino() {
    }

    public void setGearShootingStartLatitude(String text) {
        this.getModel().setGearShootingStartLatitude(Float.valueOf(text));
    }

    public void setGearShootingStartLongitude(String text) {
        this.getModel().setGearShootingStartLongitude(Float.valueOf(text));
    }

    public void setGearShootingEndLatitude(String text) {
        this.getModel().setGearShootingEndLatitude(Float.valueOf(text));
    }

    public void setGearShootingEndLongitude(String text) {
        this.getModel().setGearShootingEndLongitude(Float.valueOf(text));
    }
}

