/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import com.ezware.oxbow.swingbits.table.filter.IFilterChangeListener;
import com.ezware.oxbow.swingbits.table.filter.ITableFilter;
import com.ezware.oxbow.swingbits.table.filter.JTableFilter;
import com.ezware.oxbow.swingbits.table.filter.TableRowFilterSupport;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import fr.ifremer.tutti.ui.swing.util.table.TableRowModificationListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.util.Collection;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.sort.TableSortController;

public abstract class AbstractTuttiBatchTableUIHandler<R extends AbstractTuttiBeanUIModel, M extends AbstractTuttiTableUIModel<?, R, M>>
extends AbstractTuttiTableUIHandler<R, M> {
    private static final Log log = LogFactory.getLog(AbstractTuttiBatchTableUIHandler.class);
    protected final PersistenceService persistenceService;
    protected final TuttiBeanMonitor<M> fishingOperationMonitor;

    protected abstract void saveSelectedRowIfRequired();

    protected abstract boolean isRowValid(R var1);

    protected abstract void saveRow(R var1);

    protected abstract FishingOperation getFishingOperation();

    public abstract void selectFishingOperation(FishingOperation var1);

    protected AbstractTuttiBatchTableUIHandler(FishingOperationsUI parentUi, String[] fishingProperties, String ... properties) {
        super(parentUi.getHandler().getContext(), properties);
        this.persistenceService = this.context.getService(PersistenceService.class);
        this.fishingOperationMonitor = new TuttiBeanMonitor(fishingProperties);
    }

    public final void saveSelectedRowIfRequired(FocusEvent event) {
        Component oppositeComponent = event.getOppositeComponent();
        JXTable parentContainer = null;
        if (oppositeComponent != null) {
            parentContainer = (JXTable)SwingUtil.getParentContainer((Object)oppositeComponent, JXTable.class);
        }
        if (parentContainer == null && this.getFishingOperation() != null) {
            this.saveSelectedRowIfRequired();
        }
    }

    protected void initBatchTable(JXTable table, TableColumnModel columnModel, AbstractTuttiTableModel<R> tableModel) {
        this.installTableKeyListener(columnModel, (JTable)table);
        table.getTableHeader().setReorderingAllowed(false);
        JTableFilter tableFilter = new JTableFilter((JTable)table);
        TableRowFilterSupport.forFilter((ITableFilter)tableFilter).searchable(true).useTableRenderers(true).actions(true).apply();
        tableFilter.addChangeListener(new IFilterChangeListener(){

            public void filterChanged(ITableFilter<?> filter) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Filter changed " + filter));
                }
                TableModel model = filter.getTable().getModel();
                int columnCount = model.getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    if (!filter.isFiltered(i)) continue;
                    Collection filterState = filter.getFilterState(i);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Column " + i + " is filtered: " + filterState));
                }
            }
        });
        TableSortController sorter = new TableSortController(tableModel);
        sorter.setSortable(false);
        table.setRowSorter((RowSorter)sorter);
        Highlighter readOnlyHighlighter = TuttiUIUtil.newBackgroundColorHighlighter(HighlightPredicate.READ_ONLY, Color.LIGHT_GRAY);
        table.addHighlighter(readOnlyHighlighter);
        Highlighter validHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.EDITABLE, new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                boolean result = false;
                if (adapter.isEditable()) {
                    int rowIndex = adapter.convertRowIndexToModel(adapter.row);
                    AbstractTuttiBeanUIModel row = (AbstractTuttiBeanUIModel)((Object)AbstractTuttiBatchTableUIHandler.this.getTableModel().getEntry(rowIndex));
                    result = !row.isValid();
                }
                return result;
            }
        }}), Color.RED);
        table.addHighlighter(validHighlighter);
        this.listenRowsFromModel();
        TableRowModificationListener listener = new TableRowModificationListener<R>(tableModel, this.getRowMonitor()){

            @Override
            protected void saveSelectedRow() {
                AbstractTuttiBatchTableUIHandler.this.saveSelectedRowIfRequired();
            }
        };
        table.getSelectionModel().addListSelectionListener(listener);
        SwingUtil.scrollToTableSelection((JTable)table);
    }
}

