/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.config.TuttiServiceConfigOption;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.MainUI;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiConfig;
import fr.ifremer.tutti.ui.swing.config.TuttiConfigOption;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Calendar;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.editor.config.ConfigUIHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.widget.SwingSession;

public class MainUIHandler
extends AbstractTuttiUIHandler<TuttiUIContext> {
    private static final Log log = LogFactory.getLog(MainUIHandler.class);
    protected MainUI ui;
    protected JComponent currentBody;
    protected final PersistenceService persistenceService;

    protected MainUIHandler(TuttiUIContext context, MainUI ui) {
        super(context);
        this.ui = ui;
        this.persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {
        this.context.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (propertyName.equals("programId") || propertyName.equals("cruiseId")) {
                    MainUIHandler.this.changeTitle();
                } else if (propertyName.equals("screen")) {
                    MainUIHandler.this.setScreen((TuttiScreen)((Object)evt.getNewValue()));
                }
            }
        });
    }

    @Override
    public void afterInitUI() {
        ErrorDialogUI.init((Frame)this.ui);
        SwingSession swingSession = this.context.getSwingSession();
        swingSession.add((Component)this.ui);
        swingSession.save();
        this.changeTitle();
        TuttiScreen screen = this.context.isCruiseContextFilled() ? TuttiScreen.EDIT_FISHING_OPERATION : TuttiScreen.SELECT_CRUISE;
        this.context.setScreen(screen);
    }

    @Override
    public void onCloseUI() {
        this.closeCurrentBody();
        this.context.close();
    }

    @Override
    protected TuttiUIContext getModel() {
        return this.ui.getModel();
    }

    public void showConfig() {
        TuttiConfig config = this.context.getConfig();
        ConfigUIHelper helper = new ConfigUIHelper(config.getApplicationConfig());
        helper.registerCallBack("ui", I18n.n_((String)"tutti.action.reload.ui", (Object[])new Object[0]), (Icon)SwingUtil.createActionIcon((String)"reload-ui"), new Runnable(){

            @Override
            public void run() {
                MainUIHandler.this.reloadTutti();
            }
        }).registerCallBack("home", I18n.n_((String)"tutti.action.reload.home", (Object[])new Object[0]), (Icon)SwingUtil.createActionIcon((String)"config"), new Runnable(){

            @Override
            public void run() {
                if (TuttiScreen.SELECT_CRUISE == MainUIHandler.this.context.getScreen()) {
                    // empty if block
                }
            }
        }).registerCallBack("actions", I18n.n_((String)"tutti.action.reload.actions", (Object[])new Object[0]), (Icon)SwingUtil.createActionIcon((String)"config"), new Runnable(){

            @Override
            public void run() {
            }
        });
        helper.addCategory(I18n.n_((String)"tutti.config.category.applications", (Object[])new Object[0]), I18n.n_((String)"tutti.config.category.applications.description", (Object[])new Object[0])).addOption((ApplicationConfig.OptionDef)TuttiServiceConfigOption.DATA_DIRECTORY).setOptionCallBack("ui");
        helper.addCategory(I18n.n_((String)"tutti.config.category.other", (Object[])new Object[0]), I18n.n_((String)"tutti.config.category.other.description", (Object[])new Object[0])).addOption((ApplicationConfig.OptionDef)TuttiServiceConfigOption.SITE_URL).addOption((ApplicationConfig.OptionDef)TuttiConfigOption.UI_CONFIG_FILE).setOptionCallBack("ui");
        helper.buildUI((JAXXContext)this.ui, "tutti.config.category.applications");
        helper.displayUI((Frame)this.ui, false);
    }

    public void closeTutti() {
        this.closeTutti(true);
    }

    public void showManageProtocol() {
        this.context.setScreen(TuttiScreen.EDIT_PROTOCOL);
    }

    public void showSelectCampaign() {
        this.context.setScreen(TuttiScreen.SELECT_CRUISE);
    }

    public void showFillCatches() {
        this.context.setScreen(TuttiScreen.EDIT_FISHING_OPERATION);
    }

    public void showImportScreen() {
    }

    public void showExportScreen() {
    }

    public void showAllegroScreen() {
    }

    public void showAbout() {
        ApplicationConfig applicationConfig = this.context.getConfig().getApplicationConfig();
        String iconPath = applicationConfig.getOption("application.icon.path");
        String name = "tutti-ui-swing";
        String licensePath = "META-INF/" + name + "-LICENSE.txt";
        String thirdPartyPath = "META-INF/" + name + "-THIRD-PARTY.txt";
        AboutPanel about = new AboutPanel();
        about.setTitle(I18n._((String)"tutti.title.about", (Object[])new Object[0]));
        about.setAboutText(I18n._((String)"tutti.about.message", (Object[])new Object[0]));
        TuttiConfig config = this.context.getConfig();
        int currentYear = Calendar.getInstance().get(1);
        int inceptionYear = config.getInceptionYear();
        String years = currentYear != inceptionYear ? inceptionYear + "-" + currentYear : inceptionYear + "";
        about.setBottomText(I18n._((String)"tutti.about.bottomText", (Object[])new Object[]{config.getOrganizationName(), years, config.getVersion()}));
        about.setIconPath(iconPath);
        about.setLicenseFile(licensePath);
        about.setThirdpartyFile(thirdPartyPath);
        about.buildTopPanel();
        about.init();
        about.showInDialog((Frame)this.ui, true);
        this.context.getSwingSession().add((Component)about);
    }

    public void gotoSite() {
        TuttiConfig config = this.context.getConfig();
        URL siteURL = config.getSiteUrl();
        if (log.isDebugEnabled()) {
            log.debug((Object)("goto " + siteURL));
        }
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(siteURL.toURI());
            }
            catch (Exception e) {
                log.error((Object)("Failed to open '" + siteURL + "' in browser"), (Throwable)e);
                ErrorDialogUI.showError((Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setScreen(TuttiScreen screen) {
        try {
            String screenTitle;
            JPanel screenUI;
            TuttiUIUtil.updateBusyState(this.ui, true);
            this.closeCurrentBody();
            String surveyId = this.context.getProgramId();
            String campaignId = this.context.getCruiseId();
            switch (screen) {
                default: {
                    screenUI = new SelectCruiseUI(this.context);
                    screenTitle = I18n._((String)"tutti.title.home", (Object[])new Object[0]);
                    break;
                }
                case EDIT_PROGRAM: {
                    screenTitle = surveyId == null ? I18n._((String)"tutti.title.create.program", (Object[])new Object[0]) : I18n._((String)"tutti.title.edit.program", (Object[])new Object[0]);
                    screenUI = new EditProgramUI(this.context);
                    break;
                }
                case EDIT_CRUISE: {
                    screenTitle = campaignId == null ? I18n._((String)"tutti.title.create.cruise", (Object[])new Object[0]) : I18n._((String)"tutti.title.edit.cruise", (Object[])new Object[0]);
                    screenUI = new EditCruiseUI(this.context);
                    break;
                }
                case EDIT_FISHING_OPERATION: {
                    screenTitle = I18n._((String)"tutti.title.edit.operations", (Object[])new Object[]{this.getSelectedCruiseTitle()});
                    screenUI = new FishingOperationsUI(this.context);
                }
            }
            this.changeScreen(screenUI, screenTitle);
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            this.context.setScreen(TuttiScreen.SELECT_CRUISE);
        }
        finally {
            TuttiUIUtil.updateBusyState(this.ui, false);
        }
    }

    protected void reloadTutti() {
        this.closeTutti(false);
        try {
            this.context.open();
        }
        catch (Exception ex) {
            ErrorDialogUI.showError((Exception)ex);
        }
        MainUI mainUI = new MainUI(this.context);
        mainUI.setVisible(true);
    }

    protected void closeCurrentBody() {
        if (this.currentBody != null) {
            TuttiUI body = (TuttiUI)((Object)this.currentBody);
            ((AbstractTuttiUIHandler)body.getHandler()).onCloseUI();
            this.context.getSwingSession().save();
            this.ui.getBody().remove((Component)this.currentBody);
            this.currentBody = null;
        }
    }

    protected void changeScreen(JComponent newBody, String title) {
        this.currentBody = newBody;
        this.context.getSwingSession().add((Component)this.currentBody);
        this.ui.getBody().setTitle(title);
        this.ui.getBody().add((Component)this.currentBody);
    }

    protected void closeTutti(boolean exit) {
        this.context.getSwingSession().save();
        this.ui.setVisible(false);
        this.ui.dispose();
        this.onCloseUI();
        if (exit) {
            System.exit(0);
        }
    }

    protected void changeTitle() {
        String title = this.getSelectedCruiseTitle();
        this.ui.setTitle("Tutti - v " + this.getConfig().getVersion() + " [ " + title + " ]");
    }

    protected String getSelectedCruiseTitle() {
        String title;
        String surveyId = this.context.getProgramId();
        if (surveyId == null) {
            title = I18n._((String)"tutti.title.noSelectedProgram", (Object[])new Object[0]);
        } else {
            Program program = this.persistenceService.getProgram(surveyId);
            title = I18n._((String)"tutti.title.selectedProgram", (Object[])new Object[]{program.getName()}) + " / ";
            String campaignId = this.context.getCruiseId();
            if (campaignId == null) {
                title = title + I18n._((String)"tutti.title.noSelectedCruise", (Object[])new Object[0]);
            } else {
                Cruise cruise = this.persistenceService.getCruise(campaignId);
                title = title + I18n._((String)"tutti.title.selectedCruise", (Object[])new Object[]{cruise.getName()});
            }
        }
        return title;
    }
}

