package fr.ifremer.tutti.ui.swing.util.table;

/*
 * #%L
 * Tutti :: UI
 * $Id: TableRowModificationListener.java 51 2012-12-12 22:43:03Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/table/TableRowModificationListener.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import java.io.Serializable;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public abstract class TableRowModificationListener<R extends Serializable> implements ListSelectionListener {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(TableRowModificationListener.class);

    private final AbstractTuttiTableModel<R> tableModel;

    private final TuttiBeanMonitor<R> beanMonitor;

    protected abstract void saveSelectedRow();

    public TableRowModificationListener(AbstractTuttiTableModel<R> tableModel,
                                        TuttiBeanMonitor<R> beanMonitor) {
        this.tableModel = tableModel;
        this.beanMonitor = beanMonitor;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            ListSelectionModel source = (ListSelectionModel) e.getSource();
            int selectedRow = source.getLeadSelectionIndex();

            // save selected entry if required
            saveSelectedRow();

            R entry;

            if (source.isSelectionEmpty()) {

                // no selection
                entry = null;
                if (log.isInfoEnabled()) {
                    log.info("Selection is now empty.");
                }
            } else {
                entry = tableModel.getEntry(selectedRow);

                if (log.isInfoEnabled()) {
                    log.info("New selected row: " + selectedRow);
                }
            }

            if (log.isInfoEnabled()) {
                log.info("Will monitor entry: " + entry);
            }
            beanMonitor.setBean(entry);
        }
    }
}
