package fr.ifremer.tutti.ui.swing.content.operation.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: SpeciesBatchUIModel.java 55 2012-12-13 01:57:28Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/species/SpeciesBatchUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;

import java.util.List;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class SpeciesBatchUIModel extends AbstractTuttiTableUIModel<FishingOperation, SpeciesBatchRowModel, SpeciesBatchUIModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_TOTAL_WEIGHT = "totalWeight";

    public static final String PROPERTY_TOTAL_VRAC_WEIGHT = "totalVracWeight";

    public static final String PROPERTY_SAMPLE_VRAC_WEIGHT = "sampleVracWeight";

    public static final String PROPERTY_TOTAL_HORS_VRAC_WEIGHT = "totalHorsVracWeight";

    /**
     * Editing fishing operation.
     *
     * @since 0.2
     */
    protected FishingOperation fishingOperation;

    /**
     * Total Weight filled in screen.
     *
     * @since 0.2
     */
    protected Float totalWeight;

    /**
     * Total vrac Weight filled in screen.
     *
     * @since 0.2
     */
    protected Float totalVracWeight;

    /**
     * Total sample vrac Weight filled in screen.
     *
     * @since 0.2
     */
    protected Float sampleVracWeight;

    /**
     * Total hors vrac Weight computed by hros vrac rows.
     *
     * @since 0.2
     */
    protected Float totalHorsVracWeight;

    /**
     * Sampling order (sets by protocol).
     *
     * @since 0.2
     */
    protected List<String> samplingOrder;

    /**
     * Tree of sampling for batch rows.
     *
     * @since 0.2
     */
    protected final SpeciesBatchTreeModel samplingTreeModel;

    protected static final Binder<FishingOperation, SpeciesBatchUIModel> fromBeanBinder = BinderModelBuilder.newEmptyBuilder(FishingOperation.class, SpeciesBatchUIModel.class)
            .addProperty(FishingOperation.PROPERTY_SPECIES_TOTAL_WEIGHT, PROPERTY_TOTAL_WEIGHT)
            .addProperty(FishingOperation.PROPERTY_SPECIES_TOTAL_HORS_VRAC_WEIGHT, PROPERTY_TOTAL_HORS_VRAC_WEIGHT)
            .addProperty(FishingOperation.PROPERTY_SPECIES_TOTAL_VRAC_WEIGHT, PROPERTY_TOTAL_VRAC_WEIGHT)
            .addProperty(FishingOperation.PROPERTY_SPECIES_SAMPLE_VRAC_WEIGHT, PROPERTY_SAMPLE_VRAC_WEIGHT)
            .addProperty(FishingOperation.PROPERTY_ID, PROPERTY_ID)
            .toBinder();

    protected static final Binder<SpeciesBatchUIModel, FishingOperation> toBeanBinder = BinderModelBuilder.newEmptyBuilder(SpeciesBatchUIModel.class, FishingOperation.class)
            .addProperty(PROPERTY_TOTAL_WEIGHT, FishingOperation.PROPERTY_SPECIES_TOTAL_WEIGHT)
            .addProperty(PROPERTY_TOTAL_HORS_VRAC_WEIGHT, FishingOperation.PROPERTY_SPECIES_TOTAL_HORS_VRAC_WEIGHT)
            .addProperty(PROPERTY_TOTAL_VRAC_WEIGHT, FishingOperation.PROPERTY_SPECIES_TOTAL_VRAC_WEIGHT)
            .addProperty(PROPERTY_SAMPLE_VRAC_WEIGHT, FishingOperation.PROPERTY_SPECIES_SAMPLE_VRAC_WEIGHT)
            .toBinder();

    public SpeciesBatchUIModel() {
        super(FishingOperation.class, fromBeanBinder, toBeanBinder);
        this.samplingTreeModel = new SpeciesBatchTreeModel();
    }

    public FishingOperation getFishingOperation() {
        return fishingOperation;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }

    public SpeciesBatchTreeModel getSamplingTreeModel() {
        return samplingTreeModel;
    }

    public Float getTotalWeight() {
        return totalWeight;
    }

    public void setTotalWeight(Float totalWeight) {
        Object oldValue = getTotalWeight();
        this.totalWeight = totalWeight;
        firePropertyChange(PROPERTY_TOTAL_WEIGHT, oldValue, totalWeight);
    }

    public Float getTotalVracWeight() {
        return totalVracWeight;
    }

    public void setTotalVracWeight(Float totalVracWeight) {
        Object oldValue = getTotalVracWeight();
        this.totalVracWeight = totalVracWeight;
        firePropertyChange(PROPERTY_TOTAL_VRAC_WEIGHT, oldValue, totalVracWeight);
    }

    public Float getSampleVracWeight() {
        return sampleVracWeight;
    }

    public void setSampleVracWeight(Float sampleVracWeight) {
        Object oldValue = getSampleVracWeight();
        this.sampleVracWeight = sampleVracWeight;
        firePropertyChange(PROPERTY_SAMPLE_VRAC_WEIGHT, oldValue, sampleVracWeight);
    }

    public Float getTotalHorsVracWeight() {
        return totalHorsVracWeight;
    }

    public void setTotalHorsVracWeight(Float totalHorsVracWeight) {
        Object oldValue = getTotalHorsVracWeight();
        this.totalHorsVracWeight = totalHorsVracWeight;
        firePropertyChange(PROPERTY_TOTAL_HORS_VRAC_WEIGHT, oldValue, totalHorsVracWeight);
    }

    public List<String> getSamplingOrder() {
        return samplingOrder;
    }

    public void setSamplingOrder(List<String> samplingOrder) {
        this.samplingOrder = samplingOrder;
        samplingTreeModel.setSamplingOrder(samplingOrder.toArray(new String[samplingOrder.size()]));
    }

    @Override
    protected FishingOperation newEntity() {
        return fishingOperation;
    }
}
