package fr.ifremer.tutti.ui.swing.content.operation.benthos;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.util.editor.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextEditorUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class BenthosBatchUI extends JPanel implements TuttiUI<BenthosBatchUIModel, BenthosBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SAMPLE_TOTAL_WEIGHT_FIELD_MODEL = "sampleTotalWeightField.model";
    public static final String BINDING_SAMPLE_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "sampleTotalWeightField.numberPattern";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_MODEL = "totalWeightField.model";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "totalWeightField.numberPattern";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRSemDiJ86NJGhGC+hNaoBXSuhJShZSqNHbj1GHjRFkXInIIY+/Y3nR2Z5mZbTaygvgDQOJPgDsXJG6cEAfOHLgg/gWEOPSKeDNr73qdjZxQImWczLz3vfe+N/M9f/cnyguO3jjEYWjwwJOOS4zNtb297cYhacrHRDS540vGUfQzlkO5fTRjx/tColv7pnIv9tyLZeb6zCPegPeqiaaFPKZEdAiREl1LezSFKFrx8WroB7yPGieVhfrN33/lvra/+DaHUOhDdotQys1RXkkl4ybKObZElyHSc1yk2GtDGtzx2pDvnNorUyxEDbvkM/Q5mjTRhI85gEn05vlL1hjaP/QlKnSYS3awR6hEpRY3nBYnLuGGDKR0jMAxxBHEN5rMkwBnMJ9wLB3mGQ34t8OEUYo+S1g2O0+rvq+hJySa7GDPpoRLVH152CcRVoKed5mtUt54eewthZQgzxPOGa/jBiVbUYwHqQ4+x9SxMRDaC2Op9aP+5hYRArdJ4p4AF2JPid69AGSCcIkyr10noVy3HQ1z/+zqA+lQg2g7w0y5Pa0quEKMuoClxM2OC6T0cd8/H+7akOMw8tTtTX2z7sGVVrc37GFEu2nbay1HdOBwu9+tXeI6nk24iRuqCWkAvak8r8cAs7c3LQLPQVEGAZdT9vFJ2me8xbgr0UqqG5GL7mDaekEyienHxGl3ZJzALbW8k2lTcQiF1/x2BnqPwFrgNgiPyEvjLAvs+pTUR0c8banjqlMjbTkvVU1WkzNKVQckei1NUnySbk1e+0l0hfG2cQhS+0wyP3IKjc29mKn3fJC7K6lqQUiNREgTpRvbR3kewDaQv39ae3fhKFLdlSHVVYD69J/lpd9+/OOHSl9qpyD2q5mmA5MCJNDnSg+ko0LPRzqrrnRxC/ur+6ggCIUxo8fI1YzErN4xJAfxFpV79CKeYNEBiPzk7z/9vPzpr6+gXAVNU4btClb2VVSQHQ4sMGqH/gePdEazR1OwLsDvOFzFBsEeqGZXC9sJyAUOJNthfgAiXez2xNRoE1lmXstp37lrOGKtbzJ4ke7cVd4Q6miXCDXcxiUPgPx5taWtS/CkQRzRvTNgLTAcRIzsATeEjlzN6EhMS6Pwy4sl6/tH/a6MAUuvn2medCb/CZpwPOp4RI/A3nTLHHkzviCBzZIpljXXEJA2O1hCT0Qf6rV0qgE5ECuqHlhFyd/l7vArPlEsgoJKdCPSQ20cD5QB8zBQEUxdu/qrhjKEwx+Rzngy4FaiC6E6NPDEdY/nPF3gDug34dDO5W61Vj+4f/C4ulGtWwc7a/X6+m4NDKcCQSpwGSH9fAtTuBRoqvcOjiWauUD2moxR2Z+fzLeyyDylZ1lJnaGPFyD2ekKsNYz1f9K7+B/rORfVUM9cJFkwMdX3DeC0azpCWoOb1LCqtQ1z/cBaN9fL9eq2zlpAdyJh72e9FENB50ibs8CD+TXXLTMKw6pkrpU/PBm0KuHms77VRNcLKD3Jqi2aH6NKGQMMio8Z3Ah06QF888E3G/AFAIbMw1OgY2qdHomotr9Uy1fZCDcA4V/EGhovcQwAAA==";
    private static final Log log = LogFactory.getLog(BenthosBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AttachmentEditorUI attachmentEditor;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected JLabel fishingOperationReminderLabel;
    protected Table form;
    protected BenthosBatchUIHandler handler;
    protected BenthosBatchUI homePanel = this;
    protected LongTextEditorUI longTextEditor;
    protected BenthosBatchUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleTotalWeight",  editorName = "sampleTotalWeightField")
    protected NumberEditor sampleTotalWeightField;
    protected JLabel sampleTotalWeightLabel;
    protected JXTable table;
    protected JScrollPane tableScrollPane;
    @ValidatorField( validatorId = "validator",  propertyName = "totalWeight",  editorName = "totalWeightField")
    protected NumberEditor totalWeightField;
    protected JLabel totalWeightLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<BenthosBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public void selectFishingOperation(FishingOperation fishingOperation) { handler.selectFishingOperation(fishingOperation); }
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BenthosBatchUI(FishingOperationsUI parentUI) {
        BenthosBatchUIHandler handler = new BenthosBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public BenthosBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosBatchUI() {
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusLost__on__table(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveSelectedRowIfRequired(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentEditorUI getAttachmentEditor() {
        return attachmentEditor;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public JLabel getFishingOperationReminderLabel() {
        return fishingOperationReminderLabel;
    }

    public Table getForm() {
        return form;
    }

    public BenthosBatchUIHandler getHandler() {
        return handler;
    }

    public LongTextEditorUI getLongTextEditor() {
        return longTextEditor;
    }

    public BenthosBatchUIModel getModel() {
        return model;
    }

    public NumberEditor getSampleTotalWeightField() {
        return sampleTotalWeightField;
    }

    public JLabel getSampleTotalWeightLabel() {
        return sampleTotalWeightLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public NumberEditor getTotalWeightField() {
        return totalWeightField;
    }

    public JLabel getTotalWeightLabel() {
        return totalWeightLabel;
    }

    public SwingValidator<BenthosBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(totalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(totalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(sampleTotalWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(sampleTotalWeightField), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(longTextEditor);
        add(attachmentEditor);
        add($JPanel0, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAttachmentEditor() {
        $objectMap.put("attachmentEditor", attachmentEditor = new AttachmentEditorUI());
        
        attachmentEditor.setName("attachmentEditor");
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createFishingOperationReminderLabel() {
        $objectMap.put("fishingOperationReminderLabel", fishingOperationReminderLabel = new JLabel());
        
        fishingOperationReminderLabel.setName("fishingOperationReminderLabel");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(BenthosBatchUIHandler.class));
    }

    protected void createLongTextEditor() {
        $objectMap.put("longTextEditor", longTextEditor = new LongTextEditorUI());
        
        longTextEditor.setName("longTextEditor");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(BenthosBatchUIModel.class));
    }

    protected void createSampleTotalWeightField() {
        $objectMap.put("sampleTotalWeightField", sampleTotalWeightField = new NumberEditor(this));
        
        sampleTotalWeightField.setName("sampleTotalWeightField");
        sampleTotalWeightField.setProperty("sampleTotalWeight");
        sampleTotalWeightField.setUseFloat(false);
        sampleTotalWeightField.setShowReset(true);
    }

    protected void createSampleTotalWeightLabel() {
        $objectMap.put("sampleTotalWeightLabel", sampleTotalWeightLabel = new JLabel());
        
        sampleTotalWeightLabel.setName("sampleTotalWeightLabel");
        sampleTotalWeightLabel.setText(_("tutti.label.benthos.sampleTotalWeight"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__table"));
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTotalWeightField() {
        $objectMap.put("totalWeightField", totalWeightField = new NumberEditor(this));
        
        totalWeightField.setName("totalWeightField");
        totalWeightField.setProperty("totalWeight");
        totalWeightField.setUseFloat(false);
        totalWeightField.setShowReset(true);
    }

    protected void createTotalWeightLabel() {
        $objectMap.put("totalWeightLabel", totalWeightLabel = new JLabel());
        
        totalWeightLabel.setName("totalWeightLabel");
        totalWeightLabel.setText(_("tutti.label.benthos.totalWeight"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(BenthosBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        // inline complete setup of $JPanel0
        $JPanel0.add(fishingOperationReminderLabel, BorderLayout.NORTH);
        $JPanel0.add($JSeparator0, BorderLayout.CENTER);
        $JPanel0.add(form, BorderLayout.SOUTH);
        addChildrenToForm();
        addChildrenToTableScrollPane();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 13 property setters
        totalWeightLabel.setLabelFor(totalWeightField);
        totalWeightField.setBean(model);
        totalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        totalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        sampleTotalWeightLabel.setLabelFor(totalWeightField);
        sampleTotalWeightField.setBean(model);
        sampleTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        sampleTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createLongTextEditor();
        createAttachmentEditor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createFishingOperationReminderLabel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createForm();
        createTotalWeightLabel();
        createTotalWeightField();
        createSampleTotalWeightLabel();
        createSampleTotalWeightField();
        createTableScrollPane();
        createTable();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightField.setModel(model.getTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                totalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sampleTotalWeightField.setModel(model.getSampleTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleTotalWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SAMPLE_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                sampleTotalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
    }

}