package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.accidental.AccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.macrowaste.MacroWasteBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.plankton.PlanktonBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesBatchUI;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class FishingOperationsUI extends JPanel implements TuttiUI<FishingOperationsUIModel, FishingOperationsUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ACCIDENTEL_TAB_ENABLED = "accidentelTab.enabled";
    public static final String BINDING_BENTHOS_TAB_ENABLED = "benthosTab.enabled";
    public static final String BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM = "fishingOperationComboBox.selectedItem";
    public static final String BINDING_MACRO_DECHET_TAB_ENABLED = "macroDechetTab.enabled";
    public static final String BINDING_PLANKTON_TAB_ENABLED = "planktonTab.enabled";
    public static final String BINDING_SPECIES_TAB_ENABLED = "speciesTab.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAL1XTW8bRRgeO3EcJ+lXTEpKi+RCkUCIMT0gIaXQxolMHJw2qola4Quzu2PvlPXOMjMbb6iK+AncuMKdCxI3TogDZw5cEH8BIQ5cEe/srr3ezZo4jZRIWW/mnfd53q+Zx/nuT1SSAt18QoIAC99VbEDx7ubjxw+MJ9RU21SagnmKCxT9FIqo2EXL1nhdKvRqt63d67F7fYsPPO5Sd8J7o42WpDpyqLQpVQq9nPYwpax3xuaNwPPFCHUcVB7qN3//VfzK+vLbIkKBB9GtQSq1k7ySTObbqMgshVaB6ZDUHeL2IQzB3D7Ee0GvbTlEyvtkQD9DX6ByGy14RACYQq/MnnKIEfoHnkIVmw/oPnGpo9DdnsCsJ+iACqx8pRj2GZZD4McmdxXAYe5RQRTjLm4yaYPlwWhBHrQ8L8RdUKhsE9dyqFCoeUbMnQgogS4NuKWD3T4j8J6GSWAXFffiMqynOhZBfkQMJyx6Zeyx3suAQtEN3uCBQm/mIFCLQRewQYmLG/AY7dZoq2PQay4dZoNtQHaQEarqCQhiuN1oNe1dVsTQSSj0YmovRG9QS1vSKbyUTQE2bkXFU2jzLAUGoIOWZrk+JrsiPWoyKic5GqfhiP1xJ/psEGXax0gM8LH585PE/tCi8DOXZNWDo/mpSpfrVPM4AsD78Usuz9qAmIJvU9OmapJq5zRUIcaQSEXxnn59pF9z6V4gpsks8KbOc7ONIIiDN8evuWyLt3bbxKDO21DP1LCGq+m91Zw5henNP6ctt8eTc72UTJ1eeWfCkoxKxrI80d+M6WK6JRnrhVQFM8Z1bkgqDsP4W67FDpnlp/YJdD2VEagQTlQokYlCF5WED8uA2T0uXA/BFEnWekayNGBo/fdq9bcf//ihOdKpFeBey906IbOgH57QnVZMU1+KRMpXzKnvEW+jiyqSOqDRoQbfyAmsE5shOOC7ot2xdsc7RNoAUSr//tPPVz/5dQ4Vm2jJ4cRqEr2/hSrKFlAF7liBd/deGNHKcBGel+F3TqF5favC9fc01IZn0Ft2+113X9Aeg9v4UjS1cfBHGEQPsIYPqdTSP6+ETwOo1o2cao1DNiq//FPtfH9vVLECZHBt6vakaqWP0QJzHebSUNtj2c7V8mVPUt/iiTznCTYCyV6ZlI94vj4Inx8eK05RJ0gDyPNyVAWoqD6nIDNQpeiPlj7GaI5YVuBrlE6Yn347QP+nSN7J3CvRSFCrpehAodeiBuE+VZ3YkIV+/Q1o3+KoVzDhcsrGvFinSvJJoRZgeKirNR6+fr01S5S1m+/VXN9xnuXFMXHpnDdzcqmdM/PkpXnO1JlL+ZzZ05f+qcjLT3vEkTQXdqpczMCw4JAjDmcUXbxjEUVqBgMAt//+MZ6Cfi7NgFi1uWCfc63mmw7ruwPIV2/+Oh/y9gyQ8b20eie6H2tEwb86hq/olDA15n/YO+B4Hw4AAA==";
    private static final Log log = LogFactory.getLog(FishingOperationsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo accidentelTab;
    protected AccidentalBatchUI accidentelTabContent;
    protected TabInfo benthosTab;
    protected BenthosBatchUI benthosTabContent;
    protected BeanComboBox<FishingOperation> fishingOperationComboBox;
    protected TabInfo fishingOperationTab;
    protected FishingOperationTabUI fishingOperationTabContent;
    protected FishingOperationsUIHandler handler;
    protected FishingOperationsUI homePanel = this;
    protected TabInfo macroDechetTab;
    protected MacroWasteBatchUI macroDechetTabContent;
    protected FishingOperationsUIModel model;
    protected JButton newFishingOperationButton;
    protected TabInfo observationIndividuelTab;
    protected TabInfo planktonTab;
    protected PlanktonBatchUI planktonTabContent;
    protected TabInfo speciesTab;
    protected SpeciesBatchUI speciesTabContent;
    protected JTabbedPane tabPane;
    protected Table topPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() {
        handler.afterInitUI();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FishingOperationsUI(TuttiUIContext context) {
        FishingOperationsUIHandler handler = new FishingOperationsUIHandler(context, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public FishingOperationsUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI() {
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__newFishingOperationButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().createNewFishingOperation();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TabInfo getAccidentelTab() {
        return accidentelTab;
    }

    public AccidentalBatchUI getAccidentelTabContent() {
        return accidentelTabContent;
    }

    public TabInfo getBenthosTab() {
        return benthosTab;
    }

    public BenthosBatchUI getBenthosTabContent() {
        return benthosTabContent;
    }

    public BeanComboBox<FishingOperation> getFishingOperationComboBox() {
        return fishingOperationComboBox;
    }

    public TabInfo getFishingOperationTab() {
        return fishingOperationTab;
    }

    public FishingOperationTabUI getFishingOperationTabContent() {
        return fishingOperationTabContent;
    }

    public FishingOperationsUIHandler getHandler() {
        return handler;
    }

    public TabInfo getMacroDechetTab() {
        return macroDechetTab;
    }

    public MacroWasteBatchUI getMacroDechetTabContent() {
        return macroDechetTabContent;
    }

    public FishingOperationsUIModel getModel() {
        return model;
    }

    public JButton getNewFishingOperationButton() {
        return newFishingOperationButton;
    }

    public TabInfo getObservationIndividuelTab() {
        return observationIndividuelTab;
    }

    public TabInfo getPlanktonTab() {
        return planktonTab;
    }

    public PlanktonBatchUI getPlanktonTabContent() {
        return planktonTabContent;
    }

    public TabInfo getSpeciesTab() {
        return speciesTab;
    }

    public SpeciesBatchUI getSpeciesTabContent() {
        return speciesTabContent;
    }

    public JTabbedPane getTabPane() {
        return tabPane;
    }

    public Table getTopPanel() {
        return topPanel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(topPanel, BorderLayout.NORTH);
        add(tabPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        tabPane.add(fishingOperationTabContent);
        tabPane.add(speciesTabContent);
        tabPane.add(benthosTabContent);
        tabPane.add(planktonTabContent);
        tabPane.add(macroDechetTabContent);
        tabPane.add(accidentelTabContent);
        tabPane.add($JLabel0);
        fishingOperationTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 0));
        tabPane.setTitleAt(0, _("tutti.label.tab.fishingOperation"));
        speciesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 1));
        tabPane.setTitleAt(1, _("tutti.label.tab.species"));
        benthosTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 2));
        tabPane.setTitleAt(2, _("tutti.label.tab.benthos"));
        planktonTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 3));
        tabPane.setTitleAt(3, _("tutti.label.tab.plancton"));
        macroDechetTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 4));
        tabPane.setTitleAt(4, _("tutti.label.tab.macroDechet"));
        accidentelTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 5));
        tabPane.setTitleAt(5, _("tutti.label.tab.accidentel"));
        observationIndividuelTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 6));
        tabPane.setTitleAt(6, _("tutti.label.tab.observationIndividuel"));
    }

    protected void addChildrenToTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        topPanel.add(fishingOperationComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        topPanel.add(newFishingOperationButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createAccidentelTab() {
        $objectMap.put("accidentelTab", accidentelTab = new TabInfo());
        
        accidentelTab.setTitle(_("tutti.label.tab.accidentel"));
    }

    protected void createAccidentelTabContent() {
        $objectMap.put("accidentelTabContent", accidentelTabContent = new AccidentalBatchUI(this));
        
        accidentelTabContent.setName("accidentelTabContent");
    }

    protected void createBenthosTab() {
        $objectMap.put("benthosTab", benthosTab = new TabInfo());
        
        benthosTab.setTitle(_("tutti.label.tab.benthos"));
    }

    protected void createBenthosTabContent() {
        $objectMap.put("benthosTabContent", benthosTabContent = new BenthosBatchUI(this));
        
        benthosTabContent.setName("benthosTabContent");
    }

    protected void createFishingOperationComboBox() {
        $objectMap.put("fishingOperationComboBox", fishingOperationComboBox = new BeanComboBox<FishingOperation>(this));
        
        fishingOperationComboBox.setName("fishingOperationComboBox");
        fishingOperationComboBox.setI18nPrefix("tutti.property.");
        fishingOperationComboBox.setProperty("selectedFishingOperation");
        fishingOperationComboBox.setShowReset(true);
    }

    protected void createFishingOperationTab() {
        $objectMap.put("fishingOperationTab", fishingOperationTab = new TabInfo());
        
        fishingOperationTab.setTitle(_("tutti.label.tab.fishingOperation"));
    }

    protected void createFishingOperationTabContent() {
        $objectMap.put("fishingOperationTabContent", fishingOperationTabContent = new FishingOperationTabUI(this));
        
        fishingOperationTabContent.setName("fishingOperationTabContent");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(FishingOperationsUIHandler.class));
    }

    protected void createMacroDechetTab() {
        $objectMap.put("macroDechetTab", macroDechetTab = new TabInfo());
        
        macroDechetTab.setTitle(_("tutti.label.tab.macroDechet"));
    }

    protected void createMacroDechetTabContent() {
        $objectMap.put("macroDechetTabContent", macroDechetTabContent = new MacroWasteBatchUI(this));
        
        macroDechetTabContent.setName("macroDechetTabContent");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FishingOperationsUIModel.class));
    }

    protected void createNewFishingOperationButton() {
        $objectMap.put("newFishingOperationButton", newFishingOperationButton = new JButton());
        
        newFishingOperationButton.setName("newFishingOperationButton");
        newFishingOperationButton.setText(_("tutti.action.new"));
        newFishingOperationButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newFishingOperationButton"));
    }

    protected void createObservationIndividuelTab() {
        $objectMap.put("observationIndividuelTab", observationIndividuelTab = new TabInfo());
        
        observationIndividuelTab.setTitle(_("tutti.label.tab.observationIndividuel"));
    }

    protected void createPlanktonTab() {
        $objectMap.put("planktonTab", planktonTab = new TabInfo());
        
        planktonTab.setTitle(_("tutti.label.tab.plancton"));
    }

    protected void createPlanktonTabContent() {
        $objectMap.put("planktonTabContent", planktonTabContent = new PlanktonBatchUI(this));
        
        planktonTabContent.setName("planktonTabContent");
    }

    protected void createSpeciesTab() {
        $objectMap.put("speciesTab", speciesTab = new TabInfo());
        
        speciesTab.setTitle(_("tutti.label.tab.species"));
    }

    protected void createSpeciesTabContent() {
        $objectMap.put("speciesTabContent", speciesTabContent = new SpeciesBatchUI(this));
        
        speciesTabContent.setName("speciesTabContent");
    }

    protected void createTabPane() {
        $objectMap.put("tabPane", tabPane = new JTabbedPane());
        
        tabPane.setName("tabPane");
    }

    protected void createTopPanel() {
        $objectMap.put("topPanel", topPanel = new Table());
        
        topPanel.setName("topPanel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToTopPanel();
        addChildrenToTabPane();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        $JLabel0.setHorizontalAlignment(JLabel.CENTER);
        fishingOperationComboBox.setBean(model);
        newFishingOperationButton.setIcon(SwingUtil.createActionIcon("add"));
        observationIndividuelTab.setEnabled(false);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createTopPanel();
        createFishingOperationComboBox();
        createNewFishingOperationButton();
        createTabPane();
        createFishingOperationTabContent();
        createSpeciesTabContent();
        createBenthosTabContent();
        createPlanktonTabContent();
        createMacroDechetTabContent();
        createAccidentelTabContent();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("tutti.to.be.done"));
        createFishingOperationTab();
        createSpeciesTab();
        createBenthosTab();
        createPlanktonTab();
        createMacroDechetTab();
        createAccidentelTab();
        createObservationIndividuelTab();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationComboBox.setSelectedItem(model.getSelectedFishingOperation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TAB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTab.setEnabled(model.getSelectedFishingOperation() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TAB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTab.setEnabled(model.getSelectedFishingOperation() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PLANKTON_TAB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    planktonTab.setEnabled(model.getSelectedFishingOperation() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MACRO_DECHET_TAB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    macroDechetTab.setEnabled(model.getSelectedFishingOperation() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTEL_TAB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentelTab.setEnabled(model.getSelectedFishingOperation() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
            }
        });
    }

}