package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.BeaufortScale;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.SeaState;
import fr.ifremer.tutti.persistence.entities.referential.Strata;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.editor.SimpleTimeEditor;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.TimeEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class FishingOperationTabUI extends JPanel implements TuttiUI<FishingOperationTabUIModel, FishingOperationTabUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_AVERAGE_BOTTOM_SALINITY_FIELD_MODEL = "averageBottomSalinityField.model";
    public static final String BINDING_AVERAGE_BOTTOM_SALINITY_FIELD_NUMBER_PATTERN = "averageBottomSalinityField.numberPattern";
    public static final String BINDING_AVERAGE_BOTTOM_TEMPERATURE_FIELD_MODEL = "averageBottomTemperatureField.model";
    public static final String BINDING_AVERAGE_BOTTOM_TEMPERATURE_FIELD_NUMBER_PATTERN = "averageBottomTemperatureField.numberPattern";
    public static final String BINDING_BEAUFORT_SCALE_COMBO_BOX_SELECTED_ITEM = "beaufortScaleComboBox.selectedItem";
    public static final String BINDING_CANCEL_BUTTON_ENABLED = "cancelButton.enabled";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_DATE_FIELD_DATE = "dateField.date";
    public static final String BINDING_DISTANCE_CHALUTEE_FIELD_ENABLED = "distanceChaluteeField.enabled";
    public static final String BINDING_DISTANCE_CHALUTEE_FIELD_MODEL = "distanceChaluteeField.model";
    public static final String BINDING_DISTANCE_CHALUTEE_FIELD_NUMBER_PATTERN = "distanceChaluteeField.numberPattern";
    public static final String BINDING_DUREE_FIELD_MODEL = "dureeField.model";
    public static final String BINDING_DUREE_FIELD_NUMBER_PATTERN = "dureeField.numberPattern";
    public static final String BINDING_FISHING_OPERATION_INVALID_RADIO_SELECTED = "fishingOperationInvalidRadio.selected";
    public static final String BINDING_FISHING_OPERATION_NUMBER_FIELD_MODEL = "fishingOperationNumberField.model";
    public static final String BINDING_FISHING_OPERATION_NUMBER_FIELD_NUMBER_PATTERN = "fishingOperationNumberField.numberPattern";
    public static final String BINDING_FISHING_OPERATION_RECTILIGNE_CHECK_BOX_SELECTED = "fishingOperationRectiligneCheckBox.selected";
    public static final String BINDING_FISHING_OPERATION_RESET_RADIO_SELECTED = "fishingOperationResetRadio.selected";
    public static final String BINDING_FISHING_OPERATION_VALID_RADIO_SELECTED = "fishingOperationValidRadio.selected";
    public static final String BINDING_GEAR_SHOOTING_END_BOTTOM_SALINITY_FIELD_MODEL = "gearShootingEndBottomSalinityField.model";
    public static final String BINDING_GEAR_SHOOTING_END_BOTTOM_SALINITY_FIELD_NUMBER_PATTERN = "gearShootingEndBottomSalinityField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_BOTTOM_TEMPERATURE_FIELD_MODEL = "gearShootingEndBottomTemperatureField.model";
    public static final String BINDING_GEAR_SHOOTING_END_BOTTOM_TEMPERATURE_FIELD_NUMBER_PATTERN = "gearShootingEndBottomTemperatureField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_DATE_FIELD_DATE = "gearShootingEndDateField.date";
    public static final String BINDING_GEAR_SHOOTING_END_DEPTH_FIELD_MODEL = "gearShootingEndDepthField.model";
    public static final String BINDING_GEAR_SHOOTING_END_DEPTH_FIELD_NUMBER_PATTERN = "gearShootingEndDepthField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_FIELD_TEXT = "gearShootingEndLongitudeField.text";
    public static final String BINDING_GEAR_SHOOTING_END_SURFACE_SALINITY_FIELD_MODEL = "gearShootingEndSurfaceSalinityField.model";
    public static final String BINDING_GEAR_SHOOTING_END_SURFACE_SALINITY_FIELD_NUMBER_PATTERN = "gearShootingEndSurfaceSalinityField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_SURFACE_TEMPERATURE_FIELD_MODEL = "gearShootingEndSurfaceTemperatureField.model";
    public static final String BINDING_GEAR_SHOOTING_END_SURFACE_TEMPERATURE_FIELD_NUMBER_PATTERN = "gearShootingEndSurfaceTemperatureField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_TIME_FIELD_DATE = "gearShootingEndTimeField.date";
    public static final String BINDING_GEAR_SHOOTING_START_BOTTOM_SALINITY_FIELD_MODEL = "gearShootingStartBottomSalinityField.model";
    public static final String BINDING_GEAR_SHOOTING_START_BOTTOM_SALINITY_FIELD_NUMBER_PATTERN = "gearShootingStartBottomSalinityField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_BOTTOM_TEMPERATURE_FIELD_MODEL = "gearShootingStartBottomTemperatureField.model";
    public static final String BINDING_GEAR_SHOOTING_START_BOTTOM_TEMPERATURE_FIELD_NUMBER_PATTERN = "gearShootingStartBottomTemperatureField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_DATE_FIELD_DATE = "gearShootingStartDateField.date";
    public static final String BINDING_GEAR_SHOOTING_START_DEPTH_FIELD_MODEL = "gearShootingStartDepthField.model";
    public static final String BINDING_GEAR_SHOOTING_START_DEPTH_FIELD_NUMBER_PATTERN = "gearShootingStartDepthField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_FIELD_TEXT = "gearShootingStartLongitudeField.text";
    public static final String BINDING_GEAR_SHOOTING_START_SURFACE_SALINITY_FIELD_MODEL = "gearShootingStartSurfaceSalinityField.model";
    public static final String BINDING_GEAR_SHOOTING_START_SURFACE_SALINITY_FIELD_NUMBER_PATTERN = "gearShootingStartSurfaceSalinityField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_SURFACE_TEMPERATURE_FIELD_MODEL = "gearShootingStartSurfaceTemperatureField.model";
    public static final String BINDING_GEAR_SHOOTING_START_SURFACE_TEMPERATURE_FIELD_NUMBER_PATTERN = "gearShootingStartSurfaceTemperatureField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_TIME_FIELD_DATE = "gearShootingStartTimeField.date";
    public static final String BINDING_GEOMETRIE_MESUREE_CHECK_BOX_SELECTED = "geometrieMesureeCheckBox.selected";
    public static final String BINDING_LOCALITE_FIELD_TEXT = "localiteField.text";
    public static final String BINDING_LONGUEUR_BRAS_FIELD_MODEL = "longueurBrasField.model";
    public static final String BINDING_LONGUEUR_BRAS_FIELD_NUMBER_PATTERN = "longueurBrasField.numberPattern";
    public static final String BINDING_LONGUEUR_FUNES_FIELD_MODEL = "longueurFunesField.model";
    public static final String BINDING_LONGUEUR_FUNES_FIELD_NUMBER_PATTERN = "longueurFunesField.numberPattern";
    public static final String BINDING_OUVERTURE_HORIZONTALE_FIELD_MODEL = "ouvertureHorizontaleField.model";
    public static final String BINDING_OUVERTURE_HORIZONTALE_FIELD_NUMBER_PATTERN = "ouvertureHorizontaleField.numberPattern";
    public static final String BINDING_OUVERTURE_VERTICALE_FIELD_MODEL = "ouvertureVerticaleField.model";
    public static final String BINDING_OUVERTURE_VERTICALE_FIELD_NUMBER_PATTERN = "ouvertureVerticaleField.numberPattern";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SEA_STATE_COMBO_BOX_SELECTED_ITEM = "seaStateComboBox.selectedItem";
    public static final String BINDING_STATION_NUMBER_FIELD_MODEL = "stationNumberField.model";
    public static final String BINDING_STATION_NUMBER_FIELD_NUMBER_PATTERN = "stationNumberField.numberPattern";
    public static final String BINDING_STRATA_COMBO_BOX_SELECTED_ITEM = "strataComboBox.selectedItem";
    public static final String BINDING_SUB_STRATA_COMBO_BOX_SELECTED_ITEM = "subStrataComboBox.selectedItem";
    public static final String BINDING_SYSTEME_FERMETURE_CUL_CHECK_BOX_SELECTED = "systemeFermetureCulCheckBox.selected";
    public static final String BINDING_WIND_DIRECTION_FIELD_MODEL = "windDirectionField.model";
    public static final String BINDING_WIND_DIRECTION_FIELD_NUMBER_PATTERN = "windDirectionField.numberPattern";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(FishingOperationTabUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected NumberEditor averageBottomSalinityField;
    protected JLabel averageBottomSalinityLabel;
    protected NumberEditor averageBottomTemperatureField;
    protected JLabel averageBottomTemperatureLabel;
    protected BeanComboBox<BeaufortScale> beaufortScaleComboBox;
    protected JLabel beaufortScaleLabel;
    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentField")
    protected JTextArea commentField;
    protected JScrollPane commentPane;
    @ValidatorField( validatorId = "validator",  propertyName = "date",  editorName = "dateField")
    protected JXDatePicker dateField;
    protected JLabel dateLabel;
    protected NumberEditor distanceChaluteeField;
    protected JLabel distanceChaluteeLabel;
    protected NumberEditor dureeField;
    protected JLabel dureeLabel;
    protected Table environmentForm;
    protected TabInfo environmentTab;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected JRadioButton fishingOperationInvalidRadio;
    @ValidatorField( validatorId = "validator",  propertyName = "fishingOperationNumber",  editorName = "fishingOperationNumberField")
    protected NumberEditor fishingOperationNumberField;
    protected JLabel fishingOperationNumberLabel;
    protected JPanel fishingOperationPane;
    protected JCheckBox fishingOperationRectiligneCheckBox;
    protected JRadioButton fishingOperationResetRadio;
    protected JTabbedPane fishingOperationTabPane;
    protected JAXXButtonGroup fishingOperationValid;
    protected JToolBar fishingOperationValidPanel;
    protected JRadioButton fishingOperationValidRadio;
    protected Table gearCaracteristicsTable;
    protected JLabel gearDateLabel;
    protected JLabel gearLatitudeLabel;
    protected JLabel gearLongitudeLabel;
    protected NumberEditor gearShootingEndBottomSalinityField;
    protected JLabel gearShootingEndBottomSalinityLabel;
    protected NumberEditor gearShootingEndBottomTemperatureField;
    protected JLabel gearShootingEndBottomTemperatureLabel;
    protected JXDatePicker gearShootingEndDateField;
    protected NumberEditor gearShootingEndDepthField;
    protected JLabel gearShootingEndDepthLabel;
    protected JLabel gearShootingEndLabel;
    protected JTextField gearShootingEndLatitudeLabel;
    protected JTextField gearShootingEndLongitudeField;
    protected NumberEditor gearShootingEndSurfaceSalinityField;
    protected JLabel gearShootingEndSurfaceSalinityLabel;
    protected NumberEditor gearShootingEndSurfaceTemperatureField;
    protected JLabel gearShootingEndSurfaceTemperatureLabel;
    protected SimpleTimeEditor gearShootingEndTimeField;
    protected Table gearShootingForm;
    protected NumberEditor gearShootingStartBottomSalinityField;
    protected JLabel gearShootingStartBottomSalinityLabel;
    protected NumberEditor gearShootingStartBottomTemperatureField;
    protected JLabel gearShootingStartBottomTemperatureLabel;
    protected JXDatePicker gearShootingStartDateField;
    protected NumberEditor gearShootingStartDepthField;
    protected JLabel gearShootingStartDepthLabel;
    protected JLabel gearShootingStartLabel;
    protected JTextField gearShootingStartLatitudeLabel;
    protected JTextField gearShootingStartLongitudeField;
    protected NumberEditor gearShootingStartSurfaceSalinityField;
    protected JLabel gearShootingStartSurfaceSalinityLabel;
    protected NumberEditor gearShootingStartSurfaceTemperatureField;
    protected JLabel gearShootingStartSurfaceTemperatureLabel;
    protected SimpleTimeEditor gearShootingStartTimeField;
    protected JLabel gearTimeLabel;
    protected Table generalForm;
    protected JCheckBox geometrieMesureeCheckBox;
    protected FishingOperationTabUIHandler handler;
    protected FishingOperationTabUI homePanel = this;
    protected Table hydrologyForm;
    protected JButton importCasinoButton;
    protected JButton importPupitriButton;
    protected JTextField localiteField;
    protected JLabel localiteLabel;
    protected NumberEditor longueurBrasField;
    protected JLabel longueurBrasLabel;
    protected NumberEditor longueurFunesField;
    protected JLabel longueurFunesLabel;
    protected FishingOperationTabUIModel model;
    protected JLabel noTraitPane;
    protected NumberEditor ouvertureHorizontaleField;
    protected JLabel ouvertureHorizontaleLabel;
    protected NumberEditor ouvertureVerticaleField;
    protected JLabel ouvertureVerticaleLabel;
    protected JButton resetValidStateButton;
    @ValidatorField( validatorId = "validator",  propertyName = "saisisseur",  editorName = "saisisseurList")
    protected BeanDoubleList<Person> saisisseurList;
    protected JButton saveButton;
    protected BeanComboBox<SeaState> seaStateComboBox;
    protected JLabel seaStateLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "stationNumber",  editorName = "stationNumberField")
    protected NumberEditor stationNumberField;
    protected JLabel stationNumberLabel;
    protected BeanComboBox<Strata> strataComboBox;
    protected JLabel strataLabel;
    protected BeanComboBox<Strata> subStrataComboBox;
    protected JLabel subStrataLabel;
    protected JCheckBox systemeFermetureCulCheckBox;
    protected TabInfo traitGearShootingTab;
    protected TabInfo traitGeneralTab;
    protected TabInfo traitHydrologyTabContent;
    @Validator( validatorId = "validator")
    protected SwingValidator<FishingOperationTabUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected NumberEditor windDirectionField;
    protected JLabel windDirectionLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private HBox $HBox0;
    private JLabel $JLabel0;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JPanel $JPanel4;
    private JPanel $JPanel5;
    private JPanel $JPanel6;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public void selectFishingOperation(FishingOperation fishingOperation) { handler.selectFishingOperation(fishingOperation); }
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FishingOperationTabUI(FishingOperationsUI parentUI) {
        FishingOperationTabUIHandler handler = new FishingOperationTabUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public FishingOperationTabUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FishingOperationTabUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationTabUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FishingOperationTabUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationTabUI() {
        $initialize();
    }

    public FishingOperationTabUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationTabUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public FishingOperationTabUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__dateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "date");
    }

    public void doActionPerformed__on__fishingOperationInvalidRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(Boolean.FALSE);
    }

    public void doActionPerformed__on__fishingOperationValidRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(Boolean.TRUE);
    }

    public void doActionPerformed__on__gearShootingEndDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "gearShootingEndDate");
    }

    public void doActionPerformed__on__gearShootingStartDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "gearShootingStartDate");
    }

    public void doActionPerformed__on__importCasinoButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importCasino();
    }

    public void doActionPerformed__on__importPupitriButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importPupitri();
    }

    public void doActionPerformed__on__resetValidStateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(null);
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doItemStateChanged__on__fishingOperationRectiligneCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "fishingOperationRectiligne");
    }

    public void doItemStateChanged__on__geometrieMesureeCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "geometrieMesuree");
    }

    public void doItemStateChanged__on__systemeFermetureCulCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "systemeFermetureCul");
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__gearShootingEndLatitudeLabel(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setGearShootingEndLatitude(((JTextField)event.getSource()).getText());
    }

    public void doKeyReleased__on__gearShootingEndLongitudeField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setGearShootingEndLongitude(((JTextField)event.getSource()).getText());
    }

    public void doKeyReleased__on__gearShootingStartLatitudeLabel(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setGearShootingStartLatitude(((JTextField)event.getSource()).getText());
    }

    public void doKeyReleased__on__gearShootingStartLongitudeField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setGearShootingStartLongitude(((JTextField)event.getSource()).getText());
    }

    public void doKeyReleased__on__localiteField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "localite");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditor getAverageBottomSalinityField() {
        return averageBottomSalinityField;
    }

    public JLabel getAverageBottomSalinityLabel() {
        return averageBottomSalinityLabel;
    }

    public NumberEditor getAverageBottomTemperatureField() {
        return averageBottomTemperatureField;
    }

    public JLabel getAverageBottomTemperatureLabel() {
        return averageBottomTemperatureLabel;
    }

    public BeanComboBox<BeaufortScale> getBeaufortScaleComboBox() {
        return beaufortScaleComboBox;
    }

    public JLabel getBeaufortScaleLabel() {
        return beaufortScaleLabel;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public JXDatePicker getDateField() {
        return dateField;
    }

    public JLabel getDateLabel() {
        return dateLabel;
    }

    public NumberEditor getDistanceChaluteeField() {
        return distanceChaluteeField;
    }

    public JLabel getDistanceChaluteeLabel() {
        return distanceChaluteeLabel;
    }

    public NumberEditor getDureeField() {
        return dureeField;
    }

    public JLabel getDureeLabel() {
        return dureeLabel;
    }

    public Table getEnvironmentForm() {
        return environmentForm;
    }

    public TabInfo getEnvironmentTab() {
        return environmentTab;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public JRadioButton getFishingOperationInvalidRadio() {
        return fishingOperationInvalidRadio;
    }

    public NumberEditor getFishingOperationNumberField() {
        return fishingOperationNumberField;
    }

    public JLabel getFishingOperationNumberLabel() {
        return fishingOperationNumberLabel;
    }

    public JPanel getFishingOperationPane() {
        return fishingOperationPane;
    }

    public JCheckBox getFishingOperationRectiligneCheckBox() {
        return fishingOperationRectiligneCheckBox;
    }

    public JRadioButton getFishingOperationResetRadio() {
        return fishingOperationResetRadio;
    }

    public JTabbedPane getFishingOperationTabPane() {
        return fishingOperationTabPane;
    }

    public JAXXButtonGroup getFishingOperationValid() {
        return fishingOperationValid;
    }

    public JToolBar getFishingOperationValidPanel() {
        return fishingOperationValidPanel;
    }

    public JRadioButton getFishingOperationValidRadio() {
        return fishingOperationValidRadio;
    }

    public Table getGearCaracteristicsTable() {
        return gearCaracteristicsTable;
    }

    public JLabel getGearDateLabel() {
        return gearDateLabel;
    }

    public JLabel getGearLatitudeLabel() {
        return gearLatitudeLabel;
    }

    public JLabel getGearLongitudeLabel() {
        return gearLongitudeLabel;
    }

    public NumberEditor getGearShootingEndBottomSalinityField() {
        return gearShootingEndBottomSalinityField;
    }

    public JLabel getGearShootingEndBottomSalinityLabel() {
        return gearShootingEndBottomSalinityLabel;
    }

    public NumberEditor getGearShootingEndBottomTemperatureField() {
        return gearShootingEndBottomTemperatureField;
    }

    public JLabel getGearShootingEndBottomTemperatureLabel() {
        return gearShootingEndBottomTemperatureLabel;
    }

    public JXDatePicker getGearShootingEndDateField() {
        return gearShootingEndDateField;
    }

    public NumberEditor getGearShootingEndDepthField() {
        return gearShootingEndDepthField;
    }

    public JLabel getGearShootingEndDepthLabel() {
        return gearShootingEndDepthLabel;
    }

    public JLabel getGearShootingEndLabel() {
        return gearShootingEndLabel;
    }

    public JTextField getGearShootingEndLatitudeLabel() {
        return gearShootingEndLatitudeLabel;
    }

    public JTextField getGearShootingEndLongitudeField() {
        return gearShootingEndLongitudeField;
    }

    public NumberEditor getGearShootingEndSurfaceSalinityField() {
        return gearShootingEndSurfaceSalinityField;
    }

    public JLabel getGearShootingEndSurfaceSalinityLabel() {
        return gearShootingEndSurfaceSalinityLabel;
    }

    public NumberEditor getGearShootingEndSurfaceTemperatureField() {
        return gearShootingEndSurfaceTemperatureField;
    }

    public JLabel getGearShootingEndSurfaceTemperatureLabel() {
        return gearShootingEndSurfaceTemperatureLabel;
    }

    public SimpleTimeEditor getGearShootingEndTimeField() {
        return gearShootingEndTimeField;
    }

    public Table getGearShootingForm() {
        return gearShootingForm;
    }

    public NumberEditor getGearShootingStartBottomSalinityField() {
        return gearShootingStartBottomSalinityField;
    }

    public JLabel getGearShootingStartBottomSalinityLabel() {
        return gearShootingStartBottomSalinityLabel;
    }

    public NumberEditor getGearShootingStartBottomTemperatureField() {
        return gearShootingStartBottomTemperatureField;
    }

    public JLabel getGearShootingStartBottomTemperatureLabel() {
        return gearShootingStartBottomTemperatureLabel;
    }

    public JXDatePicker getGearShootingStartDateField() {
        return gearShootingStartDateField;
    }

    public NumberEditor getGearShootingStartDepthField() {
        return gearShootingStartDepthField;
    }

    public JLabel getGearShootingStartDepthLabel() {
        return gearShootingStartDepthLabel;
    }

    public JLabel getGearShootingStartLabel() {
        return gearShootingStartLabel;
    }

    public JTextField getGearShootingStartLatitudeLabel() {
        return gearShootingStartLatitudeLabel;
    }

    public JTextField getGearShootingStartLongitudeField() {
        return gearShootingStartLongitudeField;
    }

    public NumberEditor getGearShootingStartSurfaceSalinityField() {
        return gearShootingStartSurfaceSalinityField;
    }

    public JLabel getGearShootingStartSurfaceSalinityLabel() {
        return gearShootingStartSurfaceSalinityLabel;
    }

    public NumberEditor getGearShootingStartSurfaceTemperatureField() {
        return gearShootingStartSurfaceTemperatureField;
    }

    public JLabel getGearShootingStartSurfaceTemperatureLabel() {
        return gearShootingStartSurfaceTemperatureLabel;
    }

    public SimpleTimeEditor getGearShootingStartTimeField() {
        return gearShootingStartTimeField;
    }

    public JLabel getGearTimeLabel() {
        return gearTimeLabel;
    }

    public Table getGeneralForm() {
        return generalForm;
    }

    public JCheckBox getGeometrieMesureeCheckBox() {
        return geometrieMesureeCheckBox;
    }

    public FishingOperationTabUIHandler getHandler() {
        return handler;
    }

    public Table getHydrologyForm() {
        return hydrologyForm;
    }

    public JButton getImportCasinoButton() {
        return importCasinoButton;
    }

    public JButton getImportPupitriButton() {
        return importPupitriButton;
    }

    public JTextField getLocaliteField() {
        return localiteField;
    }

    public JLabel getLocaliteLabel() {
        return localiteLabel;
    }

    public NumberEditor getLongueurBrasField() {
        return longueurBrasField;
    }

    public JLabel getLongueurBrasLabel() {
        return longueurBrasLabel;
    }

    public NumberEditor getLongueurFunesField() {
        return longueurFunesField;
    }

    public JLabel getLongueurFunesLabel() {
        return longueurFunesLabel;
    }

    public FishingOperationTabUIModel getModel() {
        return model;
    }

    public JLabel getNoTraitPane() {
        return noTraitPane;
    }

    public NumberEditor getOuvertureHorizontaleField() {
        return ouvertureHorizontaleField;
    }

    public JLabel getOuvertureHorizontaleLabel() {
        return ouvertureHorizontaleLabel;
    }

    public NumberEditor getOuvertureVerticaleField() {
        return ouvertureVerticaleField;
    }

    public JLabel getOuvertureVerticaleLabel() {
        return ouvertureVerticaleLabel;
    }

    public JButton getResetValidStateButton() {
        return resetValidStateButton;
    }

    public BeanDoubleList<Person> getSaisisseurList() {
        return saisisseurList;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public BeanComboBox<SeaState> getSeaStateComboBox() {
        return seaStateComboBox;
    }

    public JLabel getSeaStateLabel() {
        return seaStateLabel;
    }

    public NumberEditor getStationNumberField() {
        return stationNumberField;
    }

    public JLabel getStationNumberLabel() {
        return stationNumberLabel;
    }

    public BeanComboBox<Strata> getStrataComboBox() {
        return strataComboBox;
    }

    public JLabel getStrataLabel() {
        return strataLabel;
    }

    public BeanComboBox<Strata> getSubStrataComboBox() {
        return subStrataComboBox;
    }

    public JLabel getSubStrataLabel() {
        return subStrataLabel;
    }

    public JCheckBox getSystemeFermetureCulCheckBox() {
        return systemeFermetureCulCheckBox;
    }

    public TabInfo getTraitGearShootingTab() {
        return traitGearShootingTab;
    }

    public TabInfo getTraitGeneralTab() {
        return traitGeneralTab;
    }

    public TabInfo getTraitHydrologyTabContent() {
        return traitHydrologyTabContent;
    }

    public SwingValidator<FishingOperationTabUIModel> getValidator() {
        return validator;
    }

    public NumberEditor getWindDirectionField() {
        return windDirectionField;
    }

    public JLabel getWindDirectionLabel() {
        return windDirectionLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected JPanel get$JPanel6() {
        return $JPanel6;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(SwingUtil.boxComponentWithJxLayer(commentField));
    }

    protected void addChildrenToEnvironmentForm() {
        if (!allComponentsCreated) {
            return;
        }
        environmentForm.add(beaufortScaleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        environmentForm.add(beaufortScaleComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        environmentForm.add(windDirectionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        environmentForm.add(windDirectionField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        environmentForm.add(seaStateLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        environmentForm.add(seaStateComboBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToFishingOperationInvalidRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationInvalidRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationInvalidRadio); }
    }

    protected void addChildrenToFishingOperationPane() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationPane.add(fishingOperationTabPane, BorderLayout.CENTER);
        fishingOperationPane.add($JPanel5, BorderLayout.SOUTH);
    }

    protected void addChildrenToFishingOperationResetRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationResetRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationResetRadio); }
    }

    protected void addChildrenToFishingOperationTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationTabPane.add(generalForm);
        fishingOperationTabPane.add(gearShootingForm);
        fishingOperationTabPane.add(environmentForm);
        fishingOperationTabPane.add(hydrologyForm);
        traitGeneralTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 0));
        fishingOperationTabPane.setTitleAt(0, _("tutti.label.tab.fishingOperation.general"));
        traitGearShootingTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 1));
        fishingOperationTabPane.setTitleAt(1, _("tutti.label.tab.fishingOperation.gearShooting"));
        environmentTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 2));
        fishingOperationTabPane.setTitleAt(2, _("tutti.label.tab.fishingOperation.environment"));
        traitHydrologyTabContent.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 3));
        fishingOperationTabPane.setTitleAt(3, _("tutti.label.tab.fishingOperation.hydrology"));
    }

    protected void addChildrenToFishingOperationValidPanel() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationValidPanel.add(resetValidStateButton, BorderLayout.WEST);
        fishingOperationValidPanel.add(fishingOperationResetRadio, BorderLayout.EAST);
    }

    protected void addChildrenToFishingOperationValidRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationValidRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationValidRadio); }
    }

    protected void addChildrenToGearCaracteristicsTable() {
        if (!allComponentsCreated) {
            return;
        }
        gearCaracteristicsTable.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearLongitudeLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearLatitudeLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearDateLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearTimeLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLongitudeField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLatitudeLabel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartDateField, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartTimeField, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLongitudeField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLatitudeLabel, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndDateField, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndTimeField, new GridBagConstraints(4, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToGearShootingForm() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingForm.add(gearShootingStartDepthLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingStartDepthField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingEndDepthLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(gearShootingEndDepthField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(ouvertureHorizontaleLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(ouvertureHorizontaleField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(ouvertureVerticaleLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(ouvertureVerticaleField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(longueurFunesLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(longueurFunesField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(longueurBrasLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add(longueurBrasField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        gearShootingForm.add($JPanel4, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToGeneralForm() {
        if (!allComponentsCreated) {
            return;
        }
        generalForm.add(stationNumberLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(stationNumberField), new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(fishingOperationNumberLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(fishingOperationNumberField), new GridBagConstraints(3, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(dateLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(dateField), new GridBagConstraints(5, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(strataLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(strataComboBox, new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(subStrataLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(subStrataComboBox, new GridBagConstraints(3, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(localiteLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(localiteField, new GridBagConstraints(5, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel0, new GridBagConstraints(0, 2, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(fishingOperationValidPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($HBox0, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel1, new GridBagConstraints(2, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(fishingOperationRectiligneCheckBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel2, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(dureeLabel, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(dureeField, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel3, new GridBagConstraints(0, 5, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(saisisseurList), new GridBagConstraints(0, 6, 6, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(commentPane, new GridBagConstraints(0, 7, 6, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(fishingOperationPane, BorderLayout.CENTER);
        add(noTraitPane);
    }

    protected void addChildrenToHydrologyForm() {
        if (!allComponentsCreated) {
            return;
        }
        hydrologyForm.add(gearShootingStartSurfaceTemperatureLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingStartSurfaceTemperatureField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingEndSurfaceTemperatureLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingEndSurfaceTemperatureField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingStartBottomTemperatureLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingStartBottomTemperatureField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingEndBottomTemperatureLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingEndBottomTemperatureField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(averageBottomTemperatureLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(averageBottomTemperatureField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingStartSurfaceSalinityLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingStartSurfaceSalinityField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingEndSurfaceSalinityLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingEndSurfaceSalinityField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingStartBottomSalinityLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingStartBottomSalinityField, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingEndBottomSalinityLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(gearShootingEndBottomSalinityField, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(averageBottomSalinityLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        hydrologyForm.add(averageBottomSalinityField, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAverageBottomSalinityField() {
        $objectMap.put("averageBottomSalinityField", averageBottomSalinityField = new NumberEditor(this));
        
        averageBottomSalinityField.setName("averageBottomSalinityField");
        averageBottomSalinityField.setProperty("averageBottomSalinity");
        averageBottomSalinityField.setUseFloat(false);
        averageBottomSalinityField.setShowReset(true);
    }

    protected void createAverageBottomSalinityLabel() {
        $objectMap.put("averageBottomSalinityLabel", averageBottomSalinityLabel = new JLabel());
        
        averageBottomSalinityLabel.setName("averageBottomSalinityLabel");
        averageBottomSalinityLabel.setText(_("tutti.label.fishingOperation.averageBottomSalinity"));
    }

    protected void createAverageBottomTemperatureField() {
        $objectMap.put("averageBottomTemperatureField", averageBottomTemperatureField = new NumberEditor(this));
        
        averageBottomTemperatureField.setName("averageBottomTemperatureField");
        averageBottomTemperatureField.setProperty("averageBottomTemperature");
        averageBottomTemperatureField.setUseFloat(false);
        averageBottomTemperatureField.setShowReset(true);
    }

    protected void createAverageBottomTemperatureLabel() {
        $objectMap.put("averageBottomTemperatureLabel", averageBottomTemperatureLabel = new JLabel());
        
        averageBottomTemperatureLabel.setName("averageBottomTemperatureLabel");
        averageBottomTemperatureLabel.setText(_("tutti.label.fishingOperation.averageBottomTemperature"));
    }

    protected void createBeaufortScaleComboBox() {
        $objectMap.put("beaufortScaleComboBox", beaufortScaleComboBox = new BeanComboBox<BeaufortScale>(this));
        
        beaufortScaleComboBox.setName("beaufortScaleComboBox");
        beaufortScaleComboBox.setI18nPrefix("tutti.property.");
        beaufortScaleComboBox.setProperty("beaufortScale");
        beaufortScaleComboBox.setShowReset(true);
    }

    protected void createBeaufortScaleLabel() {
        $objectMap.put("beaufortScaleLabel", beaufortScaleLabel = new JLabel());
        
        beaufortScaleLabel.setName("beaufortScaleLabel");
        beaufortScaleLabel.setText(_("tutti.label.fishingOperation.beaufortScale"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.action.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
    }

    protected void createDateField() {
        $objectMap.put("dateField", dateField = new JXDatePicker());
        
        dateField.setName("dateField");
        dateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__dateField"));
    }

    protected void createDateLabel() {
        $objectMap.put("dateLabel", dateLabel = new JLabel());
        
        dateLabel.setName("dateLabel");
        dateLabel.setText(_("tutti.label.fishingOperation.date"));
    }

    protected void createDistanceChaluteeField() {
        $objectMap.put("distanceChaluteeField", distanceChaluteeField = new NumberEditor(this));
        
        distanceChaluteeField.setName("distanceChaluteeField");
        distanceChaluteeField.setProperty("distanceChalutee");
        distanceChaluteeField.setUseFloat(false);
        distanceChaluteeField.setShowReset(true);
    }

    protected void createDistanceChaluteeLabel() {
        $objectMap.put("distanceChaluteeLabel", distanceChaluteeLabel = new JLabel());
        
        distanceChaluteeLabel.setName("distanceChaluteeLabel");
        distanceChaluteeLabel.setText(_("tutti.label.fishingOperation.distanceChalutee"));
    }

    protected void createDureeField() {
        $objectMap.put("dureeField", dureeField = new NumberEditor(this));
        
        dureeField.setName("dureeField");
        dureeField.setProperty("duree");
        dureeField.setUseFloat(false);
        dureeField.setShowReset(true);
    }

    protected void createDureeLabel() {
        $objectMap.put("dureeLabel", dureeLabel = new JLabel());
        
        dureeLabel.setName("dureeLabel");
        dureeLabel.setText(_("tutti.label.fishingOperation.duree"));
    }

    protected void createEnvironmentForm() {
        $objectMap.put("environmentForm", environmentForm = new Table());
        
        environmentForm.setName("environmentForm");
    }

    protected void createEnvironmentTab() {
        $objectMap.put("environmentTab", environmentTab = new TabInfo());
        
        environmentTab.setTitle(_("tutti.label.tab.fishingOperation.environment"));
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createFishingOperationInvalidRadio() {
        $objectMap.put("fishingOperationInvalidRadio", fishingOperationInvalidRadio = new JRadioButton());
        
        fishingOperationInvalidRadio.setName("fishingOperationInvalidRadio");
        fishingOperationInvalidRadio.setText(_("tutti.label.fishingOperation.fishingOperationInvalid"));
        fishingOperationInvalidRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fishingOperationInvalidRadio"));
    }

    protected void createFishingOperationNumberField() {
        $objectMap.put("fishingOperationNumberField", fishingOperationNumberField = new NumberEditor(this));
        
        fishingOperationNumberField.setName("fishingOperationNumberField");
        fishingOperationNumberField.setProperty("fishingOperationNumber");
        fishingOperationNumberField.setUseFloat(false);
        fishingOperationNumberField.setShowReset(true);
    }

    protected void createFishingOperationNumberLabel() {
        $objectMap.put("fishingOperationNumberLabel", fishingOperationNumberLabel = new JLabel());
        
        fishingOperationNumberLabel.setName("fishingOperationNumberLabel");
        fishingOperationNumberLabel.setText(_("tutti.label.fishingOperation.fishingOperationNumber"));
    }

    protected void createFishingOperationPane() {
        $objectMap.put("fishingOperationPane", fishingOperationPane = new JPanel());
        
        fishingOperationPane.setName("fishingOperationPane");
        fishingOperationPane.setLayout(new BorderLayout());
    }

    protected void createFishingOperationRectiligneCheckBox() {
        $objectMap.put("fishingOperationRectiligneCheckBox", fishingOperationRectiligneCheckBox = new JCheckBox());
        
        fishingOperationRectiligneCheckBox.setName("fishingOperationRectiligneCheckBox");
        fishingOperationRectiligneCheckBox.setText(_("tutti.label.fishingOperation.fishingOperationRectiligne"));
        fishingOperationRectiligneCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fishingOperationRectiligneCheckBox"));
    }

    protected void createFishingOperationResetRadio() {
        $objectMap.put("fishingOperationResetRadio", fishingOperationResetRadio = new JRadioButton());
        
        fishingOperationResetRadio.setName("fishingOperationResetRadio");
    }

    protected void createFishingOperationTabPane() {
        $objectMap.put("fishingOperationTabPane", fishingOperationTabPane = new JTabbedPane());
        
        fishingOperationTabPane.setName("fishingOperationTabPane");
    }

    protected void createFishingOperationValid() {
        $objectMap.put("fishingOperationValid", fishingOperationValid = new JAXXButtonGroup());
    }

    protected void createFishingOperationValidPanel() {
        $objectMap.put("fishingOperationValidPanel", fishingOperationValidPanel = new JToolBar());
        
        fishingOperationValidPanel.setName("fishingOperationValidPanel");
        fishingOperationValidPanel.setLayout(new BorderLayout());
        fishingOperationValidPanel.setFloatable(false);
        fishingOperationValidPanel.setOpaque(false);
        fishingOperationValidPanel.setBorderPainted(false);
    }

    protected void createFishingOperationValidRadio() {
        $objectMap.put("fishingOperationValidRadio", fishingOperationValidRadio = new JRadioButton());
        
        fishingOperationValidRadio.setName("fishingOperationValidRadio");
        fishingOperationValidRadio.setText(_("tutti.label.fishingOperation.fishingOperationValid"));
        fishingOperationValidRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fishingOperationValidRadio"));
    }

    protected void createGearCaracteristicsTable() {
        $objectMap.put("gearCaracteristicsTable", gearCaracteristicsTable = new Table());
        
        gearCaracteristicsTable.setName("gearCaracteristicsTable");
    }

    protected void createGearDateLabel() {
        $objectMap.put("gearDateLabel", gearDateLabel = new JLabel());
        
        gearDateLabel.setName("gearDateLabel");
        gearDateLabel.setText(_("tutti.label.fishingOperation.gearDate"));
    }

    protected void createGearLatitudeLabel() {
        $objectMap.put("gearLatitudeLabel", gearLatitudeLabel = new JLabel());
        
        gearLatitudeLabel.setName("gearLatitudeLabel");
        gearLatitudeLabel.setText(_("tutti.label.fishingOperation.gearLatitude"));
    }

    protected void createGearLongitudeLabel() {
        $objectMap.put("gearLongitudeLabel", gearLongitudeLabel = new JLabel());
        
        gearLongitudeLabel.setName("gearLongitudeLabel");
        gearLongitudeLabel.setText(_("tutti.label.fishingOperation.gearLongitude"));
    }

    protected void createGearShootingEndBottomSalinityField() {
        $objectMap.put("gearShootingEndBottomSalinityField", gearShootingEndBottomSalinityField = new NumberEditor(this));
        
        gearShootingEndBottomSalinityField.setName("gearShootingEndBottomSalinityField");
        gearShootingEndBottomSalinityField.setProperty("gearShootingEndBottomSalinity");
        gearShootingEndBottomSalinityField.setUseFloat(false);
        gearShootingEndBottomSalinityField.setShowReset(true);
    }

    protected void createGearShootingEndBottomSalinityLabel() {
        $objectMap.put("gearShootingEndBottomSalinityLabel", gearShootingEndBottomSalinityLabel = new JLabel());
        
        gearShootingEndBottomSalinityLabel.setName("gearShootingEndBottomSalinityLabel");
        gearShootingEndBottomSalinityLabel.setText(_("tutti.label.fishingOperation.gearShootingEndBottomSalinity"));
    }

    protected void createGearShootingEndBottomTemperatureField() {
        $objectMap.put("gearShootingEndBottomTemperatureField", gearShootingEndBottomTemperatureField = new NumberEditor(this));
        
        gearShootingEndBottomTemperatureField.setName("gearShootingEndBottomTemperatureField");
        gearShootingEndBottomTemperatureField.setProperty("gearShootingEndBottomTemperature");
        gearShootingEndBottomTemperatureField.setUseFloat(false);
        gearShootingEndBottomTemperatureField.setShowReset(true);
    }

    protected void createGearShootingEndBottomTemperatureLabel() {
        $objectMap.put("gearShootingEndBottomTemperatureLabel", gearShootingEndBottomTemperatureLabel = new JLabel());
        
        gearShootingEndBottomTemperatureLabel.setName("gearShootingEndBottomTemperatureLabel");
        gearShootingEndBottomTemperatureLabel.setText(_("tutti.label.fishingOperation.gearShootingEndBottomTemperature"));
    }

    protected void createGearShootingEndDateField() {
        $objectMap.put("gearShootingEndDateField", gearShootingEndDateField = new JXDatePicker());
        
        gearShootingEndDateField.setName("gearShootingEndDateField");
        gearShootingEndDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearShootingEndDateField"));
    }

    protected void createGearShootingEndDepthField() {
        $objectMap.put("gearShootingEndDepthField", gearShootingEndDepthField = new NumberEditor(this));
        
        gearShootingEndDepthField.setName("gearShootingEndDepthField");
        gearShootingEndDepthField.setProperty("gearShootingEndDepth");
        gearShootingEndDepthField.setUseFloat(false);
        gearShootingEndDepthField.setShowReset(true);
    }

    protected void createGearShootingEndDepthLabel() {
        $objectMap.put("gearShootingEndDepthLabel", gearShootingEndDepthLabel = new JLabel());
        
        gearShootingEndDepthLabel.setName("gearShootingEndDepthLabel");
        gearShootingEndDepthLabel.setText(_("tutti.label.fishingOperation.gearShootingEndDepth"));
    }

    protected void createGearShootingEndLabel() {
        $objectMap.put("gearShootingEndLabel", gearShootingEndLabel = new JLabel());
        
        gearShootingEndLabel.setName("gearShootingEndLabel");
        gearShootingEndLabel.setText(_("tutti.label.fishingOperation.gearShootingEnd"));
    }

    protected void createGearShootingEndLatitudeLabel() {
        $objectMap.put("gearShootingEndLatitudeLabel", gearShootingEndLatitudeLabel = new JTextField());
        
        gearShootingEndLatitudeLabel.setName("gearShootingEndLatitudeLabel");
        gearShootingEndLatitudeLabel.setColumns(15);
        gearShootingEndLatitudeLabel.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__gearShootingEndLatitudeLabel"));
    }

    protected void createGearShootingEndLongitudeField() {
        $objectMap.put("gearShootingEndLongitudeField", gearShootingEndLongitudeField = new JTextField());
        
        gearShootingEndLongitudeField.setName("gearShootingEndLongitudeField");
        gearShootingEndLongitudeField.setColumns(15);
        gearShootingEndLongitudeField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__gearShootingEndLongitudeField"));
    }

    protected void createGearShootingEndSurfaceSalinityField() {
        $objectMap.put("gearShootingEndSurfaceSalinityField", gearShootingEndSurfaceSalinityField = new NumberEditor(this));
        
        gearShootingEndSurfaceSalinityField.setName("gearShootingEndSurfaceSalinityField");
        gearShootingEndSurfaceSalinityField.setProperty("gearShootingEndSurfaceSalinity");
        gearShootingEndSurfaceSalinityField.setUseFloat(false);
        gearShootingEndSurfaceSalinityField.setShowReset(true);
    }

    protected void createGearShootingEndSurfaceSalinityLabel() {
        $objectMap.put("gearShootingEndSurfaceSalinityLabel", gearShootingEndSurfaceSalinityLabel = new JLabel());
        
        gearShootingEndSurfaceSalinityLabel.setName("gearShootingEndSurfaceSalinityLabel");
        gearShootingEndSurfaceSalinityLabel.setText(_("tutti.label.fishingOperation.gearShootingEndSurfaceSalinity"));
    }

    protected void createGearShootingEndSurfaceTemperatureField() {
        $objectMap.put("gearShootingEndSurfaceTemperatureField", gearShootingEndSurfaceTemperatureField = new NumberEditor(this));
        
        gearShootingEndSurfaceTemperatureField.setName("gearShootingEndSurfaceTemperatureField");
        gearShootingEndSurfaceTemperatureField.setProperty("gearShootingEndSurfaceTemperature");
        gearShootingEndSurfaceTemperatureField.setUseFloat(false);
        gearShootingEndSurfaceTemperatureField.setShowReset(true);
    }

    protected void createGearShootingEndSurfaceTemperatureLabel() {
        $objectMap.put("gearShootingEndSurfaceTemperatureLabel", gearShootingEndSurfaceTemperatureLabel = new JLabel());
        
        gearShootingEndSurfaceTemperatureLabel.setName("gearShootingEndSurfaceTemperatureLabel");
        gearShootingEndSurfaceTemperatureLabel.setText(_("tutti.label.fishingOperation.gearShootingEndSurfaceTemperature"));
    }

    protected void createGearShootingEndTimeField() {
        $objectMap.put("gearShootingEndTimeField", gearShootingEndTimeField = new SimpleTimeEditor(this));
        
        gearShootingEndTimeField.setName("gearShootingEndTimeField");
        gearShootingEndTimeField.setProperty("gearShootingEndDate");
    }

    protected void createGearShootingForm() {
        $objectMap.put("gearShootingForm", gearShootingForm = new Table());
        
        gearShootingForm.setName("gearShootingForm");
    }

    protected void createGearShootingStartBottomSalinityField() {
        $objectMap.put("gearShootingStartBottomSalinityField", gearShootingStartBottomSalinityField = new NumberEditor(this));
        
        gearShootingStartBottomSalinityField.setName("gearShootingStartBottomSalinityField");
        gearShootingStartBottomSalinityField.setProperty("gearShootingStartBottomSalinity");
        gearShootingStartBottomSalinityField.setUseFloat(false);
        gearShootingStartBottomSalinityField.setShowReset(true);
    }

    protected void createGearShootingStartBottomSalinityLabel() {
        $objectMap.put("gearShootingStartBottomSalinityLabel", gearShootingStartBottomSalinityLabel = new JLabel());
        
        gearShootingStartBottomSalinityLabel.setName("gearShootingStartBottomSalinityLabel");
        gearShootingStartBottomSalinityLabel.setText(_("tutti.label.fishingOperation.gearShootingStartBottomSalinity"));
    }

    protected void createGearShootingStartBottomTemperatureField() {
        $objectMap.put("gearShootingStartBottomTemperatureField", gearShootingStartBottomTemperatureField = new NumberEditor(this));
        
        gearShootingStartBottomTemperatureField.setName("gearShootingStartBottomTemperatureField");
        gearShootingStartBottomTemperatureField.setProperty("gearShootingStartBottomTemperature");
        gearShootingStartBottomTemperatureField.setUseFloat(false);
        gearShootingStartBottomTemperatureField.setShowReset(true);
    }

    protected void createGearShootingStartBottomTemperatureLabel() {
        $objectMap.put("gearShootingStartBottomTemperatureLabel", gearShootingStartBottomTemperatureLabel = new JLabel());
        
        gearShootingStartBottomTemperatureLabel.setName("gearShootingStartBottomTemperatureLabel");
        gearShootingStartBottomTemperatureLabel.setText(_("tutti.label.fishingOperation.gearShootingStartBottomTemperature"));
    }

    protected void createGearShootingStartDateField() {
        $objectMap.put("gearShootingStartDateField", gearShootingStartDateField = new JXDatePicker());
        
        gearShootingStartDateField.setName("gearShootingStartDateField");
        gearShootingStartDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearShootingStartDateField"));
    }

    protected void createGearShootingStartDepthField() {
        $objectMap.put("gearShootingStartDepthField", gearShootingStartDepthField = new NumberEditor(this));
        
        gearShootingStartDepthField.setName("gearShootingStartDepthField");
        gearShootingStartDepthField.setProperty("gearShootingStartDepth");
        gearShootingStartDepthField.setUseFloat(false);
        gearShootingStartDepthField.setShowReset(true);
    }

    protected void createGearShootingStartDepthLabel() {
        $objectMap.put("gearShootingStartDepthLabel", gearShootingStartDepthLabel = new JLabel());
        
        gearShootingStartDepthLabel.setName("gearShootingStartDepthLabel");
        gearShootingStartDepthLabel.setText(_("tutti.label.fishingOperation.gearShootingStartDepth"));
    }

    protected void createGearShootingStartLabel() {
        $objectMap.put("gearShootingStartLabel", gearShootingStartLabel = new JLabel());
        
        gearShootingStartLabel.setName("gearShootingStartLabel");
        gearShootingStartLabel.setText(_("tutti.label.fishingOperation.gearShootingStart"));
    }

    protected void createGearShootingStartLatitudeLabel() {
        $objectMap.put("gearShootingStartLatitudeLabel", gearShootingStartLatitudeLabel = new JTextField());
        
        gearShootingStartLatitudeLabel.setName("gearShootingStartLatitudeLabel");
        gearShootingStartLatitudeLabel.setColumns(15);
        gearShootingStartLatitudeLabel.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__gearShootingStartLatitudeLabel"));
    }

    protected void createGearShootingStartLongitudeField() {
        $objectMap.put("gearShootingStartLongitudeField", gearShootingStartLongitudeField = new JTextField());
        
        gearShootingStartLongitudeField.setName("gearShootingStartLongitudeField");
        gearShootingStartLongitudeField.setColumns(15);
        gearShootingStartLongitudeField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__gearShootingStartLongitudeField"));
    }

    protected void createGearShootingStartSurfaceSalinityField() {
        $objectMap.put("gearShootingStartSurfaceSalinityField", gearShootingStartSurfaceSalinityField = new NumberEditor(this));
        
        gearShootingStartSurfaceSalinityField.setName("gearShootingStartSurfaceSalinityField");
        gearShootingStartSurfaceSalinityField.setProperty("gearShootingStartSurfaceSalinity");
        gearShootingStartSurfaceSalinityField.setUseFloat(false);
        gearShootingStartSurfaceSalinityField.setShowReset(true);
    }

    protected void createGearShootingStartSurfaceSalinityLabel() {
        $objectMap.put("gearShootingStartSurfaceSalinityLabel", gearShootingStartSurfaceSalinityLabel = new JLabel());
        
        gearShootingStartSurfaceSalinityLabel.setName("gearShootingStartSurfaceSalinityLabel");
        gearShootingStartSurfaceSalinityLabel.setText(_("tutti.label.fishingOperation.gearShootingStartSurfaceSalinity"));
    }

    protected void createGearShootingStartSurfaceTemperatureField() {
        $objectMap.put("gearShootingStartSurfaceTemperatureField", gearShootingStartSurfaceTemperatureField = new NumberEditor(this));
        
        gearShootingStartSurfaceTemperatureField.setName("gearShootingStartSurfaceTemperatureField");
        gearShootingStartSurfaceTemperatureField.setProperty("gearShootingStartSurfaceTemperature");
        gearShootingStartSurfaceTemperatureField.setUseFloat(false);
        gearShootingStartSurfaceTemperatureField.setShowReset(true);
    }

    protected void createGearShootingStartSurfaceTemperatureLabel() {
        $objectMap.put("gearShootingStartSurfaceTemperatureLabel", gearShootingStartSurfaceTemperatureLabel = new JLabel());
        
        gearShootingStartSurfaceTemperatureLabel.setName("gearShootingStartSurfaceTemperatureLabel");
        gearShootingStartSurfaceTemperatureLabel.setText(_("tutti.label.fishingOperation.gearShootingStartSurfaceTemperature"));
    }

    protected void createGearShootingStartTimeField() {
        $objectMap.put("gearShootingStartTimeField", gearShootingStartTimeField = new SimpleTimeEditor(this));
        
        gearShootingStartTimeField.setName("gearShootingStartTimeField");
        gearShootingStartTimeField.setProperty("gearShootingStartDate");
    }

    protected void createGearTimeLabel() {
        $objectMap.put("gearTimeLabel", gearTimeLabel = new JLabel());
        
        gearTimeLabel.setName("gearTimeLabel");
        gearTimeLabel.setText(_("tutti.label.fishingOperation.gearTime"));
    }

    protected void createGeneralForm() {
        $objectMap.put("generalForm", generalForm = new Table());
        
        generalForm.setName("generalForm");
    }

    protected void createGeometrieMesureeCheckBox() {
        $objectMap.put("geometrieMesureeCheckBox", geometrieMesureeCheckBox = new JCheckBox());
        
        geometrieMesureeCheckBox.setName("geometrieMesureeCheckBox");
        geometrieMesureeCheckBox.setText(_("tutti.label.fishingOperation.geometrieMesuree"));
        geometrieMesureeCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__geometrieMesureeCheckBox"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(FishingOperationTabUIHandler.class));
    }

    protected void createHydrologyForm() {
        $objectMap.put("hydrologyForm", hydrologyForm = new Table());
        
        hydrologyForm.setName("hydrologyForm");
    }

    protected void createImportCasinoButton() {
        $objectMap.put("importCasinoButton", importCasinoButton = new JButton());
        
        importCasinoButton.setName("importCasinoButton");
        importCasinoButton.setText(_("tutti.action.casino-import"));
        importCasinoButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importCasinoButton"));
    }

    protected void createImportPupitriButton() {
        $objectMap.put("importPupitriButton", importPupitriButton = new JButton());
        
        importPupitriButton.setName("importPupitriButton");
        importPupitriButton.setText(_("tutti.action.pupitri-import"));
        importPupitriButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importPupitriButton"));
    }

    protected void createLocaliteField() {
        $objectMap.put("localiteField", localiteField = new JTextField());
        
        localiteField.setName("localiteField");
        localiteField.setColumns(15);
        localiteField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__localiteField"));
    }

    protected void createLocaliteLabel() {
        $objectMap.put("localiteLabel", localiteLabel = new JLabel());
        
        localiteLabel.setName("localiteLabel");
        localiteLabel.setText(_("tutti.label.fishingOperation.localite"));
    }

    protected void createLongueurBrasField() {
        $objectMap.put("longueurBrasField", longueurBrasField = new NumberEditor(this));
        
        longueurBrasField.setName("longueurBrasField");
        longueurBrasField.setProperty("longueurBras");
        longueurBrasField.setUseFloat(false);
        longueurBrasField.setShowReset(true);
    }

    protected void createLongueurBrasLabel() {
        $objectMap.put("longueurBrasLabel", longueurBrasLabel = new JLabel());
        
        longueurBrasLabel.setName("longueurBrasLabel");
        longueurBrasLabel.setText(_("tutti.label.fishingOperation.longueurBras"));
    }

    protected void createLongueurFunesField() {
        $objectMap.put("longueurFunesField", longueurFunesField = new NumberEditor(this));
        
        longueurFunesField.setName("longueurFunesField");
        longueurFunesField.setProperty("longueurFunes");
        longueurFunesField.setUseFloat(false);
        longueurFunesField.setShowReset(true);
    }

    protected void createLongueurFunesLabel() {
        $objectMap.put("longueurFunesLabel", longueurFunesLabel = new JLabel());
        
        longueurFunesLabel.setName("longueurFunesLabel");
        longueurFunesLabel.setText(_("tutti.label.fishingOperation.longueurFunes"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FishingOperationTabUIModel.class));
    }

    protected void createNoTraitPane() {
        $objectMap.put("noTraitPane", noTraitPane = new JLabel());
        
        noTraitPane.setName("noTraitPane");
        noTraitPane.setText(_("tutti.label.no.fishingOperation.selected"));
    }

    protected void createOuvertureHorizontaleField() {
        $objectMap.put("ouvertureHorizontaleField", ouvertureHorizontaleField = new NumberEditor(this));
        
        ouvertureHorizontaleField.setName("ouvertureHorizontaleField");
        ouvertureHorizontaleField.setProperty("ouvertureHorizontale");
        ouvertureHorizontaleField.setUseFloat(false);
        ouvertureHorizontaleField.setShowReset(true);
    }

    protected void createOuvertureHorizontaleLabel() {
        $objectMap.put("ouvertureHorizontaleLabel", ouvertureHorizontaleLabel = new JLabel());
        
        ouvertureHorizontaleLabel.setName("ouvertureHorizontaleLabel");
        ouvertureHorizontaleLabel.setText(_("tutti.label.fishingOperation.ouvertureHorizontale"));
    }

    protected void createOuvertureVerticaleField() {
        $objectMap.put("ouvertureVerticaleField", ouvertureVerticaleField = new NumberEditor(this));
        
        ouvertureVerticaleField.setName("ouvertureVerticaleField");
        ouvertureVerticaleField.setProperty("ouvertureVerticale");
        ouvertureVerticaleField.setUseFloat(false);
        ouvertureVerticaleField.setShowReset(true);
    }

    protected void createOuvertureVerticaleLabel() {
        $objectMap.put("ouvertureVerticaleLabel", ouvertureVerticaleLabel = new JLabel());
        
        ouvertureVerticaleLabel.setName("ouvertureVerticaleLabel");
        ouvertureVerticaleLabel.setText(_("tutti.label.fishingOperation.ouvertureVerticale"));
    }

    protected void createResetValidStateButton() {
        $objectMap.put("resetValidStateButton", resetValidStateButton = new JButton());
        
        resetValidStateButton.setName("resetValidStateButton");
        resetValidStateButton.setText(_("tutti.action.reset.fishingOperationValidState"));
        resetValidStateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetValidStateButton"));
    }

    protected void createSaisisseurList() {
        $objectMap.put("saisisseurList", saisisseurList = new BeanDoubleList<Person>());
        
        saisisseurList.setName("saisisseurList");
        saisisseurList.setProperty("saisisseur");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.action.save"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createSeaStateComboBox() {
        $objectMap.put("seaStateComboBox", seaStateComboBox = new BeanComboBox<SeaState>(this));
        
        seaStateComboBox.setName("seaStateComboBox");
        seaStateComboBox.setI18nPrefix("tutti.property.");
        seaStateComboBox.setProperty("seaState");
        seaStateComboBox.setShowReset(true);
    }

    protected void createSeaStateLabel() {
        $objectMap.put("seaStateLabel", seaStateLabel = new JLabel());
        
        seaStateLabel.setName("seaStateLabel");
        seaStateLabel.setText(_("tutti.label.fishingOperation.seaState"));
    }

    protected void createStationNumberField() {
        $objectMap.put("stationNumberField", stationNumberField = new NumberEditor(this));
        
        stationNumberField.setName("stationNumberField");
        stationNumberField.setProperty("stationNumber");
        stationNumberField.setUseFloat(false);
        stationNumberField.setShowReset(true);
    }

    protected void createStationNumberLabel() {
        $objectMap.put("stationNumberLabel", stationNumberLabel = new JLabel());
        
        stationNumberLabel.setName("stationNumberLabel");
        stationNumberLabel.setText(_("tutti.label.fishingOperation.stationNumber"));
    }

    protected void createStrataComboBox() {
        $objectMap.put("strataComboBox", strataComboBox = new BeanComboBox<Strata>(this));
        
        strataComboBox.setName("strataComboBox");
        strataComboBox.setI18nPrefix("tutti.property.");
        strataComboBox.setProperty("strata");
        strataComboBox.setShowReset(true);
    }

    protected void createStrataLabel() {
        $objectMap.put("strataLabel", strataLabel = new JLabel());
        
        strataLabel.setName("strataLabel");
        strataLabel.setText(_("tutti.label.fishingOperation.strata"));
    }

    protected void createSubStrataComboBox() {
        $objectMap.put("subStrataComboBox", subStrataComboBox = new BeanComboBox<Strata>(this));
        
        subStrataComboBox.setName("subStrataComboBox");
        subStrataComboBox.setI18nPrefix("tutti.property.");
        subStrataComboBox.setProperty("subStrata");
        subStrataComboBox.setShowReset(true);
    }

    protected void createSubStrataLabel() {
        $objectMap.put("subStrataLabel", subStrataLabel = new JLabel());
        
        subStrataLabel.setName("subStrataLabel");
        subStrataLabel.setText(_("tutti.label.fishingOperation.subStrata"));
    }

    protected void createSystemeFermetureCulCheckBox() {
        $objectMap.put("systemeFermetureCulCheckBox", systemeFermetureCulCheckBox = new JCheckBox());
        
        systemeFermetureCulCheckBox.setName("systemeFermetureCulCheckBox");
        systemeFermetureCulCheckBox.setText(_("tutti.label.fishingOperation.systemeFermetureCul"));
        systemeFermetureCulCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__systemeFermetureCulCheckBox"));
    }

    protected void createTraitGearShootingTab() {
        $objectMap.put("traitGearShootingTab", traitGearShootingTab = new TabInfo());
        
        traitGearShootingTab.setTitle(_("tutti.label.tab.fishingOperation.gearShooting"));
    }

    protected void createTraitGeneralTab() {
        $objectMap.put("traitGeneralTab", traitGeneralTab = new TabInfo());
        
        traitGeneralTab.setTitle(_("tutti.label.tab.fishingOperation.general"));
    }

    protected void createTraitHydrologyTabContent() {
        $objectMap.put("traitHydrologyTabContent", traitHydrologyTabContent = new TabInfo());
        
        traitHydrologyTabContent.setTitle(_("tutti.label.tab.fishingOperation.hydrology"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(FishingOperationTabUIModel.class, null));
    }

    protected void createWindDirectionField() {
        $objectMap.put("windDirectionField", windDirectionField = new NumberEditor(this));
        
        windDirectionField.setName("windDirectionField");
        windDirectionField.setProperty("windDirection");
        windDirectionField.setUseFloat(false);
        windDirectionField.setShowReset(true);
    }

    protected void createWindDirectionLabel() {
        $objectMap.put("windDirectionLabel", windDirectionLabel = new JLabel());
        
        windDirectionLabel.setName("windDirectionLabel");
        windDirectionLabel.setText(_("tutti.label.fishingOperation.windDirection"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToFishingOperationPane();
        addChildrenToFishingOperationTabPane();
        addChildrenToGeneralForm();
        // inline complete setup of $JPanel0
        $JPanel0.add(gearCaracteristicsTable, BorderLayout.CENTER);
        addChildrenToGearCaracteristicsTable();
        addChildrenToFishingOperationValidPanel();
        addChildrenToFishingOperationResetRadio();
        // inline complete setup of $HBox0
        $HBox0.add(fishingOperationValidRadio);
        $HBox0.add(fishingOperationInvalidRadio);
        addChildrenToFishingOperationValidRadio();
        addChildrenToFishingOperationInvalidRadio();
        // inline complete setup of $JPanel2
        $JPanel2.add(distanceChaluteeLabel, BorderLayout.WEST);
        $JPanel2.add(distanceChaluteeField, BorderLayout.CENTER);
        // inline complete setup of $JPanel3
        $JPanel3.add(importPupitriButton);
        $JPanel3.add(importCasinoButton);
        addChildrenToCommentPane();
        addChildrenToGearShootingForm();
        // inline complete setup of $JPanel4
        $JPanel4.add(systemeFermetureCulCheckBox);
        $JPanel4.add(geometrieMesureeCheckBox);
        addChildrenToEnvironmentForm();
        addChildrenToHydrologyForm();
        // inline complete setup of $JPanel5
        $JPanel5.add($JPanel6, BorderLayout.CENTER);
        // inline complete setup of $JPanel6
        $JPanel6.add(cancelButton);
        $JPanel6.add(saveButton);
        
        // apply 64 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 119 property setters
        stationNumberLabel.setLabelFor(stationNumberField);
        stationNumberField.setBean(model);
        stationNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        stationNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        fishingOperationNumberLabel.setLabelFor(fishingOperationNumberField);
        fishingOperationNumberField.setBean(model);
        fishingOperationNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        fishingOperationNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        dateLabel.setLabelFor(dateField);
        dateField.setFormats("dd/MM/yyyy");
        strataLabel.setLabelFor(strataComboBox);
        strataComboBox.setBean(model);
        subStrataLabel.setLabelFor(subStrataComboBox);
        subStrataComboBox.setBean(model);
        localiteLabel.setLabelFor(localiteField);
        gearShootingStartDateField.setFormats("dd/MM/yyyy");
        gearShootingStartTimeField.setBean(model);
        gearShootingEndDateField.setFormats("dd/MM/yyyy");
        gearShootingEndTimeField.setBean(model);
        resetValidStateButton.setIcon(SwingUtil.createActionIcon("reset"));
        distanceChaluteeLabel.setLabelFor(distanceChaluteeField);
        distanceChaluteeField.setBean(model);
        distanceChaluteeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        distanceChaluteeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        dureeLabel.setLabelFor(dureeField);
        dureeField.setBean(model);
        dureeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        dureeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        importPupitriButton.setIcon(SwingUtil.createActionIcon("pupitri-import"));
        importCasinoButton.setIcon(SwingUtil.createActionIcon("casino-import"));
        saisisseurList.setBean(model);
        saisisseurList.setBeanType(Person.class);
        saisisseurList.setBorder(BorderFactory.createTitledBorder(_("tutti.label.list.saisisseur")));
        commentPane.setColumnHeaderView(new JLabel(_("tutti.label.comment")));
        commentPane.setMinimumSize(new Dimension(10,50));
        gearShootingStartDepthLabel.setLabelFor(gearShootingStartDepthField);
        gearShootingStartDepthField.setBean(model);
        gearShootingStartDepthField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartDepthField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndDepthLabel.setLabelFor(gearShootingEndDepthField);
        gearShootingEndDepthField.setBean(model);
        gearShootingEndDepthField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndDepthField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        ouvertureHorizontaleLabel.setLabelFor(ouvertureHorizontaleField);
        ouvertureHorizontaleField.setBean(model);
        ouvertureHorizontaleField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        ouvertureHorizontaleField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        ouvertureVerticaleLabel.setLabelFor(ouvertureVerticaleField);
        ouvertureVerticaleField.setBean(model);
        ouvertureVerticaleField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        ouvertureVerticaleField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        longueurFunesLabel.setLabelFor(longueurFunesField);
        longueurFunesField.setBean(model);
        longueurFunesField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        longueurFunesField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        longueurBrasLabel.setLabelFor(longueurBrasField);
        longueurBrasField.setBean(model);
        longueurBrasField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        longueurBrasField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        beaufortScaleLabel.setLabelFor(beaufortScaleComboBox);
        beaufortScaleComboBox.setBean(model);
        windDirectionLabel.setLabelFor(windDirectionField);
        windDirectionField.setBean(model);
        windDirectionField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        windDirectionField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        seaStateLabel.setLabelFor(seaStateComboBox);
        seaStateComboBox.setBean(model);
        gearShootingStartSurfaceTemperatureLabel.setLabelFor(gearShootingStartSurfaceTemperatureField);
        gearShootingStartSurfaceTemperatureField.setBean(model);
        gearShootingStartSurfaceTemperatureField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartSurfaceTemperatureField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndSurfaceTemperatureLabel.setLabelFor(gearShootingEndSurfaceTemperatureField);
        gearShootingEndSurfaceTemperatureField.setBean(model);
        gearShootingEndSurfaceTemperatureField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndSurfaceTemperatureField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartBottomTemperatureLabel.setLabelFor(gearShootingStartBottomTemperatureField);
        gearShootingStartBottomTemperatureField.setBean(model);
        gearShootingStartBottomTemperatureField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartBottomTemperatureField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndBottomTemperatureLabel.setLabelFor(gearShootingEndBottomTemperatureField);
        gearShootingEndBottomTemperatureField.setBean(model);
        gearShootingEndBottomTemperatureField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndBottomTemperatureField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        averageBottomTemperatureLabel.setLabelFor(averageBottomTemperatureField);
        averageBottomTemperatureField.setBean(model);
        averageBottomTemperatureField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        averageBottomTemperatureField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartSurfaceSalinityLabel.setLabelFor(gearShootingStartSurfaceSalinityField);
        gearShootingStartSurfaceSalinityField.setBean(model);
        gearShootingStartSurfaceSalinityField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartSurfaceSalinityField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndSurfaceSalinityLabel.setLabelFor(gearShootingEndSurfaceSalinityField);
        gearShootingEndSurfaceSalinityField.setBean(model);
        gearShootingEndSurfaceSalinityField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndSurfaceSalinityField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartBottomSalinityLabel.setLabelFor(gearShootingStartBottomSalinityField);
        gearShootingStartBottomSalinityField.setBean(model);
        gearShootingStartBottomSalinityField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartBottomSalinityField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndBottomSalinityLabel.setLabelFor(gearShootingEndBottomSalinityField);
        gearShootingEndBottomSalinityField.setBean(model);
        gearShootingEndBottomSalinityField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndBottomSalinityField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        averageBottomSalinityLabel.setLabelFor(averageBottomSalinityField);
        averageBottomSalinityField.setBean(model);
        averageBottomSalinityField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        averageBottomSalinityField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        noTraitPane.setHorizontalAlignment(JLabel.CENTER);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createFishingOperationPane();
        createFishingOperationTabPane();
        createGeneralForm();
        createStationNumberLabel();
        createStationNumberField();
        createFishingOperationNumberLabel();
        createFishingOperationNumberField();
        createDateLabel();
        createDateField();
        createStrataLabel();
        createStrataComboBox();
        createSubStrataLabel();
        createSubStrataComboBox();
        createLocaliteLabel();
        createLocaliteField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createGearCaracteristicsTable();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createGearLongitudeLabel();
        createGearLatitudeLabel();
        createGearDateLabel();
        createGearTimeLabel();
        createGearShootingStartLabel();
        createGearShootingStartLongitudeField();
        createGearShootingStartLatitudeLabel();
        createGearShootingStartDateField();
        createGearShootingStartTimeField();
        createGearShootingEndLabel();
        createGearShootingEndLongitudeField();
        createGearShootingEndLatitudeLabel();
        createGearShootingEndDateField();
        createGearShootingEndTimeField();
        createFishingOperationValidPanel();
        createResetValidStateButton();
        createFishingOperationResetRadio();
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        createFishingOperationValidRadio();
        createFishingOperationInvalidRadio();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createFishingOperationRectiligneCheckBox();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new BorderLayout());
        createDistanceChaluteeLabel();
        createDistanceChaluteeField();
        createDureeLabel();
        createDureeField();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createImportPupitriButton();
        createImportCasinoButton();
        createSaisisseurList();
        createCommentPane();
        createCommentField();
        createGearShootingForm();
        createGearShootingStartDepthLabel();
        createGearShootingStartDepthField();
        createGearShootingEndDepthLabel();
        createGearShootingEndDepthField();
        createOuvertureHorizontaleLabel();
        createOuvertureHorizontaleField();
        createOuvertureVerticaleLabel();
        createOuvertureVerticaleField();
        createLongueurFunesLabel();
        createLongueurFunesField();
        createLongueurBrasLabel();
        createLongueurBrasField();
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new JPanel());
        
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout(new GridLayout(1,0));
        createSystemeFermetureCulCheckBox();
        createGeometrieMesureeCheckBox();
        createEnvironmentForm();
        createBeaufortScaleLabel();
        createBeaufortScaleComboBox();
        createWindDirectionLabel();
        createWindDirectionField();
        createSeaStateLabel();
        createSeaStateComboBox();
        createHydrologyForm();
        createGearShootingStartSurfaceTemperatureLabel();
        createGearShootingStartSurfaceTemperatureField();
        createGearShootingEndSurfaceTemperatureLabel();
        createGearShootingEndSurfaceTemperatureField();
        createGearShootingStartBottomTemperatureLabel();
        createGearShootingStartBottomTemperatureField();
        createGearShootingEndBottomTemperatureLabel();
        createGearShootingEndBottomTemperatureField();
        createAverageBottomTemperatureLabel();
        createAverageBottomTemperatureField();
        createGearShootingStartSurfaceSalinityLabel();
        createGearShootingStartSurfaceSalinityField();
        createGearShootingEndSurfaceSalinityLabel();
        createGearShootingEndSurfaceSalinityField();
        createGearShootingStartBottomSalinityLabel();
        createGearShootingStartBottomSalinityField();
        createGearShootingEndBottomSalinityLabel();
        createGearShootingEndBottomSalinityField();
        createAverageBottomSalinityLabel();
        createAverageBottomSalinityField();
        // inline creation of $JPanel5
        $objectMap.put("$JPanel5", $JPanel5 = new JPanel());
        
        $JPanel5.setName("$JPanel5");
        $JPanel5.setLayout(new BorderLayout());
        // inline creation of $JPanel6
        $objectMap.put("$JPanel6", $JPanel6 = new JPanel());
        
        $JPanel6.setName("$JPanel6");
        $JPanel6.setLayout(new GridLayout(1,0));
        createCancelButton();
        createSaveButton();
        createNoTraitPane();
        createTraitGeneralTab();
        createTraitGearShootingTab();
        createEnvironmentTab();
        createTraitHydrologyTabContent();
        createFishingOperationValid();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 64 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 64 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATION_NUMBER_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("stationNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stationNumberField.setModel(model.getStationNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("stationNumber", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STATION_NUMBER_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                stationNumberField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_NUMBER_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationNumberField.setModel(model.getFishingOperationNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationNumber", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FISHING_OPERATION_NUMBER_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                fishingOperationNumberField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("date", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dateField.setDate(model.getDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("date", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STRATA_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("strata", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    strataComboBox.setSelectedItem(model.getStrata());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("strata", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SUB_STRATA_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("subStrata", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    subStrataComboBox.setSelectedItem(model.getSubStrata());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("subStrata", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LOCALITE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("localite", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(localiteField, model.getLocalite());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("localite", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(gearShootingStartLongitudeField, getStringValue(model.getGearShootingStartLongitude()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartDateField.setDate(model.getGearShootingStartDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_TIME_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartTimeField.setDate(model.getGearShootingStartDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(gearShootingEndLongitudeField, getStringValue(model.getGearShootingEndLongitude()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndDateField.setDate(model.getGearShootingEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_TIME_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndTimeField.setDate(model.getGearShootingEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_RESET_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationResetRadio.setSelected(model.getFishingOperationValid() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_VALID_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationValidRadio.setSelected(model.getFishingOperationValid() == Boolean.TRUE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_INVALID_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationInvalidRadio.setSelected(model.getFishingOperationValid() == Boolean.FALSE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_RECTILIGNE_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationRectiligneCheckBox.setSelected(model.isFishingOperationRectiligne());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISTANCE_CHALUTEE_FIELD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    distanceChaluteeField.setEnabled(!model.isFishingOperationRectiligne());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISTANCE_CHALUTEE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("distanceChalutee", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    distanceChaluteeField.setModel(model.getDistanceChalutee());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("distanceChalutee", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DISTANCE_CHALUTEE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                distanceChaluteeField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DUREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("duree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dureeField.setModel(model.getDuree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("duree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DUREE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                dureeField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, model.getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_DEPTH_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDepth", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartDepthField.setModel(model.getGearShootingStartDepth());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDepth", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_DEPTH_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartDepthField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_DEPTH_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDepth", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndDepthField.setModel(model.getGearShootingEndDepth());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDepth", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_DEPTH_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndDepthField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OUVERTURE_HORIZONTALE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ouvertureHorizontale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ouvertureHorizontaleField.setModel(model.getOuvertureHorizontale());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ouvertureHorizontale", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_OUVERTURE_HORIZONTALE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                ouvertureHorizontaleField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OUVERTURE_VERTICALE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ouvertureVerticale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ouvertureVerticaleField.setModel(model.getOuvertureVerticale());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ouvertureVerticale", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_OUVERTURE_VERTICALE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                ouvertureVerticaleField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGUEUR_FUNES_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("longueurFunes", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longueurFunesField.setModel(model.getLongueurFunes());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("longueurFunes", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LONGUEUR_FUNES_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                longueurFunesField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGUEUR_BRAS_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("longueurBras", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longueurBrasField.setModel(model.getLongueurBras());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("longueurBras", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LONGUEUR_BRAS_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                longueurBrasField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SYSTEME_FERMETURE_CUL_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("systemeFermetureCul", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    systemeFermetureCulCheckBox.setSelected(model.isSystemeFermetureCul());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("systemeFermetureCul", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEOMETRIE_MESUREE_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("geometrieMesuree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    geometrieMesureeCheckBox.setSelected(model.isGeometrieMesuree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("geometrieMesuree", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BEAUFORT_SCALE_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("beaufortScale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    beaufortScaleComboBox.setSelectedItem(model.getBeaufortScale());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("beaufortScale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WIND_DIRECTION_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("windDirection", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    windDirectionField.setModel(model.getWindDirection());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("windDirection", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_WIND_DIRECTION_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                windDirectionField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SEA_STATE_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("seaState", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    seaStateComboBox.setSelectedItem(model.getSeaState());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("seaState", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_SURFACE_TEMPERATURE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartSurfaceTemperature", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartSurfaceTemperatureField.setModel(model.getGearShootingStartSurfaceTemperature());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartSurfaceTemperature", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_SURFACE_TEMPERATURE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartSurfaceTemperatureField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_SURFACE_TEMPERATURE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndSurfaceTemperature", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndSurfaceTemperatureField.setModel(model.getGearShootingEndSurfaceTemperature());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndSurfaceTemperature", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_SURFACE_TEMPERATURE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndSurfaceTemperatureField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_BOTTOM_TEMPERATURE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartBottomTemperature", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartBottomTemperatureField.setModel(model.getGearShootingStartBottomTemperature());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartBottomTemperature", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_BOTTOM_TEMPERATURE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartBottomTemperatureField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_BOTTOM_TEMPERATURE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndBottomTemperature", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndBottomTemperatureField.setModel(model.getGearShootingEndBottomTemperature());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndBottomTemperature", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_BOTTOM_TEMPERATURE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndBottomTemperatureField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_AVERAGE_BOTTOM_TEMPERATURE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("averageBottomTemperature", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    averageBottomTemperatureField.setModel(model.getAverageBottomTemperature());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("averageBottomTemperature", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_AVERAGE_BOTTOM_TEMPERATURE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                averageBottomTemperatureField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_SURFACE_SALINITY_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartSurfaceSalinity", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartSurfaceSalinityField.setModel(model.getGearShootingStartSurfaceSalinity());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartSurfaceSalinity", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_SURFACE_SALINITY_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartSurfaceSalinityField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_SURFACE_SALINITY_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndSurfaceSalinity", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndSurfaceSalinityField.setModel(model.getGearShootingEndSurfaceSalinity());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndSurfaceSalinity", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_SURFACE_SALINITY_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndSurfaceSalinityField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_BOTTOM_SALINITY_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartBottomSalinity", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartBottomSalinityField.setModel(model.getGearShootingStartBottomSalinity());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartBottomSalinity", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_BOTTOM_SALINITY_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartBottomSalinityField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_BOTTOM_SALINITY_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndBottomSalinity", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndBottomSalinityField.setModel(model.getGearShootingEndBottomSalinity());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndBottomSalinity", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_BOTTOM_SALINITY_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndBottomSalinityField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_AVERAGE_BOTTOM_SALINITY_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("averageBottomSalinity", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    averageBottomSalinityField.setModel(model.getAverageBottomSalinity());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("averageBottomSalinity", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_AVERAGE_BOTTOM_SALINITY_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                averageBottomSalinityField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cancelButton.setEnabled(model.isModify());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}