package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id: SelectCruiseUIModel.java 40 2012-12-11 14:19:11Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/home/SelectCruiseUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import org.jdesktop.beans.AbstractSerializableBean;

import java.util.List;

/**
 * Model of ui {@link SelectCruiseUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class SelectCruiseUIModel extends AbstractSerializableBean {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_PROGRAMS = "programs";

    public static final String PROPERTY_PROGRAM = "program";

    public static final String PROPERTY_CRUISES = "cruises";

    public static final String PROPERTY_CRUISE = "cruise";

    public static final String PROPERTY_PROGRAM_FOUND = "programFound";

    public static final String PROPERTY_CRUISE_FOUND = "cruiseFound";

    protected List<Program> programs;

    protected Program program;

    protected List<Cruise> cruises;

    protected Cruise cruise;

    public List<Program> getPrograms() {
        return programs;
    }

    public void setPrograms(List<Program> programs) {
        Object oldValue = getPrograms();
        this.programs = programs;

        // nullify program
//        setProgram(null);
        firePropertyChange(PROPERTY_PROGRAMS, oldValue, programs);
    }

    public Program getProgram() {
        return program;
    }

    public void setProgram(Program program) {
        Program oldValue = getProgram();
        this.program = program;

        // nullify cruises
//        setCruises(null);

        firePropertyChange(PROPERTY_PROGRAM, oldValue, program);
        firePropertyChange(PROPERTY_PROGRAM_FOUND, oldValue != null, program != null);
    }

    public boolean isProgramFound() {
        return program != null;
    }

    public List<Cruise> getCruises() {
        return cruises;
    }

    public void setCruises(List<Cruise> cruises) {
        Object oldValue = getCruises();
        this.cruises = cruises;

        // nullify cruise
//        setCruise(null);
        firePropertyChange(PROPERTY_CRUISES, oldValue, cruises);
    }

    public Cruise getCruise() {
        return cruise;
    }

    public void setCruise(Cruise cruise) {
        Cruise oldValue = getCruise();
        this.cruise = cruise;
        firePropertyChange(PROPERTY_CRUISE, oldValue, cruise);
        firePropertyChange(PROPERTY_CRUISE_FOUND, oldValue != null, cruise != null);
    }

    public boolean isCruiseFound() {
        return cruise != null;
    }

}
