package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class SelectCruiseUI extends JPanel implements TuttiUI<SelectCruiseUIModel, SelectCruiseUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CRUISE_COMBOBOX_ENABLED = "cruiseCombobox.enabled";
    public static final String BINDING_CRUISE_COMBOBOX_SELECTED_ITEM = "cruiseCombobox.selectedItem";
    public static final String BINDING_EDIT_CRUISE_BUTTON_ENABLED = "editCruiseButton.enabled";
    public static final String BINDING_EDIT_PROGRAM_BUTTON_ENABLED = "editProgramButton.enabled";
    public static final String BINDING_NEW_CRUISE_BUTTON_ENABLED = "newCruiseButton.enabled";
    public static final String BINDING_PROGRAM_COMBOBOX_SELECTED_ITEM = "programCombobox.selectedItem";
    public static final String BINDING_SHOW_FISHING_OPERATIONS_BUTTON_ENABLED = "showFishingOperationsButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRR+dmInTtLGiUsJJJVMW5VWldaNBFJFKggJsprIpVFTpApfGHsn8VTrnWVmlmwUgfgT+Av4ceeCxI0T4sCZAxfEv4AQB66INzNrr3e9qUNIpKyyM++973u/vs23f0BJCnjtOYkiR4S+Yn3q7L777NnjznPaVe9R2RUsUFyA/SkUodiGeXd4LhXcaLe0eyN2b2zzfsB96o94b7RgTqpjj8oepUrBtbRHV8rG/vB6IwpCMYg6JJUX9eu//ix+4X7+TREgCpDdIqZSn+SVZDLdgiJzFSwj0iek4RH/EGkI5h8i30v6bNsjUr5P+vRj+AxmWlAOiMBgCq6fPWUTw/hHgYJKj/fpHvGpp+DNA+GwA0H7VDgqVIo5IXPkEeI7Xe4rDOdoa2efetiLbREyST/YCQITraxgpkd816NCwYNzRXpo3ZOApT53NbG3zhXukXYeYXfzKel49J6ClVRLbBxzpy0rQ4eFQPBDQfot0tEklnUDoth81xxqw+Wh/WJsj8Xv8A6PFNzNAaIuw244HUp8ZwsfxnqLR+lYszd3TVPuZXHNadp2SYfcs9hbWB2sCNRSTvZUm68Ovao+PUo56fN62ma+a0o5zPXlNPBlez3IV5++mp/Gun6/lr6ratq2VxkCryclRZITTFZljx81mexhpo8DKohi3JcZc0QVsJrqBu64k+x4soSFNpREiMc4J+1xWXiCV1YQVjKCoAOa23+u1n794ffvmwMVuITYL+WajogYbieOD/JXTEMvWgkIFfMaj0iw0YaKNMNtFG4th9h+fI3kEG9Juzva3XlIZA9DlGZ++/Gnqx/9MgXFJsx5nLhNou13oKJ6AqvAPTcK3tk0jBaOZvFZxd8pBdN6VnF/Tsw2fqpgjq3f9/cEPWA444t2IWPyxw5Kiu7IEyq1sE4rEdIIq7WWU60h5U7l579r+99tDipWwAxeOdU8qVrpQygz32M+NcoZi2KuUs4HkoYuT8QvTw4BBXFhdClj9XjDPO+PFaegE6QR5lmzVfD0pjixDkSh9to0+ei/tiCjKcGE8EW0t12n7o6ifQVXbA+cQzpY+Nt3sCGzg+pjl14AnhWoSfjY+xnqa2HEj9JKDM1kjNzkoe8a+LgGS7YGOFW4gUbncFTs246WaZjWZ3nExhXsDKWJUaspVNSLDOgUcd08zDH9OwPkrOlvk+MXrnqSFr+kDMujo2CN8vBHtfWiGpGZlloyLVZEs8NSPp1eRtv/E8P1UxjWb92qD24soQucobHPyQVP93nnLPsJO8OYJbRunIRsW/+HE6lhzeL3JvPQZJThlRTDLlHdHpV5lF70yZxEDyWv7JFjjsZw+YFLFKl3mO9ipLfHoAr6OTcxoj7+Uj++yo+w9r8j3MYI/wKYzcKNWgwAAA==";
    private static final Log log = LogFactory.getLog(SelectCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected BeanComboBox<Cruise> cruiseCombobox;
    protected JLabel cruiseLabel;
    protected JButton editCruiseButton;
    protected JButton editProgramButton;
    protected SelectCruiseUIHandler handler;
    protected SelectCruiseUI homePanel = this;
    protected SelectCruiseUIModel model;
    protected JButton newCruiseButton;
    protected JButton newProgramButton;
    protected BeanComboBox<Program> programCombobox;
    protected JLabel programLabel;
    protected JButton showFishingOperationsButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiUIContext uiContext;
    
    
        protected void $afterCompleteSetup() {
            handler.afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectCruiseUI(TuttiUIContext context) {
        this.uiContext = context;
                SelectCruiseUIHandler handler =
                                     new SelectCruiseUIHandler(context, this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public SelectCruiseUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI() {
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__editCruiseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showSelectedCruise();
    }

    public void doActionPerformed__on__editProgramButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showSelectedProgram();
    }

    public void doActionPerformed__on__newCruiseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showNewCruise();
    }

    public void doActionPerformed__on__newProgramButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showNewProgram();
    }

    public void doActionPerformed__on__showFishingOperationsButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showFishingOperations();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanComboBox<Cruise> getCruiseCombobox() {
        return cruiseCombobox;
    }

    public JLabel getCruiseLabel() {
        return cruiseLabel;
    }

    public JButton getEditCruiseButton() {
        return editCruiseButton;
    }

    public JButton getEditProgramButton() {
        return editProgramButton;
    }

    public SelectCruiseUIHandler getHandler() {
        return handler;
    }

    public SelectCruiseUIModel getModel() {
        return model;
    }

    public JButton getNewCruiseButton() {
        return newCruiseButton;
    }

    public JButton getNewProgramButton() {
        return newProgramButton;
    }

    public BeanComboBox<Program> getProgramCombobox() {
        return programCombobox;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public JButton getShowFishingOperationsButton() {
        return showFishingOperationsButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createCruiseCombobox() {
        $objectMap.put("cruiseCombobox", cruiseCombobox = new BeanComboBox<Cruise>(this));
        
        cruiseCombobox.setName("cruiseCombobox");
        cruiseCombobox.setI18nPrefix("tutti.property.");
        cruiseCombobox.setProperty("cruise");
        cruiseCombobox.setShowReset(true);
    }

    protected void createCruiseLabel() {
        $objectMap.put("cruiseLabel", cruiseLabel = new JLabel());
        
        cruiseLabel.setName("cruiseLabel");
        cruiseLabel.setText(_("tutti.label.cruise"));
    }

    protected void createEditCruiseButton() {
        $objectMap.put("editCruiseButton", editCruiseButton = new JButton());
        
        editCruiseButton.setName("editCruiseButton");
        editCruiseButton.setText(_("tutti.action.edit"));
        editCruiseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editCruiseButton"));
    }

    protected void createEditProgramButton() {
        $objectMap.put("editProgramButton", editProgramButton = new JButton());
        
        editProgramButton.setName("editProgramButton");
        editProgramButton.setText(_("tutti.action.edit"));
        editProgramButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editProgramButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SelectCruiseUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SelectCruiseUIModel.class));
    }

    protected void createNewCruiseButton() {
        $objectMap.put("newCruiseButton", newCruiseButton = new JButton());
        
        newCruiseButton.setName("newCruiseButton");
        newCruiseButton.setText(_("tutti.action.new"));
        newCruiseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newCruiseButton"));
    }

    protected void createNewProgramButton() {
        $objectMap.put("newProgramButton", newProgramButton = new JButton());
        
        newProgramButton.setName("newProgramButton");
        newProgramButton.setText(_("tutti.action.new"));
        newProgramButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newProgramButton"));
    }

    protected void createProgramCombobox() {
        $objectMap.put("programCombobox", programCombobox = new BeanComboBox<Program>(this));
        
        programCombobox.setName("programCombobox");
        programCombobox.setI18nPrefix("tutti.property.");
        programCombobox.setProperty("program");
        programCombobox.setShowReset(true);
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(_("tutti.label.program"));
    }

    protected void createShowFishingOperationsButton() {
        $objectMap.put("showFishingOperationsButton", showFishingOperationsButton = new JButton());
        
        showFishingOperationsButton.setName("showFishingOperationsButton");
        showFishingOperationsButton.setText(_("tutti.action.catches"));
        showFishingOperationsButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__showFishingOperationsButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        // inline complete setup of $Table0
        $Table0.add(programLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(programCombobox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cruiseLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cruiseCombobox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(showFishingOperationsButton, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(editProgramButton);
        $JPanel0.add(newProgramButton);
        // inline complete setup of $JPanel1
        $JPanel1.add(editCruiseButton);
        $JPanel1.add(newCruiseButton);
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        programCombobox.setBean(model);
        editProgramButton.setIcon(SwingUtil.createActionIcon("edit"));
        newProgramButton.setIcon(SwingUtil.createActionIcon("add"));
        cruiseLabel.setLabelFor(cruiseCombobox);
        cruiseCombobox.setBean(model);
        editCruiseButton.setIcon(SwingUtil.createActionIcon("edit"));
        newCruiseButton.setIcon(SwingUtil.createActionIcon("add"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createProgramLabel();
        createProgramCombobox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createEditProgramButton();
        createNewProgramButton();
        createCruiseLabel();
        createCruiseCombobox();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createEditCruiseButton();
        createNewCruiseButton();
        createShowFishingOperationsButton();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    programCombobox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_PROGRAM_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editProgramButton.setEnabled(model.isProgramFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cruiseCombobox.setEnabled(model.isProgramFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("cruise", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cruiseCombobox.setSelectedItem(model.getCruise());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("cruise", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_CRUISE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editCruiseButton.setEnabled(model.isProgramFound() && model.isCruiseFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_CRUISE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    newCruiseButton.setEnabled(model.isProgramFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SHOW_FISHING_OPERATIONS_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.addPropertyChangeListener("cruiseContextFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (uiContext != null) {
                    showFishingOperationsButton.setEnabled(uiContext.isCruiseContextFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.removePropertyChangeListener("cruiseContextFilled", this);
                }
            }
        });
    }

}