/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.catches;

import fr.ifremer.tutti.persistence.entities.TraitBean;
import fr.ifremer.tutti.persistence.entities.UserBean;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.content.catches.CatchesUI;
import fr.ifremer.tutti.ui.swing.content.catches.TraitTabUI;
import fr.ifremer.tutti.ui.swing.content.catches.TraitTabUIModel;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class TraitTabUIHandler
extends AbstractTuttiUIHandler<TraitTabUIModel> {
    private static final Log log = LogFactory.getLog(TraitTabUIHandler.class);
    private final TraitTabUI ui;
    private final CatchesUI parentUi;
    private final PersistenceService persistenceService;

    public TraitTabUIHandler(CatchesUI parentUi, TraitTabUI ui) {
        super(parentUi.getHandler().getContext());
        this.ui = ui;
        this.parentUi = parentUi;
        this.persistenceService = this.context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {
        TraitTabUIModel model = new TraitTabUIModel();
        model.addPropertyChangeListener("empty", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JPanel form = TraitTabUIHandler.this.ui.getTraitPane();
                JLabel noContentPane = TraitTabUIHandler.this.ui.getNoTraitPane();
                Boolean empty = (Boolean)evt.getNewValue();
                TraitTabUIHandler.this.ui.remove(form);
                TraitTabUIHandler.this.ui.remove(noContentPane);
                if (empty.booleanValue()) {
                    TraitTabUIHandler.this.ui.add((Component)noContentPane, "Center");
                } else {
                    TraitTabUIHandler.this.ui.add((Component)form, "Center");
                }
                TraitTabUIHandler.this.ui.repaint();
            }
        });
        this.listModelIsModify(model);
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        TraitTabUIModel model = this.ui.getModel();
        this.initUI(this.ui);
        this.initBeanList(this.ui.getSaisisseurHeader(), this.persistenceService.getAllUsers(), model.getSaisisseur());
        this.initBeanComboBox(this.ui.getBeaufortScaleComboBox(), this.persistenceService.getAllBeaufortScales(), model.getBeaufortScale());
        this.initBeanComboBox(this.ui.getStrataComboBox(), this.persistenceService.getAllStratas(), model.getStrata());
        this.initBeanComboBox(this.ui.getSeaStateComboBox(), this.persistenceService.getAllSeaStates(), model.getSeaState());
        model.setEmpty(true);
        this.listenValidatorValid((SimpleBeanValidator)this.ui.getValidator(), this.getModel());
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    protected TraitTabUIModel getModel() {
        return this.ui.getModel();
    }

    public void selectTrait(TraitBean bean) {
        boolean empty = bean == null;
        TraitTabUIModel model = this.ui.getModel();
        this.ui.getSaisisseurHeader().getList().clearSelection();
        if (empty) {
            model.fromBean(new TraitBean());
        } else {
            model.fromBean(bean);
        }
        List<UserBean> saisisseur = model.getSaisisseur();
        if (CollectionUtils.isNotEmpty(saisisseur)) {
            this.updateIndices(this.ui.getSaisisseurList(), saisisseur);
        }
        model.setEmpty(empty);
        model.setModify(!empty && model.isCreate());
    }

    public void cancel() {
        boolean newBean;
        String id = this.ui.getModel().getId();
        if (log.isInfoEnabled()) {
            log.info((Object)("Cancel edition for trait: " + id));
        }
        if (newBean = StringUtils.isBlank((CharSequence)id)) {
            this.parentUi.getHandler().selectTrait(null);
        } else {
            TraitBean selectedTrait = this.parentUi.getModel().getSelectedTrait();
            this.parentUi.getHandler().selectTrait(selectedTrait);
        }
    }

    public void save() {
        TraitBean toSave = this.ui.getModel().toBean();
        if (log.isInfoEnabled()) {
            log.info((Object)("Save edition for trait: " + toSave.getId()));
        }
        int selectedIndex = this.ui.getTraitTabPane().getSelectedIndex();
        this.parentUi.getHandler().saveTrait(toSave);
        this.ui.getTraitTabPane().setSelectedIndex(selectedIndex);
    }

    public void importPupitri() {
    }

    public void setGearShootingStartLatitude(String text) {
        this.ui.getModel().setGearShootingStartLatitude(Float.valueOf(text));
    }

    public void setGearShootingStartLongitude(String text) {
        this.ui.getModel().setGearShootingStartLongitude(Float.valueOf(text));
    }

    public void setGearShootingStartTime(String text) {
        this.ui.getModel().setGearShootingStartTime(Date.valueOf(text));
    }

    public void setGearShootingEndLatitude(String text) {
        this.ui.getModel().setGearShootingEndLatitude(Float.valueOf(text));
    }

    public void setGearShootingEndLongitude(String text) {
        this.ui.getModel().setGearShootingEndLongitude(Float.valueOf(text));
    }

    public void setGearShootingEndTime(String text) {
        this.ui.getModel().setGearShootingEndTime(Date.valueOf(text));
    }
}

