/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.campaign;

import fr.ifremer.tutti.persistence.entities.SurveyBean;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.campaign.EditSurveyUI;
import fr.ifremer.tutti.ui.swing.content.campaign.EditSurveyUIModel;
import javax.swing.JTable;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditSurveyUIHandler
extends AbstractTuttiUIHandler<EditSurveyUIModel> {
    private static final Log log = LogFactory.getLog(EditSurveyUIHandler.class);
    private final EditSurveyUI ui;
    private final PersistenceService persistenceService;

    public EditSurveyUIHandler(TuttiUIContext context, EditSurveyUI ui) {
        super(context);
        this.ui = ui;
        this.persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {
        EditSurveyUIModel model = new EditSurveyUIModel();
        String surveyId = this.context.getSurveyId();
        if (surveyId == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Edit new survey");
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Edit existing survey " + surveyId));
            }
            SurveyBean survey = this.persistenceService.getSurvey(surveyId);
            model.fromBean(survey);
        }
        this.listModelIsModify(model);
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        EditSurveyUIModel model = this.ui.getModel();
        this.initBeanComboBox(this.ui.getZoneComboBox(), this.persistenceService.getAllZones(), model.getZone());
        SwingValidatorUtil.installUI((JTable)this.ui.getErrorTable(), (SwingValidatorMessageTableRenderer)new SwingValidatorMessageTableRenderer());
        this.listenValidatorValid((SimpleBeanValidator)this.ui.getValidator(), model);
        model.setModify(model.isCreate());
    }

    @Override
    public void onCloseUI() {
        this.ui.getValidator().setBean(null);
    }

    @Override
    protected EditSurveyUIModel getModel() {
        return this.ui.getModel();
    }

    public void cancel() {
        this.context.setScreen(TuttiScreen.SELECT_CAMPAIGN);
    }

    public void save() {
        EditSurveyUIModel model = this.ui.getModel();
        SurveyBean bean = model.toBean();
        SurveyBean saved = model.isCreate() ? this.persistenceService.createSurvey(bean) : this.persistenceService.saveSurvey(bean);
        this.context.setSurveyId(saved.getId());
        this.context.setScreen(TuttiScreen.SELECT_CAMPAIGN);
    }
}

