package fr.ifremer.tutti.ui.swing.content.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: BenthosTabUIHandler.java 20 2012-11-26 10:27:11Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/catches/BenthosTabUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.CatchBean;
import fr.ifremer.tutti.persistence.entities.SpeciesBean;
import fr.ifremer.tutti.persistence.entities.TraitBean;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class BenthosTabUIHandler extends AbstractTuttiUIHandler<BenthosTabUIModel> {

    /** Logger. */
    private static final Log log = LogFactory.getLog(BenthosTabUIHandler.class);

    private final BenthosTabUI ui;

    private final CatchesUI parentUi;

    private final PersistenceService persistenceService;

    public BenthosTabUIHandler(CatchesUI parentUi, BenthosTabUI ui) {
        super(parentUi.getHandler().getContext());
        this.ui = ui;
        this.parentUi = parentUi;
        this.persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {

        BenthosTabUIModel model = new BenthosTabUIModel();
        ui.setContextValue(model);

        JTable tb = new JTable();

        TableCellEditor defaultEditor = tb.getDefaultEditor(String.class);
        TableCellRenderer defaultRenderer = tb.getDefaultRenderer(Object.class);

        // prepare the table column model
        TableColumnModel columnModel = new DefaultTableColumnModel();

        TableColumn col;

        // species (by code) column

        col = new TableColumn(0);

        JComboBox speciesEditor = new JComboBox();
        List<SpeciesBean> allSpecies = persistenceService.getAllSpecies();
        SwingUtil.fillComboBox(speciesEditor, allSpecies, null);
//        col.setCellEditor();
        col.setCellRenderer(newTableCellRender(SpeciesBean.class));
        col.setHeaderValue(_("tutti.table.benthos.header.speciesByCode"));
//        col.setHeaderRenderer(SwingUtil.newStringTableCellRenderer(dRender,50, true));
        col.setIdentifier("speciesByCode");
        columnModel.addColumn(col);

        // Poids observé
        col = new TableColumn(1);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(_("tutti.table.benthos.header.weight"));
//        col.setHeaderRenderer(SwingUtil.newStringTableCellRenderer(dRender,50, true));
        col.setIdentifier("weight");
        columnModel.addColumn(col);

        // Nombre observé
        col = new TableColumn(2);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(_("tutti.table.benthos.header.number"));
//        col.setHeaderRenderer(SwingUtil.newStringTableCellRenderer(dRender,50, true));
        col.setIdentifier("computedNumber");
        columnModel.addColumn(col);

        ui.setContextValue(columnModel);

        final BenthosTableModel tableModel = new BenthosTableModel(columnModel);
        ui.setContextValue(tableModel);

        model.addPropertyChangeListener(BenthosTabUIModel.PROPERTY_CATCHES, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                tableModel.setData((List<CatchBean>) evt.getNewValue());
            }
        });

    }

    @Override
    public void afterInitUI() {
        BenthosTabUIModel model = ui.getModel();

        initUI(ui);
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    protected BenthosTabUIModel getModel() {
        return ui.getModel();
    }

    public void selectTrait(TraitBean bean) {

        boolean empty = bean == null;

        BenthosTabUIModel model = ui.getModel();

        List<CatchBean> catches;

        if (empty) {
            catches = null;
            bean = new TraitBean();
        } else {
            catches = persistenceService.getAllCatches(bean.getId());
        }

        model.fromBean(bean);
        model.setCatches(catches);
    }

    public void cancel() {

        if (log.isInfoEnabled()) {
            log.info("Cancel edition");
        }
    }

    public void save() {
        if (log.isInfoEnabled()) {
            log.info("Will save");
        }
    }
}