package fr.ifremer.tutti.ui.swing.content.campaign;

/*
 * #%L
 * Tutti :: UI
 * $Id: SelectCampaignUIModel.java 15 2012-11-24 13:10:24Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/campaign/SelectCampaignUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.CampaignBean;
import fr.ifremer.tutti.persistence.entities.SurveyBean;
import org.jdesktop.beans.AbstractSerializableBean;

import java.util.List;

/**
 * Model of ui {@link SelectCampaignUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class SelectCampaignUIModel extends AbstractSerializableBean {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_SURVEYS = "surveys";

    public static final String PROPERTY_SURVEY = "survey";

    public static final String PROPERTY_CAMPAIGNS = "campaigns";

    public static final String PROPERTY_CAMPAIGN = "campaign";

    public static final String PROPERTY_SURVEY_FOUND = "surveyFound";

    public static final String PROPERTY_CAMPAIGN_FOUND = "campaignFound";

    protected List<SurveyBean> surveys;

    protected SurveyBean survey;

    protected List<CampaignBean> campaigns;

    protected CampaignBean campaign;

    public List<SurveyBean> getSurveys() {
        return surveys;
    }

    public void setSurveys(List<SurveyBean> surveys) {
        Object oldValue = getSurveys();
        this.surveys = surveys;

        // nullify survey
//        setSurvey(null);
        firePropertyChange(PROPERTY_SURVEYS, oldValue, surveys);
    }

    public SurveyBean getSurvey() {
        return survey;
    }

    public void setSurvey(SurveyBean survey) {
        SurveyBean oldValue = getSurvey();
        this.survey = survey;

        // nullify campaigns
//        setCampaigns(null);

        firePropertyChange(PROPERTY_SURVEY, oldValue, survey);
        firePropertyChange(PROPERTY_SURVEY_FOUND, oldValue != null, survey != null);
    }

    public boolean isSurveyFound() {
        return survey != null;
    }

    public List<CampaignBean> getCampaigns() {
        return campaigns;
    }

    public void setCampaigns(List<CampaignBean> campaigns) {
        Object oldValue = getCampaigns();
        this.campaigns = campaigns;

        // nullify campaign
//        setCampaign(null);
        firePropertyChange(PROPERTY_CAMPAIGNS, oldValue, campaigns);
    }

    public CampaignBean getCampaign() {
        return campaign;
    }

    public void setCampaign(CampaignBean campaign) {
        CampaignBean oldValue = getCampaign();
        this.campaign = campaign;
        firePropertyChange(PROPERTY_CAMPAIGN, oldValue, campaign);
        firePropertyChange(PROPERTY_CAMPAIGN_FOUND, oldValue != null, campaign != null);
    }

    public boolean isCampaignFound() {
        return campaign != null;
    }

}
