package fr.ifremer.tutti.ui.swing.content.campaign;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.CountryBean;
import fr.ifremer.tutti.persistence.entities.GearBean;
import fr.ifremer.tutti.persistence.entities.SurveyBean;
import fr.ifremer.tutti.persistence.entities.UserBean;
import fr.ifremer.tutti.persistence.entities.VesselBean;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditCampaignUI extends JPanel implements TuttiUI<EditCampaignUIModel, EditCampaignUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_COUNTRY_COMBO_BOX_SELECTED_ITEM = "countryComboBox.selectedItem";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SURVEY_COMBO_BOX_SELECTED_ITEM = "surveyComboBox.selectedItem";
    public static final String BINDING_SURVEY_PART_FIELD_TEXT = "surveyPartField.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW = "$JScrollPane0.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditCampaignUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentField")
    protected JTextArea commentField;
    protected JScrollPane commentPane;
    @ValidatorField( validatorId = "validator",  propertyName = "country",  editorName = "countryComboBox")
    protected BeanComboBox<CountryBean> countryComboBox;
    protected JLabel countryLabel;
    protected JTable errorTable;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected BeanListHeader<GearBean> gearHeader;
    protected JList gearList;
    @ValidatorField( validatorId = "validator",  propertyName = "gear",  editorName = "gearPane")
    protected JScrollPane gearPane;
    protected EditCampaignUIHandler handler;
    protected BeanListHeader<UserBean> headOfMissionHeader;
    protected JList headOfMissionList;
    @ValidatorField( validatorId = "validator",  propertyName = "headOfMission",  editorName = "headOfMissionPane")
    protected JScrollPane headOfMissionPane;
    protected BeanListHeader<UserBean> headOfSortRoomHeader;
    protected JList headOfSortRoomList;
    @ValidatorField( validatorId = "validator",  propertyName = "headOfSortRoom",  editorName = "headOfSortRoomPane")
    protected JScrollPane headOfSortRoomPane;
    protected EditCampaignUI homePanel = this;
    protected JButton importCasinoButton;
    protected JPanel messagePanel;
    protected EditCampaignUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    protected JButton saveButton;
    protected JSplitPane splitPane;
    @ValidatorField( validatorId = "validator",  propertyName = "survey",  editorName = "surveyComboBox")
    protected BeanComboBox<SurveyBean> surveyComboBox;
    protected JLabel surveyLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "surveyPart",  editorName = "surveyPartField")
    protected JTextField surveyPartField;
    protected JLabel surveyPartLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditCampaignUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected BeanListHeader<VesselBean> vesselHeader;
    protected JList vesselList;
    @ValidatorField( validatorId = "validator",  propertyName = "vessel",  editorName = "vesselPane")
    protected JScrollPane vesselPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditCampaignUI(TuttiUIContext context) {
        EditCampaignUIHandler handler = new EditCampaignUIHandler(context, this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public EditCampaignUI() {
        $initialize();
    }

    public EditCampaignUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCampaignUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditCampaignUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCampaignUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditCampaignUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCampaignUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditCampaignUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__importCasinoButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importCasino();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doFocusGained__on__gearPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        gearList.requestFocus();
    }

    public void doFocusGained__on__headOfMissionPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        headOfMissionList.requestFocus();
    }

    public void doFocusGained__on__headOfSortRoomPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        headOfSortRoomList.requestFocus();
    }

    public void doFocusGained__on__vesselPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        vesselList.requestFocus();
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "name");
    }

    public void doKeyReleased__on__surveyPartField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "surveyPart");
    }

    public void doValueChanged__on__gearList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.selectListData(event, "gear");
    }

    public void doValueChanged__on__headOfMissionList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.selectListData(event, "headOfMission");
    }

    public void doValueChanged__on__headOfSortRoomList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.selectListData(event, "headOfSortRoom");
    }

    public void doValueChanged__on__vesselList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.selectListData(event, "vessel");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public BeanComboBox<CountryBean> getCountryComboBox() {
        return countryComboBox;
    }

    public JLabel getCountryLabel() {
        return countryLabel;
    }

    public JTable getErrorTable() {
        return errorTable;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public BeanListHeader<GearBean> getGearHeader() {
        return gearHeader;
    }

    public JList getGearList() {
        return gearList;
    }

    public JScrollPane getGearPane() {
        return gearPane;
    }

    public EditCampaignUIHandler getHandler() {
        return handler;
    }

    public BeanListHeader<UserBean> getHeadOfMissionHeader() {
        return headOfMissionHeader;
    }

    public JList getHeadOfMissionList() {
        return headOfMissionList;
    }

    public JScrollPane getHeadOfMissionPane() {
        return headOfMissionPane;
    }

    public BeanListHeader<UserBean> getHeadOfSortRoomHeader() {
        return headOfSortRoomHeader;
    }

    public JList getHeadOfSortRoomList() {
        return headOfSortRoomList;
    }

    public JScrollPane getHeadOfSortRoomPane() {
        return headOfSortRoomPane;
    }

    public JButton getImportCasinoButton() {
        return importCasinoButton;
    }

    public JPanel getMessagePanel() {
        return messagePanel;
    }

    public EditCampaignUIModel getModel() {
        return model;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    public BeanComboBox<SurveyBean> getSurveyComboBox() {
        return surveyComboBox;
    }

    public JLabel getSurveyLabel() {
        return surveyLabel;
    }

    public JTextField getSurveyPartField() {
        return surveyPartField;
    }

    public JLabel getSurveyPartLabel() {
        return surveyPartLabel;
    }

    public SwingValidator<EditCampaignUIModel> getValidator() {
        return validator;
    }

    public BeanListHeader<VesselBean> getVesselHeader() {
        return vesselHeader;
    }

    public JList getVesselList() {
        return vesselList;
    }

    public JScrollPane getVesselPane() {
        return vesselPane;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(SwingUtil.boxComponentWithJxLayer(commentField));
    }

    protected void addChildrenToGearPane() {
        if (!allComponentsCreated) {
            return;
        }
        gearPane.getViewport().add(gearList);
    }

    protected void addChildrenToHeadOfMissionPane() {
        if (!allComponentsCreated) {
            return;
        }
        headOfMissionPane.getViewport().add(headOfMissionList);
    }

    protected void addChildrenToHeadOfSortRoomPane() {
        if (!allComponentsCreated) {
            return;
        }
        headOfSortRoomPane.getViewport().add(headOfSortRoomList);
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(splitPane, BorderLayout.CENTER);
    }

    protected void addChildrenToMessagePanel() {
        if (!allComponentsCreated) {
            return;
        }
        messagePanel.add($JScrollPane0);
    }

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add($Table0, JSplitPane.LEFT);
        splitPane.add(messagePanel, JSplitPane.RIGHT);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        SwingValidatorUtil.registerErrorTableMouseListener(errorTable);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void addChildrenToVesselPane() {
        if (!allComponentsCreated) {
            return;
        }
        vesselPane.getViewport().add(vesselList);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.action.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
    }

    protected void createCountryComboBox() {
        $objectMap.put("countryComboBox", countryComboBox = new BeanComboBox<CountryBean>(this));
        
        countryComboBox.setName("countryComboBox");
        countryComboBox.setI18nPrefix("tutti.property.");
        countryComboBox.setProperty("country");
        countryComboBox.setShowReset(true);
    }

    protected void createCountryLabel() {
        $objectMap.put("countryLabel", countryLabel = new JLabel());
        
        countryLabel.setName("countryLabel");
        countryLabel.setText(_("tutti.label.campaign.country"));
    }

    protected void createErrorTable() {
        $objectMap.put("errorTable", errorTable = new JTable());
        
        errorTable.setName("errorTable");
        errorTable.setCellSelectionEnabled(false);
        errorTable.setSelectionMode(0);
        errorTable.setAutoResizeMode(2);
        errorTable.setRowSelectionAllowed(true);
        errorTable.setAutoCreateRowSorter(true);
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createGearHeader() {
        $objectMap.put("gearHeader", gearHeader = new BeanListHeader<GearBean>());
        
        gearHeader.setName("gearHeader");
        gearHeader.setI18nPrefix("tutti.property.");
        gearHeader.setShowReset(true);
    }

    protected void createGearList() {
        $objectMap.put("gearList", gearList = new JList());
        
        gearList.setName("gearList");
        gearList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__gearList"));
    }

    protected void createGearPane() {
        $objectMap.put("gearPane", gearPane = new JScrollPane());
        
        gearPane.setName("gearPane");
        gearPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__gearPane"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditCampaignUIHandler.class));
    }

    protected void createHeadOfMissionHeader() {
        $objectMap.put("headOfMissionHeader", headOfMissionHeader = new BeanListHeader<UserBean>());
        
        headOfMissionHeader.setName("headOfMissionHeader");
        headOfMissionHeader.setI18nPrefix("tutti.property.");
        headOfMissionHeader.setShowReset(true);
    }

    protected void createHeadOfMissionList() {
        $objectMap.put("headOfMissionList", headOfMissionList = new JList());
        
        headOfMissionList.setName("headOfMissionList");
        headOfMissionList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__headOfMissionList"));
    }

    protected void createHeadOfMissionPane() {
        $objectMap.put("headOfMissionPane", headOfMissionPane = new JScrollPane());
        
        headOfMissionPane.setName("headOfMissionPane");
        headOfMissionPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__headOfMissionPane"));
    }

    protected void createHeadOfSortRoomHeader() {
        $objectMap.put("headOfSortRoomHeader", headOfSortRoomHeader = new BeanListHeader<UserBean>());
        
        headOfSortRoomHeader.setName("headOfSortRoomHeader");
        headOfSortRoomHeader.setI18nPrefix("tutti.property.");
        headOfSortRoomHeader.setShowReset(true);
    }

    protected void createHeadOfSortRoomList() {
        $objectMap.put("headOfSortRoomList", headOfSortRoomList = new JList());
        
        headOfSortRoomList.setName("headOfSortRoomList");
        headOfSortRoomList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__headOfSortRoomList"));
    }

    protected void createHeadOfSortRoomPane() {
        $objectMap.put("headOfSortRoomPane", headOfSortRoomPane = new JScrollPane());
        
        headOfSortRoomPane.setName("headOfSortRoomPane");
        headOfSortRoomPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__headOfSortRoomPane"));
    }

    protected void createImportCasinoButton() {
        $objectMap.put("importCasinoButton", importCasinoButton = new JButton());
        
        importCasinoButton.setName("importCasinoButton");
        importCasinoButton.setText(_("tutti.action.casino-import"));
        importCasinoButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importCasinoButton"));
    }

    protected void createMessagePanel() {
        $objectMap.put("messagePanel", messagePanel = new JPanel());
        
        messagePanel.setName("messagePanel");
        messagePanel.setLayout(new GridLayout());
        SwingUtil.setComponentHeight(messagePanel,200);
        SwingUtil.setComponentWidth(messagePanel,500);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditCampaignUIModel.class));
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(_("tutti.label.campaign.name"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.action.save"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(0.3);
        splitPane.setOneTouchExpandable(true);
    }

    protected void createSurveyComboBox() {
        $objectMap.put("surveyComboBox", surveyComboBox = new BeanComboBox<SurveyBean>(this));
        
        surveyComboBox.setName("surveyComboBox");
        surveyComboBox.setI18nPrefix("tutti.property.");
        surveyComboBox.setProperty("survey");
        surveyComboBox.setShowReset(true);
    }

    protected void createSurveyLabel() {
        $objectMap.put("surveyLabel", surveyLabel = new JLabel());
        
        surveyLabel.setName("surveyLabel");
        surveyLabel.setText(_("tutti.label.campaign.survey"));
    }

    protected void createSurveyPartField() {
        $objectMap.put("surveyPartField", surveyPartField = new JTextField());
        
        surveyPartField.setName("surveyPartField");
        surveyPartField.setColumns(15);
        surveyPartField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__surveyPartField"));
    }

    protected void createSurveyPartLabel() {
        $objectMap.put("surveyPartLabel", surveyPartLabel = new JLabel());
        
        surveyPartLabel.setName("surveyPartLabel");
        surveyPartLabel.setText(_("tutti.label.campaign.surveyPart"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditCampaignUIModel.class, null));
    }

    protected void createVesselHeader() {
        $objectMap.put("vesselHeader", vesselHeader = new BeanListHeader<VesselBean>());
        
        vesselHeader.setName("vesselHeader");
        vesselHeader.setI18nPrefix("tutti.property.");
        vesselHeader.setShowReset(true);
    }

    protected void createVesselList() {
        $objectMap.put("vesselList", vesselList = new JList());
        
        vesselList.setName("vesselList");
        vesselList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__vesselList"));
    }

    protected void createVesselPane() {
        $objectMap.put("vesselPane", vesselPane = new JScrollPane());
        
        vesselPane.setName("vesselPane");
        vesselPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__vesselPane"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToSplitPane();
        // inline complete setup of $Table0
        $Table0.add(surveyLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(surveyComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(countryLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(countryComboBox), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(nameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(surveyPartLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(surveyPartField), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(commentPane, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(importCasinoButton, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(SwingUtil.boxComponentWithJxLayer(vesselPane));
        $JPanel0.add(SwingUtil.boxComponentWithJxLayer(gearPane));
        addChildrenToVesselPane();
        addChildrenToGearPane();
        // inline complete setup of $JPanel1
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(headOfMissionPane));
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(headOfSortRoomPane));
        addChildrenToHeadOfMissionPane();
        addChildrenToHeadOfSortRoomPane();
        addChildrenToCommentPane();
        // inline complete setup of $JPanel2
        $JPanel2.add(cancelButton);
        $JPanel2.add(saveButton);
        addChildrenToMessagePanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(errorTable);
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 51 property setters
        vesselPane.setColumnHeaderView(vesselHeader);
        gearPane.setColumnHeaderView(gearHeader);
        headOfMissionPane.setColumnHeaderView(headOfMissionHeader);
        headOfSortRoomPane.setColumnHeaderView(headOfSortRoomHeader);
        splitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        surveyLabel.setLabelFor(surveyComboBox);
        surveyComboBox.setBean(model);
        countryLabel.setLabelFor(countryComboBox);
        countryComboBox.setBean(model);
        nameLabel.setLabelFor(nameField);
        surveyPartLabel.setLabelFor(surveyPartField);
        vesselPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        vesselPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        vesselList.setModel(new DefaultListModel());
        vesselList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        vesselHeader.setLabelText(_("tutti.label.list.vessel"));
        vesselHeader.setBeanType(VesselBean.class);
        vesselHeader.setList(vesselList);
        gearPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        gearPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        gearList.setModel(new DefaultListModel());
        gearList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        gearHeader.setLabelText(_("tutti.label.list.gear"));
        gearHeader.setBeanType(GearBean.class);
        gearHeader.setList(gearList);
        headOfMissionPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        headOfMissionPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        headOfMissionList.setModel(new DefaultListModel());
        headOfMissionList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        headOfMissionHeader.setLabelText(_("tutti.label.list.headOfMission"));
        headOfMissionHeader.setBeanType(UserBean.class);
        headOfMissionHeader.setList(headOfMissionList);
        headOfSortRoomPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        headOfSortRoomPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        headOfSortRoomList.setModel(new DefaultListModel());
        headOfSortRoomList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        headOfSortRoomHeader.setLabelText(_("tutti.label.list.headOfSortRoom"));
        headOfSortRoomHeader.setBeanType(UserBean.class);
        headOfSortRoomHeader.setList(headOfSortRoomList);
        commentPane.setColumnHeaderView(new JLabel(_("tutti.label.comment")));
        commentPane.setMinimumSize(new Dimension(10,50));
        importCasinoButton.setIcon(SwingUtil.createActionIcon("casino-import"));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        messagePanel.setBorder(BorderFactory.createTitledBorder("Messages"));
        errorTable.setModel(errorTableModel);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createSplitPane();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createSurveyLabel();
        createSurveyComboBox();
        createCountryLabel();
        createCountryComboBox();
        createNameLabel();
        createNameField();
        createSurveyPartLabel();
        createSurveyPartField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createVesselPane();
        createVesselList();
        createVesselHeader();
        createGearPane();
        createGearList();
        createGearHeader();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 0));
        createHeadOfMissionPane();
        createHeadOfMissionList();
        createHeadOfMissionHeader();
        createHeadOfSortRoomPane();
        createHeadOfSortRoomList();
        createHeadOfSortRoomHeader();
        createCommentPane();
        createCommentField();
        createImportCasinoButton();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveButton();
        createMessagePanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createErrorTable();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (errorTable != null) {
                    errorTable.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (errorTable != null) {
                    $JScrollPane0.setColumnHeaderView(errorTable.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (errorTable != null) {
                    errorTable.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SURVEY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("survey", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    surveyComboBox.setSelectedItem(model.getSurvey());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("survey", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COUNTRY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("country", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    countryComboBox.setSelectedItem(model.getCountry());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("country", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(nameField, model.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SURVEY_PART_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("surveyPart", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(surveyPartField, model.getSurveyPart());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("surveyPart", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, model.getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}